
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

/*
 * This class is automatically generated from AggrTypeFunctions1.tdd using FreeMarker.
 */

package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;

@SuppressWarnings("unused")

public class CountDateTypeFunctions {

@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class DateCount implements DrillAggFunc{

  @Param DateHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = 0;
  }

  @Override
  public void add() {

	    value.value++;
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = 0;
  }

 }

@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableDateCount implements DrillAggFunc{

  @Param NullableDateHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = 0;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

	    value.value++;
    } // end of sout block
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = 0;
  }

 }

@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class TimeStampCount implements DrillAggFunc{

  @Param TimeStampHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = 0;
  }

  @Override
  public void add() {

	    value.value++;
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = 0;
  }

 }

@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableTimeStampCount implements DrillAggFunc{

  @Param NullableTimeStampHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = 0;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

	    value.value++;
    } // end of sout block
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = 0;
  }

 }

@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class TimeStampTZCount implements DrillAggFunc{

  @Param TimeStampTZHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = 0;
  }

  @Override
  public void add() {

	    value.value++;
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = 0;
  }

 }

@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableTimeStampTZCount implements DrillAggFunc{

  @Param NullableTimeStampTZHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = 0;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

	    value.value++;
    } // end of sout block
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = 0;
  }

 }

@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class TimeCount implements DrillAggFunc{

  @Param TimeHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = 0;
  }

  @Override
  public void add() {

	    value.value++;
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = 0;
  }

 }

@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableTimeCount implements DrillAggFunc{

  @Param NullableTimeHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = 0;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

	    value.value++;
    } // end of sout block
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = 0;
  }

 }

@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntervalDayCount implements DrillAggFunc{

  @Param IntervalDayHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = 0;
  }

  @Override
  public void add() {

	    value.value++;
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = 0;
  }

 }

@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntervalDayCount implements DrillAggFunc{

  @Param NullableIntervalDayHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = 0;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

	    value.value++;
    } // end of sout block
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = 0;
  }

 }

@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntervalYearCount implements DrillAggFunc{

  @Param IntervalYearHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = 0;
  }

  @Override
  public void add() {

	    value.value++;
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = 0;
  }

 }

@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntervalYearCount implements DrillAggFunc{

  @Param NullableIntervalYearHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = 0;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

	    value.value++;
    } // end of sout block
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = 0;
  }

 }

@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntervalCount implements DrillAggFunc{

  @Param IntervalHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = 0;
  }

  @Override
  public void add() {

	    value.value++;
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = 0;
  }

 }

@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntervalCount implements DrillAggFunc{

  @Param NullableIntervalHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = 0;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

	    value.value++;
    } // end of sout block
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = 0;
  }

 }

}

