
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
/*
 * This class is automatically generated from AddTypes.tdd using FreeMarker.
 */


package org.apache.drill.exec.expr.fn.impl;


import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.types.TypeProtos.MinorType;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.StringFunctions;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;

@SuppressWarnings("unused")

public class GMathFunctions{
  static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(GMathFunctions.class);
  
  private GMathFunctions(){}



  @FunctionTemplate(name = "abs", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class AbsInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.abs(in.value);
    }
  }
  

  @FunctionTemplate(name = "abs", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class AbsBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output BigIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (long) java.lang.Math.abs(in.value);
    }
  }
  

  @FunctionTemplate(name = "abs", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class AbsFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (float) java.lang.Math.abs(in.value);
    }
  }
  

  @FunctionTemplate(name = "abs", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class AbsFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (double) java.lang.Math.abs(in.value);
    }
  }
  

  @FunctionTemplate(name = "abs", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class AbsSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output SmallIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (short) java.lang.Math.abs(in.value);
    }
  }
  

  @FunctionTemplate(name = "abs", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class AbsTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output TinyIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (byte) java.lang.Math.abs(in.value);
    }
  }
  

  @FunctionTemplate(name = "abs", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class AbsUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output UInt1Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (byte) java.lang.Math.abs(in.value);
    }
  }
  

  @FunctionTemplate(name = "abs", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class AbsUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output UInt2Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (char) java.lang.Math.abs(in.value);
    }
  }
  

  @FunctionTemplate(name = "abs", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class AbsUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output UInt4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.abs(in.value);
    }
  }
  

  @FunctionTemplate(name = "abs", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class AbsUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output UInt8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (long) java.lang.Math.abs(in.value);
    }
  }
  


  @FunctionTemplate(name = "ceil", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CeilInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.ceil(in.value);
    }
  }
  

  @FunctionTemplate(name = "ceil", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CeilBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output BigIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (long) java.lang.Math.ceil(in.value);
    }
  }
  

  @FunctionTemplate(name = "ceil", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CeilFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (float) java.lang.Math.ceil(in.value);
    }
  }
  

  @FunctionTemplate(name = "ceil", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CeilFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (double) java.lang.Math.ceil(in.value);
    }
  }
  

  @FunctionTemplate(name = "ceil", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CeilSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output SmallIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (short) java.lang.Math.ceil(in.value);
    }
  }
  

  @FunctionTemplate(name = "ceil", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CeilTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output TinyIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (byte) java.lang.Math.ceil(in.value);
    }
  }
  

  @FunctionTemplate(name = "ceil", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CeilUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output UInt1Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (byte) java.lang.Math.ceil(in.value);
    }
  }
  

  @FunctionTemplate(name = "ceil", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CeilUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output UInt2Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (char) java.lang.Math.ceil(in.value);
    }
  }
  

  @FunctionTemplate(name = "ceil", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CeilUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output UInt4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.ceil(in.value);
    }
  }
  

  @FunctionTemplate(name = "ceil", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CeilUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output UInt8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (long) java.lang.Math.ceil(in.value);
    }
  }
  


  @FunctionTemplate(name = "floor", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class FloorInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.floor(in.value);
    }
  }
  

  @FunctionTemplate(name = "floor", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class FloorBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output BigIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (long) java.lang.Math.floor(in.value);
    }
  }
  

  @FunctionTemplate(name = "floor", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class FloorFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (float) java.lang.Math.floor(in.value);
    }
  }
  

  @FunctionTemplate(name = "floor", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class FloorFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (double) java.lang.Math.floor(in.value);
    }
  }
  

  @FunctionTemplate(name = "floor", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class FloorSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output SmallIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (short) java.lang.Math.floor(in.value);
    }
  }
  

  @FunctionTemplate(name = "floor", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class FloorTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output TinyIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (byte) java.lang.Math.floor(in.value);
    }
  }
  

  @FunctionTemplate(name = "floor", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class FloorUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output UInt1Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (byte) java.lang.Math.floor(in.value);
    }
  }
  

  @FunctionTemplate(name = "floor", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class FloorUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output UInt2Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (char) java.lang.Math.floor(in.value);
    }
  }
  

  @FunctionTemplate(name = "floor", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class FloorUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output UInt4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.floor(in.value);
    }
  }
  

  @FunctionTemplate(name = "floor", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class FloorUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output UInt8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (long) java.lang.Math.floor(in.value);
    }
  }
  


  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RoundInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.round(in.value);
    }
  }
  

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RoundBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output BigIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (long) java.lang.Math.round(in.value);
    }
  }
  

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RoundFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (float) java.lang.Math.round(in.value);
    }
  }
  

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RoundFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (double) java.lang.Math.round(in.value);
    }
  }
  

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RoundSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output SmallIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (short) java.lang.Math.round(in.value);
    }
  }
  

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RoundTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output TinyIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (byte) java.lang.Math.round(in.value);
    }
  }
  

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RoundUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output UInt1Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (byte) java.lang.Math.round(in.value);
    }
  }
  

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RoundUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output UInt2Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (char) java.lang.Math.round(in.value);
    }
  }
  

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RoundUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output UInt4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.round(in.value);
    }
  }
  

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RoundUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output UInt8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (long) java.lang.Math.round(in.value);
    }
  }
  


  @FunctionTemplate(name = "sqrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SqrtInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.sqrt(in.value);
    }
  }
  

  @FunctionTemplate(name = "sqrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SqrtBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output BigIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (long) java.lang.Math.sqrt(in.value);
    }
  }
  

  @FunctionTemplate(name = "sqrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SqrtFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (float) java.lang.Math.sqrt(in.value);
    }
  }
  

  @FunctionTemplate(name = "sqrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SqrtFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (double) java.lang.Math.sqrt(in.value);
    }
  }
  

  @FunctionTemplate(name = "sqrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SqrtSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output SmallIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (short) java.lang.Math.sqrt(in.value);
    }
  }
  

  @FunctionTemplate(name = "sqrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SqrtTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output TinyIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (byte) java.lang.Math.sqrt(in.value);
    }
  }
  

  @FunctionTemplate(name = "sqrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SqrtUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output UInt1Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (byte) java.lang.Math.sqrt(in.value);
    }
  }
  

  @FunctionTemplate(name = "sqrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SqrtUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output UInt2Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (char) java.lang.Math.sqrt(in.value);
    }
  }
  

  @FunctionTemplate(name = "sqrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SqrtUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output UInt4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.sqrt(in.value);
    }
  }
  

  @FunctionTemplate(name = "sqrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SqrtUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output UInt8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (long) java.lang.Math.sqrt(in.value);
    }
  }
  


  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) (in.value);
    }
  }
  

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output BigIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (long) (in.value);
    }
  }
  

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      java.math.BigDecimal bd = java.math.BigDecimal.valueOf(in.value).setScale(0, java.math.BigDecimal.ROUND_DOWN);
      out.value = bd.floatValue();

    }
  }
  

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      java.math.BigDecimal bd = java.math.BigDecimal.valueOf(in.value).setScale(0, java.math.BigDecimal.ROUND_DOWN);
      out.value = bd.doubleValue();

    }
  }
  

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output SmallIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (short) (in.value);
    }
  }
  

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output TinyIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (byte) (in.value);
    }
  }
  

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output UInt1Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (byte) (in.value);
    }
  }
  

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output UInt2Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (char) (in.value);
    }
  }
  

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output UInt4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) (in.value);
    }
  }
  

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output UInt8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (long) (in.value);
    }
  }
  


  @FunctionTemplate(name = "sign", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SignInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.signum(in.value);
    }
  }
  

  @FunctionTemplate(name = "sign", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SignBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.signum(in.value);
    }
  }
  

  @FunctionTemplate(name = "sign", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SignFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.signum(in.value);
    }
  }
  

  @FunctionTemplate(name = "sign", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SignFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.signum(in.value);
    }
  }
  

  @FunctionTemplate(name = "sign", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SignSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.signum(in.value);
    }
  }
  

  @FunctionTemplate(name = "sign", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SignTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.signum(in.value);
    }
  }
  

  @FunctionTemplate(name = "sign", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SignUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.signum(in.value);
    }
  }
  

  @FunctionTemplate(name = "sign", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SignUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.signum(in.value);
    }
  }
  

  @FunctionTemplate(name = "sign", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SignUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.signum(in.value);
    }
  }
  

  @FunctionTemplate(name = "sign", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SignUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {

      out.value = (int) java.lang.Math.signum(in.value);
    }
  }
  


  //////////////////////////////////////////////////////////////////////////////////////////////////
  //Math functions which take two arguments (of same type). 
  //////////////////////////////////////////////////////////////////////////////////////////////////
  

  @FunctionTemplate(name = "div", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class DivInt implements DrillSimpleFunc {

    @Param IntHolder input1;
    @Param IntHolder input2;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (int) ( input1.value  /  input2.value);
    }
  }

  @FunctionTemplate(name = "div", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class DivBigInt implements DrillSimpleFunc {

    @Param BigIntHolder input1;
    @Param BigIntHolder input2;
    @Output BigIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (long) ( input1.value  /  input2.value);
    }
  }

  @FunctionTemplate(name = "div", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class DivFloat4 implements DrillSimpleFunc {

    @Param Float4Holder input1;
    @Param Float4Holder input2;
    @Output Float4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    java.math.BigDecimal bdOut = java.math.BigDecimal.valueOf(input1.value  /  input2.value).setScale(0, java.math.BigDecimal.ROUND_DOWN);
    out.value = bdOut.floatValue();
    }
  }

  @FunctionTemplate(name = "div", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class DivFloat8 implements DrillSimpleFunc {

    @Param Float8Holder input1;
    @Param Float8Holder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    java.math.BigDecimal bdOut = java.math.BigDecimal.valueOf(input1.value  /  input2.value).setScale(0, java.math.BigDecimal.ROUND_DOWN);
    out.value = bdOut.doubleValue();
    }
  }

  @FunctionTemplate(name = "div", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class DivSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder input1;
    @Param SmallIntHolder input2;
    @Output SmallIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (short) ( input1.value  /  input2.value);
    }
  }

  @FunctionTemplate(name = "div", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class DivTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder input1;
    @Param TinyIntHolder input2;
    @Output TinyIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (byte) ( input1.value  /  input2.value);
    }
  }

  @FunctionTemplate(name = "div", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class DivUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder input1;
    @Param UInt1Holder input2;
    @Output UInt1Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (byte) ( input1.value  /  input2.value);
    }
  }

  @FunctionTemplate(name = "div", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class DivUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder input1;
    @Param UInt2Holder input2;
    @Output UInt2Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (char) ( input1.value  /  input2.value);
    }
  }

  @FunctionTemplate(name = "div", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class DivUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder input1;
    @Param UInt4Holder input2;
    @Output UInt4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (int) ( input1.value  /  input2.value);
    }
  }

  @FunctionTemplate(name = "div", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class DivUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder input1;
    @Param UInt8Holder input2;
    @Output UInt8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (long) ( input1.value  /  input2.value);
    }
  }

  @FunctionTemplate(name = "mod", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ModInt implements DrillSimpleFunc {

    @Param IntHolder input1;
    @Param IntHolder input2;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (int) (input2.value == 0 ? input1.value : (input1.value  %  input2.value));
    }
  }

  @FunctionTemplate(name = "mod", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ModBigInt implements DrillSimpleFunc {

    @Param BigIntHolder input1;
    @Param BigIntHolder input2;
    @Output BigIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (long) (input2.value == 0 ? input1.value : (input1.value  %  input2.value));
    }
  }

  @FunctionTemplate(name = "mod", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ModFloat4 implements DrillSimpleFunc {

    @Param Float4Holder input1;
    @Param Float4Holder input2;
    @Output Float4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (float) (input2.value == 0 ? input1.value : (input1.value  %  input2.value));
    }
  }

  @FunctionTemplate(name = "mod", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ModFloat8 implements DrillSimpleFunc {

    @Param Float8Holder input1;
    @Param Float8Holder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (double) (input2.value == 0 ? input1.value : (input1.value  %  input2.value));
    }
  }

  @FunctionTemplate(name = "mod", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ModSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder input1;
    @Param SmallIntHolder input2;
    @Output SmallIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (short) (input2.value == 0 ? input1.value : (input1.value  %  input2.value));
    }
  }

  @FunctionTemplate(name = "mod", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ModTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder input1;
    @Param TinyIntHolder input2;
    @Output TinyIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (byte) (input2.value == 0 ? input1.value : (input1.value  %  input2.value));
    }
  }

  @FunctionTemplate(name = "mod", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ModUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder input1;
    @Param UInt1Holder input2;
    @Output UInt1Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (byte) (input2.value == 0 ? input1.value : (input1.value  %  input2.value));
    }
  }

  @FunctionTemplate(name = "mod", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ModUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder input1;
    @Param UInt2Holder input2;
    @Output UInt2Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (char) (input2.value == 0 ? input1.value : (input1.value  %  input2.value));
    }
  }

  @FunctionTemplate(name = "mod", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ModUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder input1;
    @Param UInt4Holder input2;
    @Output UInt4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (int) (input2.value == 0 ? input1.value : (input1.value  %  input2.value));
    }
  }

  @FunctionTemplate(name = "mod", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ModUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder input1;
    @Param UInt8Holder input2;
    @Output UInt8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value = (long) (input2.value == 0 ? input1.value : (input1.value  %  input2.value));
    }
  }

  @FunctionTemplate(name = "lshift", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class LeftShiftInt implements DrillSimpleFunc {

    @Param IntHolder input1;
    @Param IntHolder input2;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value =(int) ( input1.value  <<  input2.value);
    }
  }

  @FunctionTemplate(name = "lshift", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class LeftShiftBigInt implements DrillSimpleFunc {

    @Param BigIntHolder input1;
    @Param BigIntHolder input2;
    @Output BigIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value =(long) ( input1.value  <<  input2.value);
    }
  }

  @FunctionTemplate(name = "lshift", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class LeftShiftSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder input1;
    @Param SmallIntHolder input2;
    @Output SmallIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value =(short) ( input1.value  <<  input2.value);
    }
  }

  @FunctionTemplate(name = "lshift", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class LeftShiftTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder input1;
    @Param TinyIntHolder input2;
    @Output TinyIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value =(byte) ( input1.value  <<  input2.value);
    }
  }

  @FunctionTemplate(name = "lshift", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class LeftShiftUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder input1;
    @Param UInt1Holder input2;
    @Output UInt1Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value =(byte) ( input1.value  <<  input2.value);
    }
  }

  @FunctionTemplate(name = "lshift", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class LeftShiftUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder input1;
    @Param UInt2Holder input2;
    @Output UInt2Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value =(char) ( input1.value  <<  input2.value);
    }
  }

  @FunctionTemplate(name = "lshift", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class LeftShiftUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder input1;
    @Param UInt4Holder input2;
    @Output UInt4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value =(int) ( input1.value  <<  input2.value);
    }
  }

  @FunctionTemplate(name = "lshift", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class LeftShiftUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder input1;
    @Param UInt8Holder input2;
    @Output UInt8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value =(long) ( input1.value  <<  input2.value);
    }
  }

  @FunctionTemplate(name = "rshift", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RightShiftInt implements DrillSimpleFunc {

    @Param IntHolder input1;
    @Param IntHolder input2;
    @Output IntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value =(int) ( input1.value  >>  input2.value);
    }
  }

  @FunctionTemplate(name = "rshift", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RightShiftBigInt implements DrillSimpleFunc {

    @Param BigIntHolder input1;
    @Param BigIntHolder input2;
    @Output BigIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value =(long) ( input1.value  >>  input2.value);
    }
  }

  @FunctionTemplate(name = "rshift", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RightShiftSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder input1;
    @Param SmallIntHolder input2;
    @Output SmallIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value =(short) ( input1.value  >>  input2.value);
    }
  }

  @FunctionTemplate(name = "rshift", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RightShiftTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder input1;
    @Param TinyIntHolder input2;
    @Output TinyIntHolder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value =(byte) ( input1.value  >>  input2.value);
    }
  }

  @FunctionTemplate(name = "rshift", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RightShiftUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder input1;
    @Param UInt1Holder input2;
    @Output UInt1Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value =(byte) ( input1.value  >>  input2.value);
    }
  }

  @FunctionTemplate(name = "rshift", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RightShiftUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder input1;
    @Param UInt2Holder input2;
    @Output UInt2Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value =(char) ( input1.value  >>  input2.value);
    }
  }

  @FunctionTemplate(name = "rshift", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RightShiftUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder input1;
    @Param UInt4Holder input2;
    @Output UInt4Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value =(int) ( input1.value  >>  input2.value);
    }
  }

  @FunctionTemplate(name = "rshift", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RightShiftUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder input1;
    @Param UInt8Holder input2;
    @Output UInt8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
    out.value =(long) ( input1.value  >>  input2.value);
    }
  }


  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncateInt implements DrillSimpleFunc {

    @Param IntHolder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.DOWN).doubleValue();
    }
  }

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncateBigInt implements DrillSimpleFunc {

    @Param BigIntHolder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.DOWN).doubleValue();
    }
  }

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncateFloat4 implements DrillSimpleFunc {

    @Param Float4Holder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.DOWN).doubleValue();
    }
  }

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncateFloat8 implements DrillSimpleFunc {

    @Param Float8Holder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.DOWN).doubleValue();
    }
  }

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncateSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.DOWN).doubleValue();
    }
  }

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncateTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.DOWN).doubleValue();
    }
  }

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncateUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.DOWN).doubleValue();
    }
  }

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncateUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.DOWN).doubleValue();
    }
  }

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncateUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.DOWN).doubleValue();
    }
  }

  @FunctionTemplate(name = "trunc", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TruncateUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.DOWN).doubleValue();
    }
  }

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RounddInt implements DrillSimpleFunc {

    @Param IntHolder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.HALF_UP).doubleValue();
    }
  }

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RounddBigInt implements DrillSimpleFunc {

    @Param BigIntHolder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.HALF_UP).doubleValue();
    }
  }

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RounddFloat4 implements DrillSimpleFunc {

    @Param Float4Holder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.HALF_UP).doubleValue();
    }
  }

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RounddFloat8 implements DrillSimpleFunc {

    @Param Float8Holder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.HALF_UP).doubleValue();
    }
  }

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RounddSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.HALF_UP).doubleValue();
    }
  }

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RounddTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.HALF_UP).doubleValue();
    }
  }

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RounddUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.HALF_UP).doubleValue();
    }
  }

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RounddUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.HALF_UP).doubleValue();
    }
  }

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RounddUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.HALF_UP).doubleValue();
    }
  }

  @FunctionTemplate(name = "round", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class RounddUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder input1;
    @Param IntHolder input2;
    @Output Float8Holder out;

    public void setup(RecordBatch b) {
    }

    public void eval() {
      java.math.BigDecimal temp = new java.math.BigDecimal(input1.value);
      out.value = temp.setScale(input2.value, java.math.RoundingMode.HALF_UP).doubleValue();
    }
  }
}



//////////////////////////////////////////////////////////////////////////////////////////////////
//End of GMath Functions
//////////////////////////////////////////////////////////////////////////////////////////////////




