
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;

@SuppressWarnings("unused")
public class GCompareVarBinaryVarChar{

  @FunctionTemplate(name = "compare_to", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class CompareVarBinaryVarChar implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarCharHolder right;
      @Output IntHolder out;

      public void setup(RecordBatch b) {}

      public void eval() {

outside:{
  
    
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(left.buffer, left.start, left.end, right.buffer, right.start, right.end);
  

  
  

}
      }
  }


  @FunctionTemplate(names = {"less_than", "<"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanVarBinaryVarChar implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup(RecordBatch b) {}

      public void eval() {
        
        int cmp;

outside:{
  
    
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(left.buffer, left.start, left.end, right.buffer, right.start, right.end);
  

  
  

}
        out.value = cmp == -1 ? 1 : 0;

      }
  }
  
  @FunctionTemplate(names = {"less_than_or_equal_to", "<="}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanEVarBinaryVarChar implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup(RecordBatch b) {}

      public void eval() {
        
        int cmp;

outside:{
  
    
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(left.buffer, left.start, left.end, right.buffer, right.start, right.end);
  

  
  

}
        out.value = cmp < 1 ? 1 : 0;

    }
  }
  
  @FunctionTemplate(names = {"greater_than", ">"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanVarBinaryVarChar implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup(RecordBatch b) {}

      public void eval() {
        
        int cmp;

outside:{
  
    
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(left.buffer, left.start, left.end, right.buffer, right.start, right.end);
  

  
  

}
        out.value = cmp == 1 ? 1 : 0;

    }
  }
  
  @FunctionTemplate(names = {"greater_than_or_equal_to", ">="}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanEVarBinaryVarChar implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup(RecordBatch b) {}

      public void eval() {
        
        int cmp;

outside:{
  
    
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(left.buffer, left.start, left.end, right.buffer, right.start, right.end);
  

  
  

}
        out.value = cmp > -1 ? 1 : 0;

      }
  }
  
  @FunctionTemplate(names = {"equal","==","="}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class EqualsVarBinaryVarChar implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup(RecordBatch b) {}

      public void eval() {
          out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.equal(left.buffer, left.start, left.end, right.buffer, right.start, right.end);

      }
  }
  
  @FunctionTemplate(names = {"not_equal","<>","!="}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class NotEqualsVarBinaryVarChar implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup(RecordBatch b) {}

      public void eval() {
        
        int cmp;

outside:{
  
    
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(left.buffer, left.start, left.end, right.buffer, right.start, right.end);
  

  
  

}
        out.value = cmp == 0 ? 0 : 1;
                
      }
  }


}
