
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;

@SuppressWarnings("unused")
public class GCompareNullableBigIntNullableFloat8{

  @FunctionTemplate(name = "compare_to", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class CompareNullableBigIntNullableFloat8 implements DrillSimpleFunc {

      @Param NullableBigIntHolder left;
      @Param NullableFloat8Holder right;
      @Output IntHolder out;

      public void setup(RecordBatch b) {}

      public void eval() {

outside:{
  
        if(left.isSet == 0){
          if(right.isSet == 0){
            out.value = 0;
            break outside;
          }else{
            out.value = 1;
            break outside;
          }
        }else if(right.isSet == 0){
          out.value = -1;
          break outside;
        }
    
      out.value = left.value < right.value ? -1 : ((left.value == right.value)? 0 : 1);
  

  
  

}
      }
  }


}
