
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionCostCategory;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;

@SuppressWarnings("unused")
public class GCompareIntervalYearFunctions {

  @FunctionTemplate(name = "compare_to", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CompareIntervalYear implements DrillSimpleFunc {

      @Param IntervalYearHolder left;
      @Param IntervalYearHolder right;
      @Output IntHolder out;

      public void setup(RecordBatch b) {}

      public void eval() {

          out.value = (left.value > right.value) ? 1 : ((left.value < right.value) ? -1 : 0);
      }
  }

  @FunctionTemplate(name = "less_than", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanIntervalYear implements DrillSimpleFunc {

      @Param IntervalYearHolder left;
      @Param IntervalYearHolder right;
      @Output BitHolder out;

      public void setup(RecordBatch b) {}

      public void eval() {
        out.value = left.value < right.value ? 1 : 0;
      }
  }

  @FunctionTemplate(name = "less_than_or_equal_to", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanEIntervalYear implements DrillSimpleFunc {

      @Param IntervalYearHolder left;
      @Param IntervalYearHolder right;
      @Output BitHolder out;

      public void setup(RecordBatch b) {}

      public void eval() {
        out.value = left.value <= right.value ? 1 : 0;
    }
  }

  @FunctionTemplate(name = "greater_than", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanIntervalYear implements DrillSimpleFunc {

      @Param IntervalYearHolder left;
      @Param IntervalYearHolder right;
      @Output BitHolder out;

      public void setup(RecordBatch b) {}

      public void eval() {
        out.value = left.value > right.value ? 1 : 0;
    }
  }

  @FunctionTemplate(name = "greater_than_or_equal_to", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanEIntervalYear implements DrillSimpleFunc {

      @Param IntervalYearHolder left;
      @Param IntervalYearHolder right;
      @Output BitHolder out;

      public void setup(RecordBatch b) {}

      public void eval() {
        out.value = left.value >= right.value ? 1 : 0;
      }
  }

  @FunctionTemplate(name = "equal", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class EqualsIntervalYear implements DrillSimpleFunc {

      @Param IntervalYearHolder left;
      @Param IntervalYearHolder right;
      @Output BitHolder out;

      public void setup(RecordBatch b) {}

      public void eval() {
        out.value = left.value == right.value ? 1 : 0;
      }
  }

  @FunctionTemplate(name = "not_equal", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class NotEqualsIntervalYear implements DrillSimpleFunc {

      @Param IntervalYearHolder left;
      @Param IntervalYearHolder right;
      @Output BitHolder out;

      public void setup(RecordBatch b) {}

      public void eval() {
        out.value = left.value != right.value ? 1 : 0;
      }
  }

}




