/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.lambda.functions;

import java.util.Arrays;
import java.util.Iterator;
import net.hydromatic.lambda.functions.BiPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiPredicates {
    private static final BiPredicate<Object, Object> IS_NULL = new AbstractBiPredicate<Object, Object>(){

        @Override
        public boolean eval(Object o, Object o2) {
            return o == null;
        }
    };
    private static final BiPredicate<Object, Object> NON_NULL = new AbstractBiPredicate<Object, Object>(){

        @Override
        public boolean eval(Object o, Object o2) {
            return o != null;
        }
    };
    private static final BiPredicate<Object, Object> FALSE = new AbstractBiPredicate<Object, Object>(){

        @Override
        public boolean eval(Object o, Object o2) {
            return false;
        }
    };
    private static final BiPredicate<Object, Object> TRUE = new AbstractBiPredicate<Object, Object>(){

        @Override
        public boolean eval(Object o, Object o2) {
            return false;
        }
    };

    private BiPredicates() {
        throw new AssertionError((Object)"No instances!");
    }

    public static <K, V> BiPredicate<K, V> isNull() {
        return IS_NULL;
    }

    public static <K, V> BiPredicate<K, V> nonNull() {
        return NON_NULL;
    }

    public static <K, V> BiPredicate<K, V> alwaysFalse() {
        return FALSE;
    }

    public static <K, V> BiPredicate<K, V> alwaysTrue() {
        return TRUE;
    }

    public static <K, V> BiPredicate<K, V> negate(final BiPredicate<? super K, ? super V> biPredicate) {
        return new AbstractBiPredicate<K, V>(){

            @Override
            public boolean eval(K k, V v) {
                return !biPredicate.eval(k, v);
            }
        };
    }

    public static <K, V> BiPredicate<K, V> and(final BiPredicate<? super K, ? super V> first, final BiPredicate<? super K, ? super V> second) {
        return new AbstractBiPredicate<K, V>(){

            @Override
            public boolean eval(K k, V v) {
                return first.eval(k, v) && second.eval(k, v);
            }
        };
    }

    public static <K, V> BiPredicate<K, V> and(final Iterable<? extends BiPredicate<? super K, ? super V>> predicates) {
        return new AbstractBiPredicate<K, V>(){

            @Override
            public boolean eval(K k, V v) {
                for (BiPredicate predicate : predicates) {
                    if (predicate.eval(k, v)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <K, V> BiPredicate<K, V> and(final BiPredicate<? super K, ? super V> first, final Iterable<? extends BiPredicate<? super K, ? super V>> predicates) {
        return new AbstractBiPredicate<K, V>(){

            @Override
            public boolean eval(K k, V v) {
                if (!first.eval(k, v)) {
                    return false;
                }
                for (BiPredicate predicate : predicates) {
                    if (predicate.eval(k, v)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <K, V> BiPredicate<K, V> or(final BiPredicate<? super K, ? super V> first, final BiPredicate<? super K, ? super V> second) {
        return new AbstractBiPredicate<K, V>(){

            @Override
            public boolean eval(K k, V v) {
                return first.eval(k, v) || second.eval(k, v);
            }
        };
    }

    public static <K, V> BiPredicate<K, V> or(final Iterable<? extends BiPredicate<? super K, ? super V>> predicates) {
        return new AbstractBiPredicate<K, V>(){

            @Override
            public boolean eval(K k, V v) {
                for (BiPredicate predicate : predicates) {
                    if (!predicate.eval(k, v)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <K, V> BiPredicate<K, V> or(final BiPredicate<? super K, ? super V> first, final Iterable<? extends BiPredicate<? super K, ? super V>> predicates) {
        return new AbstractBiPredicate<K, V>(){

            @Override
            public boolean eval(K k, V v) {
                if (first.eval(k, v)) {
                    return true;
                }
                for (BiPredicate predicate : predicates) {
                    if (!predicate.eval(k, v)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <K, V> BiPredicate<K, V> or(BiPredicate<? super K, ? super V> ... predicates) {
        return BiPredicates.or(Arrays.asList(predicates));
    }

    public static <K, V> BiPredicate<K, V> xor(final BiPredicate<? super K, ? super V> first, final BiPredicate<? super K, ? super V> second) {
        return new AbstractBiPredicate<K, V>(){

            @Override
            public boolean eval(K k, V v) {
                return first.eval(k, v) ^ second.eval(k, v);
            }
        };
    }

    public static <K, V> BiPredicate<K, V> xor(final Iterable<? extends BiPredicate<? super K, ? super V>> predicates) {
        return new AbstractBiPredicate<K, V>(){

            @Override
            public boolean eval(K k, V v) {
                Iterator iterator = predicates.iterator();
                if (!iterator.hasNext()) {
                    return false;
                }
                boolean b = ((BiPredicate)iterator.next()).eval(k, v);
                while (iterator.hasNext()) {
                    if (((BiPredicate)iterator.next()).eval(k, v) == b) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <K, V> BiPredicate<K, V> xor(final BiPredicate<? super K, ? super V> first, final Iterable<? extends BiPredicate<? super K, ? super V>> predicates) {
        return new AbstractBiPredicate<K, V>(){

            @Override
            public boolean eval(K k, V v) {
                boolean b = first.eval(k, v);
                for (BiPredicate predicate : predicates) {
                    if (predicate.eval(k, v) == b) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <K, V> BiPredicate<K, V> xor(BiPredicate<? super K, ? super V> ... predicates) {
        return BiPredicates.xor(Arrays.asList(predicates));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractBiPredicate<K, V>
    implements BiPredicate<K, V> {
        @Override
        public BiPredicate<K, V> and(BiPredicate<? super K, ? super V> p) {
            return BiPredicates.and(this, p);
        }

        @Override
        public BiPredicate<K, V> or(BiPredicate<? super K, ? super V> p) {
            return BiPredicates.or(this, p);
        }

        @Override
        public BiPredicate<K, V> xor(BiPredicate<? super K, ? super V> p) {
            return BiPredicates.xor(this, p);
        }

        public BiPredicate<K, V> negate() {
            return BiPredicates.negate(this);
        }
    }
}

