/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec;

import de.huxhorn.sulky.codec.Encoder;
import de.huxhorn.sulky.codec.EnumPersistenceDelegate;
import de.huxhorn.sulky.io.IOUtilities;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlEncoder<E>
implements Encoder<E> {
    private static final Class[] NO_ENUMS = new Class[0];
    private boolean compressing;
    private final Class[] enums;
    private EnumPersistenceDelegate enumDelegate;

    public XmlEncoder() {
        this(false);
    }

    public XmlEncoder(boolean compressing) {
        this(compressing, NO_ENUMS);
    }

    public XmlEncoder(boolean compressing, Class ... enums) {
        this.setCompressing(compressing);
        this.enums = enums;
        if (this.enums != null && this.enums.length > 0) {
            this.enumDelegate = new EnumPersistenceDelegate();
        }
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode(E object) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            XMLEncoder encoder;
            if (this.compressing) {
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(bos);
                encoder = new XMLEncoder(gZIPOutputStream);
            } else {
                encoder = new XMLEncoder(bos);
            }
            if (this.enums != null) {
                for (Class c : this.enums) {
                    encoder.setPersistenceDelegate(c, this.enumDelegate);
                }
            }
            encoder.writeObject(object);
            encoder.close();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtilities.closeQuietly((OutputStream)bos);
        }
    }

    public String toString() {
        return "XmlEncoder[compressing=" + this.compressing + ", enums=" + Arrays.toString(this.enums) + "]";
    }
}

