/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.validation;

import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.util.StringUtils;
import org.datanucleus.validation.PersistenceTraversalResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidatorHandler
implements CallbackHandler {
    Validator validator;
    ClassLoaderResolver clr;
    PersistenceConfiguration conf;

    public BeanValidatorHandler(ExecutionContext ec, ValidatorFactory factory) {
        this.conf = ec.getNucleusContext().getPersistenceConfiguration();
        this.clr = ec.getClassLoaderResolver();
        this.validator = factory.usingContext().traversableResolver((TraversableResolver)new PersistenceTraversalResolver(ec)).getValidator();
    }

    public void validate(Object pc, String callbackName, Class<?>[] groups) {
        if (this.validator == null) {
            return;
        }
        Set violations = this.validator.validate(pc, (Class[])groups);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException("Validation failed for " + StringUtils.toJVMIDString(pc) + " during " + callbackName + " for groups " + StringUtils.objectArrayToString(groups) + " - exceptions are attached", violations);
        }
    }

    @Override
    public void preDelete(Object pc) {
        Class<?>[] groups = this.getGroups(this.conf.getStringProperty("datanucleus.validation.group.pre-remove"), "pre-remove");
        if (groups != null) {
            this.validate(pc, "pre-remove", groups);
        }
    }

    @Override
    public void preStore(Object pc) {
        Class<?>[] groups = this.getGroups(this.conf.getStringProperty("datanucleus.validation.group.pre-update"), "pre-update");
        if (groups != null) {
            this.validate(pc, "pre-update", groups);
        }
    }

    @Override
    public void prePersist(Object pc) {
        Class<?>[] groups = this.getGroups(this.conf.getStringProperty("datanucleus.validation.group.pre-persist"), "pre-persist");
        if (groups != null) {
            this.validate(pc, "pre-persist", groups);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void setValidationListener(CallbackHandler handler) {
    }

    @Override
    public void addListener(Object listener, Class[] classes) {
    }

    @Override
    public void removeListener(Object listener) {
    }

    @Override
    public void postAttach(Object pc, Object detachedPC) {
    }

    @Override
    public void postClear(Object pc) {
    }

    @Override
    public void postCreate(Object pc) {
    }

    @Override
    public void postDelete(Object pc) {
    }

    @Override
    public void postDetach(Object pc, Object detachedPC) {
    }

    @Override
    public void postDirty(Object pc) {
    }

    @Override
    public void postLoad(Object pc) {
    }

    @Override
    public void postRefresh(Object pc) {
    }

    @Override
    public void postStore(Object pc) {
    }

    @Override
    public void preAttach(Object detachedPC) {
    }

    @Override
    public void preClear(Object pc) {
    }

    @Override
    public void preDetach(Object pc) {
    }

    @Override
    public void preDirty(Object pc) {
    }

    private Class<?>[] getGroups(String property, String eventName) {
        if (property == null || property.trim().length() == 0) {
            if (eventName.equals("pre-persist") || eventName.equals("pre-update")) {
                return new Class[]{Default.class};
            }
            return null;
        }
        String[] classNames = property.trim().split(",");
        Class[] groups = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            groups[i] = this.clr.classForName(classNames[i].trim());
        }
        return groups;
    }
}

