/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo.schema;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mongodb.DB;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DynamicDrillTable;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.SchemaFactory;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.mongo.MongoCnxnManager;
import org.apache.drill.exec.store.mongo.MongoScanSpec;
import org.apache.drill.exec.store.mongo.MongoStoragePlugin;
import org.apache.drill.exec.store.mongo.schema.MongoDatabaseSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoSchemaFactory
implements SchemaFactory {
    static final Logger logger = LoggerFactory.getLogger(MongoSchemaFactory.class);
    private static final String DATABASES = "databases";
    private LoadingCache<String, List<String>> databases;
    private LoadingCache<String, List<String>> tableNameLoader;
    private final String schemaName;
    private final MongoStoragePlugin plugin;
    private final List<ServerAddress> addresses;
    private final MongoClientOptions options;

    public MongoSchemaFactory(MongoStoragePlugin schema, String schemaName) throws ExecutionSetupException, UnknownHostException {
        String connection = schema.getConfig().getConnection();
        this.plugin = schema;
        this.schemaName = schemaName;
        MongoClientURI clientURI = new MongoClientURI(connection);
        List hosts = clientURI.getHosts();
        this.addresses = Lists.newArrayList();
        for (String host : hosts) {
            this.addresses.add(new ServerAddress(host));
        }
        this.options = clientURI.getOptions();
        this.databases = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new DatabaseLoader());
        this.tableNameLoader = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new TableNameLoader());
    }

    public void registerSchemas(UserSession session, SchemaPlus parent) {
        MongoSchema schema = new MongoSchema(this.schemaName);
        SchemaPlus hPlus = parent.add(this.schemaName, (Schema)schema);
        schema.setHolder(hPlus);
    }

    class MongoSchema
    extends AbstractSchema {
        public MongoSchema(String name) {
            super((List)ImmutableList.of(), name);
        }

        public Schema getSubSchema(String name) {
            try {
                List tables = (List)MongoSchemaFactory.this.tableNameLoader.get((Object)name);
                return new MongoDatabaseSchema(tables, this, name);
            }
            catch (ExecutionException e) {
                logger.warn("Failure while attempting to access MongoDataBase '{}'.", (Object)name, (Object)e.getCause());
                return null;
            }
        }

        void setHolder(SchemaPlus plusOfThis) {
            for (String s : this.getSubSchemaNames()) {
                plusOfThis.add(s, this.getSubSchema(s));
            }
        }

        public boolean showInInformationSchema() {
            return false;
        }

        public Set<String> getSubSchemaNames() {
            try {
                List dbs = (List)MongoSchemaFactory.this.databases.get((Object)MongoSchemaFactory.DATABASES);
                return Sets.newHashSet((Iterable)dbs);
            }
            catch (ExecutionException e) {
                logger.warn("Failure while getting Mongo database list.", (Throwable)e);
                return Collections.emptySet();
            }
        }

        List<String> getTableNames(String dbName) {
            try {
                return (List)MongoSchemaFactory.this.tableNameLoader.get((Object)dbName);
            }
            catch (ExecutionException e) {
                logger.warn("Failure while loading table names for database '{}'.", (Object)dbName, (Object)e.getCause());
                return Collections.emptyList();
            }
        }

        DrillTable getDrillTable(String dbName, String collectionName) {
            MongoScanSpec mongoScanSpec = new MongoScanSpec(dbName, collectionName);
            return new DynamicDrillTable((StoragePlugin)MongoSchemaFactory.this.plugin, MongoSchemaFactory.this.schemaName, (Object)mongoScanSpec);
        }

        public String getTypeName() {
            return "mongo";
        }
    }

    private class TableNameLoader
    extends CacheLoader<String, List<String>> {
        private TableNameLoader() {
        }

        public List<String> load(String dbName) throws Exception {
            DB db = MongoCnxnManager.getClient(MongoSchemaFactory.this.addresses, MongoSchemaFactory.this.options).getDB(dbName);
            db.setReadPreference(ReadPreference.nearest());
            Set collectionNames = db.getCollectionNames();
            return new ArrayList<String>(collectionNames);
        }
    }

    private class DatabaseLoader
    extends CacheLoader<String, List<String>> {
        private DatabaseLoader() {
        }

        public List<String> load(String key) throws Exception {
            if (!MongoSchemaFactory.DATABASES.equals(key)) {
                throw new UnsupportedOperationException();
            }
            return MongoCnxnManager.getClient(MongoSchemaFactory.this.addresses, MongoSchemaFactory.this.options).getDatabaseNames();
        }
    }
}

