/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo.schema;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.hydromatic.optiq.Table;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.mongo.schema.MongoSchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDatabaseSchema
extends AbstractSchema {
    static final Logger logger = LoggerFactory.getLogger(MongoDatabaseSchema.class);
    private final MongoSchemaFactory.MongoSchema mongoSchema;
    private final Set<String> tables;

    public MongoDatabaseSchema(List<String> tableList, MongoSchemaFactory.MongoSchema mongoSchema, String name) {
        super(mongoSchema.getSchemaPath(), name);
        this.mongoSchema = mongoSchema;
        this.tables = Sets.newHashSet(tableList);
    }

    public Table getTable(String tableName) {
        return this.mongoSchema.getDrillTable(this.name, tableName);
    }

    public Set<String> getTableNames() {
        return this.tables;
    }

    public String getTypeName() {
        return "mongo";
    }
}

