/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.LazyWriteableDBObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.BSONObject;
import org.bson.LazyBSONCallback;

public class MongoUtils {
    public static BasicDBObject andFilterAtIndex(BasicDBObject leftFilter, BasicDBObject rightFilter) {
        BasicDBObject andQueryFilter = new BasicDBObject();
        ArrayList<BasicDBObject> filters = new ArrayList<BasicDBObject>();
        filters.add(leftFilter);
        filters.add(rightFilter);
        andQueryFilter.put("$and", filters);
        return andQueryFilter;
    }

    public static BasicDBObject orFilterAtIndex(BasicDBObject leftFilter, BasicDBObject rightFilter) {
        BasicDBObject orQueryFilter = new BasicDBObject();
        ArrayList<BasicDBObject> filters = new ArrayList<BasicDBObject>();
        filters.add(leftFilter);
        filters.add(rightFilter);
        orQueryFilter.put("$or", filters);
        return orQueryFilter;
    }

    public static BasicDBObject deserializeFilter(byte[] filterBytes) {
        LazyWriteableDBObject dbo = new LazyWriteableDBObject(filterBytes, new LazyBSONCallback());
        BasicDBObject result = new BasicDBObject();
        result.putAll((BSONObject)dbo);
        return result;
    }

    public static Map<String, List<BasicDBObject>> mergeFilters(Map<String, Object> minFilters, Map<String, Object> maxFilters) {
        List list;
        HashMap filters = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : minFilters.entrySet()) {
            list = (List)filters.get(entry.getKey());
            if (list == null) {
                list = Lists.newArrayList();
                filters.put(entry.getKey(), list);
            }
            list.add(new BasicDBObject(entry.getKey(), (Object)new BasicDBObject("$gte", entry.getValue())));
        }
        for (Map.Entry<String, Object> entry : maxFilters.entrySet()) {
            list = (List)filters.get(entry.getKey());
            if (list == null) {
                list = Lists.newArrayList();
                filters.put(entry.getKey(), list);
            }
            list.add(new BasicDBObject(entry.getKey(), (Object)new BasicDBObject("$lt", entry.getValue())));
        }
        return filters;
    }
}

