/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import net.hydromatic.optiq.SchemaPlus;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.mongo.MongoGroupScan;
import org.apache.drill.exec.store.mongo.MongoPushDownFilterForScan;
import org.apache.drill.exec.store.mongo.MongoScanSpec;
import org.apache.drill.exec.store.mongo.MongoStoragePluginConfig;
import org.apache.drill.exec.store.mongo.schema.MongoSchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoStoragePlugin
extends AbstractStoragePlugin {
    static final Logger logger = LoggerFactory.getLogger(MongoStoragePlugin.class);
    private DrillbitContext context;
    private MongoStoragePluginConfig mongoConfig;
    private MongoSchemaFactory schemaFactory;

    public MongoStoragePlugin(MongoStoragePluginConfig mongoConfig, DrillbitContext context, String name) throws IOException, ExecutionSetupException {
        this.context = context;
        this.mongoConfig = mongoConfig;
        this.schemaFactory = new MongoSchemaFactory(this, name);
    }

    public DrillbitContext getContext() {
        return this.context;
    }

    public MongoStoragePluginConfig getConfig() {
        return this.mongoConfig;
    }

    public void registerSchemas(UserSession session, SchemaPlus parent) {
        this.schemaFactory.registerSchemas(session, parent);
    }

    public boolean supportsRead() {
        return true;
    }

    public AbstractGroupScan getPhysicalScan(JSONOptions selection) throws IOException {
        MongoScanSpec mongoScanSpec = (MongoScanSpec)selection.getListWith(new ObjectMapper(), (TypeReference)new TypeReference<MongoScanSpec>(){});
        return new MongoGroupScan(this, mongoScanSpec, null);
    }

    public Set<StoragePluginOptimizerRule> getOptimizerRules() {
        return ImmutableSet.of((Object)MongoPushDownFilterForScan.INSTANCE);
    }
}

