/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.mongo.MongoCnxnManager;
import org.apache.drill.exec.store.mongo.MongoSubScan;
import org.apache.drill.exec.store.mongo.MongoUtils;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.complex.fn.JsonReader;
import org.apache.drill.exec.vector.complex.impl.VectorContainerWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoRecordReader
extends AbstractRecordReader {
    static final Logger logger = LoggerFactory.getLogger(MongoRecordReader.class);
    private static final int TARGET_RECORD_COUNT = 3000;
    private DBCollection collection;
    private DBCursor cursor;
    private NullableVarCharVector valueVector;
    private JsonReader jsonReader;
    private VectorContainerWriter writer;
    private List<SchemaPath> columns;
    private BasicDBObject filters;
    private DBObject fields;
    private MongoClientOptions clientOptions;
    private FragmentContext fragmentContext;
    private OperatorContext operatorContext;
    private Boolean enableAllTextMode;

    public MongoRecordReader(MongoSubScan.MongoSubScanSpec subScanSpec, List<SchemaPath> projectedColumns, FragmentContext context, MongoClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.fields = new BasicDBObject();
        this.fields.put("_id", (Object)0);
        this.columns = projectedColumns;
        this.setColumns(projectedColumns);
        this.transformColumns(projectedColumns);
        this.fragmentContext = context;
        this.filters = new BasicDBObject();
        Map<String, List<BasicDBObject>> mergedFilters = MongoUtils.mergeFilters(subScanSpec.getMinFilters(), subScanSpec.getMaxFilters());
        this.buildFilters(subScanSpec.getFilter(), mergedFilters);
        this.enableAllTextMode = this.fragmentContext.getDrillbitContext().getOptionManager().getOption((String)"store.mongo.all_text_mode").bool_val;
        this.init(subScanSpec);
    }

    protected Collection<SchemaPath> transformColumns(Collection<SchemaPath> projectedColumns) {
        LinkedHashSet transformed = Sets.newLinkedHashSet();
        if (!this.isStarQuery()) {
            for (SchemaPath column : projectedColumns) {
                PathSegment.NameSegment root = column.getRootSegment();
                String fieldName = root.getPath();
                transformed.add(SchemaPath.getSimplePath((String)fieldName));
                this.fields.put(fieldName, (Object)1);
            }
        }
        return transformed;
    }

    private void buildFilters(BasicDBObject pushdownFilters, Map<String, List<BasicDBObject>> mergedFilters) {
        for (Map.Entry<String, List<BasicDBObject>> entry : mergedFilters.entrySet()) {
            List<BasicDBObject> list = entry.getValue();
            if (list.size() == 1) {
                this.filters.putAll(list.get(0).toMap());
                continue;
            }
            BasicDBObject andQueryFilter = new BasicDBObject();
            andQueryFilter.put("$and", list);
            this.filters.putAll(andQueryFilter.toMap());
        }
        if (pushdownFilters != null && !pushdownFilters.toMap().isEmpty()) {
            this.filters = !mergedFilters.isEmpty() ? MongoUtils.andFilterAtIndex(this.filters, pushdownFilters) : pushdownFilters;
        }
    }

    private void init(MongoSubScan.MongoSubScanSpec subScanSpec) {
        try {
            List<String> hosts = subScanSpec.getHosts();
            ArrayList addresses = Lists.newArrayList();
            for (String host : hosts) {
                addresses.add(new ServerAddress(host));
            }
            MongoClient client = MongoCnxnManager.getClient(addresses, this.clientOptions);
            DB db = client.getDB(subScanSpec.getDbName());
            db.setReadPreference(ReadPreference.nearest());
            this.collection = db.getCollection(subScanSpec.getCollectionName());
        }
        catch (UnknownHostException e) {
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void setup(OutputMutator output) throws ExecutionSetupException {
        if (this.isStarQuery()) {
            try {
                SchemaPath startColumn = SchemaPath.getSimplePath((String)"*");
                MaterializedField field = MaterializedField.create((SchemaPath)startColumn, (TypeProtos.MajorType)Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
                this.valueVector = (NullableVarCharVector)output.addField(field, NullableVarCharVector.class);
            }
            catch (SchemaChangeException e) {
                throw new ExecutionSetupException((Throwable)e);
            }
        } else {
            this.writer = new VectorContainerWriter(output);
            this.jsonReader = new JsonReader(this.fragmentContext.getManagedBuffer(), this.columns, this.enableAllTextMode.booleanValue());
        }
        logger.info("Filters Applied : " + this.filters);
        logger.info("Fields Selected :" + this.fields);
        this.cursor = this.collection.find((DBObject)this.filters, this.fields);
    }

    private int handleNonStarQuery() {
        this.writer.allocate();
        this.writer.reset();
        int docCount = 0;
        Stopwatch watch = new Stopwatch();
        watch.start();
        try {
            int rowCount;
            String errMsg = "Document {} is too big to fit into allocated ValueVector";
            for (rowCount = 0; rowCount < 3000 && this.cursor.hasNext(); ++rowCount) {
                this.writer.setPosition(docCount);
                String doc = this.cursor.next().toString();
                this.jsonReader.setSource(doc.getBytes(Charsets.UTF_8));
                if (this.jsonReader.write((BaseWriter.ComplexWriter)this.writer) == JsonReader.ReadState.WRITE_SUCCEED) {
                    ++docCount;
                    break;
                }
                if (docCount != 0) continue;
                throw new DrillRuntimeException(errMsg);
            }
            this.jsonReader.ensureAtLeastOneField((BaseWriter.ComplexWriter)this.writer);
            this.writer.setValueCount(docCount);
            logger.debug("Took {} ms to get {} records", (Object)watch.elapsed(TimeUnit.MILLISECONDS), (Object)rowCount);
            return docCount;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DrillRuntimeException("Failure while reading Mongo Record.", (Throwable)e);
        }
    }

    private int handleStarQuery() {
        Stopwatch watch = new Stopwatch();
        watch.start();
        if (this.valueVector == null) {
            throw new DrillRuntimeException("Value vector is not initialized!!!");
        }
        this.valueVector.clear();
        this.valueVector.allocateNew(0xBB8000, 3000);
        String errMsg = "Document {} is too big to fit into allocated ValueVector";
        try {
            int rowCount;
            for (rowCount = 0; rowCount < 3000 && this.cursor.hasNext(); ++rowCount) {
                String doc = this.cursor.next().toString();
                byte[] record = doc.getBytes(Charsets.UTF_8);
                if (this.valueVector.getMutator().setSafe(rowCount, record, 0, record.length)) continue;
                logger.warn(errMsg, (Object)doc);
                if (rowCount == 0) break;
            }
            this.valueVector.getMutator().setValueCount(rowCount);
            logger.debug("Took {} ms to get {} records", (Object)watch.elapsed(TimeUnit.MILLISECONDS), (Object)rowCount);
            return rowCount;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DrillRuntimeException("Failure while reading Mongo Record.", (Throwable)e);
        }
    }

    public int next() {
        return this.isStarQuery() ? this.handleStarQuery() : this.handleNonStarQuery();
    }

    public void cleanup() {
    }

    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public void setOperatorContext(OperatorContext operatorContext) {
        this.operatorContext = operatorContext;
    }
}

