/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.google.common.collect.ImmutableList;
import com.mongodb.BasicDBObject;
import java.io.IOException;
import org.apache.drill.common.expression.BooleanOperator;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.exec.store.mongo.DrillMongoConstants;
import org.apache.drill.exec.store.mongo.MongoCompareFunctionProcessor;
import org.apache.drill.exec.store.mongo.MongoGroupScan;
import org.apache.drill.exec.store.mongo.MongoScanSpec;
import org.apache.drill.exec.store.mongo.MongoUtils;
import org.apache.drill.exec.store.mongo.common.MongoCompareOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoFilterBuilder
extends AbstractExprVisitor<MongoScanSpec, Void, RuntimeException>
implements DrillMongoConstants {
    static final Logger logger = LoggerFactory.getLogger(MongoFilterBuilder.class);
    final MongoGroupScan groupScan;
    final LogicalExpression le;
    private boolean allExpressionsConverted = true;

    public MongoFilterBuilder(MongoGroupScan groupScan, LogicalExpression conditionExp) {
        this.groupScan = groupScan;
        this.le = conditionExp;
    }

    public MongoScanSpec parseTree() {
        MongoScanSpec parsedSpec = (MongoScanSpec)this.le.accept((ExprVisitor)this, null);
        if (parsedSpec != null) {
            parsedSpec = this.mergeScanSpecs("booleanAnd", this.groupScan.getScanSpec(), parsedSpec);
        }
        return parsedSpec;
    }

    private MongoScanSpec mergeScanSpecs(String functionName, MongoScanSpec leftScanSpec, MongoScanSpec rightScanSpec) {
        BasicDBObject newFilter = null;
        switch (functionName) {
            case "booleanAnd": {
                if (leftScanSpec.getFilters() != null && rightScanSpec.getFilters() != null) {
                    newFilter = MongoUtils.andFilterAtIndex(leftScanSpec.getFilters(), rightScanSpec.getFilters());
                    break;
                }
                if (leftScanSpec.getFilters() != null) {
                    newFilter = leftScanSpec.getFilters();
                    break;
                }
                newFilter = rightScanSpec.getFilters();
                break;
            }
            case "booleanOr": {
                newFilter = MongoUtils.orFilterAtIndex(leftScanSpec.getFilters(), rightScanSpec.getFilters());
            }
        }
        return new MongoScanSpec(this.groupScan.getScanSpec().getDbName(), this.groupScan.getScanSpec().getCollectionName(), newFilter);
    }

    public boolean isAllExpressionsConverted() {
        return this.allExpressionsConverted;
    }

    public MongoScanSpec visitUnknown(LogicalExpression e, Void value) throws RuntimeException {
        this.allExpressionsConverted = false;
        return null;
    }

    public MongoScanSpec visitBooleanOperator(BooleanOperator op, Void value) {
        ImmutableList args = op.args;
        MongoScanSpec nodeScanSpec = null;
        String functionName = op.getName();
        block7: for (int i = 0; i < args.size(); ++i) {
            switch (functionName) {
                case "booleanAnd": 
                case "booleanOr": {
                    if (nodeScanSpec == null) {
                        nodeScanSpec = (MongoScanSpec)((LogicalExpression)args.get(i)).accept((ExprVisitor)this, null);
                        continue block7;
                    }
                    MongoScanSpec scanSpec = (MongoScanSpec)((LogicalExpression)args.get(i)).accept((ExprVisitor)this, null);
                    if (scanSpec != null) {
                        nodeScanSpec = this.mergeScanSpecs(functionName, nodeScanSpec, scanSpec);
                        continue block7;
                    }
                    this.allExpressionsConverted = false;
                }
            }
        }
        return nodeScanSpec;
    }

    public MongoScanSpec visitFunctionCall(FunctionCall call, Void value) throws RuntimeException {
        MongoScanSpec nodeScanSpec = null;
        String functionName = call.getName();
        ImmutableList args = call.args;
        if (MongoCompareFunctionProcessor.isCompareFunction(functionName)) {
            MongoCompareFunctionProcessor processor = MongoCompareFunctionProcessor.process(call);
            if (processor.isSuccess()) {
                try {
                    nodeScanSpec = this.createMongoScanSpec(processor.getFunctionName(), processor.getPath(), processor.getValue());
                }
                catch (Exception e) {
                    logger.error(" Failed to creare Filter ", (Throwable)e);
                }
            }
        } else {
            switch (functionName) {
                case "booleanAnd": 
                case "booleanOr": {
                    MongoScanSpec leftScanSpec = (MongoScanSpec)((LogicalExpression)args.get(0)).accept((ExprVisitor)this, null);
                    MongoScanSpec rightScanSpec = (MongoScanSpec)((LogicalExpression)args.get(1)).accept((ExprVisitor)this, null);
                    if (leftScanSpec != null && rightScanSpec != null) {
                        nodeScanSpec = this.mergeScanSpecs(functionName, leftScanSpec, rightScanSpec);
                        break;
                    }
                    this.allExpressionsConverted = false;
                    if (!"booleanAnd".equals(functionName)) break;
                    MongoScanSpec mongoScanSpec = nodeScanSpec = leftScanSpec == null ? rightScanSpec : leftScanSpec;
                }
            }
        }
        if (nodeScanSpec == null) {
            this.allExpressionsConverted = false;
        }
        return nodeScanSpec;
    }

    private MongoScanSpec createMongoScanSpec(String functionName, SchemaPath field, Object fieldValue) throws ClassNotFoundException, IOException {
        String fieldName = field.getAsUnescapedPath();
        MongoCompareOp compareOp = null;
        switch (functionName) {
            case "equal": {
                compareOp = MongoCompareOp.EQUAL;
                break;
            }
            case "not_equal": {
                compareOp = MongoCompareOp.NOT_EQUAL;
                break;
            }
            case "greater_than_or_equal_to": {
                compareOp = MongoCompareOp.GREATER_OR_EQUAL;
                break;
            }
            case "greater_than": {
                compareOp = MongoCompareOp.GREATER;
                break;
            }
            case "less_than_or_equal_to": {
                compareOp = MongoCompareOp.LESS_OR_EQUAL;
                break;
            }
            case "less_than": {
                compareOp = MongoCompareOp.LESS;
                break;
            }
            case "isnull": 
            case "isNull": 
            case "is null": {
                compareOp = MongoCompareOp.IFNULL;
                break;
            }
            case "isnotnull": 
            case "isNotNull": 
            case "is not null": {
                compareOp = MongoCompareOp.IFNOTNULL;
            }
        }
        if (compareOp != null) {
            BasicDBObject queryFilter = new BasicDBObject();
            if (compareOp == MongoCompareOp.IFNULL) {
                queryFilter.put(fieldName, (Object)new BasicDBObject(MongoCompareOp.EQUAL.getCompareOp(), null));
            } else if (compareOp == MongoCompareOp.IFNOTNULL) {
                queryFilter.put(fieldName, (Object)new BasicDBObject(MongoCompareOp.NOT_EQUAL.getCompareOp(), null));
            } else {
                queryFilter.put(fieldName, (Object)new BasicDBObject(compareOp.getCompareOp(), fieldValue));
            }
            return new MongoScanSpec(this.groupScan.getScanSpec().getDbName(), this.groupScan.getScanSpec().getCollectionName(), queryFilter);
        }
        return null;
    }
}

