/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoCnxnManager {
    private static final Logger logger = LoggerFactory.getLogger(MongoCnxnManager.class);
    private static Cache<ServerAddress, MongoClient> addressClientMap = CacheBuilder.newBuilder().maximumSize(5L).expireAfterAccess(10L, TimeUnit.MINUTES).removalListener((RemovalListener)new AddressCloser()).build();

    public static synchronized MongoClient getClient(List<ServerAddress> addresses, MongoClientOptions clientOptions) throws UnknownHostException {
        ServerAddress serverAddress = addresses.get(0);
        MongoClient client = (MongoClient)addressClientMap.getIfPresent((Object)serverAddress);
        if (client == null) {
            client = new MongoClient(addresses, clientOptions);
            addressClientMap.put((Object)serverAddress, (Object)client);
            logger.debug("Created connection to {}.", (Object)serverAddress.toString());
            logger.debug("Number of connections opened are {}.", (Object)addressClientMap.size());
        }
        return client;
    }

    private static class AddressCloser
    implements RemovalListener<ServerAddress, MongoClient> {
        private AddressCloser() {
        }

        public synchronized void onRemoval(RemovalNotification<ServerAddress, MongoClient> removal) {
            ((MongoClient)removal.getValue()).close();
            logger.debug("Closed connection to {}.", (Object)((ServerAddress)removal.getKey()).toString());
        }
    }
}

