/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.hbase.HiveHBaseTableInputFormat;
import org.apache.hadoop.hive.hbase.HiveHBaseTableOutputFormat;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.StringUtils;

public class HBaseStorageHandler
extends DefaultStorageHandler
implements HiveMetaHook,
HiveStoragePredicateHandler {
    public static final String DEFAULT_PREFIX = "default.";
    private boolean configureInputJobProps = true;
    private Configuration jobConf;
    private Configuration hbaseConf;
    private HBaseAdmin admin;

    private HBaseAdmin getHBaseAdmin() throws MetaException {
        try {
            if (this.admin == null) {
                this.admin = new HBaseAdmin(this.hbaseConf);
            }
            return this.admin;
        }
        catch (IOException ioe) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ioe));
        }
    }

    private String getHBaseTableName(Table tbl) {
        String tableName = (String)tbl.getParameters().get("hbase.table.name");
        if (tableName == null && (tableName = (String)tbl.getSd().getSerdeInfo().getParameters().get("hbase.table.name")) != null) {
            tableName = tableName.toLowerCase();
        }
        if (tableName == null && (tableName = (tbl.getDbName() + "." + tbl.getTableName()).toLowerCase()).startsWith(DEFAULT_PREFIX)) {
            tableName = tableName.substring(DEFAULT_PREFIX.length());
        }
        return tableName;
    }

    public void preDropTable(Table table) throws MetaException {
    }

    public void rollbackDropTable(Table table) throws MetaException {
    }

    public void commitDropTable(Table tbl, boolean deleteData) throws MetaException {
        try {
            String tableName = this.getHBaseTableName(tbl);
            boolean isExternal = MetaStoreUtils.isExternalTable((Table)tbl);
            if (deleteData && !isExternal) {
                if (this.getHBaseAdmin().isTableEnabled(tableName)) {
                    this.getHBaseAdmin().disableTable(tableName);
                }
                this.getHBaseAdmin().deleteTable(tableName);
            }
        }
        catch (IOException ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void preCreateTable(Table tbl) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)tbl);
        if (tbl.getSd().getLocation() != null) {
            throw new MetaException("LOCATION may not be specified for HBase.");
        }
        try {
            HTableDescriptor tableDesc;
            String tableName = this.getHBaseTableName(tbl);
            Map serdeParam = tbl.getSd().getSerdeInfo().getParameters();
            String hbaseColumnsMapping = (String)serdeParam.get("hbase.columns.mapping");
            List<HBaseSerDe.ColumnMapping> columnsMapping = null;
            columnsMapping = HBaseSerDe.parseColumnsMapping(hbaseColumnsMapping);
            if (!this.getHBaseAdmin().tableExists(tableName)) {
                if (isExternal) throw new MetaException("HBase table " + tableName + " doesn't exist while the table is declared as an external table.");
                tableDesc = new HTableDescriptor(tableName);
                HashSet<String> uniqueColumnFamilies = new HashSet<String>();
                for (HBaseSerDe.ColumnMapping colMap : columnsMapping) {
                    if (colMap.hbaseRowKey) continue;
                    uniqueColumnFamilies.add(colMap.familyName);
                }
                for (String columnFamily : uniqueColumnFamilies) {
                    tableDesc.addFamily(new HColumnDescriptor(Bytes.toBytes((String)columnFamily)));
                }
                this.getHBaseAdmin().createTable(tableDesc);
            } else {
                if (!isExternal) {
                    throw new MetaException("Table " + tableName + " already exists" + " within HBase; use CREATE EXTERNAL TABLE instead to" + " register it in Hive.");
                }
                tableDesc = this.getHBaseAdmin().getTableDescriptor(Bytes.toBytes((String)tableName));
                for (int i = 0; i < columnsMapping.size(); ++i) {
                    HBaseSerDe.ColumnMapping colMap = columnsMapping.get(i);
                    if (colMap.hbaseRowKey || tableDesc.hasFamily(colMap.familyNameBytes)) continue;
                    throw new MetaException("Column Family " + colMap.familyName + " is not defined in hbase table " + tableName);
                }
            }
            new HTable(this.hbaseConf, tableDesc.getName());
            return;
        }
        catch (MasterNotRunningException mnre) {
            throw new MetaException(StringUtils.stringifyException((Throwable)mnre));
        }
        catch (IOException ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
        catch (SerDeException se) {
            throw new MetaException(StringUtils.stringifyException((Throwable)se));
        }
    }

    public void rollbackCreateTable(Table table) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)table);
        String tableName = this.getHBaseTableName(table);
        try {
            if (!isExternal && this.getHBaseAdmin().tableExists(tableName)) {
                if (this.getHBaseAdmin().isTableEnabled(tableName)) {
                    this.getHBaseAdmin().disableTable(tableName);
                }
                this.getHBaseAdmin().deleteTable(tableName);
            }
        }
        catch (IOException ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
    }

    public void commitCreateTable(Table table) throws MetaException {
    }

    public Configuration getConf() {
        return this.hbaseConf;
    }

    public Configuration getJobConf() {
        return this.jobConf;
    }

    public void setConf(Configuration conf) {
        this.jobConf = conf;
        this.hbaseConf = HBaseConfiguration.create((Configuration)conf);
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return HiveHBaseTableInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return HiveHBaseTableOutputFormat.class;
    }

    public Class<? extends SerDe> getSerDeClass() {
        return HBaseSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return this;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureInputJobProps = true;
        this.configureTableJobProperties(tableDesc, jobProperties);
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureInputJobProps = false;
        this.configureTableJobProperties(tableDesc, jobProperties);
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        String tableName;
        String scanBatch;
        String scanCacheBlocks;
        Properties tableProperties = tableDesc.getProperties();
        jobProperties.put("hbase.columns.mapping", tableProperties.getProperty("hbase.columns.mapping"));
        jobProperties.put("hbase.columns.mapping.regex.matching", tableProperties.getProperty("hbase.columns.mapping.regex.matching", "true"));
        jobProperties.put("hbase.table.default.storage.type", tableProperties.getProperty("hbase.table.default.storage.type", "string"));
        String scanCache = tableProperties.getProperty("hbase.scan.cache");
        if (scanCache != null) {
            jobProperties.put("hbase.scan.cache", scanCache);
        }
        if ((scanCacheBlocks = tableProperties.getProperty("hbase.scan.cacheblock")) != null) {
            jobProperties.put("hbase.scan.cacheblock", scanCacheBlocks);
        }
        if ((scanBatch = tableProperties.getProperty("hbase.scan.batch")) != null) {
            jobProperties.put("hbase.scan.batch", scanBatch);
        }
        if ((tableName = tableProperties.getProperty("hbase.table.name")) == null) {
            tableName = tableProperties.getProperty("name");
            if ((tableName = tableName.toLowerCase()).startsWith(DEFAULT_PREFIX)) {
                tableName = tableName.substring(DEFAULT_PREFIX.length());
            }
        }
        jobProperties.put("hbase.table.name", tableName);
        Configuration jobConf = this.getJobConf();
        this.addHBaseResources(jobConf, jobProperties);
        if (this.configureInputJobProps) {
            try {
                HBaseConfiguration.addHbaseResources((Configuration)jobConf);
                this.addHBaseDelegationToken(jobConf);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while configuring input job properties", e);
            }
        } else {
            Configuration copyOfConf = new Configuration(jobConf);
            HBaseConfiguration.addHbaseResources((Configuration)copyOfConf);
            jobProperties.put("hbase.mapred.outputtable", tableName);
        }
    }

    private void addHBaseResources(Configuration jobConf, Map<String, String> newJobProperties) {
        Configuration conf = new Configuration(false);
        HBaseConfiguration.addHbaseResources((Configuration)conf);
        for (Map.Entry entry : conf) {
            if (jobConf.get((String)entry.getKey()) != null) continue;
            newJobProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void addHBaseDelegationToken(Configuration conf) throws IOException {
        if (User.isHBaseSecurityEnabled((Configuration)conf)) {
            try {
                User.getCurrent().obtainAuthTokenForJob(conf, new Job(conf));
            }
            catch (InterruptedException e) {
                throw new IOException("Error while obtaining hbase delegation token", e);
            }
        }
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        try {
            TableMapReduceUtil.addDependencyJars((Configuration)jobConf, (Class[])new Class[0]);
            TableMapReduceUtil.addDependencyJars((Configuration)jobConf, (Class[])new Class[]{HBaseStorageHandler.class, HBaseConfiguration.class});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf jobConf, Deserializer deserializer, ExprNodeDesc predicate) {
        String columnNameProperty = jobConf.get("columns");
        List<String> columnNames = Arrays.asList(columnNameProperty.split(","));
        HBaseSerDe hbaseSerde = (HBaseSerDe)deserializer;
        int keyColPos = hbaseSerde.getKeyColumnOffset();
        String keyColType = jobConf.get("columns.types").split(",")[keyColPos];
        IndexPredicateAnalyzer analyzer = HiveHBaseTableInputFormat.newIndexPredicateAnalyzer(columnNames.get(keyColPos), keyColType, hbaseSerde.getStorageFormatOfCol(keyColPos).get(0));
        ArrayList searchConditions = new ArrayList();
        ExprNodeDesc residualPredicate = analyzer.analyzePredicate(predicate, searchConditions);
        int scSize = searchConditions.size();
        if (scSize < 1 || 2 < scSize) {
            return null;
        }
        if (scSize == 2 && (((IndexSearchCondition)searchConditions.get(0)).getComparisonOp().equals("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual") || ((IndexSearchCondition)searchConditions.get(1)).getComparisonOp().equals("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual"))) {
            return null;
        }
        HiveStoragePredicateHandler.DecomposedPredicate decomposedPredicate = new HiveStoragePredicateHandler.DecomposedPredicate();
        decomposedPredicate.pushedPredicate = analyzer.translateSearchConditions(searchConditions);
        decomposedPredicate.residualPredicate = residualPredicate;
        return decomposedPredicate;
    }
}

