/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Keying {
    private static final String SCHEME = "r:";
    private static final Pattern URI_RE_PARSER = Pattern.compile("^([^:/?#]+://(?:[^/?#@]+@)?)([^:/?#]+)(.*)$");

    public static String createKey(String u) {
        if (u.startsWith(SCHEME)) {
            throw new IllegalArgumentException("Starts with r:");
        }
        Matcher m = Keying.getMatcher(u);
        if (m == null || !m.matches()) {
            return u;
        }
        return SCHEME + m.group(1) + Keying.reverseHostname(m.group(2)) + m.group(3);
    }

    public static String keyToUri(String s) {
        if (!s.startsWith(SCHEME)) {
            return s;
        }
        Matcher m = Keying.getMatcher(s.substring(SCHEME.length()));
        if (m == null || !m.matches()) {
            return s;
        }
        return m.group(1) + Keying.reverseHostname(m.group(2)) + m.group(3);
    }

    private static Matcher getMatcher(String u) {
        if (u == null || u.length() <= 0) {
            return null;
        }
        return URI_RE_PARSER.matcher(u);
    }

    private static String reverseHostname(String hostname) {
        if (hostname == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(hostname.length());
        StringTokenizer st = new StringTokenizer(hostname, ".", false);
        while (st.hasMoreElements()) {
            Object next = st.nextElement();
            if (sb.length() > 0) {
                sb.insert(0, ".");
            }
            sb.insert(0, next);
        }
        return sb.toString();
    }
}

