/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.FSUtils;

public class HFileArchiveUtil {
    private HFileArchiveUtil() {
    }

    public static Path getStoreArchivePath(Configuration conf, String tableName, String regionName, String familyName) throws IOException {
        Path tableArchiveDir = HFileArchiveUtil.getTableArchivePath(conf, tableName);
        return Store.getStoreHomedir(tableArchiveDir, regionName, familyName);
    }

    public static Path getStoreArchivePath(Configuration conf, HRegion region, byte[] family) {
        return HFileArchiveUtil.getStoreArchivePath(conf, region.getRegionInfo(), region.getTableDir(), family);
    }

    public static Path getStoreArchivePath(Configuration conf, HRegionInfo region, Path tabledir, byte[] family) {
        Path tableArchiveDir = HFileArchiveUtil.getTableArchivePath(tabledir);
        return Store.getStoreHomedir(tableArchiveDir, HRegionInfo.encodeRegionName(region.getRegionName()), family);
    }

    public static Path getRegionArchiveDir(Configuration conf, Path tabledir, Path regiondir) {
        Path archiveDir = HFileArchiveUtil.getTableArchivePath(tabledir);
        String encodedRegionName = regiondir.getName();
        return HRegion.getRegionDir(archiveDir, encodedRegionName);
    }

    public static Path getRegionArchiveDir(Path rootdir, Path tabledir, Path regiondir) {
        Path archiveDir = HFileArchiveUtil.getTableArchivePath(rootdir, tabledir.getName());
        String encodedRegionName = regiondir.getName();
        return HRegion.getRegionDir(archiveDir, encodedRegionName);
    }

    public static Path getTableArchivePath(Path tabledir) {
        Path root = tabledir.getParent();
        return HFileArchiveUtil.getTableArchivePath(root, tabledir.getName());
    }

    public static Path getTableArchivePath(Path rootdir, String tableName) {
        return new Path(HFileArchiveUtil.getArchivePath(rootdir), tableName);
    }

    public static Path getTableArchivePath(Configuration conf, String tableName) throws IOException {
        return new Path(HFileArchiveUtil.getArchivePath(conf), tableName);
    }

    public static Path getArchivePath(Configuration conf) throws IOException {
        return HFileArchiveUtil.getArchivePath(FSUtils.getRootDir(conf));
    }

    private static Path getArchivePath(Path rootdir) {
        return new Path(rootdir, ".archive");
    }
}

