/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;

public class AuthenticationTokenIdentifier
extends TokenIdentifier {
    public static final byte VERSION = 1;
    public static final Text AUTH_TOKEN_TYPE = new Text("HBASE_AUTH_TOKEN");
    protected String username;
    protected int keyId;
    protected long issueDate;
    protected long expirationDate;
    protected long sequenceNumber;

    public AuthenticationTokenIdentifier() {
    }

    public AuthenticationTokenIdentifier(String username) {
        this.username = username;
    }

    public AuthenticationTokenIdentifier(String username, int keyId, long issueDate, long expirationDate) {
        this.username = username;
        this.keyId = keyId;
        this.issueDate = issueDate;
        this.expirationDate = expirationDate;
    }

    public Text getKind() {
        return AUTH_TOKEN_TYPE;
    }

    public UserGroupInformation getUser() {
        if (this.username == null || "".equals(this.username)) {
            return null;
        }
        return UserGroupInformation.createRemoteUser((String)this.username);
    }

    public String getUsername() {
        return this.username;
    }

    void setUsername(String name) {
        this.username = name;
    }

    public int getKeyId() {
        return this.keyId;
    }

    void setKeyId(int id) {
        this.keyId = id;
    }

    public long getIssueDate() {
        return this.issueDate;
    }

    void setIssueDate(long timestamp) {
        this.issueDate = timestamp;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    void setExpirationDate(long timestamp) {
        this.expirationDate = timestamp;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    void setSequenceNumber(long seq) {
        this.sequenceNumber = seq;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(1);
        WritableUtils.writeString((DataOutput)out, (String)this.username);
        WritableUtils.writeVInt((DataOutput)out, (int)this.keyId);
        WritableUtils.writeVLong((DataOutput)out, (long)this.issueDate);
        WritableUtils.writeVLong((DataOutput)out, (long)this.expirationDate);
        WritableUtils.writeVLong((DataOutput)out, (long)this.sequenceNumber);
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version != 1) {
            throw new IOException("Version mismatch in deserialization: expected=1, got=" + version);
        }
        this.username = WritableUtils.readString((DataInput)in);
        this.keyId = WritableUtils.readVInt((DataInput)in);
        this.issueDate = WritableUtils.readVLong((DataInput)in);
        this.expirationDate = WritableUtils.readVLong((DataInput)in);
        this.sequenceNumber = WritableUtils.readVLong((DataInput)in);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof AuthenticationTokenIdentifier) {
            AuthenticationTokenIdentifier ident = (AuthenticationTokenIdentifier)((Object)other);
            return this.sequenceNumber == ident.getSequenceNumber() && this.keyId == ident.getKeyId() && this.issueDate == ident.getIssueDate() && this.expirationDate == ident.getExpirationDate() && (this.username == null ? ident.getUsername() == null : this.username.equals(ident.getUsername()));
        }
        return false;
    }

    public int hashCode() {
        return (int)this.sequenceNumber;
    }
}

