/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.util.Bytes;

public class TablePermission
extends Permission {
    private static Log LOG = LogFactory.getLog(TablePermission.class);
    private byte[] table;
    private byte[] family;
    private byte[] qualifier;

    public TablePermission() {
    }

    public TablePermission(byte[] table, byte[] family, Permission.Action ... assigned) {
        this(table, family, (byte[])null, assigned);
    }

    public TablePermission(byte[] table, byte[] family, byte[] qualifier, Permission.Action ... assigned) {
        super(assigned);
        this.table = table;
        this.family = family;
        this.qualifier = qualifier;
    }

    public TablePermission(byte[] table, byte[] family, byte[] qualifier, byte[] actionCodes) {
        super(actionCodes);
        this.table = table;
        this.family = family;
        this.qualifier = qualifier;
    }

    public byte[] getTable() {
        return this.table;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public boolean implies(byte[] table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (!Bytes.equals(this.table, table)) {
            return false;
        }
        if (!(this.family == null || family != null && Bytes.equals(this.family, family))) {
            return false;
        }
        if (!(this.qualifier == null || qualifier != null && Bytes.equals(this.qualifier, qualifier))) {
            return false;
        }
        return super.implies(action);
    }

    public boolean implies(byte[] table, KeyValue kv, Permission.Action action) {
        if (!Bytes.equals(this.table, table)) {
            return false;
        }
        if (this.family != null && Bytes.compareTo(this.family, 0, this.family.length, kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength()) != 0) {
            return false;
        }
        if (this.qualifier != null && Bytes.compareTo(this.qualifier, 0, this.qualifier.length, kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength()) != 0) {
            return false;
        }
        return super.implies(action);
    }

    public boolean matchesFamily(byte[] table, byte[] family, Permission.Action action) {
        if (!Bytes.equals(this.table, table)) {
            return false;
        }
        if (!(this.family == null || family != null && Bytes.equals(this.family, family))) {
            return false;
        }
        return super.implies(action);
    }

    public boolean matchesFamilyQualifier(byte[] table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (!this.matchesFamily(table, family, action)) {
            return false;
        }
        if (!(this.qualifier == null || qualifier != null && Bytes.equals(this.qualifier, qualifier))) {
            return false;
        }
        return super.implies(action);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TablePermission)) {
            return false;
        }
        TablePermission other = (TablePermission)((Object)obj);
        if (!(Bytes.equals(this.table, other.getTable()) && (this.family == null && other.getFamily() == null || Bytes.equals(this.family, other.getFamily())) && (this.qualifier == null && other.getQualifier() == null || Bytes.equals(this.qualifier, other.getQualifier())))) {
            return false;
        }
        return super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int prime = 37;
        int result = super.hashCode();
        if (this.table != null) {
            result = 37 * result + Bytes.hashCode(this.table);
        }
        if (this.family != null) {
            result = 37 * result + Bytes.hashCode(this.family);
        }
        if (this.qualifier != null) {
            result = 37 * result + Bytes.hashCode(this.qualifier);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("[TablePermission: ").append("table=").append(Bytes.toString(this.table)).append(", family=").append(Bytes.toString(this.family)).append(", qualifier=").append(Bytes.toString(this.qualifier)).append(", actions=");
        if (this.actions != null) {
            for (int i = 0; i < this.actions.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                if (this.actions[i] != null) {
                    str.append(this.actions[i].toString());
                    continue;
                }
                str.append("NULL");
            }
        }
        str.append("]");
        return str.toString();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.table = Bytes.readByteArray(in);
        if (in.readBoolean()) {
            this.family = Bytes.readByteArray(in);
        }
        if (in.readBoolean()) {
            this.qualifier = Bytes.readByteArray(in);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Bytes.writeByteArray(out, this.table);
        out.writeBoolean(this.family != null);
        if (this.family != null) {
            Bytes.writeByteArray(out, this.family);
        }
        out.writeBoolean(this.qualifier != null);
        if (this.qualifier != null) {
            Bytes.writeByteArray(out, this.qualifier);
        }
    }
}

