/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TableAuthManager;

class AccessControlFilter
extends FilterBase {
    private TableAuthManager authManager;
    private byte[] table;
    private User user;

    AccessControlFilter() {
    }

    AccessControlFilter(TableAuthManager mgr, User ugi, byte[] tableName) {
        this.authManager = mgr;
        this.table = tableName;
        this.user = ugi;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue kv) {
        if (this.authManager.authorize(this.user, this.table, kv, Permission.Action.READ)) {
            return Filter.ReturnCode.INCLUDE;
        }
        return Filter.ReturnCode.NEXT_COL;
    }

    public void write(DataOutput dataOutput) throws IOException {
        throw new UnsupportedOperationException("Serialization not supported.  Intended for server-side use only.");
    }

    public void readFields(DataInput dataInput) throws IOException {
        throw new UnsupportedOperationException("Serialization not supported.  Intended for server-side use only.");
    }
}

