/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSinkMetrics;
import org.apache.hadoop.hbase.util.Bytes;

public class ReplicationSink {
    private static final Log LOG = LogFactory.getLog(ReplicationSink.class);
    public static final String REPLICATION_LOG_DIR = ".replogs";
    private final Configuration conf;
    private final HConnection sharedHtableCon;
    private final ReplicationSinkMetrics metrics;

    public ReplicationSink(Configuration conf, Stoppable stopper) throws IOException {
        this.conf = HBaseConfiguration.create(conf);
        this.decorateConf();
        this.sharedHtableCon = HConnectionManager.createConnection(this.conf);
        this.metrics = new ReplicationSinkMetrics();
    }

    private void decorateConf() {
        this.conf.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, this.conf.getInt("replication.sink.client.retries.number", 4));
        this.conf.setInt("hbase.client.operation.timeout", this.conf.getInt("replication.sink.client.ops.timeout", 10000));
    }

    public void replicateEntries(HLog.Entry[] entries) throws IOException {
        if (entries.length == 0) {
            return;
        }
        try {
            long totalReplicated = 0L;
            TreeMap rowMap = new TreeMap(Bytes.BYTES_COMPARATOR);
            for (HLog.Entry entry : entries) {
                WALEdit edit = entry.getEdit();
                byte[] table = entry.getKey().getTablename();
                Put put2 = null;
                Delete del = null;
                KeyValue lastKV = null;
                List<KeyValue> kvs = edit.getKeyValues();
                for (KeyValue kv : kvs) {
                    if (lastKV == null || lastKV.getType() != kv.getType() || !lastKV.matchingRow(kv)) {
                        UUID clusterId = entry.getKey().getClusterId();
                        List<UUID> clusterIds = edit.getClusterIds();
                        if (kv.isDelete()) {
                            del = new Delete(kv.getRow());
                            del.setClusterId(clusterId);
                            del.setClusterIds(clusterIds);
                            clusterIds.add(clusterId);
                            this.addToHashMultiMap(rowMap, table, clusterIds, del);
                        } else {
                            put2 = new Put(kv.getRow());
                            put2.setClusterId(clusterId);
                            put2.setClusterIds(clusterIds);
                            clusterIds.add(clusterId);
                            this.addToHashMultiMap(rowMap, table, clusterIds, put2);
                        }
                    }
                    if (kv.isDelete()) {
                        del.addDeleteMarker(kv);
                    } else {
                        put2.add(kv);
                    }
                    lastKV = kv;
                }
                ++totalReplicated;
            }
            for (Map.Entry entry : rowMap.entrySet()) {
                this.batch((byte[])entry.getKey(), ((Map)entry.getValue()).values());
            }
            this.metrics.setAgeOfLastAppliedOp(entries[entries.length - 1].getKey().getWriteTime());
            this.metrics.appliedBatchesRate.inc(1);
            LOG.info((Object)("Total replicated: " + totalReplicated));
        }
        catch (IOException ex) {
            LOG.error((Object)"Unable to accept edit because:", (Throwable)ex);
            throw ex;
        }
    }

    private <K1, K2, V> List<V> addToHashMultiMap(Map<K1, Map<K2, List<V>>> map, K1 key1, K2 key2, V value) {
        List<V> values;
        Map<K2, List<List<V>>> innerMap = map.get(key1);
        if (innerMap == null) {
            innerMap = new HashMap<K2, List<V>>();
            map.put(key1, innerMap);
        }
        if ((values = innerMap.get(key2)) == null) {
            values = new ArrayList<V>();
            innerMap.put(key2, values);
        }
        values.add(value);
        return values;
    }

    public void stopReplicationSinkServices() {
        try {
            this.sharedHtableCon.close();
        }
        catch (IOException e) {
            LOG.warn((Object)"IOException while closing the connection", (Throwable)e);
        }
    }

    protected void batch(byte[] tableName, Collection<List<Row>> allRows) throws IOException {
        if (allRows.isEmpty()) {
            return;
        }
        HTableInterface table = null;
        try {
            table = this.sharedHtableCon.getTable(tableName);
            for (List<Row> rows : allRows) {
                table.batch(rows);
                this.metrics.appliedOpsRate.inc(rows.size());
            }
        }
        catch (InterruptedException ix) {
            throw new IOException(ix);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }
}

