/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.metrics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.apache.hadoop.hbase.util.ClassSize;

public class SchemaConfigured
implements HeapSize,
SchemaMetrics.SchemaAware {
    private static final Log LOG = LogFactory.getLog(SchemaConfigured.class);
    private String cfName;
    private String tableName;
    private SchemaMetrics schemaMetrics;
    public static final int SCHEMA_CONFIGURED_UNALIGNED_HEAP_SIZE;
    private static final int SCHEMA_CONFIGURED_ALIGNED_HEAP_SIZE;

    private SchemaConfigured(Configuration conf) {
        SchemaMetrics.configureGlobally(conf);
    }

    public static SchemaConfigured createUnknown() {
        return new SchemaConfigured(null, "__unknown", "__unknown");
    }

    public SchemaConfigured() {
    }

    public SchemaConfigured(Configuration conf, Path path) {
        this(conf);
        if (path != null) {
            String[] splits = path.toString().split("/");
            int numPathLevels = splits.length;
            if (numPathLevels > 0 && splits[0].isEmpty()) {
                --numPathLevels;
            }
            if (numPathLevels < 5) {
                LOG.warn((Object)("Could not determine table and column family of the HFile path " + path + ". Expecting at least " + 5 + " path components."));
                path = null;
            } else {
                this.cfName = splits[splits.length - 2];
                if (this.cfName.equals(".tmp")) {
                    this.cfName = null;
                }
                this.tableName = splits[splits.length - 4];
                return;
            }
        }
        this.cfName = "__unknown";
        this.tableName = "__unknown";
    }

    public SchemaConfigured(Path path) {
        this(null, path);
    }

    public SchemaConfigured(Configuration conf, String tableName, String cfName) {
        this(conf);
        this.tableName = tableName;
        this.cfName = cfName;
    }

    public SchemaConfigured(SchemaMetrics.SchemaAware that) {
        this.tableName = that.getTableName();
        this.cfName = that.getColumnFamilyName();
        this.schemaMetrics = that.getSchemaMetrics();
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getColumnFamilyName() {
        return this.cfName;
    }

    @Override
    public SchemaMetrics getSchemaMetrics() {
        if (this.schemaMetrics == null) {
            if (this.tableName == null || this.cfName == null) {
                throw new IllegalStateException("Schema metrics requested before table/CF name initialization: " + this.schemaConfAsJSON());
            }
            this.schemaMetrics = SchemaMetrics.getInstance(this.tableName, this.cfName);
        }
        return this.schemaMetrics;
    }

    public void passSchemaMetricsTo(SchemaConfigured target) {
        if (this.isNull()) {
            SchemaConfigured.resetSchemaMetricsConf(target);
            return;
        }
        if (!this.isSchemaConfigured()) {
            throw new IllegalStateException("Table name/CF not initialized: " + this.schemaConfAsJSON());
        }
        if (this.conflictingWith(target)) {
            throw new IllegalArgumentException("Trying to change table name to \"" + this.tableName + "\", CF name to \"" + this.cfName + "\" from " + target.schemaConfAsJSON());
        }
        target.tableName = this.tableName;
        target.cfName = this.cfName;
        target.schemaMetrics = this.schemaMetrics;
        target.schemaConfigurationChanged();
    }

    public static void resetSchemaMetricsConf(SchemaConfigured target) {
        target.tableName = null;
        target.cfName = null;
        target.schemaMetrics = null;
        target.schemaConfigurationChanged();
    }

    @Override
    public long heapSize() {
        return SCHEMA_CONFIGURED_ALIGNED_HEAP_SIZE;
    }

    public String schemaConfAsJSON() {
        return "{\"tableName\":\"" + this.tableName + "\",\"cfName\":\"" + this.cfName + "\"}";
    }

    protected boolean isSchemaConfigured() {
        return this.tableName != null && this.cfName != null;
    }

    private boolean isNull() {
        return this.tableName == null && this.cfName == null && this.schemaMetrics == null;
    }

    boolean conflictingWith(SchemaConfigured other) {
        return other.tableName != null && !this.tableName.equals(other.tableName) || other.cfName != null && !this.cfName.equals(other.cfName);
    }

    protected void schemaConfigurationChanged() {
    }

    static {
        if (ClassSize.OBJECT <= 0 || ClassSize.REFERENCE <= 0) {
            throw new AssertionError((Object)"Class sizes are not initialized");
        }
        SCHEMA_CONFIGURED_UNALIGNED_HEAP_SIZE = ClassSize.OBJECT + 3 * ClassSize.REFERENCE;
        SCHEMA_CONFIGURED_ALIGNED_HEAP_SIZE = ClassSize.align(SCHEMA_CONFIGURED_UNALIGNED_HEAP_SIZE);
    }
}

