/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseFileSystem;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.InvalidHFileException;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.ChangedReadersObserver;
import org.apache.hadoop.hbase.regionserver.Compactor;
import org.apache.hadoop.hbase.regionserver.CompoundConfiguration;
import org.apache.hadoop.hbase.regionserver.GetClosestRowBeforeTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.regionserver.compactions.CompactSelection;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaConfigured;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.CollectionBackedScanner;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSHDFSUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.util.StringUtils;

public class Store
extends SchemaConfigured
implements HeapSize {
    static final Log LOG = LogFactory.getLog(Store.class);
    public static final String BLOCKING_STOREFILES_KEY = "hbase.hstore.blockingStoreFiles";
    public static final int DEFAULT_BLOCKING_STOREFILE_COUNT = 7;
    protected final MemStore memstore;
    private final Path homedir;
    private final HRegion region;
    private final HColumnDescriptor family;
    final FileSystem fs;
    final Configuration conf;
    final CacheConfig cacheConf;
    private long ttl;
    private final int minFilesToCompact;
    private final int maxFilesToCompact;
    private final long minCompactSize;
    private final long maxCompactSize;
    private long lastCompactSize = 0L;
    volatile boolean forceMajor = false;
    static int closeCheckInterval = 0;
    private final int blockingStoreFileCount;
    private volatile long storeSize = 0L;
    private volatile long totalUncompressedBytes = 0L;
    private final Object flushLock = new Object();
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final boolean verifyBulkLoads;
    private long blockingFileCount;
    public static final int PRIORITY_USER = 1;
    public static final int NO_PRIORITY = Integer.MIN_VALUE;
    ScanInfo scanInfo;
    private volatile ImmutableList<StoreFile> storefiles = null;
    List<StoreFile> filesCompacting = Lists.newArrayList();
    private final Set<ChangedReadersObserver> changedReaderObservers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final int blocksize;
    private HFileDataBlockEncoder dataBlockEncoder;
    private ChecksumType checksumType;
    private int bytesPerChecksum;
    final KeyValue.KVComparator comparator;
    private final Compactor compactor;
    private static final int DEFAULT_FLUSH_RETRIES_NUMBER = 10;
    private static int flush_retries_number;
    private static int pauseTime;
    public static final long FIXED_OVERHEAD;
    public static final long DEEP_OVERHEAD;

    protected Store(Path basedir, HRegion region, HColumnDescriptor family, FileSystem fs, Configuration confParam) throws IOException {
        super(new CompoundConfiguration().add(confParam).add(family.getValues()), region.getTableDesc().getNameAsString(), Bytes.toString(family.getName()));
        HRegionInfo info = region.getRegionInfo();
        this.fs = fs;
        Path p = Store.getStoreHomedir(basedir, info.getEncodedName(), family.getName());
        this.homedir = this.createStoreHomeDir(this.fs, p);
        this.region = region;
        this.family = family;
        this.conf = new CompoundConfiguration().add(confParam).add(family.getValues());
        this.blocksize = family.getBlocksize();
        this.dataBlockEncoder = new HFileDataBlockEncoderImpl(family.getDataBlockEncodingOnDisk(), family.getDataBlockEncoding());
        this.comparator = info.getComparator();
        this.ttl = family.getTimeToLive();
        this.ttl = this.ttl == Integer.MAX_VALUE ? Long.MAX_VALUE : (this.ttl == -1L ? Long.MAX_VALUE : (this.ttl *= 1000L));
        long timeToPurgeDeletes = Math.max(this.conf.getLong("hbase.hstore.time.to.purge.deletes", 0L), 0L);
        LOG.info((Object)("time to purge deletes set to " + timeToPurgeDeletes + "ms in store " + this));
        this.scanInfo = new ScanInfo(family, this.ttl, timeToPurgeDeletes, this.comparator);
        this.memstore = new MemStore(this.conf, this.comparator);
        this.minFilesToCompact = Math.max(2, this.conf.getInt("hbase.hstore.compaction.min", this.conf.getInt("hbase.hstore.compactionThreshold", 3)));
        LOG.info((Object)("hbase.hstore.compaction.min = " + this.minFilesToCompact));
        this.cacheConf = new CacheConfig(this.conf, family);
        this.blockingStoreFileCount = this.conf.getInt(BLOCKING_STOREFILES_KEY, 7);
        this.maxFilesToCompact = this.conf.getInt("hbase.hstore.compaction.max", 10);
        this.minCompactSize = this.conf.getLong("hbase.hstore.compaction.min.size", this.region.memstoreFlushSize);
        this.maxCompactSize = this.conf.getLong("hbase.hstore.compaction.max.size", Long.MAX_VALUE);
        this.verifyBulkLoads = this.conf.getBoolean("hbase.hstore.bulkload.verify", false);
        this.blockingFileCount = this.conf.getInt(BLOCKING_STOREFILES_KEY, 7);
        if (closeCheckInterval == 0) {
            closeCheckInterval = this.conf.getInt("hbase.hstore.close.check.interval", 10000000);
        }
        this.storefiles = this.sortAndClone(this.loadStoreFiles());
        this.checksumType = Store.getChecksumType(this.conf);
        this.bytesPerChecksum = Store.getBytesPerChecksum(this.conf);
        this.compactor = new Compactor(this.conf);
        if (flush_retries_number == 0) {
            flush_retries_number = this.conf.getInt("hbase.hstore.flush.retries.number", 10);
            pauseTime = this.conf.getInt(HConstants.HBASE_SERVER_PAUSE, HConstants.DEFAULT_HBASE_SERVER_PAUSE);
            if (flush_retries_number <= 0) {
                throw new IllegalArgumentException("hbase.hstore.flush.retries.number must be > 0, not " + flush_retries_number);
            }
        }
    }

    long getTTL(HColumnDescriptor family) {
        long ttl = family.getTimeToLive();
        ttl = ttl == Integer.MAX_VALUE ? Long.MAX_VALUE : (ttl == -1L ? Long.MAX_VALUE : (ttl *= 1000L));
        return ttl;
    }

    Path createStoreHomeDir(FileSystem fs, Path homedir) throws IOException {
        if (!fs.exists(homedir) && !HBaseFileSystem.makeDirOnFileSystem(fs, homedir)) {
            throw new IOException("Failed create of: " + homedir.toString());
        }
        return homedir;
    }

    FileSystem getFileSystem() {
        return this.fs;
    }

    public static int getBytesPerChecksum(Configuration conf) {
        return conf.getInt("hbase.hstore.bytes.per.checksum", 16384);
    }

    public static ChecksumType getChecksumType(Configuration conf) {
        String checksumName = conf.get("hbase.hstore.checksum.algorithm");
        if (checksumName == null) {
            return HFile.DEFAULT_CHECKSUM_TYPE;
        }
        return ChecksumType.nameToType(checksumName);
    }

    public HColumnDescriptor getFamily() {
        return this.family;
    }

    long getMaxSequenceId() {
        return StoreFile.getMaxSequenceIdInList(this.getStorefiles());
    }

    public long getMaxMemstoreTS() {
        return StoreFile.getMaxMemstoreTSInList(this.getStorefiles());
    }

    public static Path getStoreHomedir(Path tabledir, String encodedName, byte[] family) {
        return Store.getStoreHomedir(tabledir, encodedName, Bytes.toString(family));
    }

    public long getFlushableSize() {
        return this.memstore.getFlushableSize();
    }

    public static Path getStoreHomedir(Path tabledir, String encodedName, String family) {
        return new Path(tabledir, new Path(encodedName, new Path(family)));
    }

    public static Path getStoreHomedir(Path parentRegionDirectory, byte[] family) {
        return new Path(parentRegionDirectory, new Path(Bytes.toString(family)));
    }

    Path getHomedir() {
        return this.homedir;
    }

    public HFileDataBlockEncoder getDataBlockEncoder() {
        return this.dataBlockEncoder;
    }

    void setDataBlockEncoderInTest(HFileDataBlockEncoder blockEncoder) {
        this.dataBlockEncoder = blockEncoder;
    }

    FileStatus[] getStoreFiles() throws IOException {
        return FSUtils.listStatus(this.fs, this.homedir, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StoreFile> loadStoreFiles() throws IOException {
        ArrayList<StoreFile> results = new ArrayList<StoreFile>();
        FileStatus[] files = this.getStoreFiles();
        if (files == null || files.length == 0) {
            return results;
        }
        ThreadPoolExecutor storeFileOpenerThreadPool = this.region.getStoreFileOpenAndCloseThreadPool("StoreFileOpenerThread-" + this.family.getNameAsString());
        ExecutorCompletionService<StoreFile> completionService = new ExecutorCompletionService<StoreFile>(storeFileOpenerThreadPool);
        int totalValidStoreFile = 0;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDir()) continue;
            final Path p = files[i].getPath();
            if (!HFileLink.isHFileLink(p) && this.fs.getFileStatus(p).getLen() <= 0L) {
                LOG.warn((Object)("Skipping " + p + " because its empty. HBASE-646 DATA LOSS?"));
                continue;
            }
            completionService.submit(new Callable<StoreFile>(){

                @Override
                public StoreFile call() throws IOException {
                    StoreFile storeFile = new StoreFile(Store.this.fs, p, Store.this.conf, Store.this.cacheConf, Store.this.family.getBloomFilterType(), Store.this.dataBlockEncoder);
                    Store.this.passSchemaMetricsTo(storeFile);
                    storeFile.createReader();
                    return storeFile;
                }
            });
            ++totalValidStoreFile;
        }
        IOException ioe = null;
        try {
            for (int i = 0; i < totalValidStoreFile; ++i) {
                try {
                    Future future = completionService.take();
                    StoreFile storeFile = (StoreFile)future.get();
                    long length = storeFile.getReader().length();
                    this.storeSize += length;
                    this.totalUncompressedBytes += storeFile.getReader().getTotalUncompressedBytes();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("loaded " + storeFile.toStringDetailed()));
                    }
                    results.add(storeFile);
                    continue;
                }
                catch (InterruptedException e) {
                    if (ioe != null) continue;
                    ioe = new InterruptedIOException(e.getMessage());
                    continue;
                }
                catch (ExecutionException e) {
                    if (ioe != null) continue;
                    ioe = new IOException(e.getCause());
                }
            }
        }
        finally {
            storeFileOpenerThreadPool.shutdownNow();
        }
        if (ioe != null) {
            for (StoreFile file : results) {
                try {
                    if (file == null) continue;
                    file.closeReader(true);
                }
                catch (IOException e) {
                    LOG.warn((Object)e.getMessage());
                }
            }
            throw ioe;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long add(KeyValue kv) {
        this.lock.readLock().lock();
        try {
            long l = this.memstore.add(kv);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long timeOfOldestEdit() {
        return this.memstore.timeOfOldestEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long delete(KeyValue kv) {
        this.lock.readLock().lock();
        try {
            long l = this.memstore.delete(kv);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollback(KeyValue kv) {
        this.lock.readLock().lock();
        try {
            this.memstore.rollback(kv);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<StoreFile> getStorefiles() {
        return this.storefiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertBulkLoadHFileOk(Path srcPath) throws IOException {
        Closeable reader = null;
        try {
            LOG.info((Object)("Validating hfile at " + srcPath + " for inclusion in " + "store " + this + " region " + this.region));
            reader = HFile.createReader(srcPath.getFileSystem(this.conf), srcPath, this.cacheConf);
            reader.loadFileInfo();
            byte[] firstKey = reader.getFirstRowKey();
            byte[] lk = reader.getLastKey();
            byte[] lastKey = lk == null ? null : KeyValue.createKeyValueFromKey(lk).getRow();
            LOG.debug((Object)("HFile bounds: first=" + Bytes.toStringBinary(firstKey) + " last=" + Bytes.toStringBinary(lastKey)));
            LOG.debug((Object)("Region bounds: first=" + Bytes.toStringBinary(this.region.getStartKey()) + " last=" + Bytes.toStringBinary(this.region.getEndKey())));
            HRegionInfo hri = this.region.getRegionInfo();
            if (!hri.containsRange(firstKey, lastKey)) {
                throw new WrongRegionException("Bulk load file " + srcPath.toString() + " does not fit inside region " + this.region);
            }
            if (this.verifyBulkLoads) {
                KeyValue prevKV = null;
                HFileScanner scanner = reader.getScanner(false, false, false);
                scanner.seekTo();
                do {
                    KeyValue kv = scanner.getKeyValue();
                    if (prevKV != null) {
                        if (Bytes.compareTo(prevKV.getBuffer(), prevKV.getRowOffset(), prevKV.getRowLength(), kv.getBuffer(), kv.getRowOffset(), kv.getRowLength()) > 0) {
                            throw new InvalidHFileException("Previous row is greater than current row: path=" + srcPath + " previous=" + Bytes.toStringBinary(prevKV.getKey()) + " current=" + Bytes.toStringBinary(kv.getKey()));
                        }
                        if (Bytes.compareTo(prevKV.getBuffer(), prevKV.getFamilyOffset(), prevKV.getFamilyLength(), kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength()) != 0) {
                            throw new InvalidHFileException("Previous key had different family compared to current key: path=" + srcPath + " previous=" + Bytes.toStringBinary(prevKV.getFamily()) + " current=" + Bytes.toStringBinary(kv.getFamily()));
                        }
                    }
                    prevKV = kv;
                } while (scanner.next());
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bulkLoadHFile(String srcPathStr, long seqNum) throws IOException {
        FileSystem desFs;
        Path srcPath = new Path(srcPathStr);
        FileSystem srcFs = srcPath.getFileSystem(this.conf);
        FileSystem fileSystem = desFs = this.fs instanceof HFileSystem ? ((HFileSystem)this.fs).getBackingFs() : this.fs;
        if (!FSHDFSUtils.isSameHdfs(this.conf, srcFs, desFs)) {
            LOG.info((Object)("File " + srcPath + " on different filesystem than " + "destination store - moving to this filesystem."));
            Path tmpPath = this.getTmpPath();
            FileUtil.copy((FileSystem)srcFs, (Path)srcPath, (FileSystem)this.fs, (Path)tmpPath, (boolean)false, (Configuration)this.conf);
            LOG.info((Object)("Copied to temporary path on dst filesystem: " + tmpPath));
            srcPath = tmpPath;
        }
        Path dstPath = StoreFile.getRandomFilename(this.fs, this.homedir, seqNum == -1L ? null : "_SeqId_" + seqNum + "_");
        LOG.debug((Object)("Renaming bulk load file " + srcPath + " to " + dstPath));
        StoreFile.rename(this.fs, srcPath, dstPath);
        StoreFile sf = new StoreFile(this.fs, dstPath, this.conf, this.cacheConf, this.family.getBloomFilterType(), this.dataBlockEncoder);
        this.passSchemaMetricsTo(sf);
        StoreFile.Reader r = sf.createReader();
        this.storeSize += r.length();
        this.totalUncompressedBytes += r.getTotalUncompressedBytes();
        LOG.info((Object)("Moved hfile " + srcPath + " into store directory " + this.homedir + " - updating store file list."));
        this.lock.writeLock().lock();
        try {
            ArrayList<StoreFile> newFiles = new ArrayList<StoreFile>((Collection<StoreFile>)this.storefiles);
            newFiles.add(sf);
            this.storefiles = this.sortAndClone(newFiles);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.notifyChangedReadersObservers();
        LOG.info((Object)("Successfully loaded store file " + srcPath + " into store " + this + " (new location: " + dstPath + ")"));
    }

    private Path getTmpPath() throws IOException {
        return StoreFile.getRandomFilename(this.fs, this.region.getTmpDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImmutableList<StoreFile> close() throws IOException {
        this.lock.writeLock().lock();
        try {
            ImmutableList<StoreFile> result = this.storefiles;
            this.storefiles = ImmutableList.of();
            if (!result.isEmpty()) {
                ThreadPoolExecutor storeFileCloserThreadPool = this.region.getStoreFileOpenAndCloseThreadPool("StoreFileCloserThread-" + this.family.getNameAsString());
                ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(storeFileCloserThreadPool);
                for (final StoreFile f : result) {
                    completionService.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws IOException {
                            f.closeReader(true);
                            return null;
                        }
                    });
                }
                IOException ioe = null;
                try {
                    for (int i = 0; i < result.size(); ++i) {
                        try {
                            Future future = completionService.take();
                            future.get();
                            continue;
                        }
                        catch (InterruptedException e) {
                            if (ioe != null) continue;
                            ioe = new InterruptedIOException();
                            ioe.initCause(e);
                            continue;
                        }
                        catch (ExecutionException e) {
                            if (ioe != null) continue;
                            ioe = new IOException(e.getCause());
                        }
                    }
                }
                finally {
                    storeFileCloserThreadPool.shutdownNow();
                }
                if (ioe != null) {
                    throw ioe;
                }
            }
            LOG.info((Object)("Closed " + this));
            ImmutableList<StoreFile> immutableList = result;
            return immutableList;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snapshot() {
        this.lock.writeLock().lock();
        try {
            this.memstore.snapshot();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected Path flushCache(long logCacheFlushId, SortedSet<KeyValue> snapshot, TimeRangeTracker snapshotTimeRangeTracker, AtomicLong flushedSize, MonitoredTask status) throws IOException {
        IOException lastException = null;
        for (int i = 0; i < flush_retries_number; ++i) {
            try {
                Path pathName = this.internalFlushCache(snapshot, logCacheFlushId, snapshotTimeRangeTracker, flushedSize, status);
                try {
                    if (pathName != null) {
                        this.validateStoreFile(pathName);
                    }
                    return pathName;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed validating store file " + pathName + ", retrying num=" + i), (Throwable)e);
                    lastException = e instanceof IOException ? (IOException)e : new IOException(e);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed flushing store file, retrying num=" + i), (Throwable)e);
                lastException = e;
            }
            if (lastException == null || i >= flush_retries_number - 1) continue;
            try {
                Thread.sleep(pauseTime);
                continue;
            }
            catch (InterruptedException e) {
                InterruptedIOException iie = new InterruptedIOException();
                iie.initCause(e);
                throw iie;
            }
        }
        throw lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path internalFlushCache(SortedSet<KeyValue> set, long logCacheFlushId, TimeRangeTracker snapshotTimeRangeTracker, AtomicLong flushedSize, MonitoredTask status) throws IOException {
        Path pathName;
        long smallestReadPoint = this.region.getSmallestReadPoint();
        long flushed = 0L;
        if (set.size() == 0) {
            return null;
        }
        InternalScanner scanner = null;
        CollectionBackedScanner memstoreScanner = new CollectionBackedScanner(set, this.comparator);
        if (this.getHRegion().getCoprocessorHost() != null) {
            scanner = this.getHRegion().getCoprocessorHost().preFlushScannerOpen(this, memstoreScanner);
        }
        if (scanner == null) {
            Scan scan = new Scan();
            scan.setMaxVersions(this.scanInfo.getMaxVersions());
            scanner = new StoreScanner(this, this.scanInfo, scan, Collections.singletonList(memstoreScanner), ScanType.MINOR_COMPACT, this.region.getSmallestReadPoint(), Long.MIN_VALUE);
        }
        if (this.getHRegion().getCoprocessorHost() != null) {
            InternalScanner cpScanner = this.getHRegion().getCoprocessorHost().preFlush(this, scanner);
            if (cpScanner == null) {
                return null;
            }
            scanner = cpScanner;
        }
        try {
            int compactionKVMax = this.conf.getInt("hbase.hstore.compaction.kv.max", 10);
            Object object = this.flushLock;
            synchronized (object) {
                status.setStatus("Flushing " + this + ": creating writer");
                StoreFile.Writer writer = this.createWriterInTmp(set.size());
                writer.setTimeRangeTracker(snapshotTimeRangeTracker);
                pathName = writer.getPath();
                try {
                    boolean hasMore;
                    ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
                    do {
                        hasMore = scanner.next(kvs, compactionKVMax);
                        if (kvs.isEmpty()) continue;
                        for (KeyValue kv : kvs) {
                            if (kv.getMemstoreTS() <= smallestReadPoint) {
                                kv = kv.shallowCopy();
                                kv.setMemstoreTS(0L);
                            }
                            writer.append(kv);
                            flushed += this.memstore.heapSizeChange(kv, true);
                        }
                        kvs.clear();
                    } while (hasMore);
                }
                finally {
                    status.setStatus("Flushing " + this + ": appending metadata");
                    writer.appendMetadata(logCacheFlushId, false);
                    status.setStatus("Flushing " + this + ": closing flushed file");
                    writer.close();
                }
            }
        }
        finally {
            flushedSize.set(flushed);
            scanner.close();
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Flushed , sequenceid=" + logCacheFlushId + ", memsize=" + StringUtils.humanReadableInt((long)flushed) + ", into tmp file " + pathName));
        }
        return pathName;
    }

    private StoreFile commitFile(Path path, long logCacheFlushId, TimeRangeTracker snapshotTimeRangeTracker, AtomicLong flushedSize, MonitoredTask status) throws IOException {
        String fileName = path.getName();
        Path dstPath = new Path(this.homedir, fileName);
        String msg = "Renaming flushed file at " + path + " to " + dstPath;
        LOG.debug((Object)msg);
        status.setStatus("Flushing " + this + ": " + msg);
        if (!HBaseFileSystem.renameDirForFileSystem(this.fs, path, dstPath)) {
            LOG.warn((Object)("Unable to rename " + path + " to " + dstPath));
        }
        status.setStatus("Flushing " + this + ": reopening flushed file");
        StoreFile sf = new StoreFile(this.fs, dstPath, this.conf, this.cacheConf, this.family.getBloomFilterType(), this.dataBlockEncoder);
        this.passSchemaMetricsTo(sf);
        StoreFile.Reader r = sf.createReader();
        this.storeSize += r.length();
        this.totalUncompressedBytes += r.getTotalUncompressedBytes();
        this.getSchemaMetrics().updatePersistentStoreMetric(SchemaMetrics.StoreMetricType.FLUSH_SIZE, flushedSize.longValue());
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Added " + sf + ", entries=" + r.getEntries() + ", sequenceid=" + logCacheFlushId + ", filesize=" + StringUtils.humanReadableInt((long)r.length())));
        }
        return sf;
    }

    private StoreFile.Writer createWriterInTmp(int maxKeyCount) throws IOException {
        return this.createWriterInTmp(maxKeyCount, this.family.getCompression(), false, true);
    }

    public StoreFile.Writer createWriterInTmp(int maxKeyCount, Compression.Algorithm compression, boolean isCompaction, boolean includeMVCCReadpoint) throws IOException {
        CacheConfig writerCacheConf;
        if (isCompaction) {
            writerCacheConf = new CacheConfig(this.cacheConf);
            writerCacheConf.setCacheDataOnWrite(false);
        } else {
            writerCacheConf = this.cacheConf;
        }
        StoreFile.Writer w = new StoreFile.WriterBuilder(this.conf, writerCacheConf, this.fs, this.blocksize).withOutputDir(this.region.getTmpDir()).withDataBlockEncoder(this.dataBlockEncoder).withComparator(this.comparator).withBloomType(this.family.getBloomFilterType()).withMaxKeyCount(maxKeyCount).withChecksumType(this.checksumType).withBytesPerChecksum(this.bytesPerChecksum).withCompression(compression).includeMVCCReadpoint(includeMVCCReadpoint).build();
        SchemaConfigured sc = (SchemaConfigured)((Object)w.writer);
        SchemaConfigured.resetSchemaMetricsConf(sc);
        this.passSchemaMetricsTo(sc);
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateStorefiles(StoreFile sf, SortedSet<KeyValue> set) throws IOException {
        this.lock.writeLock().lock();
        try {
            ArrayList<StoreFile> newList = new ArrayList<StoreFile>((Collection<StoreFile>)this.storefiles);
            newList.add(sf);
            this.storefiles = this.sortAndClone(newList);
            this.memstore.clearSnapshot(set);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.notifyChangedReadersObservers();
        return this.needsCompaction();
    }

    private void notifyChangedReadersObservers() throws IOException {
        for (ChangedReadersObserver o : this.changedReaderObservers) {
            o.updateReaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<KeyValueScanner> getScanners(boolean cacheBlocks, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher) throws IOException {
        List<KeyValueScanner> memStoreScanners;
        List<StoreFile> storeFiles;
        this.lock.readLock().lock();
        try {
            storeFiles = this.getStorefiles();
            memStoreScanners = this.memstore.getScanners();
        }
        finally {
            this.lock.readLock().unlock();
        }
        List<StoreFileScanner> sfScanners = StoreFileScanner.getScannersForStoreFiles(storeFiles, cacheBlocks, usePread, isCompaction, matcher);
        ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(sfScanners.size() + 1);
        scanners.addAll(sfScanners);
        scanners.addAll(memStoreScanners);
        return scanners;
    }

    void addChangedReaderObserver(ChangedReadersObserver o) {
        this.changedReaderObservers.add(o);
    }

    void deleteChangedReaderObserver(ChangedReadersObserver o) {
        this.changedReaderObservers.remove(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StoreFile compact(CompactionRequest cr) throws IOException {
        if (cr == null || cr.getFiles().isEmpty()) {
            return null;
        }
        Preconditions.checkArgument((boolean)cr.getStore().toString().equals(this.toString()));
        List<StoreFile> filesToCompact = cr.getFiles();
        List<StoreFile> list = this.filesCompacting;
        synchronized (list) {
            Preconditions.checkArgument((boolean)this.filesCompacting.containsAll(filesToCompact));
        }
        long maxId = StoreFile.getMaxSequenceIdInList(filesToCompact);
        LOG.info((Object)("Starting compaction of " + filesToCompact.size() + " file(s) in " + this + " of " + this.region.getRegionInfo().getRegionNameAsString() + " into tmpdir=" + this.region.getTmpDir() + ", seqid=" + maxId + ", totalSize=" + StringUtils.humanReadableInt((long)cr.getSize())));
        StoreFile sf = null;
        try {
            StoreFile.Writer writer = this.compactor.compact(cr, maxId);
            if (this.conf.getBoolean("hbase.hstore.compaction.complete", true)) {
                sf = this.completeCompaction(filesToCompact, writer);
                if (this.region.getCoprocessorHost() != null) {
                    this.region.getCoprocessorHost().postCompact(this, sf, cr);
                }
            } else {
                sf = new StoreFile(this.fs, writer.getPath(), this.conf, this.cacheConf, this.family.getBloomFilterType(), this.dataBlockEncoder);
                sf.createReader();
            }
        }
        finally {
            List<StoreFile> list2 = this.filesCompacting;
            synchronized (list2) {
                this.filesCompacting.removeAll(filesToCompact);
            }
        }
        LOG.info((Object)("Completed" + (cr.isMajor() ? " major " : " ") + "compaction of " + filesToCompact.size() + " file(s) in " + this + " of " + this.region.getRegionInfo().getRegionNameAsString() + " into " + (sf == null ? "none" : sf.getPath().getName()) + ", size=" + (sf == null ? "none" : StringUtils.humanReadableInt((long)sf.getReader().length())) + "; total size for store is " + StringUtils.humanReadableInt((long)this.storeSize)));
        return sf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactRecentForTesting(int N) throws IOException {
        boolean isMajor;
        long maxId;
        List<StoreFile> filesToCompact;
        List<StoreFile> list;
        this.lock.readLock().lock();
        try {
            list = this.filesCompacting;
            synchronized (list) {
                int count;
                filesToCompact = Lists.newArrayList(this.storefiles);
                if (!this.filesCompacting.isEmpty()) {
                    StoreFile last = this.filesCompacting.get(this.filesCompacting.size() - 1);
                    int idx = filesToCompact.indexOf(last);
                    Preconditions.checkArgument((idx != -1 ? 1 : 0) != 0);
                    filesToCompact.subList(0, idx + 1).clear();
                }
                if (N > (count = filesToCompact.size())) {
                    throw new RuntimeException("Not enough files");
                }
                filesToCompact = filesToCompact.subList(count - N, count);
                maxId = StoreFile.getMaxSequenceIdInList((Collection<StoreFile>)filesToCompact);
                isMajor = filesToCompact.size() == this.storefiles.size();
                this.filesCompacting.addAll(filesToCompact);
                Collections.sort(this.filesCompacting, StoreFile.Comparators.SEQ_ID);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try {
            StoreFile.Writer writer = this.compactor.compactForTesting(this, this.conf, filesToCompact, isMajor, maxId);
            StoreFile sf = this.completeCompaction(filesToCompact, writer);
            if (this.region.getCoprocessorHost() != null) {
                this.region.getCoprocessorHost().postCompact(this, sf, null);
            }
        }
        finally {
            list = this.filesCompacting;
            synchronized (list) {
                this.filesCompacting.removeAll(filesToCompact);
            }
        }
    }

    boolean hasReferences() {
        return this.hasReferences((Collection<StoreFile>)this.storefiles);
    }

    private boolean hasReferences(Collection<StoreFile> files) {
        if (files != null && files.size() > 0) {
            for (StoreFile hsf : files) {
                if (!hsf.isReference()) continue;
                return true;
            }
        }
        return false;
    }

    public static long getLowestTimestamp(List<StoreFile> candidates) throws IOException {
        long minTs = Long.MAX_VALUE;
        for (StoreFile storeFile : candidates) {
            minTs = Math.min(minTs, storeFile.getModificationTimeStamp());
        }
        return minTs;
    }

    public CompactionProgress getCompactionProgress() {
        return this.compactor.getProgress();
    }

    boolean isMajorCompaction() throws IOException {
        int pos;
        for (StoreFile sf : this.storefiles) {
            if (sf.getReader() != null) continue;
            LOG.debug((Object)("StoreFile " + sf + " has null Reader"));
            return false;
        }
        ArrayList<StoreFile> candidates = new ArrayList<StoreFile>((Collection<StoreFile>)this.storefiles);
        for (pos = 0; pos < candidates.size() && ((StoreFile)candidates.get(pos)).getReader().length() > this.maxCompactSize && !((StoreFile)candidates.get(pos)).isReference(); ++pos) {
        }
        candidates.subList(0, pos).clear();
        return this.isMajorCompaction(candidates);
    }

    private boolean isMajorCompaction(List<StoreFile> filesToCompact) throws IOException {
        boolean result = false;
        long mcTime = this.getNextMajorCompactTime();
        if (filesToCompact == null || filesToCompact.isEmpty() || mcTime == 0L) {
            return result;
        }
        long lowTimestamp = Store.getLowestTimestamp(filesToCompact);
        long now = EnvironmentEdgeManager.currentTimeMillis();
        if (lowTimestamp > 0L && lowTimestamp < now - mcTime) {
            if (filesToCompact.size() == 1) {
                long oldest;
                StoreFile sf = filesToCompact.get(0);
                long l = oldest = sf.getReader().timeRangeTracker == null ? Long.MIN_VALUE : now - sf.getReader().timeRangeTracker.minimumTimestamp;
                if (sf.isMajorCompaction() && (this.ttl == Integer.MAX_VALUE || oldest < this.ttl)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Skipping major compaction of " + this + " because one (major) compacted file only and oldestTime " + oldest + "ms is < ttl=" + this.ttl));
                    }
                } else if (this.ttl != Integer.MAX_VALUE && oldest > this.ttl) {
                    LOG.debug((Object)("Major compaction triggered on store " + this + ", because keyvalues outdated; time since last major compaction " + (now - lowTimestamp) + "ms"));
                    result = true;
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Major compaction triggered on store " + this + "; time since last major compaction " + (now - lowTimestamp) + "ms"));
                }
                result = true;
            }
        }
        return result;
    }

    long getNextMajorCompactTime() {
        double jitterPct;
        long ret = this.conf.getLong("hbase.hregion.majorcompaction", 86400000L);
        if (this.family.getValue("hbase.hregion.majorcompaction") != null) {
            String strCompactionTime = this.family.getValue("hbase.hregion.majorcompaction");
            ret = new Long(strCompactionTime);
        }
        if (ret > 0L && (jitterPct = (double)this.conf.getFloat("hbase.hregion.majorcompaction.jitter", 0.2f)) > 0.0) {
            long jitter = Math.round((double)ret * jitterPct);
            ImmutableList<StoreFile> snapshot = this.storefiles;
            if (snapshot != null && !snapshot.isEmpty()) {
                String seed = ((StoreFile)snapshot.get(0)).getPath().getName();
                double curRand = new Random(seed.hashCode()).nextDouble();
                ret += jitter - Math.round((double)(2L * jitter) * curRand);
            } else {
                ret = 0L;
            }
        }
        return ret;
    }

    public CompactionRequest requestCompaction() throws IOException {
        return this.requestCompaction(Integer.MIN_VALUE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompactionRequest requestCompaction(int priority, CompactionRequest request) throws IOException {
        if (!this.region.areWritesEnabled()) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            List<StoreFile> list = this.filesCompacting;
            synchronized (list) {
                boolean isMajor;
                CompactSelection filesToCompact;
                block17: {
                    ArrayList candidates = Lists.newArrayList(this.storefiles);
                    if (!this.filesCompacting.isEmpty()) {
                        StoreFile last = this.filesCompacting.get(this.filesCompacting.size() - 1);
                        int idx = candidates.indexOf(last);
                        Preconditions.checkArgument((idx != -1 ? 1 : 0) != 0);
                        candidates.subList(0, idx + 1).clear();
                    }
                    boolean override = false;
                    if (this.region.getCoprocessorHost() != null) {
                        override = this.region.getCoprocessorHost().preCompactSelection(this, candidates, request);
                    }
                    filesToCompact = override ? new CompactSelection(this.conf, candidates) : this.compactSelection(candidates, priority);
                    if (this.region.getCoprocessorHost() != null) {
                        this.region.getCoprocessorHost().postCompactSelection(this, (ImmutableList<StoreFile>)ImmutableList.copyOf(filesToCompact.getFilesToCompact()), request);
                    }
                    if (!filesToCompact.getFilesToCompact().isEmpty()) break block17;
                    CompactionRequest compactionRequest = null;
                    return compactionRequest;
                }
                if (!Collections.disjoint(this.filesCompacting, filesToCompact.getFilesToCompact())) {
                    Preconditions.checkArgument((boolean)false, (String)"%s overlaps with %s", (Object[])new Object[]{filesToCompact, this.filesCompacting});
                }
                this.filesCompacting.addAll(filesToCompact.getFilesToCompact());
                Collections.sort(this.filesCompacting, StoreFile.Comparators.SEQ_ID);
                boolean bl = isMajor = filesToCompact.getFilesToCompact().size() == this.storefiles.size();
                if (isMajor) {
                    this.forceMajor = false;
                }
                int pri = this.getCompactPriority(priority);
                if (request == null) {
                    request = new CompactionRequest(this.region, this, filesToCompact, isMajor, pri);
                } else {
                    request.setSelection(filesToCompact);
                    request.setIsMajor(isMajor);
                    request.setPriority(pri);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (request != null) {
            CompactionRequest.preRequest(request);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishRequest(CompactionRequest cr) {
        CompactionRequest.postRequest(cr);
        cr.finishRequest();
        List<StoreFile> list = this.filesCompacting;
        synchronized (list) {
            this.filesCompacting.removeAll(cr.getFiles());
        }
    }

    CompactSelection compactSelection(List<StoreFile> candidates) throws IOException {
        return this.compactSelection(candidates, Integer.MIN_VALUE);
    }

    CompactSelection compactSelection(List<StoreFile> candidates, int priority) throws IOException {
        boolean forcemajor;
        CompactSelection compactSelection = new CompactSelection(this.conf, candidates);
        boolean bl = forcemajor = this.forceMajor && this.filesCompacting.isEmpty();
        if (!forcemajor) {
            int pos;
            CompactSelection expiredSelection;
            if (this.conf.getBoolean("hbase.store.delete.expired.storefile", true) && this.ttl != Long.MAX_VALUE && this.scanInfo.minVersions == 0 && (expiredSelection = compactSelection.selectExpiredStoreFilesToCompact(EnvironmentEdgeManager.currentTimeMillis() - this.ttl)) != null) {
                return expiredSelection;
            }
            for (pos = 0; pos < compactSelection.getFilesToCompact().size() && compactSelection.getFilesToCompact().get(pos).getReader().length() > this.maxCompactSize && !compactSelection.getFilesToCompact().get(pos).isReference(); ++pos) {
            }
            if (pos != 0) {
                compactSelection.clearSubList(0, pos);
            }
        }
        if (compactSelection.getFilesToCompact().isEmpty()) {
            LOG.debug((Object)(this.getHRegionInfo().getEncodedName() + " - " + this + ": no store files to compact"));
            compactSelection.emptyFileList();
            return compactSelection;
        }
        boolean majorcompaction = forcemajor && priority == 1 || (forcemajor || this.isMajorCompaction(compactSelection.getFilesToCompact())) && compactSelection.getFilesToCompact().size() < this.maxFilesToCompact;
        LOG.debug((Object)(this.getHRegionInfo().getEncodedName() + " - " + this.getColumnFamilyName() + ": Initiating " + (majorcompaction ? "major" : "minor") + "compaction"));
        if (!majorcompaction && !this.hasReferences(compactSelection.getFilesToCompact())) {
            compactSelection.getFilesToCompact().removeAll(Collections2.filter(compactSelection.getFilesToCompact(), (Predicate)new Predicate<StoreFile>(){

                public boolean apply(StoreFile input) {
                    return input.excludeFromMinorCompaction();
                }
            }));
            if (compactSelection.getFilesToCompact().size() < this.minFilesToCompact) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Not compacting files because we only have " + compactSelection.getFilesToCompact().size() + " files ready for compaction.  Need " + this.minFilesToCompact + " to initiate."));
                }
                compactSelection.emptyFileList();
                return compactSelection;
            }
            compactSelection = this.conf.getBoolean("hbase.hstore.useExploringCompation", false) ? this.exploringCompactionSelection(compactSelection) : this.defaultCompactionSelection(compactSelection);
        } else if (majorcompaction) {
            if (compactSelection.getFilesToCompact().size() > this.maxFilesToCompact) {
                LOG.debug((Object)("Warning, compacting more than " + this.maxFilesToCompact + " files, probably because of a user-requested major compaction"));
                if (priority != 1) {
                    LOG.error((Object)"Compacting more than max files on a non user-requested compaction");
                }
            }
        } else if (compactSelection.getFilesToCompact().size() > this.maxFilesToCompact) {
            int pastMax = compactSelection.getFilesToCompact().size() - this.maxFilesToCompact;
            compactSelection.getFilesToCompact().subList(0, pastMax).clear();
        }
        return compactSelection;
    }

    private CompactSelection defaultCompactionSelection(CompactSelection compactSelection) {
        int start = 0;
        double r = compactSelection.getCompactSelectionRatio();
        int countOfFiles = compactSelection.getFilesToCompact().size();
        long[] fileSizes = new long[countOfFiles];
        long[] sumSize = new long[countOfFiles];
        for (int i = countOfFiles - 1; i >= 0; --i) {
            StoreFile file = compactSelection.getFilesToCompact().get(i);
            fileSizes[i] = file.getReader().length();
            int tooFar = i + this.maxFilesToCompact - 1;
            sumSize[i] = fileSizes[i] + (i + 1 < countOfFiles ? sumSize[i + 1] : 0L) - (tooFar < countOfFiles ? fileSizes[tooFar] : 0L);
        }
        while (countOfFiles - start >= this.minFilesToCompact && fileSizes[start] > Math.max(this.minCompactSize, (long)((double)sumSize[start + 1] * r))) {
            ++start;
        }
        int end = Math.min(countOfFiles, start + this.maxFilesToCompact);
        long totalSize = fileSizes[start] + (start + 1 < countOfFiles ? sumSize[start + 1] : 0L);
        if ((compactSelection = compactSelection.getSubList(start, end)).getFilesToCompact().size() < this.minFilesToCompact) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skipped compaction of " + this + ".  Only " + (end - start) + " file(s) of size " + StringUtils.humanReadableInt((long)totalSize) + " have met compaction criteria."));
            }
            compactSelection.emptyFileList();
            return compactSelection;
        }
        return compactSelection;
    }

    private CompactSelection exploringCompactionSelection(CompactSelection compactSelection) {
        List<StoreFile> candidates = compactSelection.getFilesToCompact();
        int futureFiles = this.filesCompacting.isEmpty() ? 0 : 1;
        boolean mayBeStuck = candidates.size() - this.filesCompacting.size() + futureFiles >= this.blockingStoreFileCount;
        List<Object> bestSelection = new ArrayList(0);
        List<Object> smallest = new ArrayList(0);
        long bestSize = 0L;
        long smallestSize = Long.MAX_VALUE;
        double r = compactSelection.getCompactSelectionRatio();
        for (int startIndex = 0; startIndex < candidates.size(); ++startIndex) {
            for (int currentEnd = startIndex + this.minFilesToCompact - 1; currentEnd < candidates.size(); ++currentEnd) {
                List<StoreFile> potentialMatchFiles = candidates.subList(startIndex, currentEnd + 1);
                if (potentialMatchFiles.size() < this.minFilesToCompact || potentialMatchFiles.size() > this.maxFilesToCompact) continue;
                long size = this.getCompactionSize(potentialMatchFiles);
                if (size < smallestSize) {
                    smallest = potentialMatchFiles;
                    smallestSize = size;
                }
                if (size >= this.minCompactSize && !this.filesInRatio(potentialMatchFiles, r) || size > this.maxCompactSize || potentialMatchFiles.size() <= bestSelection.size() && (potentialMatchFiles.size() != bestSelection.size() || size >= bestSize)) continue;
                bestSelection = potentialMatchFiles;
                bestSize = size;
            }
        }
        if (bestSelection.size() == 0 && mayBeStuck) {
            smallest = new ArrayList(smallest);
            compactSelection.getFilesToCompact().clear();
            compactSelection.getFilesToCompact().addAll(smallest);
        } else {
            bestSelection = new ArrayList(bestSelection);
            compactSelection.getFilesToCompact().clear();
            compactSelection.getFilesToCompact().addAll(bestSelection);
        }
        return compactSelection;
    }

    private boolean filesInRatio(List<StoreFile> files, double currentRatio) {
        int i;
        if (files.size() < 2) {
            return true;
        }
        long totalFileSize = 0L;
        for (i = 0; i < files.size(); ++i) {
            totalFileSize += files.get(i).getReader().length();
        }
        for (i = 0; i < files.size(); ++i) {
            long sumAllOtherFilesize;
            long singleFileSize = files.get(i).getReader().length();
            if (!((double)singleFileSize > (double)(sumAllOtherFilesize = totalFileSize - singleFileSize) * currentRatio) || sumAllOtherFilesize < this.minCompactSize) continue;
            return false;
        }
        return true;
    }

    private long getCompactionSize(List<StoreFile> files) {
        long size = 0L;
        if (files == null) {
            return size;
        }
        for (StoreFile f : files) {
            size += f.getReader().length();
        }
        return size;
    }

    private void validateStoreFile(Path path) throws IOException {
        StoreFile storeFile = null;
        try {
            storeFile = new StoreFile(this.fs, path, this.conf, this.cacheConf, this.family.getBloomFilterType(), NoOpDataBlockEncoder.INSTANCE);
            this.passSchemaMetricsTo(storeFile);
            storeFile.createReader();
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to open store file : " + path + ", keeping it in tmp location"), (Throwable)e);
            throw e;
        }
        finally {
            if (storeFile != null) {
                storeFile.closeReader(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StoreFile completeCompaction(Collection<StoreFile> compactedFiles, StoreFile.Writer compactedFile) throws IOException {
        StoreFile result = null;
        if (compactedFile != null) {
            this.validateStoreFile(compactedFile.getPath());
            Path origPath = compactedFile.getPath();
            Path destPath = new Path(this.homedir, origPath.getName());
            LOG.info((Object)("Renaming compacted file at " + origPath + " to " + destPath));
            if (!HBaseFileSystem.renameDirForFileSystem(this.fs, origPath, destPath)) {
                LOG.error((Object)("Failed move of compacted file " + origPath + " to " + destPath));
                throw new IOException("Failed move of compacted file " + origPath + " to " + destPath);
            }
            result = new StoreFile(this.fs, destPath, this.conf, this.cacheConf, this.family.getBloomFilterType(), this.dataBlockEncoder);
            this.passSchemaMetricsTo(result);
            result.createReader();
        }
        try {
            this.lock.writeLock().lock();
            try {
                ArrayList newStoreFiles = Lists.newArrayList(this.storefiles);
                newStoreFiles.removeAll(compactedFiles);
                this.filesCompacting.removeAll(compactedFiles);
                if (result != null) {
                    newStoreFiles.add(result);
                }
                this.storefiles = this.sortAndClone(newStoreFiles);
            }
            finally {
                this.lock.writeLock().unlock();
            }
            this.notifyChangedReadersObservers();
            LOG.debug((Object)"Removing store files after compaction...");
            HFileArchiver.archiveStoreFiles(this.conf, this.fs, this.region, this.family.getName(), compactedFiles);
        }
        catch (IOException e) {
            e = RemoteExceptionHandler.checkIOException(e);
            LOG.error((Object)("Failed replacing compacted files in " + this + ". Compacted file is " + (result == null ? "none" : result.toString()) + ".  Files replaced " + compactedFiles.toString() + " some of which may have been already removed"), (Throwable)e);
        }
        this.storeSize = 0L;
        this.totalUncompressedBytes = 0L;
        for (StoreFile hsf : this.storefiles) {
            StoreFile.Reader r = hsf.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + hsf + " has a null Reader"));
                continue;
            }
            this.storeSize += r.length();
            this.totalUncompressedBytes += r.getTotalUncompressedBytes();
        }
        return result;
    }

    public ImmutableList<StoreFile> sortAndClone(List<StoreFile> storeFiles) {
        Collections.sort(storeFiles, StoreFile.Comparators.SEQ_ID);
        ImmutableList newList = ImmutableList.copyOf(storeFiles);
        return newList;
    }

    public int getNumberOfStoreFiles() {
        return this.storefiles.size();
    }

    int versionsToReturn(int wantedVersions) {
        if (wantedVersions <= 0) {
            throw new IllegalArgumentException("Number of versions must be > 0");
        }
        int maxVersions = this.family.getMaxVersions();
        return wantedVersions > maxVersions ? maxVersions : wantedVersions;
    }

    static boolean isExpired(KeyValue key, long oldestTimestamp) {
        return key.getTimestamp() < oldestTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyValue getRowKeyAtOrBefore(byte[] row) throws IOException {
        long ttlToUse = this.scanInfo.getMinVersions() > 0 ? Long.MAX_VALUE : this.ttl;
        KeyValue kv = new KeyValue(row, Long.MAX_VALUE);
        GetClosestRowBeforeTracker state = new GetClosestRowBeforeTracker(this.comparator, kv, ttlToUse, this.region.getRegionInfo().isMetaRegion());
        this.lock.readLock().lock();
        try {
            this.memstore.getRowKeyAtOrBefore(state);
            for (StoreFile sf : Lists.reverse(this.storefiles)) {
                this.rowAtOrBeforeFromStoreFile(sf, state);
            }
            KeyValue keyValue = state.getCandidate();
            return keyValue;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void rowAtOrBeforeFromStoreFile(StoreFile f, GetClosestRowBeforeTracker state) throws IOException {
        KeyValue kv;
        HFileScanner scanner;
        KeyValue firstOnRow;
        StoreFile.Reader r = f.getReader();
        if (r == null) {
            LOG.warn((Object)("StoreFile " + f + " has a null Reader"));
            return;
        }
        if (r.getEntries() == 0L) {
            LOG.warn((Object)("StoreFile " + f + " is a empty store file"));
            return;
        }
        byte[] fk = r.getFirstKey();
        if (fk == null) {
            return;
        }
        KeyValue firstKV = KeyValue.createKeyValueFromKey(fk, 0, fk.length);
        byte[] lk = r.getLastKey();
        KeyValue lastKV = KeyValue.createKeyValueFromKey(lk, 0, lk.length);
        if (this.comparator.compareRows(lastKV, firstOnRow = state.getTargetKey()) < 0) {
            if (!state.isTargetTable(lastKV)) {
                return;
            }
            firstOnRow = new KeyValue(lastKV.getRow(), Long.MAX_VALUE);
        }
        if (!this.seekToScanner(scanner = r.getScanner(true, true, false), firstOnRow, firstKV)) {
            return;
        }
        if (this.walkForwardInSingleRow(scanner, firstOnRow, state)) {
            return;
        }
        while (scanner.seekBefore(firstOnRow.getBuffer(), firstOnRow.getKeyOffset(), firstOnRow.getKeyLength()) && state.isTargetTable(kv = scanner.getKeyValue()) && state.isBetterCandidate(kv) && this.seekToScanner(scanner, firstOnRow = new KeyValue(kv.getRow(), Long.MAX_VALUE), firstKV) && !this.walkForwardInSingleRow(scanner, firstOnRow, state)) {
        }
    }

    private boolean seekToScanner(HFileScanner scanner, KeyValue firstOnRow, KeyValue firstKV) throws IOException {
        int result;
        KeyValue kv = firstOnRow;
        if (this.comparator.compareRows(firstKV, firstOnRow) == 0) {
            kv = firstKV;
        }
        return (result = scanner.seekTo(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength())) >= 0;
    }

    private boolean walkForwardInSingleRow(HFileScanner scanner, KeyValue firstOnRow, GetClosestRowBeforeTracker state) throws IOException {
        boolean foundCandidate = false;
        do {
            KeyValue kv;
            if (this.comparator.compareRows(kv = scanner.getKeyValue(), firstOnRow) < 0) continue;
            if (state.isTooFar(kv, firstOnRow)) break;
            if (state.isExpired(kv) || !state.handle(kv)) continue;
            foundCandidate = true;
            break;
        } while (scanner.next());
        return foundCandidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canSplit() {
        this.lock.readLock().lock();
        try {
            for (StoreFile sf : this.storefiles) {
                if (!sf.isReference()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(sf + " is not splittable"));
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSplitPoint() {
        this.lock.readLock().lock();
        try {
            if (this.storefiles.isEmpty()) {
                byte[] byArray = null;
                return byArray;
            }
            assert (!this.region.getRegionInfo().isMetaRegion());
            long maxSize = 0L;
            StoreFile largestSf = null;
            for (StoreFile sf : this.storefiles) {
                if (sf.isReference()) {
                    byte[] byArray = null;
                    return byArray;
                }
                StoreFile.Reader r = sf.getReader();
                if (r == null) {
                    LOG.warn((Object)("Storefile " + sf + " Reader is null"));
                    continue;
                }
                long size = r.length();
                if (size <= maxSize) continue;
                maxSize = size;
                largestSf = sf;
            }
            StoreFile.Reader r = largestSf.getReader();
            if (r == null) {
                StoreFile sf;
                LOG.warn((Object)("Storefile " + largestSf + " Reader is null"));
                sf = null;
                return sf;
            }
            byte[] midkey = r.midkey();
            if (midkey != null) {
                KeyValue mk = KeyValue.createKeyValueFromKey(midkey, 0, midkey.length);
                byte[] fk = r.getFirstKey();
                KeyValue firstKey = KeyValue.createKeyValueFromKey(fk, 0, fk.length);
                byte[] lk = r.getLastKey();
                KeyValue lastKey = KeyValue.createKeyValueFromKey(lk, 0, lk.length);
                if (this.comparator.compareRows(mk, firstKey) == 0 || this.comparator.compareRows(mk, lastKey) == 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"cannot split because midkey is the same as first or last row");
                    }
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] byArray = mk.getRow();
                return byArray;
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed getting store size for " + this), (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    public long getLastCompactSize() {
        return this.lastCompactSize;
    }

    public long getSize() {
        return this.storeSize;
    }

    public void triggerMajorCompaction() {
        this.forceMajor = true;
    }

    boolean getForceMajorCompaction() {
        return this.forceMajor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyValueScanner getScanner(Scan scan, NavigableSet<byte[]> targetCols) throws IOException {
        this.lock.readLock().lock();
        try {
            KeyValueScanner scanner = null;
            if (this.getHRegion().getCoprocessorHost() != null) {
                scanner = this.getHRegion().getCoprocessorHost().preStoreScannerOpen(this, scan, targetCols);
            }
            if (scanner == null) {
                scanner = new StoreScanner(this, this.getScanInfo(), scan, targetCols);
            }
            KeyValueScanner keyValueScanner = scanner;
            return keyValueScanner;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        return this.getColumnFamilyName();
    }

    int getStorefilesCount() {
        return this.storefiles.size();
    }

    long getStoreSizeUncompressed() {
        return this.totalUncompressedBytes;
    }

    long getStorefilesSize() {
        long size = 0L;
        for (StoreFile s : this.storefiles) {
            StoreFile.Reader r = s.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + s + " has a null Reader"));
                continue;
            }
            size += r.length();
        }
        return size;
    }

    long getStorefilesIndexSize() {
        long size = 0L;
        for (StoreFile s : this.storefiles) {
            StoreFile.Reader r = s.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + s + " has a null Reader"));
                continue;
            }
            size += r.indexSize();
        }
        return size;
    }

    long getTotalStaticIndexSize() {
        long size = 0L;
        for (StoreFile s : this.storefiles) {
            size += s.getReader().getUncompressedDataIndexSize();
        }
        return size;
    }

    long getTotalStaticBloomSize() {
        long size = 0L;
        for (StoreFile s : this.storefiles) {
            StoreFile.Reader r = s.getReader();
            size += r.getTotalBloomSize();
        }
        return size;
    }

    long getMemStoreSize() {
        return this.memstore.heapSize();
    }

    public int getCompactPriority() {
        return this.getCompactPriority(Integer.MIN_VALUE);
    }

    public int getCompactPriority(int priority) {
        if (priority == 1) {
            return 1;
        }
        return this.blockingStoreFileCount - this.storefiles.size();
    }

    boolean throttleCompaction(long compactionSize) {
        long throttlePoint = this.conf.getLong("hbase.regionserver.thread.compaction.throttle", (long)(2 * this.minFilesToCompact) * this.region.memstoreFlushSize);
        return compactionSize > throttlePoint;
    }

    public HRegion getHRegion() {
        return this.region;
    }

    HRegionInfo getHRegionInfo() {
        return this.region.getRegionInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateColumnValue(byte[] row, byte[] f, byte[] qualifier, long newValue) throws IOException {
        this.lock.readLock().lock();
        try {
            long now = EnvironmentEdgeManager.currentTimeMillis();
            long l = this.memstore.updateColumnValue(row, f, qualifier, newValue, now);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long upsert(List<KeyValue> kvs) throws IOException {
        this.lock.readLock().lock();
        try {
            long l = this.memstore.upsert(kvs);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public StoreFlusher getStoreFlusher(long cacheFlushId) {
        return new StoreFlusherImpl(cacheFlushId);
    }

    public boolean needsCompaction() {
        return this.storefiles.size() - this.filesCompacting.size() > this.minFilesToCompact;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConf;
    }

    @Override
    public long heapSize() {
        return DEEP_OVERHEAD + this.memstore.heapSize();
    }

    public KeyValue.KVComparator getComparator() {
        return this.comparator;
    }

    public ScanInfo getScanInfo() {
        return this.scanInfo;
    }

    public boolean hasTooManyStoreFiles() {
        return (long)this.getStorefilesCount() > this.blockingFileCount;
    }

    static {
        FIXED_OVERHEAD = ClassSize.align(SchemaConfigured.SCHEMA_CONFIGURED_UNALIGNED_HEAP_SIZE + 17 * ClassSize.REFERENCE + 56 + 20 + 1);
        DEEP_OVERHEAD = ClassSize.align(FIXED_OVERHEAD + (long)ClassSize.OBJECT + (long)ClassSize.REENTRANT_LOCK + (long)ClassSize.CONCURRENT_SKIPLISTMAP + (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + (long)ClassSize.OBJECT + ScanInfo.FIXED_OVERHEAD);
    }

    public static class ScanInfo {
        private byte[] family;
        private int minVersions;
        private int maxVersions;
        private long ttl;
        private boolean keepDeletedCells;
        private long timeToPurgeDeletes;
        private KeyValue.KVComparator comparator;
        public static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 2 * ClassSize.REFERENCE + 8 + 8 + 1);

        public ScanInfo(HColumnDescriptor family, long ttl, long timeToPurgeDeletes, KeyValue.KVComparator comparator) {
            this(family.getName(), family.getMinVersions(), family.getMaxVersions(), ttl, family.getKeepDeletedCells(), timeToPurgeDeletes, comparator);
        }

        public ScanInfo(byte[] family, int minVersions, int maxVersions, long ttl, boolean keepDeletedCells, long timeToPurgeDeletes, KeyValue.KVComparator comparator) {
            this.family = family;
            this.minVersions = minVersions;
            this.maxVersions = maxVersions;
            this.ttl = ttl;
            this.keepDeletedCells = keepDeletedCells;
            this.timeToPurgeDeletes = timeToPurgeDeletes;
            this.comparator = comparator;
        }

        public byte[] getFamily() {
            return this.family;
        }

        public int getMinVersions() {
            return this.minVersions;
        }

        public int getMaxVersions() {
            return this.maxVersions;
        }

        public long getTtl() {
            return this.ttl;
        }

        public boolean getKeepDeletedCells() {
            return this.keepDeletedCells;
        }

        public long getTimeToPurgeDeletes() {
            return this.timeToPurgeDeletes;
        }

        public KeyValue.KVComparator getComparator() {
            return this.comparator;
        }
    }

    private class StoreFlusherImpl
    implements StoreFlusher {
        private long cacheFlushId;
        private SortedSet<KeyValue> snapshot;
        private StoreFile storeFile;
        private Path storeFilePath;
        private TimeRangeTracker snapshotTimeRangeTracker;
        private AtomicLong flushedSize;

        private StoreFlusherImpl(long cacheFlushId) {
            this.cacheFlushId = cacheFlushId;
            this.flushedSize = new AtomicLong();
        }

        @Override
        public void prepare() {
            Store.this.memstore.snapshot();
            this.snapshot = Store.this.memstore.getSnapshot();
            this.snapshotTimeRangeTracker = Store.this.memstore.getSnapshotTimeRangeTracker();
        }

        @Override
        public void flushCache(MonitoredTask status) throws IOException {
            this.storeFilePath = Store.this.flushCache(this.cacheFlushId, this.snapshot, this.snapshotTimeRangeTracker, this.flushedSize, status);
        }

        @Override
        public boolean commit(MonitoredTask status) throws IOException {
            if (this.storeFilePath == null) {
                return false;
            }
            this.storeFile = Store.this.commitFile(this.storeFilePath, this.cacheFlushId, this.snapshotTimeRangeTracker, this.flushedSize, status);
            if (Store.this.getHRegion().getCoprocessorHost() != null) {
                Store.this.getHRegion().getCoprocessorHost().postFlush(Store.this, this.storeFile);
            }
            return Store.this.updateStorefiles(this.storeFile, this.snapshot);
        }
    }
}

