/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.util.Bytes;

public class ScanDeleteTracker
implements DeleteTracker {
    private boolean hasFamilyStamp = false;
    private long familyStamp = 0L;
    private byte[] deleteBuffer = null;
    private int deleteOffset = 0;
    private int deleteLength = 0;
    private byte deleteType = 0;
    private long deleteTimestamp = 0L;

    @Override
    public void add(byte[] buffer, int qualifierOffset, int qualifierLength, long timestamp, byte type) {
        if (!this.hasFamilyStamp || timestamp > this.familyStamp) {
            if (type == KeyValue.Type.DeleteFamily.getCode()) {
                this.hasFamilyStamp = true;
                this.familyStamp = timestamp;
                return;
            }
            if (this.deleteBuffer != null && type < this.deleteType && Bytes.equals(this.deleteBuffer, this.deleteOffset, this.deleteLength, buffer, qualifierOffset, qualifierLength)) {
                return;
            }
            this.deleteBuffer = buffer;
            this.deleteOffset = qualifierOffset;
            this.deleteLength = qualifierLength;
            this.deleteType = type;
            this.deleteTimestamp = timestamp;
        }
    }

    @Override
    public DeleteTracker.DeleteResult isDeleted(byte[] buffer, int qualifierOffset, int qualifierLength, long timestamp) {
        if (this.hasFamilyStamp && timestamp <= this.familyStamp) {
            return DeleteTracker.DeleteResult.FAMILY_DELETED;
        }
        if (this.deleteBuffer != null) {
            int ret = Bytes.compareTo(this.deleteBuffer, this.deleteOffset, this.deleteLength, buffer, qualifierOffset, qualifierLength);
            if (ret == 0) {
                if (this.deleteType == KeyValue.Type.DeleteColumn.getCode()) {
                    return DeleteTracker.DeleteResult.COLUMN_DELETED;
                }
                if (timestamp == this.deleteTimestamp) {
                    return DeleteTracker.DeleteResult.VERSION_DELETED;
                }
                assert (timestamp < this.deleteTimestamp);
                this.deleteBuffer = null;
            } else if (ret < 0) {
                this.deleteBuffer = null;
            } else {
                throw new IllegalStateException("isDelete failed: deleteBuffer=" + Bytes.toStringBinary(this.deleteBuffer, this.deleteOffset, this.deleteLength) + ", qualifier=" + Bytes.toStringBinary(buffer, qualifierOffset, qualifierLength) + ", timestamp=" + timestamp + ", comparison result: " + ret);
            }
        }
        return DeleteTracker.DeleteResult.NOT_DELETED;
    }

    @Override
    public boolean isEmpty() {
        return this.deleteBuffer == null && !this.hasFamilyStamp;
    }

    @Override
    public void reset() {
        this.hasFamilyStamp = false;
        this.familyStamp = 0L;
        this.deleteBuffer = null;
    }

    @Override
    public void update() {
        this.reset();
    }
}

