/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;

public class MemStoreLAB {
    private AtomicReference<Chunk> curChunk = new AtomicReference();
    static final String CHUNK_SIZE_KEY = "hbase.hregion.memstore.mslab.chunksize";
    static final int CHUNK_SIZE_DEFAULT = 0x200000;
    final int chunkSize;
    static final String MAX_ALLOC_KEY = "hbase.hregion.memstore.mslab.max.allocation";
    static final int MAX_ALLOC_DEFAULT = 262144;
    final int maxAlloc;

    public MemStoreLAB() {
        this(new Configuration());
    }

    public MemStoreLAB(Configuration conf) {
        this.chunkSize = conf.getInt(CHUNK_SIZE_KEY, 0x200000);
        this.maxAlloc = conf.getInt(MAX_ALLOC_KEY, 262144);
        Preconditions.checkArgument((this.maxAlloc <= this.chunkSize ? 1 : 0) != 0, (Object)"hbase.hregion.memstore.mslab.max.allocation must be less than hbase.hregion.memstore.mslab.chunksize");
    }

    public Allocation allocateBytes(int size) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (Object)"negative size");
        if (size > this.maxAlloc) {
            return null;
        }
        Chunk c;
        int allocOffset;
        while ((allocOffset = (c = this.getOrMakeChunk()).alloc(size)) == -1) {
            this.tryRetireChunk(c);
        }
        return new Allocation(c.data, allocOffset);
    }

    private void tryRetireChunk(Chunk c) {
        boolean weRetiredIt = this.curChunk.compareAndSet(c, null);
    }

    private Chunk getOrMakeChunk() {
        Chunk c;
        do {
            if ((c = this.curChunk.get()) == null) continue;
            return c;
        } while (!this.curChunk.compareAndSet(null, c = new Chunk(this.chunkSize)));
        c.init();
        return c;
    }

    public static class Allocation {
        private final byte[] data;
        private final int offset;

        private Allocation(byte[] data, int off) {
            this.data = data;
            this.offset = off;
        }

        public String toString() {
            return "Allocation(data=" + this.data + " with capacity=" + this.data.length + ", off=" + this.offset + ")";
        }

        byte[] getData() {
            return this.data;
        }

        int getOffset() {
            return this.offset;
        }
    }

    private static class Chunk {
        private byte[] data;
        private static final int UNINITIALIZED = -1;
        private static final int OOM = -2;
        private AtomicInteger nextFreeOffset = new AtomicInteger(-1);
        private AtomicInteger allocCount = new AtomicInteger();
        private final int size;

        private Chunk(int size) {
            this.size = size;
        }

        public void init() {
            assert (this.nextFreeOffset.get() == -1);
            try {
                this.data = new byte[this.size];
            }
            catch (OutOfMemoryError e) {
                boolean failInit = this.nextFreeOffset.compareAndSet(-1, -2);
                assert (failInit);
                throw e;
            }
            boolean initted = this.nextFreeOffset.compareAndSet(-1, 0);
            Preconditions.checkState((boolean)initted, (Object)"Multiple threads tried to init same chunk");
        }

        public int alloc(int size) {
            int oldOffset;
            while (true) {
                if ((oldOffset = this.nextFreeOffset.get()) == -1) {
                    Thread.yield();
                    continue;
                }
                if (oldOffset == -2) {
                    return -1;
                }
                if (oldOffset + size > this.data.length) {
                    return -1;
                }
                if (this.nextFreeOffset.compareAndSet(oldOffset, oldOffset + size)) break;
            }
            this.allocCount.incrementAndGet();
            return oldOffset;
        }

        public String toString() {
            return "Chunk@" + System.identityHashCode(this) + " allocs=" + this.allocCount.get() + "waste=" + (this.data.length - this.nextFreeOffset.get());
        }
    }
}

