/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.io.IOUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;

public abstract class LogMonitoring {
    public static Set<File> getActiveLogFiles() throws IOException {
        HashSet ret = Sets.newHashSet();
        Enumeration e = Logger.getRootLogger().getAllAppenders();
        while (e.hasMoreElements()) {
            Appender a = (Appender)e.nextElement();
            if (!(a instanceof FileAppender)) continue;
            FileAppender fa = (FileAppender)a;
            String filename = fa.getFile();
            ret.add(new File(filename));
        }
        return ret;
    }

    public static void dumpTailOfLogs(PrintWriter out, long tailKb) throws IOException {
        Set<File> logs = LogMonitoring.getActiveLogFiles();
        for (File f : logs) {
            out.println("+++++++++++++++++++++++++++++++");
            out.println(f.getAbsolutePath());
            out.println("+++++++++++++++++++++++++++++++");
            try {
                LogMonitoring.dumpTailOfLog(f, out, tailKb);
            }
            catch (IOException ioe) {
                out.println("Unable to dump log at " + f);
                ioe.printStackTrace(out);
            }
            out.println("\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpTailOfLog(File f, PrintWriter out, long tailKb) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        try {
            String line;
            FileChannel channel = fis.getChannel();
            channel.position(Math.max(0L, channel.size() - tailKb * 1024L));
            BufferedReader r = new BufferedReader(new InputStreamReader(fis));
            r.readLine();
            while ((line = r.readLine()) != null) {
                out.println(line);
            }
        }
        finally {
            IOUtils.closeStream((Closeable)fis);
        }
    }
}

