/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.ipc.RpcEngine;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.VersionedProtocol;
import org.apache.hadoop.hbase.ipc.WritableRpcEngine;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.util.ReflectionUtils;

public class HBaseRPC {
    protected static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.HBaseRPC");
    public static final String RPC_ENGINE_PROP = "hbase.rpc.engine";
    private static ThreadLocal<Integer> rpcTimeout = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return Integer.MAX_VALUE;
        }
    };

    private HBaseRPC() {
    }

    public static synchronized RpcEngine getProtocolEngine(Configuration conf) {
        Class impl = conf.getClass(RPC_ENGINE_PROP, WritableRpcEngine.class);
        LOG.debug((Object)("Using RpcEngine: " + impl.getName()));
        RpcEngine engine = (RpcEngine)ReflectionUtils.newInstance((Class)impl, (Configuration)conf);
        return engine;
    }

    public static <T extends VersionedProtocol> T waitForProxy(RpcEngine rpcClient, Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, int maxAttempts, int rpcTimeout, long timeout) throws IOException {
        long startTime = System.currentTimeMillis();
        int reconnectAttempts = 0;
        while (true) {
            IOException ioe;
            block7: {
                try {
                    return rpcClient.getProxy(protocol, clientVersion, addr, conf, rpcTimeout);
                }
                catch (SocketTimeoutException te) {
                    LOG.info((Object)("Problem connecting to server: " + addr));
                    ioe = te;
                }
                catch (IOException ioex) {
                    ConnectException ce = null;
                    ioe = ioex instanceof ConnectException ? (ce = (ConnectException)ioex) : (ioex.getCause() != null && ioex.getCause() instanceof ConnectException ? (ce = (ConnectException)ioex.getCause()) : (ioex.getMessage().toLowerCase().contains("connection refused") ? (ce = new ConnectException(ioex.getMessage())) : ioex));
                    if (ce == null) break block7;
                    HBaseRPC.handleConnectionException(++reconnectAttempts, maxAttempts, protocol, addr, ce);
                }
            }
            if (System.currentTimeMillis() - timeout >= startTime) {
                throw ioe;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
            }
        }
    }

    private static void handleConnectionException(int retries, int maxAttmpts, Class<?> protocol, InetSocketAddress addr, ConnectException ce) throws RetriesExhaustedException {
        if (maxAttmpts >= 0 && retries >= maxAttmpts) {
            LOG.info((Object)("Server at " + addr + " could not be reached after " + maxAttmpts + " tries, giving up."));
            throw new RetriesExhaustedException("Failed setting up proxy " + protocol + " to " + addr.toString() + " after attempts=" + maxAttmpts, ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Object[] call(Method method, Object[][] params, InetSocketAddress[] addrs, Class<? extends VersionedProtocol> protocol, User ticket, Configuration conf) throws IOException, InterruptedException {
        Object[] result = null;
        RpcEngine engine = null;
        try {
            engine = HBaseRPC.getProtocolEngine(conf);
            result = engine.call(method, params, addrs, protocol, ticket, conf);
        }
        finally {
            engine.close();
        }
        return result;
    }

    public static RpcServer getServer(Object instance, Class<?>[] ifaces, String bindAddress, int port, int numHandlers, int metaHandlerCount, boolean verbose, Configuration conf, int highPriorityLevel) throws IOException {
        return HBaseRPC.getServer(instance.getClass(), instance, ifaces, bindAddress, port, numHandlers, metaHandlerCount, verbose, conf, highPriorityLevel);
    }

    public static RpcServer getServer(Class protocol, Object instance, Class<?>[] ifaces, String bindAddress, int port, int numHandlers, int metaHandlerCount, boolean verbose, Configuration conf, int highPriorityLevel) throws IOException {
        return HBaseRPC.getProtocolEngine(conf).getServer(protocol, instance, ifaces, bindAddress, port, numHandlers, metaHandlerCount, verbose, conf, highPriorityLevel);
    }

    public static void setRpcTimeout(int rpcTimeout) {
        HBaseRPC.rpcTimeout.set(rpcTimeout);
    }

    public static int getRpcTimeout() {
        return rpcTimeout.get();
    }

    public static void resetRpcTimeout() {
        rpcTimeout.remove();
    }

    public static int getRpcTimeout(int defaultTimeout) {
        return Math.min(defaultTimeout, rpcTimeout.get());
    }

    public static class UnknownProtocolException
    extends DoNotRetryIOException {
        private Class<?> protocol;

        public UnknownProtocolException(String mesg) {
            super(mesg);
        }

        public UnknownProtocolException(Class<?> protocol) {
            this(protocol, "Server is not handling protocol " + protocol.getName());
        }

        public UnknownProtocolException(Class<?> protocol, String mesg) {
            super(mesg);
            this.protocol = protocol;
        }

        public Class getProtocol() {
            return this.protocol;
        }
    }

    public static class VersionMismatch
    extends IOException {
        private static final long serialVersionUID = 0L;
        private String interfaceName;
        private long clientVersion;
        private long serverVersion;

        public VersionMismatch(String interfaceName, long clientVersion, long serverVersion) {
            super("Protocol " + interfaceName + " version mismatch. (client = " + clientVersion + ", server = " + serverVersion + ")");
            this.interfaceName = interfaceName;
            this.clientVersion = clientVersion;
            this.serverVersion = serverVersion;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public long getClientVersion() {
            return this.clientVersion;
        }

        public long getServerVersion() {
            return this.serverVersion;
        }
    }
}

