/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.util.Pair;

public class NoOpDataBlockEncoder
implements HFileDataBlockEncoder {
    public static final NoOpDataBlockEncoder INSTANCE = new NoOpDataBlockEncoder();

    private NoOpDataBlockEncoder() {
    }

    @Override
    public HFileBlock diskToCacheFormat(HFileBlock block, boolean isCompaction) {
        if (block.getBlockType() == BlockType.ENCODED_DATA) {
            throw new IllegalStateException("Unexpected encoded block");
        }
        return block;
    }

    @Override
    public Pair<ByteBuffer, BlockType> beforeWriteToDisk(ByteBuffer in, boolean includesMemstoreTS, byte[] dummyHeader) {
        return new Pair<ByteBuffer, BlockType>(in, BlockType.DATA);
    }

    @Override
    public boolean useEncodedScanner(boolean isCompaction) {
        return false;
    }

    @Override
    public void saveMetadata(HFile.Writer writer) {
    }

    @Override
    public DataBlockEncoding getEncodingOnDisk() {
        return DataBlockEncoding.NONE;
    }

    @Override
    public DataBlockEncoding getEncodingInCache() {
        return DataBlockEncoding.NONE;
    }

    @Override
    public DataBlockEncoding getEffectiveEncodingInCache(boolean isCompaction) {
        return DataBlockEncoding.NONE;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

