/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.io.encoding.CopyKeyDataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DiffKeyDeltaEncoder;
import org.apache.hadoop.hbase.io.encoding.FastDiffDeltaEncoder;
import org.apache.hadoop.hbase.io.encoding.PrefixKeyDeltaEncoder;
import org.apache.hadoop.hbase.util.Bytes;

public enum DataBlockEncoding {
    NONE(0, null),
    PREFIX(2, new PrefixKeyDeltaEncoder()),
    DIFF(3, new DiffKeyDeltaEncoder()),
    FAST_DIFF(4, new FastDiffDeltaEncoder());

    private final short id;
    private final byte[] idInBytes;
    private final DataBlockEncoder encoder;
    public static final int ID_SIZE = 2;
    private static Map<Short, DataBlockEncoding> idToEncoding;

    private DataBlockEncoding(int id, DataBlockEncoder encoder) {
        if (id < Short.MIN_VALUE || id > Short.MAX_VALUE) {
            throw new AssertionError((Object)("Data block encoding algorithm id is out of range: " + id));
        }
        this.id = (short)id;
        this.idInBytes = Bytes.toBytes(this.id);
        if (this.idInBytes.length != 2) {
            throw new RuntimeException("Unexpected length of encoder ID byte representation: " + Bytes.toStringBinary(this.idInBytes));
        }
        this.encoder = encoder;
    }

    public byte[] getNameInBytes() {
        return Bytes.toBytes(this.toString());
    }

    public short getId() {
        return this.id;
    }

    public void writeIdInBytes(OutputStream stream) throws IOException {
        stream.write(this.idInBytes);
    }

    public DataBlockEncoder getEncoder() {
        return this.encoder;
    }

    public static List<DataBlockEncoder> getAllEncoders() {
        ArrayList<DataBlockEncoder> encoders = new ArrayList<DataBlockEncoder>();
        for (DataBlockEncoding algo : DataBlockEncoding.values()) {
            DataBlockEncoder encoder = algo.getEncoder();
            if (encoder == null) continue;
            encoders.add(encoder);
        }
        encoders.add(new CopyKeyDataBlockEncoder());
        return encoders;
    }

    public static DataBlockEncoder getDataBlockEncoderById(short encoderId) {
        if (!idToEncoding.containsKey(encoderId)) {
            throw new IllegalArgumentException(String.format("There is no data block encoder for given id '%d'", encoderId));
        }
        return idToEncoding.get(encoderId).getEncoder();
    }

    public static String getNameFromId(short encoderId) {
        return idToEncoding.get(encoderId).toString();
    }

    public static boolean isCorrectEncoder(DataBlockEncoder encoder, short encoderId) {
        if (!idToEncoding.containsKey(encoderId)) {
            throw new IllegalArgumentException(String.format("There is no data block encoder for given id '%d'", encoderId));
        }
        DataBlockEncoding algorithm = idToEncoding.get(encoderId);
        return ((Object)((Object)algorithm)).getClass().equals(encoder.getClass());
    }

    public static DataBlockEncoding getEncodingById(short dataBlockEncodingId) {
        return idToEncoding.get(dataBlockEncodingId);
    }

    static {
        idToEncoding = new HashMap<Short, DataBlockEncoding>();
        for (DataBlockEncoding algo : DataBlockEncoding.values()) {
            if (idToEncoding.containsKey(algo.id)) {
                throw new RuntimeException(String.format("Two data block encoder algorithms '%s' and '%s' have the same id %d", idToEncoding.get(algo.id).toString(), algo.toString(), (int)algo.id));
            }
            idToEncoding.put(algo.id, algo);
        }
    }
}

