/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.coprocessor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public class ExecResult
implements Writable {
    private byte[] regionName;
    private Object value;

    public ExecResult() {
    }

    public ExecResult(Object value) {
        this(HConstants.EMPTY_BYTE_ARRAY, value);
    }

    public ExecResult(byte[] region, Object value) {
        this.regionName = region;
        this.value = value;
    }

    public byte[] getRegionName() {
        return this.regionName;
    }

    public Object getValue() {
        return this.value;
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.regionName);
        HbaseObjectWritable.writeObject(out, this.value, this.value != null ? this.value.getClass() : Writable.class, null);
    }

    public void readFields(DataInput in) throws IOException {
        this.regionName = Bytes.readByteArray(in);
        this.value = HbaseObjectWritable.readObject(in, null);
    }
}

