/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.util.Bytes;

public class ClientSmallScanner
extends ClientScanner {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private ServerCallable<Result[]> smallScanCallable = null;
    private byte[] skipRowOfFirstResult = null;

    public ClientSmallScanner(Configuration conf, Scan scan, byte[] tableName) throws IOException {
        this(conf, scan, tableName, HConnectionManager.getConnection(conf));
    }

    public ClientSmallScanner(Configuration conf, Scan scan, byte[] tableName, HConnection connection) throws IOException {
        super(conf, scan, tableName, connection);
    }

    @Override
    protected void initializeScannerInConstruction() throws IOException {
    }

    private boolean nextScanner(int nbRows, boolean done, boolean currentRegionDone) throws IOException {
        byte[] localStartKey;
        int cacheNum = nbRows;
        this.skipRowOfFirstResult = null;
        if (this.currentRegion != null && currentRegionDone) {
            byte[] endKey = this.currentRegion.getEndKey();
            if (endKey == null || Bytes.equals(endKey, HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(endKey) || done) {
                this.close();
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Finished with small scan at " + (Object)((Object)this.currentRegion)));
                }
                return false;
            }
            localStartKey = endKey;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Finished with region " + (Object)((Object)this.currentRegion)));
            }
        } else if (this.lastResult != null) {
            localStartKey = this.lastResult.getRow();
            this.skipRowOfFirstResult = this.lastResult.getRow();
            ++cacheNum;
        } else {
            localStartKey = this.scan.getStartRow();
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Advancing internal small scanner to startKey at '" + Bytes.toStringBinary(localStartKey) + "'"));
        }
        this.smallScanCallable = this.getSmallScanCallable(localStartKey, cacheNum);
        if (this.scanMetrics != null && this.skipRowOfFirstResult == null) {
            this.scanMetrics.countOfRegions.inc();
        }
        return true;
    }

    private ServerCallable<Result[]> getSmallScanCallable(byte[] localStartKey, final int nbRows) {
        this.scan.setStartRow(localStartKey);
        ServerCallable<Result[]> callable = new ServerCallable<Result[]>(this.getConnection(), this.getTableName(), this.scan.getStartRow()){

            @Override
            public Result[] call() throws IOException {
                return this.server.scan(this.location.getRegionInfo().getRegionName(), ClientSmallScanner.this.scan, nbRows);
            }
        };
        return callable;
    }

    @Override
    public Result next() throws IOException {
        if (this.cache.size() == 0 && this.closed) {
            return null;
        }
        if (this.cache.size() == 0) {
            Result[] values = null;
            long remainingResultSize = this.maxScannerResultSize;
            int countdown = this.caching;
            boolean currentRegionDone = false;
            while (remainingResultSize > 0L && countdown > 0 && this.nextScanner(countdown, values == null, currentRegionDone)) {
                values = this.smallScanCallable.withRetries();
                this.currentRegion = this.smallScanCallable.getHRegionInfo();
                long currentTime = System.currentTimeMillis();
                if (this.scanMetrics != null) {
                    this.scanMetrics.sumOfMillisSecBetweenNexts.inc(currentTime - this.lastNext);
                }
                this.lastNext = currentTime;
                if (values != null && values.length > 0) {
                    for (int i = 0; i < values.length; ++i) {
                        Result rs = values[i];
                        if (i == 0 && this.skipRowOfFirstResult != null && Bytes.equals(this.skipRowOfFirstResult, rs.getRow())) continue;
                        this.cache.add(rs);
                        for (KeyValue kv : rs.raw()) {
                            remainingResultSize -= kv.heapSize();
                        }
                        --countdown;
                        this.lastResult = rs;
                    }
                }
                currentRegionDone = countdown > 0;
            }
        }
        if (this.cache.size() > 0) {
            return (Result)this.cache.poll();
        }
        this.writeScanMetrics();
        return null;
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            this.writeScanMetrics();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

