/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.formatting;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SafeString {
    public static final String ERROR_PREFIX = "[!!!";
    public static final String ERROR_SEPARATOR = "=>";
    public static final String ERROR_MSG_SEPARATOR = ":";
    public static final String ERROR_SUFFIX = "!!!]";
    public static final String RECURSION_PREFIX = "[...";
    public static final String RECURSION_SUFFIX = "...]";

    private SafeString() {
    }

    public static String toString(Object o) {
        if (o == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        SafeString.append(o, builder);
        return builder.toString();
    }

    public static void append(Object obj, StringBuilder into) {
        HashSet<String> dejaVu = new HashSet<String>();
        SafeString.recursiveAppend(obj, into, dejaVu);
    }

    private static void recursiveAppend(Object o, StringBuilder str, Set<String> dejaVu) {
        if (o == null) {
            str.append("null");
            return;
        }
        if (o instanceof String) {
            str.append(o);
            return;
        }
        Class<?> oClass = o.getClass();
        if (oClass.isArray()) {
            if (oClass == byte[].class) {
                str.append(Arrays.toString((byte[])o));
            } else if (oClass == short[].class) {
                str.append(Arrays.toString((short[])o));
            } else if (oClass == int[].class) {
                str.append(Arrays.toString((int[])o));
            } else if (oClass == long[].class) {
                str.append(Arrays.toString((long[])o));
            } else if (oClass == float[].class) {
                str.append(Arrays.toString((float[])o));
            } else if (oClass == double[].class) {
                str.append(Arrays.toString((double[])o));
            } else if (oClass == boolean[].class) {
                str.append(Arrays.toString((boolean[])o));
            } else if (oClass == char[].class) {
                str.append(Arrays.toString((char[])o));
            } else {
                String id = SafeString.identityToString(o);
                if (dejaVu.contains(id)) {
                    str.append(RECURSION_PREFIX).append(id).append(RECURSION_SUFFIX);
                } else {
                    dejaVu.add(id);
                    Object[] oArray = (Object[])o;
                    str.append("[");
                    boolean first = true;
                    for (Object current : oArray) {
                        if (first) {
                            first = false;
                        } else {
                            str.append(", ");
                        }
                        SafeString.recursiveAppend(current, str, new HashSet<String>(dejaVu));
                    }
                    str.append("]");
                }
            }
        } else if (o instanceof Map) {
            String id = SafeString.identityToString(o);
            if (dejaVu.contains(id)) {
                str.append(RECURSION_PREFIX).append(id).append(RECURSION_SUFFIX);
            } else {
                dejaVu.add(id);
                Map oMap = (Map)o;
                str.append("{");
                boolean isFirst = true;
                for (Map.Entry current : oMap.entrySet()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        str.append(", ");
                    }
                    Object key = current.getKey();
                    Object value = current.getValue();
                    SafeString.recursiveAppend(key, str, new HashSet<String>(dejaVu));
                    str.append("=");
                    SafeString.recursiveAppend(value, str, new HashSet<String>(dejaVu));
                }
                str.append("}");
            }
        } else if (o instanceof Collection) {
            String id = SafeString.identityToString(o);
            if (dejaVu.contains(id)) {
                str.append(RECURSION_PREFIX).append(id).append(RECURSION_SUFFIX);
            } else {
                dejaVu.add(id);
                Collection oCol = (Collection)o;
                str.append("[");
                boolean isFirst = true;
                for (Object current : oCol) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        str.append(", ");
                    }
                    SafeString.recursiveAppend(current, str, new HashSet<String>(dejaVu));
                }
                str.append("]");
            }
        } else if (o instanceof Date) {
            Date date = (Date)o;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            str.append(format.format(date));
        } else {
            try {
                str.append(o.toString());
            }
            catch (Throwable t) {
                str.append(ERROR_PREFIX);
                str.append(SafeString.identityToString(o));
                str.append(ERROR_SEPARATOR);
                String msg = t.getMessage();
                String className = t.getClass().getName();
                str.append(className);
                if (msg != null && !className.equals(msg)) {
                    str.append(ERROR_MSG_SEPARATOR);
                    str.append(msg);
                }
                str.append(ERROR_SUFFIX);
            }
        }
    }

    public static String identityToString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }
}

