/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.ResultSet;
import java.util.List;
import net.hydromatic.avatica.AvaticaPrepareResult;
import net.hydromatic.avatica.AvaticaResultSet;
import net.hydromatic.avatica.AvaticaStatement;
import net.hydromatic.avatica.Cursor;
import net.hydromatic.avatica.Meta;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.jdbc.DrillConnectionImpl;
import org.apache.drill.jdbc.DrillPrepareResult;
import org.apache.drill.jdbc.DrillResultSet;
import org.apache.drill.jdbc.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaImpl
implements Meta {
    static final Logger logger = LoggerFactory.getLogger(MetaImpl.class);
    static final Driver DRIVER = new Driver();
    final DrillConnectionImpl connection;

    public MetaImpl(DrillConnectionImpl connection) {
        this.connection = connection;
    }

    public String getSqlKeywords() {
        return "";
    }

    public String getNumericFunctions() {
        return "";
    }

    public String getStringFunctions() {
        return "";
    }

    public String getSystemFunctions() {
        return "";
    }

    public String getTimeDateFunctions() {
        return "";
    }

    public static ResultSet getEmptyResultSet() {
        return null;
    }

    private ResultSet s(String s) {
        try {
            logger.debug("Running {}", (Object)s);
            AvaticaStatement statement = this.connection.createStatement();
            statement.execute(s);
            return statement.getResultSet();
        }
        catch (Exception e) {
            throw new DrillRuntimeException("Failure while attempting to get DatabaseMetadata.", (Throwable)e);
        }
    }

    public ResultSet getTables(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) {
        StringBuilder sb = new StringBuilder();
        sb.append("select TABLE_CATALOG as TABLE_CAT, TABLE_SCHEMA as TABLE_SCHEM, TABLE_NAME, TABLE_TYPE, '' as REMARKS, '' as TYPE_CAT, '' as TYPE_SCHEM, '' as TYPE_NAME, '' as SELF_REFERENCING_COL_NAME, '' as REF_GENERATION FROM INFORMATION_SCHEMA.`TABLES` WHERE 1=1 ");
        if (catalog != null) {
            sb.append(" AND TABLE_CATALOG = '" + StringEscapeUtils.escapeSql((String)catalog) + "' ");
        }
        if (schemaPattern.s != null) {
            sb.append(" AND TABLE_SCHEMA like '" + StringEscapeUtils.escapeSql((String)schemaPattern.s) + "'");
        }
        if (tableNamePattern.s != null) {
            sb.append(" AND TABLE_NAME like '" + StringEscapeUtils.escapeSql((String)tableNamePattern.s) + "'");
        }
        if (typeList != null && typeList.size() > 0) {
            sb.append("AND (");
            for (int t = 0; t < typeList.size(); ++t) {
                if (t != 0) {
                    sb.append(" OR ");
                }
                sb.append(" TABLE_TYPE LIKE '" + StringEscapeUtils.escapeSql((String)typeList.get(t)) + "' ");
            }
            sb.append(")");
        }
        sb.append(" ORDER BY TABLE_TYPE, TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME");
        return this.s(sb.toString());
    }

    public ResultSet getColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        StringBuilder sb = new StringBuilder();
        sb.append("select TABLE_CATALOG as TABLE_CAT, TABLE_SCHEMA as TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, DATA_TYPE, CHARACTER_MAXIMUM_LENGTH as BUFFER_LENGTH, NUMERIC_PRECISION as DECIMAL_PRECISION, NUMERIC_PRECISION_RADIX as NUM_PREC_RADIX, 2 as NULLABLE, '' as REMARKS, '' as COLUMN_DEF, 0 as SQL_DATA_TYPE, 0 as SQL_DATETIME_SUB, 4 as CHAR_OCTET_LENGTH, 1 as ORDINAL_POSITION, 'YES' as IS_NULLABLE, '' as SCOPE_CATALOG,'' as SCOPE_SCHEMA, '' as SCOPE_TABLE, '' as SOURCE_DATA_TYPE, '' as IS_AUTOINCREMENT, '' as IS_GENERATEDCOLUMN FROM INFORMATION_SCHEMA.COLUMNS WHERE 1=1 ");
        if (catalog != null) {
            sb.append(" AND TABLE_CATALOG = '" + StringEscapeUtils.escapeSql((String)catalog) + "' ");
        }
        if (schemaPattern.s != null) {
            sb.append(" AND TABLE_SCHEMA like '" + StringEscapeUtils.escapeSql((String)schemaPattern.s) + "'");
        }
        if (tableNamePattern.s != null) {
            sb.append(" AND TABLE_NAME like '" + StringEscapeUtils.escapeSql((String)tableNamePattern.s) + "'");
        }
        if (columnNamePattern.s != null) {
            sb.append(" AND COLUMN_NAME like '" + StringEscapeUtils.escapeSql((String)columnNamePattern.s) + "'");
        }
        sb.append(" ORDER BY TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME");
        return this.s(sb.toString());
    }

    public ResultSet getSchemas(String catalog, Meta.Pat schemaPattern) {
        StringBuilder sb = new StringBuilder();
        sb.append("select SCHEMA_NAME as TABLE_SCHEM, CATALOG_NAME as TABLE_CAT  FROM INFORMATION_SCHEMA.SCHEMATA WHERE 1=1 ");
        if (catalog != null) {
            sb.append(" AND CATALOG_NAME = '" + StringEscapeUtils.escapeSql((String)catalog) + "' ");
        }
        if (schemaPattern.s != null) {
            sb.append(" AND SCHEMA_NAME like '" + StringEscapeUtils.escapeSql((String)schemaPattern.s) + "'");
        }
        sb.append(" ORDER BY CATALOG_NAME, SCHEMA_NAME");
        return this.s(sb.toString());
    }

    public ResultSet getCatalogs() {
        StringBuilder sb = new StringBuilder();
        sb.append("select CATALOG_NAME as TABLE_CAT  FROM INFORMATION_SCHEMA.CATALOGS ");
        sb.append(" ORDER BY CATALOG_NAME");
        return this.s(sb.toString());
    }

    public ResultSet getTableTypes() {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getProcedures(String catalog, Meta.Pat schemaPattern, Meta.Pat procedureNamePattern) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getProcedureColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat procedureNamePattern, Meta.Pat columnNamePattern) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, Meta.Pat columnNamePattern) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getTablePrivileges(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getTypeInfo() {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getUDTs(String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern, int[] types) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getSuperTypes(String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getSuperTables(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getAttributes(String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern, Meta.Pat attributeNamePattern) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getClientInfoProperties() {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getFunctions(String catalog, Meta.Pat schemaPattern, Meta.Pat functionNamePattern) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getFunctionColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat functionNamePattern, Meta.Pat columnNamePattern) {
        return MetaImpl.getEmptyResultSet();
    }

    public ResultSet getPseudoColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        return MetaImpl.getEmptyResultSet();
    }

    public Cursor createCursor(AvaticaResultSet resultSet_) {
        return ((DrillResultSet)resultSet_).cursor;
    }

    public AvaticaPrepareResult prepare(AvaticaStatement statement_, String sql) {
        return new DrillPrepareResult(sql);
    }

    static interface Named {
        public String getName();
    }
}

