/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import net.hydromatic.avatica.DriverVersion;
import net.hydromatic.avatica.Handler;
import net.hydromatic.avatica.HandlerImpl;
import net.hydromatic.avatica.UnregisteredDriver;

public class Driver
extends UnregisteredDriver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:drill:";

    public static boolean load() {
        return true;
    }

    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    protected String getFactoryClassName(UnregisteredDriver.JdbcVersion jdbcVersion) {
        switch (jdbcVersion) {
            case JDBC_30: {
                return "org.apache.drill.jdbc.DrillJdbc3Factory";
            }
            case JDBC_40: {
                return "org.apache.drill.jdbc.DrillJdbc40Factory";
            }
        }
        return "org.apache.drill.jdbc.DrillJdbc41Factory";
    }

    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, (String)"apache-drill-jdbc.properties", (String)"Drill JDBC Driver", (String)"unknown version", (String)"Optiq", (String)"unknown version");
    }

    protected Handler createHandler() {
        return new HandlerImpl();
    }

    static {
        new Driver().register();
    }
}

