/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import net.hydromatic.avatica.ArrayImpl;
import net.hydromatic.avatica.ColumnMetaData;
import net.hydromatic.avatica.Cursor;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.user.QueryResultBatch;
import org.apache.drill.jdbc.DrillAccessorList;
import org.apache.drill.jdbc.DrillColumnMetaDataList;
import org.apache.drill.jdbc.DrillResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillCursor
implements Cursor {
    static final Logger logger = LoggerFactory.getLogger(DrillCursor.class);
    private static final String UNKNOWN = "--UNKNOWN--";
    private boolean started = false;
    private boolean finished = false;
    private final RecordBatchLoader currentBatch;
    private final DrillResultSet.Listener listener;
    private boolean redoFirstNext = false;
    private boolean first = true;
    private DrillColumnMetaDataList columnMetaDataList;
    private BatchSchema schema;
    final DrillResultSet results;
    int currentRecord = 0;
    private long recordBatchCount;
    private final DrillAccessorList accessors = new DrillAccessorList();

    public DrillCursor(DrillResultSet results) {
        this.results = results;
        this.currentBatch = results.currentBatch;
        this.listener = results.listener;
    }

    public List<Cursor.Accessor> createAccessors(List<ColumnMetaData> types, Calendar localCalendar, ArrayImpl.Factory factory) {
        this.columnMetaDataList = (DrillColumnMetaDataList)types;
        return this.accessors;
    }

    public boolean next() throws SQLException {
        if (!this.started) {
            this.started = true;
            this.redoFirstNext = true;
        } else if (this.redoFirstNext && !this.finished) {
            this.redoFirstNext = false;
            return true;
        }
        if (this.finished) {
            return false;
        }
        if (this.currentRecord + 1 < this.currentBatch.getRecordCount()) {
            ++this.currentRecord;
            return true;
        }
        try {
            QueryResultBatch qrb = this.listener.getNext();
            ++this.recordBatchCount;
            while (qrb != null && qrb.getHeader().getRowCount() == 0 && !this.first) {
                qrb.release();
                qrb = this.listener.getNext();
                ++this.recordBatchCount;
            }
            this.first = false;
            if (qrb == null) {
                this.finished = true;
                return false;
            }
            this.currentRecord = 0;
            boolean changed = this.currentBatch.load(qrb.getHeader().getDef(), qrb.getData());
            this.schema = this.currentBatch.getSchema();
            if (changed) {
                this.updateColumns();
            }
            if (this.redoFirstNext && this.currentBatch.getRecordCount() == 0) {
                this.redoFirstNext = false;
            }
            return true;
        }
        catch (InterruptedException | SchemaChangeException | RpcException e) {
            throw new SQLException("Failure while executing query.", e);
        }
    }

    void updateColumns() {
        this.accessors.generateAccessors(this, this.currentBatch);
        this.columnMetaDataList.updateColumnMetaData(UNKNOWN, UNKNOWN, UNKNOWN, this.schema);
        if (this.results.changeListener != null) {
            this.results.changeListener.schemaChanged(this.schema);
        }
    }

    public long getRecordBatchCount() {
        return this.recordBatchCount;
    }

    public void close() {
        this.results.cleanup();
    }

    public boolean wasNull() throws SQLException {
        return this.accessors.wasNull();
    }
}

