/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.hydromatic.avatica.ColumnMetaData;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.jdbc.BasicList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillColumnMetaDataList
extends BasicList<ColumnMetaData> {
    static final Logger logger = LoggerFactory.getLogger(DrillColumnMetaDataList.class);
    private List<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();

    @Override
    public int size() {
        return this.columns.size();
    }

    @Override
    public ColumnMetaData get(int index) {
        return this.columns.get(index);
    }

    public void updateColumnMetaData(String catalogName, String schemaName, String tableName, BatchSchema schema) {
        this.columns = new ArrayList<ColumnMetaData>(schema.getFieldCount());
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            MaterializedField f = schema.getColumn(i);
            TypeProtos.MajorType t = f.getType();
            ColumnMetaData col = new ColumnMetaData(i, false, true, false, false, f.getDataMode() == TypeProtos.DataMode.OPTIONAL ? 1 : 0, !Types.isUnSigned((TypeProtos.MajorType)t), 10, f.getAsSchemaPath().getRootSegment().getPath(), f.getAsSchemaPath().getRootSegment().getPath(), schemaName, t.hasPrecision() ? t.getPrecision() : 0, t.hasScale() ? t.getScale() : 0, null, catalogName, DrillColumnMetaDataList.getAvaticaType(t), true, false, false, "none");
            this.columns.add(col);
        }
    }

    private static ColumnMetaData.AvaticaType getAvaticaType(TypeProtos.MajorType t) {
        int sqlTypeId = Types.getSqlType((TypeProtos.MajorType)t);
        return ColumnMetaData.scalar((int)sqlTypeId, (String)DrillColumnMetaDataList.getSqlTypeName(sqlTypeId), (ColumnMetaData.Rep)ColumnMetaData.Rep.BOOLEAN);
    }

    private static String getSqlTypeName(int type) {
        switch (type) {
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 0: {
                return "NULL";
            }
            case 1111: {
                return "OTHER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 2006: {
                return "REF";
            }
            case 70: {
                return "DATALINK";
            }
            case 16: {
                return "BOOLEAN";
            }
            case -8: {
                return "ROWID";
            }
            case -15: {
                return "NCHAR";
            }
            case -9: {
                return "NVARCHAR";
            }
            case -16: {
                return "LONGNVARCHAR";
            }
            case 2011: {
                return "NCLOB";
            }
            case 2009: {
                return "SQLXML";
            }
        }
        return "?";
    }

    @Override
    public boolean contains(Object o) {
        return this.columns.contains(o);
    }

    @Override
    public Iterator<ColumnMetaData> iterator() {
        return this.columns.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.columns.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.columns.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.columns.containsAll(c);
    }

    @Override
    public int indexOf(Object o) {
        return this.columns.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.columns.lastIndexOf(o);
    }

    @Override
    public ListIterator<ColumnMetaData> listIterator() {
        return this.columns.listIterator();
    }

    @Override
    public ListIterator<ColumnMetaData> listIterator(int index) {
        return this.columns.listIterator(index);
    }

    @Override
    public List<ColumnMetaData> subList(int fromIndex, int toIndex) {
        return this.columns.subList(fromIndex, toIndex);
    }
}

