/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.SQLException;
import net.hydromatic.avatica.Cursor;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.SqlAccessor;
import org.apache.drill.jdbc.AvaticaDrillSqlAccessor;
import org.apache.drill.jdbc.BasicList;
import org.apache.drill.jdbc.DrillCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillAccessorList
extends BasicList<Cursor.Accessor> {
    static final Logger logger = LoggerFactory.getLogger(DrillAccessorList.class);
    private Cursor.Accessor[] accessors = new Cursor.Accessor[0];
    private int lastColumn = 1;

    public void generateAccessors(DrillCursor cursor, RecordBatchLoader currentBatch) {
        int cnt = currentBatch.getSchema().getFieldCount();
        this.accessors = new Cursor.Accessor[cnt];
        for (int i = 0; i < cnt; ++i) {
            SqlAccessor acc = TypeHelper.getSqlAccessor((ValueVector)currentBatch.getValueAccessorById(null, new int[]{i}).getValueVector());
            this.accessors[i] = new AvaticaDrillSqlAccessor(acc, cursor);
        }
    }

    @Override
    public Cursor.Accessor get(int index) {
        this.lastColumn = index;
        return this.accessors[index];
    }

    public boolean wasNull() throws SQLException {
        return this.accessors[this.lastColumn].wasNull();
    }

    @Override
    public int size() {
        return this.accessors.length;
    }
}

