/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.ErrorHandler;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.resource.Resource;
import org.codehaus.janino.util.resource.ResourceFinder;

public final class JavaSourceIClassLoader
extends IClassLoader {
    private static final boolean DEBUG = false;
    private ResourceFinder sourceFinder;
    private String optionalCharacterEncoding;
    private final Set<UnitCompiler> unitCompilers;
    private ErrorHandler optionalCompileErrorHandler;
    private WarningHandler optionalWarningHandler;

    public JavaSourceIClassLoader(ResourceFinder sourceFinder, String optionalCharacterEncoding, Set<UnitCompiler> unitCompilers, IClassLoader optionalParentIClassLoader) {
        super(optionalParentIClassLoader);
        this.sourceFinder = sourceFinder;
        this.optionalCharacterEncoding = optionalCharacterEncoding;
        this.unitCompilers = unitCompilers;
        super.postConstruct();
    }

    public void setSourceFinder(ResourceFinder pathResourceFinder) {
        this.sourceFinder = pathResourceFinder;
    }

    public void setCharacterEncoding(String optionalCharacterEncoding) {
        this.optionalCharacterEncoding = optionalCharacterEncoding;
    }

    public void setCompileErrorHandler(ErrorHandler optionalCompileErrorHandler) {
        this.optionalCompileErrorHandler = optionalCompileErrorHandler;
    }

    public void setWarningHandler(WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IClass findIClass(String fieldDescriptor) throws ClassNotFoundException {
        String className = Descriptor.toClassName(fieldDescriptor);
        if (className.startsWith("java.")) {
            return null;
        }
        int idx = className.indexOf(36);
        String topLevelClassName = idx == -1 ? className : className.substring(0, idx);
        for (UnitCompiler uc : this.unitCompilers) {
            IClass res = uc.findClass(topLevelClassName);
            if (res == null) continue;
            if (!className.equals(topLevelClassName) && (res = uc.findClass(className)) == null) {
                return null;
            }
            this.defineIClass(res);
            return res;
        }
        Resource sourceResource = this.sourceFinder.findResource(ClassFile.getSourceResourceName(className));
        if (sourceResource == null) {
            return null;
        }
        try {
            Java.CompilationUnit cu;
            InputStream inputStream = sourceResource.open();
            try {
                Scanner scanner = new Scanner(sourceResource.getFileName(), inputStream, this.optionalCharacterEncoding);
                scanner.setWarningHandler(this.optionalWarningHandler);
                Parser parser = new Parser(scanner);
                parser.setWarningHandler(this.optionalWarningHandler);
                cu = parser.parseCompilationUnit();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {}
            }
            UnitCompiler uc = new UnitCompiler(cu, this);
            uc.setCompileErrorHandler(this.optionalCompileErrorHandler);
            uc.setWarningHandler(this.optionalWarningHandler);
            this.unitCompilers.add(uc);
            IClass res = uc.findClass(className);
            if (res == null) {
                if (className.equals(topLevelClassName)) {
                    throw new CompileException("Source file \"" + sourceResource.getFileName() + "\" does not declare class \"" + className + "\"", (Location)null);
                }
                return null;
            }
            this.defineIClass(res);
            return res;
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", e);
        }
        catch (CompileException e) {
            throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", e);
        }
    }
}

