/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

@Explain(displayName="Join Operator")
public class JoinDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    public static final int INNER_JOIN = 0;
    public static final int LEFT_OUTER_JOIN = 1;
    public static final int RIGHT_OUTER_JOIN = 2;
    public static final int FULL_OUTER_JOIN = 3;
    public static final int UNIQUE_JOIN = 4;
    public static final int LEFT_SEMI_JOIN = 5;
    private boolean handleSkewJoin = false;
    private int skewKeyDefinition = -1;
    private Map<Byte, String> bigKeysDirMap;
    private Map<Byte, Map<Byte, String>> smallKeysDirMap;
    private Map<Byte, TableDesc> skewKeysValuesTables;
    private Map<Byte, List<ExprNodeDesc>> exprs;
    private Map<Byte, List<ExprNodeDesc>> filters;
    private int[][] filterMap;
    private boolean[] nullsafes;
    protected List<String> outputColumnNames;
    private transient Map<String, Byte> reversedExprs;
    protected boolean noOuterJoin;
    protected JoinCondDesc[] conds;
    protected Byte[] tagOrder;
    private TableDesc keyTableDesc;
    private boolean fixedAsSorted;

    public JoinDesc() {
    }

    public JoinDesc(Map<Byte, List<ExprNodeDesc>> exprs, List<String> outputColumnNames, boolean noOuterJoin, JoinCondDesc[] conds, Map<Byte, List<ExprNodeDesc>> filters) {
        this.exprs = exprs;
        this.outputColumnNames = outputColumnNames;
        this.noOuterJoin = noOuterJoin;
        this.conds = conds;
        this.filters = filters;
        this.resetOrder();
    }

    public void resetOrder() {
        this.tagOrder = new Byte[this.exprs.size()];
        for (int i = 0; i < this.tagOrder.length; ++i) {
            this.tagOrder[i] = (byte)i;
        }
    }

    @Override
    public Object clone() {
        JoinDesc ret = new JoinDesc();
        HashMap<Byte, List<ExprNodeDesc>> cloneExprs = new HashMap<Byte, List<ExprNodeDesc>>();
        cloneExprs.putAll(this.getExprs());
        ret.setExprs(cloneExprs);
        HashMap<Byte, List<ExprNodeDesc>> cloneFilters = new HashMap<Byte, List<ExprNodeDesc>>();
        cloneFilters.putAll(this.getFilters());
        ret.setFilters(cloneFilters);
        ret.setConds((JoinCondDesc[])this.getConds().clone());
        ret.setNoOuterJoin(this.getNoOuterJoin());
        ret.setNullSafes(this.getNullSafes());
        ret.setHandleSkewJoin(this.handleSkewJoin);
        ret.setSkewKeyDefinition(this.getSkewKeyDefinition());
        ret.setTagOrder((Byte[])this.getTagOrder().clone());
        if (this.getKeyTableDesc() != null) {
            ret.setKeyTableDesc((TableDesc)this.getKeyTableDesc().clone());
        }
        if (this.getBigKeysDirMap() != null) {
            HashMap<Byte, String> cloneBigKeysDirMap = new HashMap<Byte, String>();
            cloneBigKeysDirMap.putAll(this.getBigKeysDirMap());
            ret.setBigKeysDirMap(cloneBigKeysDirMap);
        }
        if (this.getSmallKeysDirMap() != null) {
            HashMap<Byte, Map<Byte, String>> cloneSmallKeysDirMap = new HashMap<Byte, Map<Byte, String>>();
            cloneSmallKeysDirMap.putAll(this.getSmallKeysDirMap());
            ret.setSmallKeysDirMap(cloneSmallKeysDirMap);
        }
        if (this.getSkewKeysValuesTables() != null) {
            HashMap<Byte, TableDesc> cloneSkewKeysValuesTables = new HashMap<Byte, TableDesc>();
            cloneSkewKeysValuesTables.putAll(this.getSkewKeysValuesTables());
            ret.setSkewKeysValuesTables(cloneSkewKeysValuesTables);
        }
        if (this.getOutputColumnNames() != null) {
            ArrayList<String> cloneOutputColumnNames = new ArrayList<String>();
            cloneOutputColumnNames.addAll(this.getOutputColumnNames());
            ret.setOutputColumnNames(cloneOutputColumnNames);
        }
        if (this.getReversedExprs() != null) {
            HashMap<String, Byte> cloneReversedExprs = new HashMap<String, Byte>();
            cloneReversedExprs.putAll(this.getReversedExprs());
            ret.setReversedExprs(cloneReversedExprs);
        }
        return ret;
    }

    public JoinDesc(Map<Byte, List<ExprNodeDesc>> exprs, List<String> outputColumnNames, boolean noOuterJoin, JoinCondDesc[] conds) {
        this(exprs, outputColumnNames, noOuterJoin, conds, null);
    }

    public JoinDesc(Map<Byte, List<ExprNodeDesc>> exprs, List<String> outputColumnNames) {
        this(exprs, outputColumnNames, true, null);
    }

    public JoinDesc(Map<Byte, List<ExprNodeDesc>> exprs, List<String> outputColumnNames, JoinCondDesc[] conds) {
        this(exprs, outputColumnNames, true, conds, null);
    }

    public JoinDesc(JoinDesc clone) {
        this.bigKeysDirMap = clone.bigKeysDirMap;
        this.conds = clone.conds;
        this.exprs = clone.exprs;
        this.nullsafes = clone.nullsafes;
        this.handleSkewJoin = clone.handleSkewJoin;
        this.keyTableDesc = clone.keyTableDesc;
        this.noOuterJoin = clone.noOuterJoin;
        this.outputColumnNames = clone.outputColumnNames;
        this.reversedExprs = clone.reversedExprs;
        this.skewKeyDefinition = clone.skewKeyDefinition;
        this.skewKeysValuesTables = clone.skewKeysValuesTables;
        this.smallKeysDirMap = clone.smallKeysDirMap;
        this.tagOrder = clone.tagOrder;
        this.filters = clone.filters;
        this.filterMap = clone.filterMap;
    }

    public Map<Byte, List<ExprNodeDesc>> getExprs() {
        return this.exprs;
    }

    public Map<String, Byte> getReversedExprs() {
        return this.reversedExprs;
    }

    public void setReversedExprs(Map<String, Byte> reversedExprs) {
        this.reversedExprs = reversedExprs;
    }

    @Explain(displayName="condition expressions")
    public Map<Byte, String> getExprsStringMap() {
        if (this.getExprs() == null) {
            return null;
        }
        LinkedHashMap<Byte, String> ret = new LinkedHashMap<Byte, String>();
        for (Map.Entry<Byte, List<ExprNodeDesc>> ent : this.getExprs().entrySet()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            if (ent.getValue() != null) {
                for (ExprNodeDesc expr : ent.getValue()) {
                    if (!first) {
                        sb.append(" ");
                    }
                    first = false;
                    sb.append("{");
                    sb.append(expr.getExprString());
                    sb.append("}");
                }
            }
            ret.put(ent.getKey(), sb.toString());
        }
        return ret;
    }

    public void setExprs(Map<Byte, List<ExprNodeDesc>> exprs) {
        this.exprs = exprs;
    }

    @Explain(displayName="filter predicates")
    public Map<Byte, String> getFiltersStringMap() {
        if (this.getFilters() == null || this.getFilters().size() == 0) {
            return null;
        }
        LinkedHashMap<Byte, String> ret = new LinkedHashMap<Byte, String>();
        boolean filtersPresent = false;
        for (Map.Entry<Byte, List<ExprNodeDesc>> ent : this.getFilters().entrySet()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            if (ent.getValue() != null) {
                if (ent.getValue().size() != 0) {
                    filtersPresent = true;
                }
                for (ExprNodeDesc expr : ent.getValue()) {
                    if (!first) {
                        sb.append(" ");
                    }
                    first = false;
                    sb.append("{");
                    sb.append(expr.getExprString());
                    sb.append("}");
                }
            }
            ret.put(ent.getKey(), sb.toString());
        }
        if (filtersPresent) {
            return ret;
        }
        return null;
    }

    public Map<Byte, List<ExprNodeDesc>> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<Byte, List<ExprNodeDesc>> filters) {
        this.filters = filters;
    }

    @Explain(displayName="outputColumnNames")
    public List<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    public void setOutputColumnNames(List<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    public boolean getNoOuterJoin() {
        return this.noOuterJoin;
    }

    public void setNoOuterJoin(boolean noOuterJoin) {
        this.noOuterJoin = noOuterJoin;
    }

    @Explain(displayName="condition map")
    public List<JoinCondDesc> getCondsList() {
        if (this.conds == null) {
            return null;
        }
        ArrayList<JoinCondDesc> l = new ArrayList<JoinCondDesc>();
        for (JoinCondDesc cond : this.conds) {
            l.add(cond);
        }
        return l;
    }

    public JoinCondDesc[] getConds() {
        return this.conds;
    }

    public void setConds(JoinCondDesc[] conds) {
        this.conds = conds;
    }

    public Byte[] getTagOrder() {
        return this.tagOrder;
    }

    public void setTagOrder(Byte[] tagOrder) {
        this.tagOrder = tagOrder;
    }

    @Explain(displayName="handleSkewJoin")
    public boolean getHandleSkewJoin() {
        return this.handleSkewJoin;
    }

    public void setHandleSkewJoin(boolean handleSkewJoin) {
        this.handleSkewJoin = handleSkewJoin;
    }

    public Map<Byte, String> getBigKeysDirMap() {
        return this.bigKeysDirMap;
    }

    public void setBigKeysDirMap(Map<Byte, String> bigKeysDirMap) {
        this.bigKeysDirMap = bigKeysDirMap;
    }

    public Map<Byte, Map<Byte, String>> getSmallKeysDirMap() {
        return this.smallKeysDirMap;
    }

    public void setSmallKeysDirMap(Map<Byte, Map<Byte, String>> smallKeysDirMap) {
        this.smallKeysDirMap = smallKeysDirMap;
    }

    public int getSkewKeyDefinition() {
        return this.skewKeyDefinition;
    }

    public void setSkewKeyDefinition(int skewKeyDefinition) {
        this.skewKeyDefinition = skewKeyDefinition;
    }

    public Map<Byte, TableDesc> getSkewKeysValuesTables() {
        return this.skewKeysValuesTables;
    }

    public void setSkewKeysValuesTables(Map<Byte, TableDesc> skewKeysValuesTables) {
        this.skewKeysValuesTables = skewKeysValuesTables;
    }

    public boolean isNoOuterJoin() {
        return this.noOuterJoin;
    }

    public void setKeyTableDesc(TableDesc keyTblDesc) {
        this.keyTableDesc = keyTblDesc;
    }

    public TableDesc getKeyTableDesc() {
        return this.keyTableDesc;
    }

    public boolean[] getNullSafes() {
        return this.nullsafes;
    }

    public void setNullSafes(boolean[] nullSafes) {
        this.nullsafes = nullSafes;
    }

    @Explain(displayName="nullSafes")
    public String getNullSafeString() {
        if (this.nullsafes == null) {
            return null;
        }
        boolean hasNS = false;
        for (boolean ns : this.nullsafes) {
            hasNS |= ns;
        }
        return hasNS ? Arrays.toString(this.nullsafes) : null;
    }

    public int[][] getFilterMap() {
        return this.filterMap;
    }

    public void setFilterMap(int[][] filterMap) {
        this.filterMap = filterMap;
    }

    @Explain(displayName="filter mappings", normalExplain=false)
    public Map<Integer, String> getFilterMapString() {
        return this.toCompactString(this.filterMap);
    }

    protected Map<Integer, String> toCompactString(int[][] filterMap) {
        if (filterMap == null) {
            return null;
        }
        filterMap = this.compactFilter(filterMap);
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < filterMap.length; ++i) {
            if (filterMap[i] == null) continue;
            result.put(i, Arrays.toString(filterMap[i]));
        }
        return result.isEmpty() ? null : result;
    }

    private int[][] compactFilter(int[][] filterMap) {
        if (filterMap == null) {
            return null;
        }
        for (int i = 0; i < filterMap.length; ++i) {
            if (filterMap[i] == null) continue;
            boolean noFilter = true;
            for (int j = 1; j < filterMap[i].length; j += 2) {
                if (filterMap[i][j] <= 0) continue;
                noFilter = false;
                break;
            }
            if (!noFilter) continue;
            filterMap[i] = null;
        }
        for (int[] mapping : filterMap) {
            if (mapping == null) continue;
            return filterMap;
        }
        return null;
    }

    public int getTagLength() {
        int tagLength = -1;
        for (byte tag : this.getExprs().keySet()) {
            tagLength = Math.max(tagLength, tag + 1);
        }
        return tagLength;
    }

    public <T> T[] convertToArray(Map<Byte, T> source, Class<T> compType) {
        Object[] result = (Object[])Array.newInstance(compType, this.getTagLength());
        for (Map.Entry<Byte, T> entry : source.entrySet()) {
            result[entry.getKey().byteValue()] = entry.getValue();
        }
        return result;
    }

    public boolean isFixedAsSorted() {
        return this.fixedAsSorted;
    }

    public void setFixedAsSorted(boolean fixedAsSorted) {
        this.fixedAsSorted = fixedAsSorted;
    }
}

