/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ValidationUtility;

@Explain(displayName="Alter Table")
public class AlterTableDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    AlterTableTypes op;
    String oldName;
    String newName;
    ArrayList<FieldSchema> newCols;
    String serdeName;
    HashMap<String, String> props;
    String inputFormat;
    String outputFormat;
    String storageHandler;
    int numberBuckets;
    ArrayList<String> bucketColumns;
    ArrayList<Order> sortColumns;
    String oldColName;
    String newColName;
    String newColType;
    String newColComment;
    boolean first;
    String afterCol;
    boolean expectView;
    HashMap<String, String> partSpec;
    private String newLocation;
    boolean protectModeEnable;
    ProtectModeType protectModeType;
    Map<List<String>, String> skewedLocations;
    boolean isTurnOffSkewed = false;
    boolean isStoredAsSubDirectories = false;
    List<String> skewedColNames;
    List<List<String>> skewedColValues;
    Table table;
    boolean isDropIfExists = false;
    boolean isTurnOffSorting = false;

    public AlterTableDesc() {
    }

    public AlterTableDesc(String tblName, String oldColName, String newColName, String newType, String newComment, boolean first, String afterCol) {
        this.oldName = tblName;
        this.oldColName = oldColName;
        this.newColName = newColName;
        this.newColType = newType;
        this.newColComment = newComment;
        this.first = first;
        this.afterCol = afterCol;
        this.op = AlterTableTypes.RENAMECOLUMN;
    }

    public AlterTableDesc(String oldName, String newName, boolean expectView) {
        this.op = AlterTableTypes.RENAME;
        this.oldName = oldName;
        this.newName = newName;
        this.expectView = expectView;
    }

    public AlterTableDesc(String name, List<FieldSchema> newCols, AlterTableTypes alterType) {
        this.op = alterType;
        this.oldName = name;
        this.newCols = new ArrayList<FieldSchema>(newCols);
    }

    public AlterTableDesc(AlterTableTypes alterType) {
        this(alterType, false);
    }

    public AlterTableDesc(AlterTableTypes alterType, boolean expectView) {
        this.op = alterType;
        this.expectView = expectView;
    }

    public AlterTableDesc(String name, String inputFormat, String outputFormat, String serdeName, String storageHandler, HashMap<String, String> partSpec) {
        this.op = AlterTableTypes.ADDFILEFORMAT;
        this.oldName = name;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.serdeName = serdeName;
        this.storageHandler = storageHandler;
        this.partSpec = partSpec;
    }

    public AlterTableDesc(String tableName, int numBuckets, List<String> bucketCols, List<Order> sortCols, HashMap<String, String> partSpec) {
        this.oldName = tableName;
        this.op = AlterTableTypes.ADDCLUSTERSORTCOLUMN;
        this.numberBuckets = numBuckets;
        this.bucketColumns = new ArrayList<String>(bucketCols);
        this.sortColumns = new ArrayList<Order>(sortCols);
        this.partSpec = partSpec;
    }

    public AlterTableDesc(String tableName, boolean sortingOff, HashMap<String, String> partSpec) {
        this.oldName = tableName;
        this.op = AlterTableTypes.ADDCLUSTERSORTCOLUMN;
        this.isTurnOffSorting = sortingOff;
        this.partSpec = partSpec;
    }

    public AlterTableDesc(String tableName, String newLocation, HashMap<String, String> partSpec) {
        this.op = AlterTableTypes.ALTERLOCATION;
        this.oldName = tableName;
        this.newLocation = newLocation;
        this.partSpec = partSpec;
    }

    public AlterTableDesc(String tableName, Map<List<String>, String> locations, HashMap<String, String> partSpec) {
        this.op = AlterTableTypes.ALTERSKEWEDLOCATION;
        this.oldName = tableName;
        this.skewedLocations = locations;
        this.partSpec = partSpec;
    }

    public AlterTableDesc(String tableName, boolean turnOffSkewed, List<String> skewedColNames, List<List<String>> skewedColValues) {
        this.oldName = tableName;
        this.op = AlterTableTypes.ADDSKEWEDBY;
        this.isTurnOffSkewed = turnOffSkewed;
        this.skewedColNames = new ArrayList<String>(skewedColNames);
        this.skewedColValues = new ArrayList<List<String>>(skewedColValues);
    }

    public AlterTableDesc(String tableName, HashMap<String, String> partSpec, int numBuckets) {
        this.op = AlterTableTypes.ALTERBUCKETNUM;
        this.oldName = tableName;
        this.partSpec = partSpec;
        this.numberBuckets = numBuckets;
    }

    @Explain(displayName="new columns")
    public List<String> getNewColsString() {
        return Utilities.getFieldSchemaString(this.getNewCols());
    }

    @Explain(displayName="type")
    public String getAlterTableTypeString() {
        switch (this.op) {
            case RENAME: {
                return "rename";
            }
            case ADDCOLS: {
                return "add columns";
            }
            case REPLACECOLS: {
                return "replace columns";
            }
        }
        return "unknown";
    }

    @Explain(displayName="old name")
    public String getOldName() {
        return this.oldName;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    @Explain(displayName="new name")
    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public AlterTableTypes getOp() {
        return this.op;
    }

    public void setOp(AlterTableTypes op) {
        this.op = op;
    }

    public ArrayList<FieldSchema> getNewCols() {
        return this.newCols;
    }

    public void setNewCols(ArrayList<FieldSchema> newCols) {
        this.newCols = newCols;
    }

    @Explain(displayName="deserializer library")
    public String getSerdeName() {
        return this.serdeName;
    }

    public void setSerdeName(String serdeName) {
        this.serdeName = serdeName;
    }

    @Explain(displayName="properties")
    public HashMap<String, String> getProps() {
        return this.props;
    }

    public void setProps(HashMap<String, String> props) {
        this.props = props;
    }

    @Explain(displayName="input format")
    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    @Explain(displayName="output format")
    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Explain(displayName="storage handler")
    public String getStorageHandler() {
        return this.storageHandler;
    }

    public void setStorageHandler(String storageHandler) {
        this.storageHandler = storageHandler;
    }

    public int getNumberBuckets() {
        return this.numberBuckets;
    }

    public void setNumberBuckets(int numberBuckets) {
        this.numberBuckets = numberBuckets;
    }

    public ArrayList<String> getBucketColumns() {
        return this.bucketColumns;
    }

    public void setBucketColumns(ArrayList<String> bucketColumns) {
        this.bucketColumns = bucketColumns;
    }

    public ArrayList<Order> getSortColumns() {
        return this.sortColumns;
    }

    public void setSortColumns(ArrayList<Order> sortColumns) {
        this.sortColumns = sortColumns;
    }

    public String getOldColName() {
        return this.oldColName;
    }

    public void setOldColName(String oldColName) {
        this.oldColName = oldColName;
    }

    public String getNewColName() {
        return this.newColName;
    }

    public void setNewColName(String newColName) {
        this.newColName = newColName;
    }

    public String getNewColType() {
        return this.newColType;
    }

    public void setNewColType(String newType) {
        this.newColType = newType;
    }

    public String getNewColComment() {
        return this.newColComment;
    }

    public void setNewColComment(String newComment) {
        this.newColComment = newComment;
    }

    public boolean getFirst() {
        return this.first;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public String getAfterCol() {
        return this.afterCol;
    }

    public void setAfterCol(String afterCol) {
        this.afterCol = afterCol;
    }

    public boolean getExpectView() {
        return this.expectView;
    }

    public void setExpectView(boolean expectView) {
        this.expectView = expectView;
    }

    public HashMap<String, String> getPartSpec() {
        return this.partSpec;
    }

    public void setPartSpec(HashMap<String, String> partSpec) {
        this.partSpec = partSpec;
    }

    public String getNewLocation() {
        return this.newLocation;
    }

    public void setNewLocation(String newLocation) {
        this.newLocation = newLocation;
    }

    public boolean isProtectModeEnable() {
        return this.protectModeEnable;
    }

    public void setProtectModeEnable(boolean protectModeEnable) {
        this.protectModeEnable = protectModeEnable;
    }

    public ProtectModeType getProtectModeType() {
        return this.protectModeType;
    }

    public void setProtectModeType(ProtectModeType protectModeType) {
        this.protectModeType = protectModeType;
    }

    public Map<List<String>, String> getSkewedLocations() {
        return this.skewedLocations;
    }

    public void setSkewedLocations(Map<List<String>, String> skewedLocations) {
        this.skewedLocations = skewedLocations;
    }

    public boolean isTurnOffSorting() {
        return this.isTurnOffSorting;
    }

    public boolean isTurnOffSkewed() {
        return this.isTurnOffSkewed;
    }

    public void setTurnOffSkewed(boolean turnOffSkewed) {
        this.isTurnOffSkewed = turnOffSkewed;
    }

    public List<String> getSkewedColNames() {
        return this.skewedColNames;
    }

    public void setSkewedColNames(List<String> skewedColNames) {
        this.skewedColNames = skewedColNames;
    }

    public List<List<String>> getSkewedColValues() {
        return this.skewedColValues;
    }

    public void setSkewedColValues(List<List<String>> skewedColValues) {
        this.skewedColValues = skewedColValues;
    }

    public void validate() throws SemanticException {
        if (null != this.table) {
            ValidationUtility.validateSkewedInformation(ParseUtils.validateColumnNameUniqueness(this.table.getCols()), this.getSkewedColNames(), this.getSkewedColValues());
        }
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public boolean isStoredAsSubDirectories() {
        return this.isStoredAsSubDirectories;
    }

    public void setStoredAsSubDirectories(boolean isStoredAsSubDirectories) {
        this.isStoredAsSubDirectories = isStoredAsSubDirectories;
    }

    public void setDropIfExists(boolean isDropIfExists) {
        this.isDropIfExists = isDropIfExists;
    }

    public boolean getIsDropIfExists() {
        return this.isDropIfExists;
    }

    public static enum ProtectModeType {
        NO_DROP,
        OFFLINE,
        READ_ONLY,
        NO_DROP_CASCADE;

    }

    public static enum AlterTableTypes {
        RENAME,
        ADDCOLS,
        REPLACECOLS,
        ADDPROPS,
        DROPPROPS,
        ADDSERDE,
        ADDSERDEPROPS,
        ADDFILEFORMAT,
        ADDCLUSTERSORTCOLUMN,
        RENAMECOLUMN,
        ADDPARTITION,
        TOUCH,
        ARCHIVE,
        UNARCHIVE,
        ALTERPROTECTMODE,
        ALTERPARTITIONPROTECTMODE,
        ALTERLOCATION,
        DROPPARTITION,
        RENAMEPARTITION,
        ADDSKEWEDBY,
        ALTERSKEWEDLOCATION,
        ALTERBUCKETNUM,
        ALTERPARTITION;

    }
}

