/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;

@JsonPropertyOrder(value={"type"})
public abstract class LogicalExpressionBase
implements LogicalExpression {
    private final ExpressionPosition pos;

    protected LogicalExpressionBase(ExpressionPosition pos) {
        this.pos = pos;
    }

    @Override
    public ExpressionPosition getPosition() {
        return this.pos;
    }

    protected void i(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        throw new UnsupportedOperationException(String.format("The type of %s doesn't currently support LogicalExpression.getDataType().", this.getClass().getCanonicalName()));
    }

    @JsonProperty(value="type")
    public String getDescription() {
        return this.getClass().getSimpleName();
    }

    @Override
    @JsonIgnore
    public int getSelfCost() {
        throw new UnsupportedOperationException(String.format("The type of %s doesn't currently support LogicalExpression.getSelfCost().", this.getClass().getCanonicalName()));
    }

    @Override
    @JsonIgnore
    public int getCumulativeCost() {
        throw new UnsupportedOperationException(String.format("The type of %s doesn't currently support LogicalExpression.getCumulativeCost().", this.getClass().getCanonicalName()));
    }
}

