/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.drill.common.config.NestedConfig;
import org.apache.drill.common.exceptions.DrillConfigurationException;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfigBase;
import org.apache.drill.common.logical.StoragePluginConfigBase;
import org.apache.drill.common.logical.data.LogicalOperatorBase;
import org.apache.drill.common.util.PathScanner;
import org.reflections.util.ClasspathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.VM;

public final class DrillConfig
extends NestedConfig {
    static final Logger logger = LoggerFactory.getLogger(DrillConfig.class);
    private final ObjectMapper mapper;
    private final ImmutableList<String> startupArguments;
    private static final long MAX_DIRECT_MEMORY = VM.maxDirectMemory();
    private volatile List<Queue<Object>> sinkQueues = new CopyOnWriteArrayList<Queue>(new Queue[1]);

    @VisibleForTesting
    public DrillConfig(Config config, boolean enableServer) {
        super(config);
        this.mapper = new ObjectMapper();
        if (enableServer) {
            SimpleModule deserModule = new SimpleModule("LogicalExpressionDeserializationModule").addDeserializer(LogicalExpression.class, (JsonDeserializer)new LogicalExpression.De(this)).addDeserializer(SchemaPath.class, (JsonDeserializer)new SchemaPath.De(this));
            this.mapper.registerModule((Module)deserModule);
            this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
            this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            this.mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
            this.mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            this.mapper.registerSubtypes((Class[])LogicalOperatorBase.getSubTypes(this));
            this.mapper.registerSubtypes((Class[])StoragePluginConfigBase.getSubTypes(this));
            this.mapper.registerSubtypes((Class[])FormatPluginConfigBase.getSubTypes(this));
        }
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        this.startupArguments = ImmutableList.copyOf(bean.getInputArguments());
    }

    public List<String> getStartupArguments() {
        return this.startupArguments;
    }

    public static DrillConfig create() {
        return DrillConfig.create(null, true);
    }

    public static DrillConfig createClient() {
        return DrillConfig.create(null, false);
    }

    public static DrillConfig create(String overrideFileName) {
        return DrillConfig.create(overrideFileName, true);
    }

    @VisibleForTesting
    public static DrillConfig create(Properties testConfigurations) {
        return DrillConfig.create(null, testConfigurations, true);
    }

    public static DrillConfig create(String overrideFileName, boolean enableServerConfigs) {
        return DrillConfig.create(overrideFileName, null, enableServerConfigs);
    }

    private static DrillConfig create(String overrideFileName, Properties overriderProps, boolean enableServerConfigs) {
        ClassLoader[] classLoaders;
        overrideFileName = overrideFileName == null ? "drill-override.conf" : overrideFileName;
        Config fallback = null;
        for (ClassLoader classLoader : classLoaders = ClasspathHelper.classLoaders((ClassLoader[])new ClassLoader[0])) {
            if (classLoader.getResource("drill-default.conf") == null) continue;
            fallback = ConfigFactory.load((ClassLoader)classLoader, (String)"drill-default.conf");
            break;
        }
        Collection<URL> urls = PathScanner.getConfigURLs();
        logger.debug("Loading configs at the following URLs {}", urls);
        for (URL url : urls) {
            fallback = ConfigFactory.parseURL((URL)url).withFallback((ConfigMergeable)fallback);
        }
        Config effectiveConfig = ConfigFactory.load((String)overrideFileName).withFallback((ConfigMergeable)fallback);
        if (overriderProps != null) {
            effectiveConfig = ConfigFactory.parseProperties((Properties)overriderProps).withFallback((ConfigMergeable)effectiveConfig);
        }
        return new DrillConfig(effectiveConfig.resolve(), enableServerConfigs);
    }

    public <T> Class<T> getClassAt(String location, Class<T> clazz) throws DrillConfigurationException {
        String className = this.getString(location);
        if (className == null) {
            throw new DrillConfigurationException(String.format("No class defined at location '%s'.  Expected a definition of the class []", location, clazz.getCanonicalName()));
        }
        try {
            Class<?> c = Class.forName(className);
            if (clazz.isAssignableFrom(c)) {
                Class<?> t = c;
                return t;
            }
            throw new DrillConfigurationException(String.format("The class [%s] listed at location '%s' should be of type [%s].  It isn't.", className, location, clazz.getCanonicalName()));
        }
        catch (Exception ex) {
            if (ex instanceof DrillConfigurationException) {
                throw (DrillConfigurationException)ex;
            }
            throw new DrillConfigurationException(String.format("Failure while initializing class [%s] described at configuration value '%s'.", className, location), ex);
        }
    }

    public <T> T getInstanceOf(String location, Class<T> clazz) throws DrillConfigurationException {
        Class<T> c = this.getClassAt(location, clazz);
        try {
            T t = c.newInstance();
            return t;
        }
        catch (Exception ex) {
            throw new DrillConfigurationException(String.format("Failure while instantiating class [%s] located at '%s.", clazz.getCanonicalName(), location), ex);
        }
    }

    public void setSinkQueues(int number, Queue<Object> queue) {
        this.sinkQueues.set(number, queue);
    }

    public Queue<Object> getQueue(int number) {
        if (this.sinkQueues.size() <= number || number < 0 || this.sinkQueues == null) {
            throw new IllegalArgumentException(String.format("Queue %d is not available.", number));
        }
        return this.sinkQueues.get(number);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public String toString() {
        return this.root().render();
    }

    public static void main(String[] args) throws Exception {
        DrillConfig config = DrillConfig.create();
    }

    public static long getMaxDirectMemory() {
        return MAX_DIRECT_MEMORY;
    }
}

