/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.proto;

import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;
import java.io.IOException;
import java.util.HashMap;
import org.apache.drill.common.types.SchemaTypeProtos;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.SchemaCoordinationProtos;
import org.apache.drill.exec.proto.UserBitShared;

public final class SchemaUserBitShared {

    public static final class MetricValue {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "metricId";
                }
                case 2: {
                    return "longValue";
                }
                case 3: {
                    return "doubleValue";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("metricId", 1);
            fieldMap.put("longValue", 2);
            fieldMap.put("doubleValue", 3);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.MetricValue.Builder> {
            public void mergeFrom(Input input, UserBitShared.MetricValue.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setMetricId(input.readInt32());
                            break;
                        }
                        case 2: {
                            builder.setLongValue(input.readInt64());
                            break;
                        }
                        case 3: {
                            builder.setDoubleValue(input.readDouble());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.MetricValue.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.MetricValue.Builder newMessage() {
                return UserBitShared.MetricValue.newBuilder();
            }

            public String getFieldName(int number) {
                return MetricValue.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return MetricValue.getFieldNumber(name);
            }

            public Class<UserBitShared.MetricValue.Builder> typeClass() {
                return UserBitShared.MetricValue.Builder.class;
            }

            public String messageName() {
                return UserBitShared.MetricValue.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.MetricValue.class.getName();
            }

            public void writeTo(Output output, UserBitShared.MetricValue.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.MetricValue> {
            public void writeTo(Output output, UserBitShared.MetricValue message) throws IOException {
                if (message.hasMetricId()) {
                    output.writeInt32(1, message.getMetricId(), false);
                }
                if (message.hasLongValue()) {
                    output.writeInt64(2, message.getLongValue(), false);
                }
                if (message.hasDoubleValue()) {
                    output.writeDouble(3, message.getDoubleValue(), false);
                }
            }

            public boolean isInitialized(UserBitShared.MetricValue message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return MetricValue.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return MetricValue.getFieldNumber(name);
            }

            public Class<UserBitShared.MetricValue> typeClass() {
                return UserBitShared.MetricValue.class;
            }

            public String messageName() {
                return UserBitShared.MetricValue.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.MetricValue.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.MetricValue message) throws IOException {
            }

            public UserBitShared.MetricValue newMessage() {
                return null;
            }
        }
    }

    public static final class StreamProfile {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "records";
                }
                case 2: {
                    return "batches";
                }
                case 3: {
                    return "schemas";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("records", 1);
            fieldMap.put("batches", 2);
            fieldMap.put("schemas", 3);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.StreamProfile.Builder> {
            public void mergeFrom(Input input, UserBitShared.StreamProfile.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setRecords(input.readInt64());
                            break;
                        }
                        case 2: {
                            builder.setBatches(input.readInt64());
                            break;
                        }
                        case 3: {
                            builder.setSchemas(input.readInt64());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.StreamProfile.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.StreamProfile.Builder newMessage() {
                return UserBitShared.StreamProfile.newBuilder();
            }

            public String getFieldName(int number) {
                return StreamProfile.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return StreamProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.StreamProfile.Builder> typeClass() {
                return UserBitShared.StreamProfile.Builder.class;
            }

            public String messageName() {
                return UserBitShared.StreamProfile.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.StreamProfile.class.getName();
            }

            public void writeTo(Output output, UserBitShared.StreamProfile.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.StreamProfile> {
            public void writeTo(Output output, UserBitShared.StreamProfile message) throws IOException {
                if (message.hasRecords()) {
                    output.writeInt64(1, message.getRecords(), false);
                }
                if (message.hasBatches()) {
                    output.writeInt64(2, message.getBatches(), false);
                }
                if (message.hasSchemas()) {
                    output.writeInt64(3, message.getSchemas(), false);
                }
            }

            public boolean isInitialized(UserBitShared.StreamProfile message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return StreamProfile.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return StreamProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.StreamProfile> typeClass() {
                return UserBitShared.StreamProfile.class;
            }

            public String messageName() {
                return UserBitShared.StreamProfile.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.StreamProfile.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.StreamProfile message) throws IOException {
            }

            public UserBitShared.StreamProfile newMessage() {
                return null;
            }
        }
    }

    public static final class OperatorProfile {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "inputProfile";
                }
                case 3: {
                    return "operatorId";
                }
                case 4: {
                    return "operatorType";
                }
                case 5: {
                    return "setupNanos";
                }
                case 6: {
                    return "processNanos";
                }
                case 7: {
                    return "localMemoryAllocated";
                }
                case 8: {
                    return "metric";
                }
                case 9: {
                    return "waitNanos";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("inputProfile", 1);
            fieldMap.put("operatorId", 3);
            fieldMap.put("operatorType", 4);
            fieldMap.put("setupNanos", 5);
            fieldMap.put("processNanos", 6);
            fieldMap.put("localMemoryAllocated", 7);
            fieldMap.put("metric", 8);
            fieldMap.put("waitNanos", 9);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.OperatorProfile.Builder> {
            public void mergeFrom(Input input, UserBitShared.OperatorProfile.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.addInputProfile((UserBitShared.StreamProfile.Builder)input.mergeObject((Object)UserBitShared.StreamProfile.newBuilder(), (Schema)StreamProfile.MERGE));
                            break;
                        }
                        case 3: {
                            builder.setOperatorId(input.readInt32());
                            break;
                        }
                        case 4: {
                            builder.setOperatorType(input.readInt32());
                            break;
                        }
                        case 5: {
                            builder.setSetupNanos(input.readInt64());
                            break;
                        }
                        case 6: {
                            builder.setProcessNanos(input.readInt64());
                            break;
                        }
                        case 7: {
                            builder.setLocalMemoryAllocated(input.readInt64());
                            break;
                        }
                        case 8: {
                            builder.addMetric((UserBitShared.MetricValue.Builder)input.mergeObject((Object)UserBitShared.MetricValue.newBuilder(), (Schema)MetricValue.MERGE));
                            break;
                        }
                        case 9: {
                            builder.setWaitNanos(input.readInt64());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.OperatorProfile.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.OperatorProfile.Builder newMessage() {
                return UserBitShared.OperatorProfile.newBuilder();
            }

            public String getFieldName(int number) {
                return OperatorProfile.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return OperatorProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.OperatorProfile.Builder> typeClass() {
                return UserBitShared.OperatorProfile.Builder.class;
            }

            public String messageName() {
                return UserBitShared.OperatorProfile.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.OperatorProfile.class.getName();
            }

            public void writeTo(Output output, UserBitShared.OperatorProfile.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.OperatorProfile> {
            public void writeTo(Output output, UserBitShared.OperatorProfile message) throws IOException {
                for (UserBitShared.StreamProfile inputProfile : message.getInputProfileList()) {
                    output.writeObject(1, (Object)inputProfile, (Schema)StreamProfile.WRITE, true);
                }
                if (message.hasOperatorId()) {
                    output.writeInt32(3, message.getOperatorId(), false);
                }
                if (message.hasOperatorType()) {
                    output.writeInt32(4, message.getOperatorType(), false);
                }
                if (message.hasSetupNanos()) {
                    output.writeInt64(5, message.getSetupNanos(), false);
                }
                if (message.hasProcessNanos()) {
                    output.writeInt64(6, message.getProcessNanos(), false);
                }
                if (message.hasLocalMemoryAllocated()) {
                    output.writeInt64(7, message.getLocalMemoryAllocated(), false);
                }
                for (UserBitShared.MetricValue metric : message.getMetricList()) {
                    output.writeObject(8, (Object)metric, (Schema)MetricValue.WRITE, true);
                }
                if (message.hasWaitNanos()) {
                    output.writeInt64(9, message.getWaitNanos(), false);
                }
            }

            public boolean isInitialized(UserBitShared.OperatorProfile message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return OperatorProfile.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return OperatorProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.OperatorProfile> typeClass() {
                return UserBitShared.OperatorProfile.class;
            }

            public String messageName() {
                return UserBitShared.OperatorProfile.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.OperatorProfile.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.OperatorProfile message) throws IOException {
            }

            public UserBitShared.OperatorProfile newMessage() {
                return null;
            }
        }
    }

    public static final class MinorFragmentProfile {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "state";
                }
                case 2: {
                    return "error";
                }
                case 3: {
                    return "minorFragmentId";
                }
                case 4: {
                    return "operatorProfile";
                }
                case 5: {
                    return "startTime";
                }
                case 6: {
                    return "endTime";
                }
                case 7: {
                    return "memoryUsed";
                }
                case 8: {
                    return "maxMemoryUsed";
                }
                case 9: {
                    return "endpoint";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("state", 1);
            fieldMap.put("error", 2);
            fieldMap.put("minorFragmentId", 3);
            fieldMap.put("operatorProfile", 4);
            fieldMap.put("startTime", 5);
            fieldMap.put("endTime", 6);
            fieldMap.put("memoryUsed", 7);
            fieldMap.put("maxMemoryUsed", 8);
            fieldMap.put("endpoint", 9);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.MinorFragmentProfile.Builder> {
            public void mergeFrom(Input input, UserBitShared.MinorFragmentProfile.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setState(UserBitShared.FragmentState.valueOf(input.readEnum()));
                            break;
                        }
                        case 2: {
                            builder.setError((UserBitShared.DrillPBError.Builder)input.mergeObject((Object)UserBitShared.DrillPBError.newBuilder(), (Schema)DrillPBError.MERGE));
                            break;
                        }
                        case 3: {
                            builder.setMinorFragmentId(input.readInt32());
                            break;
                        }
                        case 4: {
                            builder.addOperatorProfile((UserBitShared.OperatorProfile.Builder)input.mergeObject((Object)UserBitShared.OperatorProfile.newBuilder(), (Schema)OperatorProfile.MERGE));
                            break;
                        }
                        case 5: {
                            builder.setStartTime(input.readInt64());
                            break;
                        }
                        case 6: {
                            builder.setEndTime(input.readInt64());
                            break;
                        }
                        case 7: {
                            builder.setMemoryUsed(input.readInt64());
                            break;
                        }
                        case 8: {
                            builder.setMaxMemoryUsed(input.readInt64());
                            break;
                        }
                        case 9: {
                            builder.setEndpoint((CoordinationProtos.DrillbitEndpoint.Builder)input.mergeObject((Object)CoordinationProtos.DrillbitEndpoint.newBuilder(), (Schema)SchemaCoordinationProtos.DrillbitEndpoint.MERGE));
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.MinorFragmentProfile.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.MinorFragmentProfile.Builder newMessage() {
                return UserBitShared.MinorFragmentProfile.newBuilder();
            }

            public String getFieldName(int number) {
                return MinorFragmentProfile.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return MinorFragmentProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.MinorFragmentProfile.Builder> typeClass() {
                return UserBitShared.MinorFragmentProfile.Builder.class;
            }

            public String messageName() {
                return UserBitShared.MinorFragmentProfile.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.MinorFragmentProfile.class.getName();
            }

            public void writeTo(Output output, UserBitShared.MinorFragmentProfile.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.MinorFragmentProfile> {
            public void writeTo(Output output, UserBitShared.MinorFragmentProfile message) throws IOException {
                if (message.hasState()) {
                    output.writeEnum(1, message.getState().getNumber(), false);
                }
                if (message.hasError()) {
                    output.writeObject(2, (Object)message.getError(), (Schema)DrillPBError.WRITE, false);
                }
                if (message.hasMinorFragmentId()) {
                    output.writeInt32(3, message.getMinorFragmentId(), false);
                }
                for (UserBitShared.OperatorProfile operatorProfile : message.getOperatorProfileList()) {
                    output.writeObject(4, (Object)operatorProfile, (Schema)OperatorProfile.WRITE, true);
                }
                if (message.hasStartTime()) {
                    output.writeInt64(5, message.getStartTime(), false);
                }
                if (message.hasEndTime()) {
                    output.writeInt64(6, message.getEndTime(), false);
                }
                if (message.hasMemoryUsed()) {
                    output.writeInt64(7, message.getMemoryUsed(), false);
                }
                if (message.hasMaxMemoryUsed()) {
                    output.writeInt64(8, message.getMaxMemoryUsed(), false);
                }
                if (message.hasEndpoint()) {
                    output.writeObject(9, (Object)message.getEndpoint(), (Schema)SchemaCoordinationProtos.DrillbitEndpoint.WRITE, false);
                }
            }

            public boolean isInitialized(UserBitShared.MinorFragmentProfile message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return MinorFragmentProfile.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return MinorFragmentProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.MinorFragmentProfile> typeClass() {
                return UserBitShared.MinorFragmentProfile.class;
            }

            public String messageName() {
                return UserBitShared.MinorFragmentProfile.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.MinorFragmentProfile.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.MinorFragmentProfile message) throws IOException {
            }

            public UserBitShared.MinorFragmentProfile newMessage() {
                return null;
            }
        }
    }

    public static final class MajorFragmentProfile {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "majorFragmentId";
                }
                case 2: {
                    return "minorFragmentProfile";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("majorFragmentId", 1);
            fieldMap.put("minorFragmentProfile", 2);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.MajorFragmentProfile.Builder> {
            public void mergeFrom(Input input, UserBitShared.MajorFragmentProfile.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setMajorFragmentId(input.readInt32());
                            break;
                        }
                        case 2: {
                            builder.addMinorFragmentProfile((UserBitShared.MinorFragmentProfile.Builder)input.mergeObject((Object)UserBitShared.MinorFragmentProfile.newBuilder(), (Schema)MinorFragmentProfile.MERGE));
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.MajorFragmentProfile.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.MajorFragmentProfile.Builder newMessage() {
                return UserBitShared.MajorFragmentProfile.newBuilder();
            }

            public String getFieldName(int number) {
                return MajorFragmentProfile.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return MajorFragmentProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.MajorFragmentProfile.Builder> typeClass() {
                return UserBitShared.MajorFragmentProfile.Builder.class;
            }

            public String messageName() {
                return UserBitShared.MajorFragmentProfile.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.MajorFragmentProfile.class.getName();
            }

            public void writeTo(Output output, UserBitShared.MajorFragmentProfile.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.MajorFragmentProfile> {
            public void writeTo(Output output, UserBitShared.MajorFragmentProfile message) throws IOException {
                if (message.hasMajorFragmentId()) {
                    output.writeInt32(1, message.getMajorFragmentId(), false);
                }
                for (UserBitShared.MinorFragmentProfile minorFragmentProfile : message.getMinorFragmentProfileList()) {
                    output.writeObject(2, (Object)minorFragmentProfile, (Schema)MinorFragmentProfile.WRITE, true);
                }
            }

            public boolean isInitialized(UserBitShared.MajorFragmentProfile message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return MajorFragmentProfile.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return MajorFragmentProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.MajorFragmentProfile> typeClass() {
                return UserBitShared.MajorFragmentProfile.class;
            }

            public String messageName() {
                return UserBitShared.MajorFragmentProfile.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.MajorFragmentProfile.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.MajorFragmentProfile message) throws IOException {
            }

            public UserBitShared.MajorFragmentProfile newMessage() {
                return null;
            }
        }
    }

    public static final class QueryProfile {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "id";
                }
                case 2: {
                    return "type";
                }
                case 3: {
                    return "start";
                }
                case 4: {
                    return "end";
                }
                case 5: {
                    return "query";
                }
                case 6: {
                    return "plan";
                }
                case 7: {
                    return "foreman";
                }
                case 8: {
                    return "state";
                }
                case 9: {
                    return "totalFragments";
                }
                case 10: {
                    return "finishedFragments";
                }
                case 11: {
                    return "fragmentProfile";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("id", 1);
            fieldMap.put("type", 2);
            fieldMap.put("start", 3);
            fieldMap.put("end", 4);
            fieldMap.put("query", 5);
            fieldMap.put("plan", 6);
            fieldMap.put("foreman", 7);
            fieldMap.put("state", 8);
            fieldMap.put("totalFragments", 9);
            fieldMap.put("finishedFragments", 10);
            fieldMap.put("fragmentProfile", 11);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.QueryProfile.Builder> {
            public void mergeFrom(Input input, UserBitShared.QueryProfile.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setId((UserBitShared.QueryId.Builder)input.mergeObject((Object)UserBitShared.QueryId.newBuilder(), (Schema)QueryId.MERGE));
                            break;
                        }
                        case 2: {
                            builder.setType(UserBitShared.QueryType.valueOf(input.readEnum()));
                            break;
                        }
                        case 3: {
                            builder.setStart(input.readInt64());
                            break;
                        }
                        case 4: {
                            builder.setEnd(input.readInt64());
                            break;
                        }
                        case 5: {
                            builder.setQuery(input.readString());
                            break;
                        }
                        case 6: {
                            builder.setPlan(input.readString());
                            break;
                        }
                        case 7: {
                            builder.setForeman((CoordinationProtos.DrillbitEndpoint.Builder)input.mergeObject((Object)CoordinationProtos.DrillbitEndpoint.newBuilder(), (Schema)SchemaCoordinationProtos.DrillbitEndpoint.MERGE));
                            break;
                        }
                        case 8: {
                            builder.setState(UserBitShared.QueryResult.QueryState.valueOf(input.readEnum()));
                            break;
                        }
                        case 9: {
                            builder.setTotalFragments(input.readInt32());
                            break;
                        }
                        case 10: {
                            builder.setFinishedFragments(input.readInt32());
                            break;
                        }
                        case 11: {
                            builder.addFragmentProfile((UserBitShared.MajorFragmentProfile.Builder)input.mergeObject((Object)UserBitShared.MajorFragmentProfile.newBuilder(), (Schema)MajorFragmentProfile.MERGE));
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.QueryProfile.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.QueryProfile.Builder newMessage() {
                return UserBitShared.QueryProfile.newBuilder();
            }

            public String getFieldName(int number) {
                return QueryProfile.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return QueryProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.QueryProfile.Builder> typeClass() {
                return UserBitShared.QueryProfile.Builder.class;
            }

            public String messageName() {
                return UserBitShared.QueryProfile.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.QueryProfile.class.getName();
            }

            public void writeTo(Output output, UserBitShared.QueryProfile.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.QueryProfile> {
            public void writeTo(Output output, UserBitShared.QueryProfile message) throws IOException {
                if (message.hasId()) {
                    output.writeObject(1, (Object)message.getId(), (Schema)QueryId.WRITE, false);
                }
                if (message.hasType()) {
                    output.writeEnum(2, message.getType().getNumber(), false);
                }
                if (message.hasStart()) {
                    output.writeInt64(3, message.getStart(), false);
                }
                if (message.hasEnd()) {
                    output.writeInt64(4, message.getEnd(), false);
                }
                if (message.hasQuery()) {
                    output.writeString(5, message.getQuery(), false);
                }
                if (message.hasPlan()) {
                    output.writeString(6, message.getPlan(), false);
                }
                if (message.hasForeman()) {
                    output.writeObject(7, (Object)message.getForeman(), (Schema)SchemaCoordinationProtos.DrillbitEndpoint.WRITE, false);
                }
                if (message.hasState()) {
                    output.writeEnum(8, message.getState().getNumber(), false);
                }
                if (message.hasTotalFragments()) {
                    output.writeInt32(9, message.getTotalFragments(), false);
                }
                if (message.hasFinishedFragments()) {
                    output.writeInt32(10, message.getFinishedFragments(), false);
                }
                for (UserBitShared.MajorFragmentProfile fragmentProfile : message.getFragmentProfileList()) {
                    output.writeObject(11, (Object)fragmentProfile, (Schema)MajorFragmentProfile.WRITE, true);
                }
            }

            public boolean isInitialized(UserBitShared.QueryProfile message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return QueryProfile.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return QueryProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.QueryProfile> typeClass() {
                return UserBitShared.QueryProfile.class;
            }

            public String messageName() {
                return UserBitShared.QueryProfile.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.QueryProfile.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.QueryProfile message) throws IOException {
            }

            public UserBitShared.QueryProfile newMessage() {
                return null;
            }
        }
    }

    public static final class QueryInfo {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "query";
                }
                case 2: {
                    return "start";
                }
                case 3: {
                    return "state";
                }
                case 4: {
                    return "user";
                }
                case 5: {
                    return "foreman";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("query", 1);
            fieldMap.put("start", 2);
            fieldMap.put("state", 3);
            fieldMap.put("user", 4);
            fieldMap.put("foreman", 5);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.QueryInfo.Builder> {
            public void mergeFrom(Input input, UserBitShared.QueryInfo.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setQuery(input.readString());
                            break;
                        }
                        case 2: {
                            builder.setStart(input.readInt64());
                            break;
                        }
                        case 3: {
                            builder.setState(UserBitShared.QueryResult.QueryState.valueOf(input.readEnum()));
                            break;
                        }
                        case 4: {
                            builder.setUser(input.readString());
                            break;
                        }
                        case 5: {
                            builder.setForeman((CoordinationProtos.DrillbitEndpoint.Builder)input.mergeObject((Object)CoordinationProtos.DrillbitEndpoint.newBuilder(), (Schema)SchemaCoordinationProtos.DrillbitEndpoint.MERGE));
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.QueryInfo.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.QueryInfo.Builder newMessage() {
                return UserBitShared.QueryInfo.newBuilder();
            }

            public String getFieldName(int number) {
                return QueryInfo.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return QueryInfo.getFieldNumber(name);
            }

            public Class<UserBitShared.QueryInfo.Builder> typeClass() {
                return UserBitShared.QueryInfo.Builder.class;
            }

            public String messageName() {
                return UserBitShared.QueryInfo.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.QueryInfo.class.getName();
            }

            public void writeTo(Output output, UserBitShared.QueryInfo.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.QueryInfo> {
            public void writeTo(Output output, UserBitShared.QueryInfo message) throws IOException {
                if (message.hasQuery()) {
                    output.writeString(1, message.getQuery(), false);
                }
                if (message.hasStart()) {
                    output.writeInt64(2, message.getStart(), false);
                }
                if (message.hasState()) {
                    output.writeEnum(3, message.getState().getNumber(), false);
                }
                if (message.hasUser()) {
                    output.writeString(4, message.getUser(), false);
                }
                if (message.hasForeman()) {
                    output.writeObject(5, (Object)message.getForeman(), (Schema)SchemaCoordinationProtos.DrillbitEndpoint.WRITE, false);
                }
            }

            public boolean isInitialized(UserBitShared.QueryInfo message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return QueryInfo.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return QueryInfo.getFieldNumber(name);
            }

            public Class<UserBitShared.QueryInfo> typeClass() {
                return UserBitShared.QueryInfo.class;
            }

            public String messageName() {
                return UserBitShared.QueryInfo.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.QueryInfo.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.QueryInfo message) throws IOException {
            }

            public UserBitShared.QueryInfo newMessage() {
                return null;
            }
        }
    }

    public static final class QueryResult {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "queryState";
                }
                case 2: {
                    return "queryId";
                }
                case 3: {
                    return "isLastChunk";
                }
                case 4: {
                    return "rowCount";
                }
                case 5: {
                    return "recordsScan";
                }
                case 6: {
                    return "recordsError";
                }
                case 7: {
                    return "submissionTime";
                }
                case 8: {
                    return "nodeStatus";
                }
                case 9: {
                    return "error";
                }
                case 10: {
                    return "def";
                }
                case 11: {
                    return "schemaChanged";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("queryState", 1);
            fieldMap.put("queryId", 2);
            fieldMap.put("isLastChunk", 3);
            fieldMap.put("rowCount", 4);
            fieldMap.put("recordsScan", 5);
            fieldMap.put("recordsError", 6);
            fieldMap.put("submissionTime", 7);
            fieldMap.put("nodeStatus", 8);
            fieldMap.put("error", 9);
            fieldMap.put("def", 10);
            fieldMap.put("schemaChanged", 11);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.QueryResult.Builder> {
            public void mergeFrom(Input input, UserBitShared.QueryResult.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setQueryState(UserBitShared.QueryResult.QueryState.valueOf(input.readEnum()));
                            break;
                        }
                        case 2: {
                            builder.setQueryId((UserBitShared.QueryId.Builder)input.mergeObject((Object)UserBitShared.QueryId.newBuilder(), (Schema)QueryId.MERGE));
                            break;
                        }
                        case 3: {
                            builder.setIsLastChunk(input.readBool());
                            break;
                        }
                        case 4: {
                            builder.setRowCount(input.readInt32());
                            break;
                        }
                        case 5: {
                            builder.setRecordsScan(input.readInt64());
                            break;
                        }
                        case 6: {
                            builder.setRecordsError(input.readInt64());
                            break;
                        }
                        case 7: {
                            builder.setSubmissionTime(input.readInt64());
                            break;
                        }
                        case 8: {
                            builder.addNodeStatus((UserBitShared.NodeStatus.Builder)input.mergeObject((Object)UserBitShared.NodeStatus.newBuilder(), (Schema)NodeStatus.MERGE));
                            break;
                        }
                        case 9: {
                            builder.addError((UserBitShared.DrillPBError.Builder)input.mergeObject((Object)UserBitShared.DrillPBError.newBuilder(), (Schema)DrillPBError.MERGE));
                            break;
                        }
                        case 10: {
                            builder.setDef((UserBitShared.RecordBatchDef.Builder)input.mergeObject((Object)UserBitShared.RecordBatchDef.newBuilder(), (Schema)RecordBatchDef.MERGE));
                            break;
                        }
                        case 11: {
                            builder.setSchemaChanged(input.readBool());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.QueryResult.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.QueryResult.Builder newMessage() {
                return UserBitShared.QueryResult.newBuilder();
            }

            public String getFieldName(int number) {
                return QueryResult.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return QueryResult.getFieldNumber(name);
            }

            public Class<UserBitShared.QueryResult.Builder> typeClass() {
                return UserBitShared.QueryResult.Builder.class;
            }

            public String messageName() {
                return UserBitShared.QueryResult.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.QueryResult.class.getName();
            }

            public void writeTo(Output output, UserBitShared.QueryResult.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.QueryResult> {
            public void writeTo(Output output, UserBitShared.QueryResult message) throws IOException {
                if (message.hasQueryState()) {
                    output.writeEnum(1, message.getQueryState().getNumber(), false);
                }
                if (message.hasQueryId()) {
                    output.writeObject(2, (Object)message.getQueryId(), (Schema)QueryId.WRITE, false);
                }
                if (message.hasIsLastChunk()) {
                    output.writeBool(3, message.getIsLastChunk(), false);
                }
                if (message.hasRowCount()) {
                    output.writeInt32(4, message.getRowCount(), false);
                }
                if (message.hasRecordsScan()) {
                    output.writeInt64(5, message.getRecordsScan(), false);
                }
                if (message.hasRecordsError()) {
                    output.writeInt64(6, message.getRecordsError(), false);
                }
                if (message.hasSubmissionTime()) {
                    output.writeInt64(7, message.getSubmissionTime(), false);
                }
                for (UserBitShared.NodeStatus nodeStatus : message.getNodeStatusList()) {
                    output.writeObject(8, (Object)nodeStatus, (Schema)NodeStatus.WRITE, true);
                }
                for (UserBitShared.DrillPBError error : message.getErrorList()) {
                    output.writeObject(9, (Object)error, (Schema)DrillPBError.WRITE, true);
                }
                if (message.hasDef()) {
                    output.writeObject(10, (Object)message.getDef(), (Schema)RecordBatchDef.WRITE, false);
                }
                if (message.hasSchemaChanged()) {
                    output.writeBool(11, message.getSchemaChanged(), false);
                }
            }

            public boolean isInitialized(UserBitShared.QueryResult message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return QueryResult.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return QueryResult.getFieldNumber(name);
            }

            public Class<UserBitShared.QueryResult> typeClass() {
                return UserBitShared.QueryResult.class;
            }

            public String messageName() {
                return UserBitShared.QueryResult.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.QueryResult.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.QueryResult message) throws IOException {
            }

            public UserBitShared.QueryResult newMessage() {
                return null;
            }
        }
    }

    public static final class NodeStatus {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "nodeId";
                }
                case 2: {
                    return "memoryFootprint";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("nodeId", 1);
            fieldMap.put("memoryFootprint", 2);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.NodeStatus.Builder> {
            public void mergeFrom(Input input, UserBitShared.NodeStatus.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setNodeId(input.readInt32());
                            break;
                        }
                        case 2: {
                            builder.setMemoryFootprint(input.readInt64());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.NodeStatus.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.NodeStatus.Builder newMessage() {
                return UserBitShared.NodeStatus.newBuilder();
            }

            public String getFieldName(int number) {
                return NodeStatus.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return NodeStatus.getFieldNumber(name);
            }

            public Class<UserBitShared.NodeStatus.Builder> typeClass() {
                return UserBitShared.NodeStatus.Builder.class;
            }

            public String messageName() {
                return UserBitShared.NodeStatus.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.NodeStatus.class.getName();
            }

            public void writeTo(Output output, UserBitShared.NodeStatus.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.NodeStatus> {
            public void writeTo(Output output, UserBitShared.NodeStatus message) throws IOException {
                if (message.hasNodeId()) {
                    output.writeInt32(1, message.getNodeId(), false);
                }
                if (message.hasMemoryFootprint()) {
                    output.writeInt64(2, message.getMemoryFootprint(), false);
                }
            }

            public boolean isInitialized(UserBitShared.NodeStatus message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return NodeStatus.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return NodeStatus.getFieldNumber(name);
            }

            public Class<UserBitShared.NodeStatus> typeClass() {
                return UserBitShared.NodeStatus.class;
            }

            public String messageName() {
                return UserBitShared.NodeStatus.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.NodeStatus.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.NodeStatus message) throws IOException {
            }

            public UserBitShared.NodeStatus newMessage() {
                return null;
            }
        }
    }

    public static final class SerializedField {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "majorType";
                }
                case 2: {
                    return "namePart";
                }
                case 3: {
                    return "child";
                }
                case 4: {
                    return "valueCount";
                }
                case 5: {
                    return "varByteLength";
                }
                case 6: {
                    return "groupCount";
                }
                case 7: {
                    return "bufferLength";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("majorType", 1);
            fieldMap.put("namePart", 2);
            fieldMap.put("child", 3);
            fieldMap.put("valueCount", 4);
            fieldMap.put("varByteLength", 5);
            fieldMap.put("groupCount", 6);
            fieldMap.put("bufferLength", 7);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.SerializedField.Builder> {
            public void mergeFrom(Input input, UserBitShared.SerializedField.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setMajorType((TypeProtos.MajorType.Builder)input.mergeObject((Object)TypeProtos.MajorType.newBuilder(), (Schema)SchemaTypeProtos.MajorType.MERGE));
                            break;
                        }
                        case 2: {
                            builder.setNamePart((UserBitShared.NamePart.Builder)input.mergeObject((Object)UserBitShared.NamePart.newBuilder(), (Schema)NamePart.MERGE));
                            break;
                        }
                        case 3: {
                            builder.addChild((UserBitShared.SerializedField.Builder)input.mergeObject((Object)UserBitShared.SerializedField.newBuilder(), (Schema)MERGE));
                            break;
                        }
                        case 4: {
                            builder.setValueCount(input.readInt32());
                            break;
                        }
                        case 5: {
                            builder.setVarByteLength(input.readInt32());
                            break;
                        }
                        case 6: {
                            builder.setGroupCount(input.readInt32());
                            break;
                        }
                        case 7: {
                            builder.setBufferLength(input.readInt32());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.SerializedField.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.SerializedField.Builder newMessage() {
                return UserBitShared.SerializedField.newBuilder();
            }

            public String getFieldName(int number) {
                return SerializedField.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return SerializedField.getFieldNumber(name);
            }

            public Class<UserBitShared.SerializedField.Builder> typeClass() {
                return UserBitShared.SerializedField.Builder.class;
            }

            public String messageName() {
                return UserBitShared.SerializedField.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.SerializedField.class.getName();
            }

            public void writeTo(Output output, UserBitShared.SerializedField.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.SerializedField> {
            public void writeTo(Output output, UserBitShared.SerializedField message) throws IOException {
                if (message.hasMajorType()) {
                    output.writeObject(1, (Object)message.getMajorType(), (Schema)SchemaTypeProtos.MajorType.WRITE, false);
                }
                if (message.hasNamePart()) {
                    output.writeObject(2, (Object)message.getNamePart(), (Schema)NamePart.WRITE, false);
                }
                for (UserBitShared.SerializedField child : message.getChildList()) {
                    output.writeObject(3, (Object)child, (Schema)WRITE, true);
                }
                if (message.hasValueCount()) {
                    output.writeInt32(4, message.getValueCount(), false);
                }
                if (message.hasVarByteLength()) {
                    output.writeInt32(5, message.getVarByteLength(), false);
                }
                if (message.hasGroupCount()) {
                    output.writeInt32(6, message.getGroupCount(), false);
                }
                if (message.hasBufferLength()) {
                    output.writeInt32(7, message.getBufferLength(), false);
                }
            }

            public boolean isInitialized(UserBitShared.SerializedField message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return SerializedField.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return SerializedField.getFieldNumber(name);
            }

            public Class<UserBitShared.SerializedField> typeClass() {
                return UserBitShared.SerializedField.class;
            }

            public String messageName() {
                return UserBitShared.SerializedField.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.SerializedField.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.SerializedField message) throws IOException {
            }

            public UserBitShared.SerializedField newMessage() {
                return null;
            }
        }
    }

    public static final class NamePart {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "type";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "child";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("type", 1);
            fieldMap.put("name", 2);
            fieldMap.put("child", 3);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.NamePart.Builder> {
            public void mergeFrom(Input input, UserBitShared.NamePart.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setType(UserBitShared.NamePart.Type.valueOf(input.readEnum()));
                            break;
                        }
                        case 2: {
                            builder.setName(input.readString());
                            break;
                        }
                        case 3: {
                            builder.setChild((UserBitShared.NamePart.Builder)input.mergeObject((Object)UserBitShared.NamePart.newBuilder(), (Schema)MERGE));
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.NamePart.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.NamePart.Builder newMessage() {
                return UserBitShared.NamePart.newBuilder();
            }

            public String getFieldName(int number) {
                return NamePart.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return NamePart.getFieldNumber(name);
            }

            public Class<UserBitShared.NamePart.Builder> typeClass() {
                return UserBitShared.NamePart.Builder.class;
            }

            public String messageName() {
                return UserBitShared.NamePart.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.NamePart.class.getName();
            }

            public void writeTo(Output output, UserBitShared.NamePart.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.NamePart> {
            public void writeTo(Output output, UserBitShared.NamePart message) throws IOException {
                if (message.hasType()) {
                    output.writeEnum(1, message.getType().getNumber(), false);
                }
                if (message.hasName()) {
                    output.writeString(2, message.getName(), false);
                }
                if (message.hasChild()) {
                    output.writeObject(3, (Object)message.getChild(), (Schema)WRITE, false);
                }
            }

            public boolean isInitialized(UserBitShared.NamePart message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return NamePart.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return NamePart.getFieldNumber(name);
            }

            public Class<UserBitShared.NamePart> typeClass() {
                return UserBitShared.NamePart.class;
            }

            public String messageName() {
                return UserBitShared.NamePart.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.NamePart.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.NamePart message) throws IOException {
            }

            public UserBitShared.NamePart newMessage() {
                return null;
            }
        }
    }

    public static final class RecordBatchDef {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "recordCount";
                }
                case 2: {
                    return "field";
                }
                case 3: {
                    return "carriesTwoByteSelectionVector";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("recordCount", 1);
            fieldMap.put("field", 2);
            fieldMap.put("carriesTwoByteSelectionVector", 3);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.RecordBatchDef.Builder> {
            public void mergeFrom(Input input, UserBitShared.RecordBatchDef.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setRecordCount(input.readInt32());
                            break;
                        }
                        case 2: {
                            builder.addField((UserBitShared.SerializedField.Builder)input.mergeObject((Object)UserBitShared.SerializedField.newBuilder(), (Schema)SerializedField.MERGE));
                            break;
                        }
                        case 3: {
                            builder.setCarriesTwoByteSelectionVector(input.readBool());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.RecordBatchDef.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.RecordBatchDef.Builder newMessage() {
                return UserBitShared.RecordBatchDef.newBuilder();
            }

            public String getFieldName(int number) {
                return RecordBatchDef.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return RecordBatchDef.getFieldNumber(name);
            }

            public Class<UserBitShared.RecordBatchDef.Builder> typeClass() {
                return UserBitShared.RecordBatchDef.Builder.class;
            }

            public String messageName() {
                return UserBitShared.RecordBatchDef.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.RecordBatchDef.class.getName();
            }

            public void writeTo(Output output, UserBitShared.RecordBatchDef.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.RecordBatchDef> {
            public void writeTo(Output output, UserBitShared.RecordBatchDef message) throws IOException {
                if (message.hasRecordCount()) {
                    output.writeInt32(1, message.getRecordCount(), false);
                }
                for (UserBitShared.SerializedField field : message.getFieldList()) {
                    output.writeObject(2, (Object)field, (Schema)SerializedField.WRITE, true);
                }
                if (message.hasCarriesTwoByteSelectionVector()) {
                    output.writeBool(3, message.getCarriesTwoByteSelectionVector(), false);
                }
            }

            public boolean isInitialized(UserBitShared.RecordBatchDef message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return RecordBatchDef.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return RecordBatchDef.getFieldNumber(name);
            }

            public Class<UserBitShared.RecordBatchDef> typeClass() {
                return UserBitShared.RecordBatchDef.class;
            }

            public String messageName() {
                return UserBitShared.RecordBatchDef.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.RecordBatchDef.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.RecordBatchDef message) throws IOException {
            }

            public UserBitShared.RecordBatchDef newMessage() {
                return null;
            }
        }
    }

    public static final class ParsingError {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 2: {
                    return "startColumn";
                }
                case 3: {
                    return "startRow";
                }
                case 4: {
                    return "endColumn";
                }
                case 5: {
                    return "endRow";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("startColumn", 2);
            fieldMap.put("startRow", 3);
            fieldMap.put("endColumn", 4);
            fieldMap.put("endRow", 5);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.ParsingError.Builder> {
            public void mergeFrom(Input input, UserBitShared.ParsingError.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 2: {
                            builder.setStartColumn(input.readInt32());
                            break;
                        }
                        case 3: {
                            builder.setStartRow(input.readInt32());
                            break;
                        }
                        case 4: {
                            builder.setEndColumn(input.readInt32());
                            break;
                        }
                        case 5: {
                            builder.setEndRow(input.readInt32());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.ParsingError.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.ParsingError.Builder newMessage() {
                return UserBitShared.ParsingError.newBuilder();
            }

            public String getFieldName(int number) {
                return ParsingError.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return ParsingError.getFieldNumber(name);
            }

            public Class<UserBitShared.ParsingError.Builder> typeClass() {
                return UserBitShared.ParsingError.Builder.class;
            }

            public String messageName() {
                return UserBitShared.ParsingError.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.ParsingError.class.getName();
            }

            public void writeTo(Output output, UserBitShared.ParsingError.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.ParsingError> {
            public void writeTo(Output output, UserBitShared.ParsingError message) throws IOException {
                if (message.hasStartColumn()) {
                    output.writeInt32(2, message.getStartColumn(), false);
                }
                if (message.hasStartRow()) {
                    output.writeInt32(3, message.getStartRow(), false);
                }
                if (message.hasEndColumn()) {
                    output.writeInt32(4, message.getEndColumn(), false);
                }
                if (message.hasEndRow()) {
                    output.writeInt32(5, message.getEndRow(), false);
                }
            }

            public boolean isInitialized(UserBitShared.ParsingError message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return ParsingError.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return ParsingError.getFieldNumber(name);
            }

            public Class<UserBitShared.ParsingError> typeClass() {
                return UserBitShared.ParsingError.class;
            }

            public String messageName() {
                return UserBitShared.ParsingError.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.ParsingError.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.ParsingError message) throws IOException {
            }

            public UserBitShared.ParsingError newMessage() {
                return null;
            }
        }
    }

    public static final class StackTraceElementWrapper {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "className";
                }
                case 2: {
                    return "fileName";
                }
                case 3: {
                    return "lineNumber";
                }
                case 4: {
                    return "methodName";
                }
                case 5: {
                    return "isNativeMethod";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("className", 1);
            fieldMap.put("fileName", 2);
            fieldMap.put("lineNumber", 3);
            fieldMap.put("methodName", 4);
            fieldMap.put("isNativeMethod", 5);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.StackTraceElementWrapper.Builder> {
            public void mergeFrom(Input input, UserBitShared.StackTraceElementWrapper.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setClassName(input.readString());
                            break;
                        }
                        case 2: {
                            builder.setFileName(input.readString());
                            break;
                        }
                        case 3: {
                            builder.setLineNumber(input.readInt32());
                            break;
                        }
                        case 4: {
                            builder.setMethodName(input.readString());
                            break;
                        }
                        case 5: {
                            builder.setIsNativeMethod(input.readBool());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.StackTraceElementWrapper.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.StackTraceElementWrapper.Builder newMessage() {
                return UserBitShared.StackTraceElementWrapper.newBuilder();
            }

            public String getFieldName(int number) {
                return StackTraceElementWrapper.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return StackTraceElementWrapper.getFieldNumber(name);
            }

            public Class<UserBitShared.StackTraceElementWrapper.Builder> typeClass() {
                return UserBitShared.StackTraceElementWrapper.Builder.class;
            }

            public String messageName() {
                return UserBitShared.StackTraceElementWrapper.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.StackTraceElementWrapper.class.getName();
            }

            public void writeTo(Output output, UserBitShared.StackTraceElementWrapper.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.StackTraceElementWrapper> {
            public void writeTo(Output output, UserBitShared.StackTraceElementWrapper message) throws IOException {
                if (message.hasClassName()) {
                    output.writeString(1, message.getClassName(), false);
                }
                if (message.hasFileName()) {
                    output.writeString(2, message.getFileName(), false);
                }
                if (message.hasLineNumber()) {
                    output.writeInt32(3, message.getLineNumber(), false);
                }
                if (message.hasMethodName()) {
                    output.writeString(4, message.getMethodName(), false);
                }
                if (message.hasIsNativeMethod()) {
                    output.writeBool(5, message.getIsNativeMethod(), false);
                }
            }

            public boolean isInitialized(UserBitShared.StackTraceElementWrapper message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return StackTraceElementWrapper.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return StackTraceElementWrapper.getFieldNumber(name);
            }

            public Class<UserBitShared.StackTraceElementWrapper> typeClass() {
                return UserBitShared.StackTraceElementWrapper.class;
            }

            public String messageName() {
                return UserBitShared.StackTraceElementWrapper.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.StackTraceElementWrapper.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.StackTraceElementWrapper message) throws IOException {
            }

            public UserBitShared.StackTraceElementWrapper newMessage() {
                return null;
            }
        }
    }

    public static final class ExceptionWrapper {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "exceptionClass";
                }
                case 2: {
                    return "message";
                }
                case 3: {
                    return "stackTrace";
                }
                case 4: {
                    return "cause";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("exceptionClass", 1);
            fieldMap.put("message", 2);
            fieldMap.put("stackTrace", 3);
            fieldMap.put("cause", 4);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.ExceptionWrapper.Builder> {
            public void mergeFrom(Input input, UserBitShared.ExceptionWrapper.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setExceptionClass(input.readString());
                            break;
                        }
                        case 2: {
                            builder.setMessage(input.readString());
                            break;
                        }
                        case 3: {
                            builder.addStackTrace((UserBitShared.StackTraceElementWrapper.Builder)input.mergeObject((Object)UserBitShared.StackTraceElementWrapper.newBuilder(), (Schema)StackTraceElementWrapper.MERGE));
                            break;
                        }
                        case 4: {
                            builder.setCause((UserBitShared.ExceptionWrapper.Builder)input.mergeObject((Object)UserBitShared.ExceptionWrapper.newBuilder(), (Schema)MERGE));
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.ExceptionWrapper.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.ExceptionWrapper.Builder newMessage() {
                return UserBitShared.ExceptionWrapper.newBuilder();
            }

            public String getFieldName(int number) {
                return ExceptionWrapper.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return ExceptionWrapper.getFieldNumber(name);
            }

            public Class<UserBitShared.ExceptionWrapper.Builder> typeClass() {
                return UserBitShared.ExceptionWrapper.Builder.class;
            }

            public String messageName() {
                return UserBitShared.ExceptionWrapper.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.ExceptionWrapper.class.getName();
            }

            public void writeTo(Output output, UserBitShared.ExceptionWrapper.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.ExceptionWrapper> {
            public void writeTo(Output output, UserBitShared.ExceptionWrapper message) throws IOException {
                if (message.hasExceptionClass()) {
                    output.writeString(1, message.getExceptionClass(), false);
                }
                if (message.hasMessage()) {
                    output.writeString(2, message.getMessage(), false);
                }
                for (UserBitShared.StackTraceElementWrapper stackTrace : message.getStackTraceList()) {
                    output.writeObject(3, (Object)stackTrace, (Schema)StackTraceElementWrapper.WRITE, true);
                }
                if (message.hasCause()) {
                    output.writeObject(4, (Object)message.getCause(), (Schema)WRITE, false);
                }
            }

            public boolean isInitialized(UserBitShared.ExceptionWrapper message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return ExceptionWrapper.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return ExceptionWrapper.getFieldNumber(name);
            }

            public Class<UserBitShared.ExceptionWrapper> typeClass() {
                return UserBitShared.ExceptionWrapper.class;
            }

            public String messageName() {
                return UserBitShared.ExceptionWrapper.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.ExceptionWrapper.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.ExceptionWrapper message) throws IOException {
            }

            public UserBitShared.ExceptionWrapper newMessage() {
                return null;
            }
        }
    }

    public static final class DrillPBError {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "errorId";
                }
                case 2: {
                    return "endpoint";
                }
                case 3: {
                    return "errorType";
                }
                case 4: {
                    return "message";
                }
                case 5: {
                    return "exception";
                }
                case 6: {
                    return "parsingError";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("errorId", 1);
            fieldMap.put("endpoint", 2);
            fieldMap.put("errorType", 3);
            fieldMap.put("message", 4);
            fieldMap.put("exception", 5);
            fieldMap.put("parsingError", 6);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.DrillPBError.Builder> {
            public void mergeFrom(Input input, UserBitShared.DrillPBError.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setErrorId(input.readString());
                            break;
                        }
                        case 2: {
                            builder.setEndpoint((CoordinationProtos.DrillbitEndpoint.Builder)input.mergeObject((Object)CoordinationProtos.DrillbitEndpoint.newBuilder(), (Schema)SchemaCoordinationProtos.DrillbitEndpoint.MERGE));
                            break;
                        }
                        case 3: {
                            builder.setErrorType(input.readInt32());
                            break;
                        }
                        case 4: {
                            builder.setMessage(input.readString());
                            break;
                        }
                        case 5: {
                            builder.setException((UserBitShared.ExceptionWrapper.Builder)input.mergeObject((Object)UserBitShared.ExceptionWrapper.newBuilder(), (Schema)ExceptionWrapper.MERGE));
                            break;
                        }
                        case 6: {
                            builder.addParsingError((UserBitShared.ParsingError.Builder)input.mergeObject((Object)UserBitShared.ParsingError.newBuilder(), (Schema)ParsingError.MERGE));
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.DrillPBError.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.DrillPBError.Builder newMessage() {
                return UserBitShared.DrillPBError.newBuilder();
            }

            public String getFieldName(int number) {
                return DrillPBError.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return DrillPBError.getFieldNumber(name);
            }

            public Class<UserBitShared.DrillPBError.Builder> typeClass() {
                return UserBitShared.DrillPBError.Builder.class;
            }

            public String messageName() {
                return UserBitShared.DrillPBError.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.DrillPBError.class.getName();
            }

            public void writeTo(Output output, UserBitShared.DrillPBError.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.DrillPBError> {
            public void writeTo(Output output, UserBitShared.DrillPBError message) throws IOException {
                if (message.hasErrorId()) {
                    output.writeString(1, message.getErrorId(), false);
                }
                if (message.hasEndpoint()) {
                    output.writeObject(2, (Object)message.getEndpoint(), (Schema)SchemaCoordinationProtos.DrillbitEndpoint.WRITE, false);
                }
                if (message.hasErrorType()) {
                    output.writeInt32(3, message.getErrorType(), false);
                }
                if (message.hasMessage()) {
                    output.writeString(4, message.getMessage(), false);
                }
                if (message.hasException()) {
                    output.writeObject(5, (Object)message.getException(), (Schema)ExceptionWrapper.WRITE, false);
                }
                for (UserBitShared.ParsingError parsingError : message.getParsingErrorList()) {
                    output.writeObject(6, (Object)parsingError, (Schema)ParsingError.WRITE, true);
                }
            }

            public boolean isInitialized(UserBitShared.DrillPBError message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return DrillPBError.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return DrillPBError.getFieldNumber(name);
            }

            public Class<UserBitShared.DrillPBError> typeClass() {
                return UserBitShared.DrillPBError.class;
            }

            public String messageName() {
                return UserBitShared.DrillPBError.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.DrillPBError.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.DrillPBError message) throws IOException {
            }

            public UserBitShared.DrillPBError newMessage() {
                return null;
            }
        }
    }

    public static final class QueryId {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "part1";
                }
                case 2: {
                    return "part2";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("part1", 1);
            fieldMap.put("part2", 2);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.QueryId.Builder> {
            public void mergeFrom(Input input, UserBitShared.QueryId.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setPart1(input.readSFixed64());
                            break;
                        }
                        case 2: {
                            builder.setPart2(input.readSFixed64());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.QueryId.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.QueryId.Builder newMessage() {
                return UserBitShared.QueryId.newBuilder();
            }

            public String getFieldName(int number) {
                return QueryId.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return QueryId.getFieldNumber(name);
            }

            public Class<UserBitShared.QueryId.Builder> typeClass() {
                return UserBitShared.QueryId.Builder.class;
            }

            public String messageName() {
                return UserBitShared.QueryId.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.QueryId.class.getName();
            }

            public void writeTo(Output output, UserBitShared.QueryId.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.QueryId> {
            public void writeTo(Output output, UserBitShared.QueryId message) throws IOException {
                if (message.hasPart1()) {
                    output.writeSFixed64(1, message.getPart1(), false);
                }
                if (message.hasPart2()) {
                    output.writeSFixed64(2, message.getPart2(), false);
                }
            }

            public boolean isInitialized(UserBitShared.QueryId message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return QueryId.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return QueryId.getFieldNumber(name);
            }

            public Class<UserBitShared.QueryId> typeClass() {
                return UserBitShared.QueryId.class;
            }

            public String messageName() {
                return UserBitShared.QueryId.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.QueryId.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.QueryId message) throws IOException {
            }

            public UserBitShared.QueryId newMessage() {
                return null;
            }
        }
    }

    public static final class UserCredentials {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "userName";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("userName", 1);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.UserCredentials.Builder> {
            public void mergeFrom(Input input, UserBitShared.UserCredentials.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setUserName(input.readString());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(UserBitShared.UserCredentials.Builder builder) {
                return builder.isInitialized();
            }

            public UserBitShared.UserCredentials.Builder newMessage() {
                return UserBitShared.UserCredentials.newBuilder();
            }

            public String getFieldName(int number) {
                return UserCredentials.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return UserCredentials.getFieldNumber(name);
            }

            public Class<UserBitShared.UserCredentials.Builder> typeClass() {
                return UserBitShared.UserCredentials.Builder.class;
            }

            public String messageName() {
                return UserBitShared.UserCredentials.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.UserCredentials.class.getName();
            }

            public void writeTo(Output output, UserBitShared.UserCredentials.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.UserCredentials> {
            public void writeTo(Output output, UserBitShared.UserCredentials message) throws IOException {
                if (message.hasUserName()) {
                    output.writeString(1, message.getUserName(), false);
                }
            }

            public boolean isInitialized(UserBitShared.UserCredentials message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return UserCredentials.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return UserCredentials.getFieldNumber(name);
            }

            public Class<UserBitShared.UserCredentials> typeClass() {
                return UserBitShared.UserCredentials.class;
            }

            public String messageName() {
                return UserBitShared.UserCredentials.class.getSimpleName();
            }

            public String messageFullName() {
                return UserBitShared.UserCredentials.class.getName();
            }

            public void mergeFrom(Input input, UserBitShared.UserCredentials message) throws IOException {
            }

            public UserBitShared.UserCredentials newMessage() {
                return null;
            }
        }
    }
}

