/*
 * Decompiled with CFR 0.152.
 */
package parquet;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class Log {
    public static final Level LEVEL = Level.INFO;
    public static final boolean DEBUG = LEVEL.intValue() <= Level.FINE.intValue();
    public static final boolean INFO = LEVEL.intValue() <= Level.INFO.intValue();
    public static final boolean WARN = LEVEL.intValue() <= Level.WARNING.intValue();
    public static final boolean ERROR = LEVEL.intValue() <= Level.SEVERE.intValue();
    private Logger logger;

    static {
        Logger logger = Logger.getLogger(Log.class.getPackage().getName());
        Handler[] handlers = logger.getHandlers();
        if (handlers == null || handlers.length == 0) {
            logger.setUseParentHandlers(false);
            StreamHandler handler = new StreamHandler(System.out, new Formatter(){
                Date dat = new Date();
                private static final String format = "{0,date} {0,time}";
                private MessageFormat formatter = new MessageFormat("{0,date} {0,time}");
                private Object[] args = new Object[1];

                @Override
                public synchronized String format(LogRecord record) {
                    StringBuffer sb = new StringBuffer();
                    this.dat.setTime(record.getMillis());
                    this.args[0] = this.dat;
                    this.formatter.format(this.args, sb, (FieldPosition)null);
                    sb.append(" ");
                    sb.append(record.getLevel().getLocalizedName());
                    sb.append(": ");
                    sb.append(record.getLoggerName());
                    sb.append(": ");
                    sb.append(this.formatMessage(record));
                    sb.append("\n");
                    if (record.getThrown() != null) {
                        try {
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            record.getThrown().printStackTrace(pw);
                            pw.close();
                            sb.append(sw.toString());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return sb.toString();
                }
            });
            handler.setLevel(LEVEL);
            logger.addHandler(handler);
        }
        logger.setLevel(LEVEL);
    }

    public static Log getLog(Class<?> c) {
        return new Log(c);
    }

    public Log(Class<?> c) {
        this.logger = Logger.getLogger(c.getName());
    }

    public void debug(Object m) {
        if (m instanceof Throwable) {
            this.logger.log(Level.FINE, "", (Throwable)m);
        } else {
            this.logger.fine(String.valueOf(m));
        }
    }

    public void debug(Object m, Throwable t) {
        this.logger.log(Level.FINE, String.valueOf(m), t);
    }

    public void info(Object m) {
        if (m instanceof Throwable) {
            this.logger.log(Level.INFO, "", (Throwable)m);
        } else {
            this.logger.info(String.valueOf(m));
        }
    }

    public void info(Object m, Throwable t) {
        this.logger.log(Level.INFO, String.valueOf(m), t);
    }

    public void warn(Object m) {
        if (m instanceof Throwable) {
            this.logger.log(Level.WARNING, "", (Throwable)m);
        } else {
            this.logger.warning(String.valueOf(m));
        }
    }

    public void warn(Object m, Throwable t) {
        this.logger.log(Level.WARNING, String.valueOf(m), t);
    }

    public void error(Object m) {
        if (m instanceof Throwable) {
            this.logger.log(Level.SEVERE, "", (Throwable)m);
        } else {
            this.logger.warning(String.valueOf(m));
        }
    }

    public void error(Object m, Throwable t) {
        this.logger.log(Level.SEVERE, String.valueOf(m), t);
    }
}

