/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql2rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.ModifiableTable;
import net.hydromatic.optiq.TranslatableTable;
import net.hydromatic.optiq.prepare.Prepare;
import net.hydromatic.optiq.prepare.RelOptTableImpl;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.Aggregation;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.CollectRel;
import org.eigenbase.rel.CorrelatorRel;
import org.eigenbase.rel.IntersectRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.MinusRel;
import org.eigenbase.rel.OneRowRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SamplingRel;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.TableAccessRel;
import org.eigenbase.rel.TableFunctionRel;
import org.eigenbase.rel.TableModificationRel;
import org.eigenbase.rel.TableModificationRelBase;
import org.eigenbase.rel.UncollectRel;
import org.eigenbase.rel.UnionRel;
import org.eigenbase.rel.ValuesRel;
import org.eigenbase.rel.metadata.RelColumnMapping;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptQuery;
import org.eigenbase.relopt.RelOptSamplingParameters;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexCallBinding;
import org.eigenbase.rex.RexCorrelVariable;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexFieldCollation;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexRangeRef;
import org.eigenbase.rex.RexShuttle;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.rex.RexWindowBound;
import org.eigenbase.sql.JoinConditionType;
import org.eigenbase.sql.JoinType;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlBasicCall;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlDataTypeSpec;
import org.eigenbase.sql.SqlDelete;
import org.eigenbase.sql.SqlDynamicParam;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlInsert;
import org.eigenbase.sql.SqlIntervalQualifier;
import org.eigenbase.sql.SqlJoin;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlMerge;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.SqlSampleSpec;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.SqlSelectKeyword;
import org.eigenbase.sql.SqlSetOperator;
import org.eigenbase.sql.SqlUpdate;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.SqlWindow;
import org.eigenbase.sql.SqlWith;
import org.eigenbase.sql.SqlWithItem;
import org.eigenbase.sql.fun.SqlCountAggFunction;
import org.eigenbase.sql.fun.SqlInOperator;
import org.eigenbase.sql.fun.SqlRowOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.BasicSqlType;
import org.eigenbase.sql.type.SqlReturnTypeInference;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.sql.type.TableFunctionReturnTypeInference;
import org.eigenbase.sql.util.SqlBasicVisitor;
import org.eigenbase.sql.util.SqlVisitor;
import org.eigenbase.sql.validate.CollectNamespace;
import org.eigenbase.sql.validate.DelegatingScope;
import org.eigenbase.sql.validate.ListScope;
import org.eigenbase.sql.validate.ParameterScope;
import org.eigenbase.sql.validate.SelectScope;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlUserDefinedTableFunction;
import org.eigenbase.sql.validate.SqlUserDefinedTableMacro;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorImpl;
import org.eigenbase.sql.validate.SqlValidatorNamespace;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.sql.validate.SqlValidatorUtil;
import org.eigenbase.sql2rel.DefaultValueFactory;
import org.eigenbase.sql2rel.RelDecorrelator;
import org.eigenbase.sql2rel.RelFieldTrimmer;
import org.eigenbase.sql2rel.RelStructuredTypeFlattener;
import org.eigenbase.sql2rel.SqlNodeToRexConverter;
import org.eigenbase.sql2rel.SqlNodeToRexConverterImpl;
import org.eigenbase.sql2rel.SqlRexContext;
import org.eigenbase.sql2rel.SqlRexConvertletTable;
import org.eigenbase.sql2rel.SubqueryConverter;
import org.eigenbase.trace.EigenbaseTrace;
import org.eigenbase.util.NlsString;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Static;
import org.eigenbase.util.Util;
import org.eigenbase.util14.NumberUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlToRelConverter {
    protected static final Logger SQL2REL_LOGGER = EigenbaseTrace.getSqlToRelTracer();
    protected final SqlValidator validator;
    protected final RexBuilder rexBuilder;
    protected final Prepare.CatalogReader catalogReader;
    protected final RelOptCluster cluster;
    private DefaultValueFactory defaultValueFactory;
    private SubqueryConverter subqueryConverter;
    protected final List<RelNode> leaves = new ArrayList<RelNode>();
    private final List<SqlDynamicParam> dynamicParamSqlNodes = new ArrayList<SqlDynamicParam>();
    private final SqlOperatorTable opTab;
    private boolean shouldConvertTableAccess;
    protected final RelDataTypeFactory typeFactory;
    private final SqlNodeToRexConverter exprConverter;
    private boolean decorrelationEnabled;
    private boolean trimUnusedFields;
    private boolean shouldCreateValuesRel;
    private boolean isExplain;
    private int nDynamicParamsInExplain;
    private final Map<String, DeferredLookup> mapCorrelToDeferred = new HashMap<String, DeferredLookup>();
    private int nextCorrel = 0;
    private static final String CORREL_PREFIX = "$cor";
    private final Map<String, RelNode> mapCorrelToRefRel = new HashMap<String, RelNode>();
    private final SortedMap<CorrelatorRel.Correlation, CorrelatorRel> mapCorVarToCorRel = new TreeMap<CorrelatorRel.Correlation, CorrelatorRel>();
    private final Map<RelNode, SortedSet<CorrelatorRel.Correlation>> mapRefRelToCorVar = new HashMap<RelNode, SortedSet<CorrelatorRel.Correlation>>();
    private final Map<RexFieldAccess, CorrelatorRel.Correlation> mapFieldAccessToCorVar = new HashMap<RexFieldAccess, CorrelatorRel.Correlation>();
    private final Stack<String> datasetStack = new Stack();
    private final Map<SqlNode, RexNode> mapConvertedNonCorrSubqs = new HashMap<SqlNode, RexNode>();
    public final RelOptTable.ViewExpander viewExpander;

    public SqlToRelConverter(RelOptTable.ViewExpander viewExpander, SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptPlanner planner, RexBuilder rexBuilder, SqlRexConvertletTable convertletTable) {
        this.viewExpander = viewExpander;
        this.opTab = validator == null ? SqlStdOperatorTable.instance() : validator.getOperatorTable();
        this.validator = validator;
        this.catalogReader = catalogReader;
        this.defaultValueFactory = new NullDefaultValueFactory();
        this.subqueryConverter = new NoOpSubqueryConverter();
        this.rexBuilder = rexBuilder;
        this.typeFactory = rexBuilder.getTypeFactory();
        RelOptQuery query = new RelOptQuery(planner);
        this.cluster = query.createCluster(this.typeFactory, rexBuilder);
        this.shouldConvertTableAccess = true;
        this.exprConverter = new SqlNodeToRexConverterImpl(convertletTable);
        this.decorrelationEnabled = true;
        this.trimUnusedFields = false;
        this.shouldCreateValuesRel = true;
        this.isExplain = false;
        this.nDynamicParamsInExplain = 0;
    }

    public RelOptCluster getCluster() {
        return this.cluster;
    }

    public RexBuilder getRexBuilder() {
        return this.rexBuilder;
    }

    public int getDynamicParamCount() {
        return this.dynamicParamSqlNodes.size();
    }

    public RelDataType getDynamicParamType(int index) {
        SqlNode sqlNode = this.dynamicParamSqlNodes.get(index);
        if (sqlNode == null) {
            throw Util.needToImplement("dynamic param type inference");
        }
        return this.validator.getValidatedNodeType(sqlNode);
    }

    public int getDynamicParamCountInExplain(boolean increment) {
        int retVal = this.nDynamicParamsInExplain++;
        if (increment) {
            // empty if block
        }
        return retVal;
    }

    public Map<SqlNode, RexNode> getMapConvertedNonCorrSubqs() {
        return this.mapConvertedNonCorrSubqs;
    }

    public void addConvertedNonCorrSubqs(Map<SqlNode, RexNode> alreadyConvertedNonCorrSubqs) {
        this.mapConvertedNonCorrSubqs.putAll(alreadyConvertedNonCorrSubqs);
    }

    public void setDefaultValueFactory(DefaultValueFactory factory) {
        this.defaultValueFactory = factory;
    }

    public void setSubqueryConverter(SubqueryConverter converter) {
        this.subqueryConverter = converter;
    }

    public void setIsExplain(int nDynamicParams) {
        this.isExplain = true;
        this.nDynamicParamsInExplain = nDynamicParams;
    }

    public void enableTableAccessConversion(boolean enabled) {
        this.shouldConvertTableAccess = enabled;
    }

    public void enableValuesRelCreation(boolean enabled) {
        this.shouldCreateValuesRel = enabled;
    }

    private void checkConvertedType(SqlNode query, RelNode result) {
        RelDataType convertedRowType;
        if (!query.isA(SqlKind.DML) && !this.checkConvertedRowType(query, convertedRowType = result.getRowType())) {
            RelDataType validatedRowType = this.validator.getValidatedNodeType(query);
            validatedRowType = this.uniquifyFields(validatedRowType);
            throw Util.newInternal("Conversion to relational algebra failed to preserve datatypes:\nvalidated type:\n" + validatedRowType.getFullTypeString() + "\nconverted type:\n" + convertedRowType.getFullTypeString() + "\nrel:\n" + RelOptUtil.toString(result));
        }
    }

    public RelNode flattenTypes(RelNode rootRel, boolean restructure) {
        RelStructuredTypeFlattener typeFlattener = new RelStructuredTypeFlattener(this.rexBuilder, this.createToRelContext());
        RelNode newRootRel = typeFlattener.rewrite(rootRel, restructure);
        typeFlattener.updateRelInMap(this.mapRefRelToCorVar);
        typeFlattener.updateRelInMap(this.mapCorVarToCorRel);
        return newRootRel;
    }

    public RelNode decorrelate(SqlNode query, RelNode rootRel) {
        RelNode result = rootRel;
        if (this.enableDecorrelation() && this.hasCorrelation()) {
            result = this.decorrelateQuery(result);
            this.checkConvertedType(query, result);
        }
        return result;
    }

    public RelNode trimUnusedFields(RelNode rootRel) {
        if (this.isTrimUnusedFields()) {
            RelFieldTrimmer trimmer = this.newFieldTrimmer();
            rootRel = trimmer.trim(rootRel);
            boolean dumpPlan = SQL2REL_LOGGER.isLoggable(Level.FINE);
            if (dumpPlan) {
                SQL2REL_LOGGER.fine(RelOptUtil.dumpPlan("Plan after trimming unused fields", rootRel, false, SqlExplainLevel.EXPPLAN_ATTRIBUTES));
            }
        }
        return rootRel;
    }

    protected RelFieldTrimmer newFieldTrimmer() {
        return new RelFieldTrimmer(this.validator);
    }

    public RelNode convertQuery(SqlNode query, boolean needsValidation, boolean top) {
        if (needsValidation) {
            query = this.validator.validate(query);
        }
        RelNode result = this.convertQueryRecursive(query, top, null);
        this.checkConvertedType(query, result);
        boolean dumpPlan = SQL2REL_LOGGER.isLoggable(Level.FINE);
        if (dumpPlan) {
            SQL2REL_LOGGER.fine(RelOptUtil.dumpPlan("Plan after converting SqlNode to RelNode", result, false, SqlExplainLevel.EXPPLAN_ATTRIBUTES));
        }
        return result;
    }

    protected boolean checkConvertedRowType(SqlNode query, RelDataType convertedRowType) {
        RelDataType validatedRowType = this.validator.getValidatedNodeType(query);
        validatedRowType = this.uniquifyFields(validatedRowType);
        return RelOptUtil.equal("validated row type", validatedRowType, "converted row type", convertedRowType, false);
    }

    protected RelDataType uniquifyFields(RelDataType rowType) {
        return this.validator.getTypeFactory().createStructType(RelOptUtil.getFieldTypeList(rowType), SqlValidatorUtil.uniquify(rowType.getFieldNames()));
    }

    public RelNode convertSelect(SqlSelect select) {
        SqlValidatorScope selectScope = this.validator.getWhereScope(select);
        Blackboard bb = this.createBlackboard(selectScope, null);
        this.convertSelectImpl(bb, select);
        return bb.root;
    }

    protected Blackboard createBlackboard(SqlValidatorScope scope, Map<String, RexNode> nameToNodeMap) {
        return new Blackboard(scope, nameToNodeMap);
    }

    protected void convertSelectImpl(Blackboard bb, SqlSelect select) {
        this.convertFrom(bb, select.getFrom());
        this.convertWhere(bb, select.getWhere());
        ArrayList<SqlNode> orderExprList = new ArrayList<SqlNode>();
        ArrayList<RelFieldCollation> collationList = new ArrayList<RelFieldCollation>();
        this.gatherOrderExprs(bb, select, select.getOrderList(), orderExprList, collationList);
        RelCollation collation = this.cluster.traitSetOf(new RelTrait[0]).canonize(RelCollationImpl.of(collationList));
        if (this.validator.isAggregate(select)) {
            this.convertAgg(bb, select, orderExprList);
        } else {
            this.convertSelectList(bb, select, orderExprList);
        }
        if (select.isDistinct()) {
            this.distinctify(bb, true);
        }
        this.convertOrder(select, bb, collation, orderExprList, select.getOffset(), select.getFetch());
        bb.setRoot(bb.root, true);
    }

    private void distinctify(Blackboard bb, boolean checkForDupExprs) {
        RelNode rel = bb.root;
        if (checkForDupExprs && rel instanceof ProjectRel) {
            ProjectRel project = (ProjectRel)rel;
            List<RexNode> projectExprs = project.getProjects();
            ArrayList<Integer> origins = new ArrayList<Integer>();
            int dupCount = 0;
            for (int i = 0; i < projectExprs.size(); ++i) {
                int x = this.findExpr(projectExprs.get(i), projectExprs, i);
                if (x >= 0) {
                    origins.add(x);
                    ++dupCount;
                    continue;
                }
                origins.add(i);
            }
            if (dupCount == 0) {
                this.distinctify(bb, false);
                return;
            }
            HashMap<Integer, Integer> squished = new HashMap<Integer, Integer>();
            List<RelDataTypeField> fields = rel.getRowType().getFieldList();
            ArrayList<Pair<RexNode, String>> newProjects = new ArrayList<Pair<RexNode, String>>();
            for (int i = 0; i < fields.size(); ++i) {
                if ((Integer)origins.get(i) != i) continue;
                squished.put(i, newProjects.size());
                newProjects.add(RexInputRef.of2(i, fields));
            }
            bb.root = rel = new ProjectRel(this.cluster, rel, Pair.left(newProjects), Pair.right(newProjects), 1);
            this.distinctify(bb, false);
            rel = bb.root;
            ArrayList<Pair<RexInputRef, String>> undoProjects = new ArrayList<Pair<RexInputRef, String>>();
            for (int i = 0; i < fields.size(); ++i) {
                int origin = (Integer)origins.get(i);
                RelDataTypeField field = fields.get(i);
                undoProjects.add(Pair.of(new RexInputRef((Integer)squished.get(origin), field.getType()), field.getName()));
            }
            rel = new ProjectRel(this.cluster, rel, Pair.left(undoProjects), Pair.right(undoProjects), 1);
            bb.setRoot(rel, false);
            return;
        }
        List<AggregateCall> aggCalls = Collections.emptyList();
        rel = this.createAggregate(bb, BitSets.range(rel.getRowType().getFieldCount()), aggCalls);
        bb.setRoot(rel, false);
    }

    private int findExpr(RexNode seek, List<RexNode> exprs, int count) {
        for (int i = 0; i < count; ++i) {
            RexNode expr = exprs.get(i);
            if (!expr.toString().equals(seek.toString())) continue;
            return i;
        }
        return -1;
    }

    protected void convertOrder(SqlSelect select, Blackboard bb, RelCollation collation, List<SqlNode> orderExprList, SqlNode offset, SqlNode fetch) {
        if (select.getOrderList() == null) {
            assert (collation.getFieldCollations().isEmpty());
            if (offset == null && fetch == null) {
                return;
            }
        }
        bb.setRoot(new SortRel(this.cluster, this.cluster.traitSetOf(Convention.NONE, collation), bb.root, collation, offset == null ? null : this.convertExpression(offset), fetch == null ? null : this.convertExpression(fetch)), false);
        if (orderExprList.size() > 0) {
            ArrayList<RexNode> exprs = new ArrayList<RexNode>();
            RelDataType rowType = bb.root.getRowType();
            int fieldCount = rowType.getFieldCount() - orderExprList.size();
            for (int i = 0; i < fieldCount; ++i) {
                exprs.add(this.rexBuilder.makeInputRef(bb.root, i));
            }
            bb.setRoot(new ProjectRel(this.cluster, this.cluster.traitSetOf(RelCollationImpl.PRESERVE), bb.root, exprs, this.cluster.getTypeFactory().createStructType(rowType.getFieldList().subList(0, fieldCount)), 1), false);
        }
    }

    private static boolean containsInOperator(SqlNode node) {
        try {
            SqlBasicVisitor<Void> visitor = new SqlBasicVisitor<Void>(){

                @Override
                public Void visit(SqlCall call) {
                    if (call.getOperator() instanceof SqlInOperator) {
                        throw new Util.FoundOne(call);
                    }
                    return (Void)super.visit(call);
                }
            };
            node.accept(visitor);
            return false;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return true;
        }
    }

    private static SqlNode pushDownNotForIn(SqlNode sqlNode) {
        if (sqlNode instanceof SqlCall && SqlToRelConverter.containsInOperator(sqlNode)) {
            SqlCall sqlCall = (SqlCall)sqlNode;
            if (sqlCall.getOperator() == SqlStdOperatorTable.AND || sqlCall.getOperator() == SqlStdOperatorTable.OR) {
                SqlNode[] sqlOperands = ((SqlBasicCall)sqlCall).operands;
                for (int i = 0; i < sqlOperands.length; ++i) {
                    sqlOperands[i] = SqlToRelConverter.pushDownNotForIn(sqlOperands[i]);
                }
                return sqlNode;
            }
            if (sqlCall.getOperator() == SqlStdOperatorTable.NOT) {
                Object childNode = sqlCall.operand(0);
                assert (childNode instanceof SqlCall);
                SqlBasicCall childSqlCall = (SqlBasicCall)childNode;
                if (childSqlCall.getOperator() == SqlStdOperatorTable.AND) {
                    int i;
                    SqlNode[] andOperands = childSqlCall.getOperands();
                    SqlNode[] orOperands = new SqlNode[andOperands.length];
                    for (i = 0; i < orOperands.length; ++i) {
                        orOperands[i] = SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, andOperands[i]);
                    }
                    for (i = 0; i < orOperands.length; ++i) {
                        orOperands[i] = SqlToRelConverter.pushDownNotForIn(orOperands[i]);
                    }
                    return SqlStdOperatorTable.OR.createCall(SqlParserPos.ZERO, orOperands[0], orOperands[1]);
                }
                if (childSqlCall.getOperator() == SqlStdOperatorTable.OR) {
                    int i;
                    SqlNode[] orOperands = childSqlCall.getOperands();
                    SqlNode[] andOperands = new SqlNode[orOperands.length];
                    for (i = 0; i < andOperands.length; ++i) {
                        andOperands[i] = SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, orOperands[i]);
                    }
                    for (i = 0; i < andOperands.length; ++i) {
                        andOperands[i] = SqlToRelConverter.pushDownNotForIn(andOperands[i]);
                    }
                    return SqlStdOperatorTable.AND.createCall(SqlParserPos.ZERO, andOperands[0], andOperands[1]);
                }
                if (childSqlCall.getOperator() == SqlStdOperatorTable.NOT) {
                    SqlNode[] notOperands = childSqlCall.getOperands();
                    assert (notOperands.length == 1);
                    return SqlToRelConverter.pushDownNotForIn(notOperands[0]);
                }
                if (childSqlCall.getOperator() instanceof SqlInOperator) {
                    SqlNode[] inOperands = childSqlCall.getOperands();
                    SqlInOperator inOp = (SqlInOperator)childSqlCall.getOperator();
                    if (inOp.isNotIn()) {
                        return SqlStdOperatorTable.IN.createCall(SqlParserPos.ZERO, inOperands[0], inOperands[1]);
                    }
                    return SqlStdOperatorTable.NOT_IN.createCall(SqlParserPos.ZERO, inOperands[0], inOperands[1]);
                }
                return sqlNode;
            }
            return sqlNode;
        }
        return sqlNode;
    }

    private void convertWhere(Blackboard bb, SqlNode where) {
        if (where == null) {
            return;
        }
        SqlNode newWhere = SqlToRelConverter.pushDownNotForIn(where);
        this.replaceSubqueries(bb, newWhere);
        RexNode convertedWhere = bb.convertExpression(newWhere);
        if (!convertedWhere.isAlwaysTrue()) {
            RelNode inputRel = bb.root;
            Set<String> correlatedVariablesBefore = RelOptUtil.getVariablesUsed(inputRel);
            bb.setRoot(CalcRel.createFilter(bb.root, convertedWhere), false);
            Set<String> correlatedVariables = RelOptUtil.getVariablesUsed(bb.root);
            correlatedVariables.removeAll(correlatedVariablesBefore);
            for (String correl : correlatedVariables) {
                this.mapCorrelToRefRel.put(correl, bb.root);
            }
        }
    }

    private void replaceSubqueries(Blackboard bb, SqlNode expr) {
        this.findSubqueries(bb, expr, false);
        for (SqlNode node : bb.subqueryList) {
            this.substituteSubquery(bb, node);
        }
    }

    private void substituteSubquery(Blackboard bb, SqlNode node) {
        RelNode converted;
        JoinRelType joinType = JoinRelType.INNER;
        RexNode[] leftJoinKeysForIn = null;
        boolean subqueryNeedsOuterJoin = bb.subqueryNeedsOuterJoin;
        RexNode expr = (RexNode)bb.mapSubqueryToExpr.get(node);
        if (expr != null) {
            return;
        }
        switch (node.getKind()) {
            case CURSOR: {
                this.convertCursor(bb, (SqlCall)node);
                return;
            }
            case MULTISET_QUERY_CONSTRUCTOR: 
            case MULTISET_VALUE_CONSTRUCTOR: {
                converted = this.convertMultisets((List<SqlNode>)ImmutableList.of((Object)node), bb);
                break;
            }
            case IN: {
                SqlBasicCall call = (SqlBasicCall)node;
                SqlNode[] operands = call.getOperands();
                boolean isNotIn = ((SqlInOperator)call.getOperator()).isNotIn();
                SqlNode leftKeyNode = operands[0];
                SqlNode seek = operands[1];
                if (leftKeyNode instanceof SqlCall && ((SqlCall)leftKeyNode).getOperator() instanceof SqlRowOperator) {
                    SqlBasicCall keyCall = (SqlBasicCall)leftKeyNode;
                    SqlNode[] keyCallOperands = keyCall.getOperands();
                    int rowLength = keyCallOperands.length;
                    leftJoinKeysForIn = new RexNode[rowLength];
                    for (int i = 0; i < rowLength; ++i) {
                        SqlNode sqlExpr = keyCallOperands[i];
                        leftJoinKeysForIn[i] = bb.convertExpression(sqlExpr);
                    }
                } else {
                    leftJoinKeysForIn = new RexNode[]{bb.convertExpression(leftKeyNode)};
                }
                if (seek instanceof SqlNodeList) {
                    SqlNodeList valueList = (SqlNodeList)seek;
                    boolean seenNull = false;
                    for (int i = 0; i < valueList.size(); ++i) {
                        SqlLiteral lit;
                        SqlNode sqlNode = valueList.getList().get(i);
                        if (!(sqlNode instanceof SqlLiteral) || (lit = (SqlLiteral)sqlNode).getValue() != null) continue;
                        seenNull = true;
                    }
                    if (!seenNull && valueList.size() < this.getInSubqueryThreshold()) {
                        RexNode expression = this.convertInToOr(bb, leftJoinKeysForIn, valueList, isNotIn);
                        bb.mapSubqueryToExpr.put(node, expression);
                        return;
                    }
                }
                converted = this.convertExists(seek, true, false, subqueryNeedsOuterJoin || isNotIn);
                if (subqueryNeedsOuterJoin || isNotIn) {
                    joinType = JoinRelType.LEFT;
                    break;
                }
                joinType = JoinRelType.INNER;
                break;
            }
            case EXISTS: {
                SqlBasicCall call = (SqlBasicCall)node;
                SqlNode query = call.getOperands()[0];
                converted = this.convertExists(query, false, true, true);
                if (this.convertNonCorrelatedSubq(call, bb, converted, true)) {
                    return;
                }
                joinType = JoinRelType.LEFT;
                break;
            }
            case SCALAR_QUERY: {
                SqlBasicCall call = (SqlBasicCall)node;
                SqlNode query = call.getOperands()[0];
                converted = this.convertExists(query, false, false, true);
                if (this.convertNonCorrelatedSubq(call, bb, converted, false)) {
                    return;
                }
                converted = this.convertToSingleValueSubq(query, converted);
                joinType = JoinRelType.LEFT;
                break;
            }
            case SELECT: {
                converted = this.convertExists(node, false, false, true);
                joinType = JoinRelType.LEFT;
                break;
            }
            default: {
                throw Util.newInternal("unexpected kind of subquery :" + node);
            }
        }
        RexNode expression = bb.register(converted, joinType, leftJoinKeysForIn);
        bb.mapSubqueryToExpr.put(node, expression);
    }

    private boolean convertNonCorrelatedSubq(SqlCall call, Blackboard bb, RelNode converted, boolean isExists) {
        if (this.subqueryConverter.canConvertSubquery() && this.isSubqNonCorrelated(converted, bb)) {
            RexNode constExpr = this.mapConvertedNonCorrSubqs.get(call);
            if (constExpr == null) {
                constExpr = this.subqueryConverter.convertSubquery(call, this, isExists, this.isExplain);
            }
            if (constExpr != null) {
                bb.mapSubqueryToExpr.put(call, constExpr);
                this.mapConvertedNonCorrSubqs.put(call, constExpr);
                return true;
            }
        }
        return false;
    }

    public RelNode convertToSingleValueSubq(SqlNode query, RelNode plan) {
        if (query instanceof SqlSelect) {
            SqlCall selectExprCall;
            SqlNode selectExpr;
            SqlSelect select = (SqlSelect)query;
            SqlNodeList selectList = select.getSelectList();
            SqlNodeList groupList = select.getGroup();
            if (selectList.size() == 1 && (groupList == null || groupList.size() == 0) && (selectExpr = selectList.get(0)) instanceof SqlCall && (selectExprCall = (SqlCall)selectExpr).getOperator() instanceof SqlAggFunction) {
                return plan;
            }
        }
        return RelOptUtil.createSingleValueAggRel(this.cluster, plan);
    }

    private RexNode convertInToOr(final Blackboard bb, final RexNode[] leftKeys, SqlNodeList valuesList, boolean isNotIn) {
        ArrayList<RexNode> comparisons = new ArrayList<RexNode>();
        for (SqlNode rightVals : valuesList) {
            RexNode rexComparison = null;
            if (leftKeys.length == 1) {
                rexComparison = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, leftKeys[0], bb.convertExpression(rightVals));
            } else {
                assert (rightVals instanceof SqlCall);
                final SqlBasicCall call = (SqlBasicCall)rightVals;
                assert (call.getOperator() instanceof SqlRowOperator && call.getOperands().length == leftKeys.length);
                rexComparison = RexUtil.composeConjunction(this.rexBuilder, RexUtil.generate(leftKeys.length, new Function1<Integer, RexNode>(){

                    public RexNode apply(Integer i) {
                        return SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, leftKeys[i], bb.convertExpression(call.getOperands()[i]));
                    }
                }), false);
            }
            comparisons.add(rexComparison);
        }
        RexNode result = RexUtil.composeDisjunction(this.rexBuilder, comparisons, true);
        assert (result != null);
        if (isNotIn) {
            result = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, result);
        }
        return result;
    }

    protected int getInSubqueryThreshold() {
        return 200;
    }

    private RexNode createJoinConditionForIn(Blackboard bb, List<RexNode> leftKeys, RelNode rightRel) {
        ArrayList<RexNode> joinConditions = new ArrayList<RexNode>();
        int rightInputOffset = bb.root.getRowType().getFieldCount();
        List<RelDataTypeField> rightTypeFields = rightRel.getRowType().getFieldList();
        assert (leftKeys.size() <= rightTypeFields.size());
        for (Ord key : Ord.zip(leftKeys)) {
            joinConditions.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, (RexNode)key.e, this.rexBuilder.makeInputRef(rightTypeFields.get(key.i).getType(), rightInputOffset + key.i)));
        }
        return RexUtil.composeConjunction(this.rexBuilder, joinConditions, true);
    }

    private RelNode convertExists(SqlNode seek, boolean isIn, boolean isExists, boolean needsOuterJoin) {
        assert (!isIn || !isExists);
        SqlValidatorScope seekScope = seek instanceof SqlSelect ? this.validator.getSelectScope((SqlSelect)seek) : null;
        Blackboard seekBb = this.createBlackboard(seekScope, null);
        RelNode seekRel = this.convertQueryOrInList(seekBb, seek);
        return RelOptUtil.createExistsPlan(this.cluster, seekRel, isIn, isExists, needsOuterJoin);
    }

    private RelNode convertQueryOrInList(Blackboard bb, SqlNode seek) {
        if (seek instanceof SqlNodeList) {
            return this.convertRowValues(bb, seek, ((SqlNodeList)seek).getList(), false, null);
        }
        return this.convertQueryRecursive(seek, false, null);
    }

    private RelNode convertRowValues(Blackboard bb, SqlNode rowList, Collection<SqlNode> rows, boolean allowLiteralsOnly, RelDataType targetRowType) {
        AbstractRelNode resultRel;
        ArrayList<List<RexLiteral>> tupleList = new ArrayList<List<RexLiteral>>();
        RelDataType rowType = targetRowType != null ? targetRowType : SqlTypeUtil.promoteToRowType(this.typeFactory, this.validator.getValidatedNodeType(rowList), null);
        ArrayList<RelNode> unionInputs = new ArrayList<RelNode>();
        for (SqlNode node : rows) {
            SqlBasicCall call;
            if (this.isRowConstructor(node)) {
                call = (SqlBasicCall)node;
                ArrayList<RexLiteral> tuple = new ArrayList<RexLiteral>();
                for (SqlNode operand : call.operands) {
                    RexLiteral rexLiteral = this.convertLiteralInValuesList(operand, bb, rowType, tuple.size());
                    if (rexLiteral == null && allowLiteralsOnly) {
                        return null;
                    }
                    if (rexLiteral == null || !this.shouldCreateValuesRel) {
                        tuple = null;
                        break;
                    }
                    tuple.add(rexLiteral);
                }
                if (tuple != null) {
                    tupleList.add(tuple);
                    continue;
                }
            } else {
                RexLiteral rexLiteral = this.convertLiteralInValuesList(node, bb, rowType, 0);
                if (rexLiteral != null && this.shouldCreateValuesRel) {
                    tupleList.add(Collections.singletonList(rexLiteral));
                    continue;
                }
                if (rexLiteral == null && allowLiteralsOnly) {
                    return null;
                }
                call = (SqlBasicCall)SqlStdOperatorTable.ROW.createCall(SqlParserPos.ZERO, node);
            }
            unionInputs.add(this.convertRowConstructor(bb, call));
        }
        ValuesRel valuesRel = new ValuesRel(this.cluster, rowType, tupleList);
        if (unionInputs.isEmpty()) {
            resultRel = valuesRel;
        } else {
            if (!tupleList.isEmpty()) {
                unionInputs.add(valuesRel);
            }
            UnionRel unionRel = new UnionRel(this.cluster, unionInputs, true);
            resultRel = unionRel;
        }
        this.leaves.add(resultRel);
        return resultRel;
    }

    private RexLiteral convertLiteralInValuesList(SqlNode sqlNode, Blackboard bb, RelDataType rowType, int iField) {
        if (!(sqlNode instanceof SqlLiteral)) {
            return null;
        }
        RelDataTypeField field = rowType.getFieldList().get(iField);
        RelDataType type = field.getType();
        if (type.isStruct()) {
            return null;
        }
        RexNode literalExpr = this.exprConverter.convertLiteral(bb, (SqlLiteral)sqlNode);
        if (!(literalExpr instanceof RexLiteral)) {
            assert (literalExpr.isA(SqlKind.CAST));
            RexNode child = ((RexCall)literalExpr).getOperands().get(0);
            assert (RexLiteral.isNullLiteral(child));
            return (RexLiteral)child;
        }
        RexLiteral literal = (RexLiteral)literalExpr;
        Comparable value = literal.getValue();
        if (SqlTypeUtil.isExactNumeric(type)) {
            BigDecimal roundedValue = NumberUtil.rescaleBigDecimal((BigDecimal)value, type.getScale());
            return this.rexBuilder.makeExactLiteral(roundedValue, type);
        }
        if (value instanceof NlsString && type.getSqlTypeName() == SqlTypeName.CHAR) {
            NlsString unpadded = (NlsString)value;
            return this.rexBuilder.makeCharLiteral(new NlsString(Util.rpad(unpadded.getValue(), type.getPrecision()), unpadded.getCharsetName(), unpadded.getCollation()));
        }
        return literal;
    }

    private boolean isRowConstructor(SqlNode node) {
        if (node.getKind() != SqlKind.ROW) {
            return false;
        }
        SqlCall call = (SqlCall)node;
        return call.getOperator().getName().equalsIgnoreCase("row");
    }

    private void findSubqueries(Blackboard bb, SqlNode node, boolean registerOnlyScalarSubqueries) {
        SqlKind kind = node.getKind();
        switch (kind) {
            case CURSOR: 
            case MULTISET_QUERY_CONSTRUCTOR: 
            case MULTISET_VALUE_CONSTRUCTOR: 
            case EXISTS: 
            case SCALAR_QUERY: 
            case SELECT: {
                if (!registerOnlyScalarSubqueries || kind == SqlKind.SCALAR_QUERY) {
                    bb.registerSubquery(node);
                }
                return;
            }
        }
        if (node instanceof SqlCall) {
            if (kind == SqlKind.OR || kind == SqlKind.NOT) {
                bb.subqueryNeedsOuterJoin = true;
            }
            for (SqlNode operand : ((SqlCall)node).getOperandList()) {
                if (operand == null) continue;
                this.findSubqueries(bb, operand, kind == SqlKind.IN || registerOnlyScalarSubqueries);
            }
        } else if (node instanceof SqlNodeList) {
            SqlNodeList nodes = (SqlNodeList)node;
            for (int i = 0; i < nodes.size(); ++i) {
                SqlNode child = nodes.get(i);
                this.findSubqueries(bb, child, kind == SqlKind.IN || registerOnlyScalarSubqueries);
            }
        }
        if (kind == SqlKind.IN) {
            bb.registerSubquery(node);
        }
    }

    public RexNode convertExpression(SqlNode node) {
        Map<String, RelDataType> nameToTypeMap = Collections.emptyMap();
        Blackboard bb = this.createBlackboard(new ParameterScope((SqlValidatorImpl)this.validator, nameToTypeMap), null);
        return bb.convertExpression(node);
    }

    public RexNode convertExpression(SqlNode node, Map<String, RexNode> nameToNodeMap) {
        HashMap<String, RelDataType> nameToTypeMap = new HashMap<String, RelDataType>();
        for (Map.Entry<String, RexNode> entry : nameToNodeMap.entrySet()) {
            nameToTypeMap.put(entry.getKey(), entry.getValue().getType());
        }
        Blackboard bb = this.createBlackboard(new ParameterScope((SqlValidatorImpl)this.validator, nameToTypeMap), nameToNodeMap);
        return bb.convertExpression(node);
    }

    protected RexNode convertExtendedExpression(SqlNode node, Blackboard bb) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RexNode convertOver(Blackboard bb, SqlNode node) {
        SqlCall call = (SqlCall)node;
        SqlCall aggCall = (SqlCall)call.operand(0);
        Object windowOrRef = call.operand(1);
        SqlWindow window = this.validator.resolveWindow((SqlNode)windowOrRef, bb.scope, true);
        SqlNodeList partitionList = window.getPartitionList();
        ImmutableList.Builder partitionKeys = ImmutableList.builder();
        for (SqlNode partition : partitionList) {
            partitionKeys.add((Object)bb.convertExpression(partition));
        }
        RexNode lowerBound = bb.convertExpression(window.getLowerBound());
        RexNode upperBound = bb.convertExpression(window.getUpperBound());
        SqlNodeList orderList = window.getOrderList();
        if (orderList.size() == 0 && !window.isRows() && (orderList = bb.scope.getOrderList()) == null) {
            throw new AssertionError((Object)"Relation should have sort key for implicit ORDER BY");
        }
        ImmutableList.Builder orderKeys = ImmutableList.builder();
        EnumSet<SqlKind> flags = EnumSet.noneOf(SqlKind.class);
        for (SqlNode order : orderList) {
            flags.clear();
            RexNode e = bb.convertSortExpression(order, flags);
            orderKeys.add((Object)new RexFieldCollation(e, (Set<SqlKind>)flags));
        }
        try {
            Util.permAssert(bb.window == null, "already in window agg mode");
            bb.window = window;
            RexNode rexAgg = this.exprConverter.convertCall(bb, aggCall);
            rexAgg = this.rexBuilder.ensureType(this.validator.getValidatedNodeType(call), rexAgg, false);
            HistogramShuttle visitor = new HistogramShuttle((List<RexNode>)partitionKeys.build(), (ImmutableList<RexFieldCollation>)orderKeys.build(), RexWindowBound.create(window.getLowerBound(), lowerBound), RexWindowBound.create(window.getUpperBound(), upperBound), window);
            RexNode rexNode = rexAgg.accept(visitor);
            return rexNode;
        }
        finally {
            bb.window = null;
        }
    }

    protected void convertFrom(Blackboard bb, SqlNode from) {
        switch (from.getKind()) {
            case AS: {
                SqlNode[] operands = ((SqlBasicCall)from).getOperands();
                this.convertFrom(bb, operands[0]);
                return;
            }
            case WITH_ITEM: {
                this.convertFrom(bb, ((SqlWithItem)from).query);
                return;
            }
            case WITH: {
                this.convertFrom(bb, ((SqlWith)from).body);
                return;
            }
            case TABLESAMPLE: {
                SqlNode[] operands = ((SqlBasicCall)from).getOperands();
                SqlSampleSpec sampleSpec = SqlLiteral.sampleValue(operands[1]);
                if (sampleSpec instanceof SqlSampleSpec.SqlSubstitutionSampleSpec) {
                    String sampleName = ((SqlSampleSpec.SqlSubstitutionSampleSpec)sampleSpec).getName();
                    this.datasetStack.push(sampleName);
                    this.convertFrom(bb, operands[0]);
                    this.datasetStack.pop();
                } else if (sampleSpec instanceof SqlSampleSpec.SqlTableSampleSpec) {
                    SqlSampleSpec.SqlTableSampleSpec tableSampleSpec = (SqlSampleSpec.SqlTableSampleSpec)sampleSpec;
                    this.convertFrom(bb, operands[0]);
                    RelOptSamplingParameters params = new RelOptSamplingParameters(tableSampleSpec.isBernoulli(), tableSampleSpec.getSamplePercentage(), tableSampleSpec.isRepeatable(), tableSampleSpec.getRepeatableSeed());
                    bb.setRoot(new SamplingRel(this.cluster, bb.root, params), false);
                } else {
                    throw Util.newInternal("unknown TABLESAMPLE type: " + sampleSpec);
                }
                return;
            }
            case IDENTIFIER: {
                SqlValidatorNamespace fromNamespace = this.validator.getNamespace(from).resolve();
                if (fromNamespace.getNode() != null) {
                    this.convertFrom(bb, fromNamespace.getNode());
                    return;
                }
                String datasetName = this.datasetStack.isEmpty() ? null : this.datasetStack.peek();
                boolean[] usedDataset = new boolean[]{false};
                RelOptTable table = SqlValidatorUtil.getRelOptTable(fromNamespace, this.catalogReader, datasetName, usedDataset);
                RelNode tableRel = this.shouldConvertTableAccess ? this.toRel(table) : new TableAccessRel(this.cluster, table);
                bb.setRoot(tableRel, true);
                if (usedDataset[0]) {
                    bb.setDataset(datasetName);
                }
                return;
            }
            case JOIN: {
                RexNode conditionExp;
                SqlJoin join = (SqlJoin)from;
                Blackboard fromBlackboard = this.createBlackboard(this.validator.getJoinScope(from), null);
                SqlNode left = join.getLeft();
                SqlNode right = join.getRight();
                boolean isNatural = join.isNatural();
                JoinType joinType = join.getJoinType();
                Blackboard leftBlackboard = this.createBlackboard(Util.first(this.validator.getJoinScope(left), ((DelegatingScope)bb.scope).getParent()), null);
                Blackboard rightBlackboard = this.createBlackboard(Util.first(this.validator.getJoinScope(right), ((DelegatingScope)bb.scope).getParent()), null);
                this.convertFrom(leftBlackboard, left);
                RelNode leftRel = leftBlackboard.root;
                this.convertFrom(rightBlackboard, right);
                RelNode rightRel = rightBlackboard.root;
                JoinRelType convertedJoinType = SqlToRelConverter.convertJoinType(joinType);
                if (isNatural) {
                    List<String> columnList = SqlValidatorUtil.deriveNaturalJoinColumnList(this.validator.getNamespace(left).getRowType(), this.validator.getNamespace(right).getRowType());
                    conditionExp = this.convertUsing(leftRel, rightRel, columnList);
                } else {
                    conditionExp = this.convertJoinCondition(fromBlackboard, join.getCondition(), join.getConditionType(), leftRel, rightRel);
                }
                RelNode joinRel = this.createJoin(fromBlackboard, leftRel, rightRel, conditionExp, convertedJoinType);
                bb.setRoot(joinRel, false);
                return;
            }
            case SELECT: 
            case INTERSECT: 
            case EXCEPT: 
            case UNION: {
                RelNode rel = this.convertQueryRecursive(from, false, null);
                bb.setRoot(rel, true);
                return;
            }
            case VALUES: {
                this.convertValuesImpl(bb, (SqlCall)from, null);
                return;
            }
            case UNNEST: {
                Object node = ((SqlCall)from).operand(0);
                this.replaceSubqueries(bb, (SqlNode)node);
                RelNode childRel = CalcRel.createProject(null != bb.root ? bb.root : new OneRowRel(this.cluster), Collections.singletonList(bb.convertExpression((SqlNode)node)), Collections.singletonList(this.validator.deriveAlias((SqlNode)node, 0)), true);
                UncollectRel uncollectRel = new UncollectRel(this.cluster, this.cluster.traitSetOf(Convention.NONE), childRel);
                bb.setRoot(uncollectRel, true);
                return;
            }
            case COLLECTION_TABLE: {
                SqlCall call = (SqlCall)from;
                assert (call.getOperandList().size() == 1);
                call = (SqlCall)call.operand(0);
                this.convertCollectionTable(bb, call);
                return;
            }
        }
        throw Util.newInternal("not a join operator " + from);
    }

    protected void convertCollectionTable(Blackboard bb, SqlCall call) {
        Type elementType;
        SqlOperator operator = call.getOperator();
        if (operator == SqlStdOperatorTable.TABLESAMPLE) {
            String sampleName = SqlLiteral.stringValue(call.operand(0));
            this.datasetStack.push(sampleName);
            SqlCall cursorCall = (SqlCall)call.operand(1);
            Object query = cursorCall.operand(0);
            RelNode converted = this.convertQuery((SqlNode)query, false, false);
            bb.setRoot(converted, false);
            this.datasetStack.pop();
            return;
        }
        this.replaceSubqueries(bb, call);
        if (operator instanceof SqlUserDefinedTableMacro) {
            SqlUserDefinedTableMacro udf = (SqlUserDefinedTableMacro)operator;
            TranslatableTable table = udf.getTable(this.typeFactory, call.getOperandList());
            RelDataType rowType = table.getRowType(this.typeFactory);
            RelOptTableImpl relOptTable = RelOptTableImpl.create(null, rowType, table);
            RelNode converted = this.toRel(relOptTable);
            bb.setRoot(converted, true);
            return;
        }
        if (operator instanceof SqlUserDefinedTableFunction) {
            SqlUserDefinedTableFunction udtf = (SqlUserDefinedTableFunction)operator;
            elementType = udtf.getElementType(this.typeFactory, call.getOperandList());
        } else {
            elementType = null;
        }
        RexNode rexCall = bb.convertExpression(call);
        ImmutableList<RelNode> inputs = bb.retrieveCursors();
        Set<RelColumnMapping> columnMappings = this.getColumnMappings(operator);
        TableFunctionRel callRel = new TableFunctionRel(this.cluster, (List<RelNode>)inputs, rexCall, elementType, this.validator.getValidatedNodeType(call), columnMappings);
        bb.setRoot(callRel, true);
        this.afterTableFunction(bb, call, callRel);
    }

    protected void afterTableFunction(Blackboard bb, SqlCall call, TableFunctionRel callRel) {
    }

    private Set<RelColumnMapping> getColumnMappings(SqlOperator op) {
        SqlReturnTypeInference rti = op.getReturnTypeInference();
        if (rti == null) {
            return null;
        }
        if (rti instanceof TableFunctionReturnTypeInference) {
            TableFunctionReturnTypeInference tfrti = (TableFunctionReturnTypeInference)rti;
            return tfrti.getColumnMappings();
        }
        return null;
    }

    protected RelNode createJoin(Blackboard bb, RelNode leftRel, RelNode rightRel, RexNode joinCond, JoinRelType joinType) {
        Set<String> correlatedVariables = RelOptUtil.getVariablesUsed(rightRel);
        if (joinCond == null) {
            joinCond = this.rexBuilder.makeLiteral(true);
        }
        if (correlatedVariables.size() > 0) {
            ArrayList<CorrelatorRel.Correlation> correlations = new ArrayList<CorrelatorRel.Correlation>();
            for (String correlName : correlatedVariables) {
                DeferredLookup lookup = this.mapCorrelToDeferred.get(correlName);
                RexFieldAccess fieldAccess = lookup.getFieldAccess(correlName);
                String originalRelName = lookup.getOriginalRelName();
                String originalFieldName = fieldAccess.getField().getName();
                int[] nsIndexes = new int[]{-1};
                SqlValidatorScope[] ancestorScopes = new SqlValidatorScope[]{null};
                SqlValidatorNamespace foundNs = lookup.bb.scope.resolve(originalRelName, ancestorScopes, nsIndexes);
                assert (foundNs != null);
                assert (nsIndexes.length == 1);
                int childNamespaceIndex = nsIndexes[0];
                SqlValidatorScope ancestorScope = ancestorScopes[0];
                boolean correlInCurrentScope = ancestorScope == bb.scope;
                if (!correlInCurrentScope) continue;
                int namespaceOffset = 0;
                if (childNamespaceIndex > 0) {
                    assert (ancestorScope instanceof ListScope);
                    List<SqlValidatorNamespace> children = ((ListScope)ancestorScope).getChildren();
                    for (int i = 0; i < childNamespaceIndex; ++i) {
                        SqlValidatorNamespace child = children.get(i);
                        namespaceOffset += child.getRowType().getFieldCount();
                    }
                }
                RelDataTypeField field = this.catalogReader.field(foundNs.getRowType(), originalFieldName);
                int pos = namespaceOffset + field.getIndex();
                assert (field.getType() == lookup.getFieldAccess(correlName).getField().getType());
                assert (pos != -1);
                if (bb.mapRootRelToFieldProjection.containsKey(bb.root)) {
                    Map exprProjection = (Map)bb.mapRootRelToFieldProjection.get(bb.root);
                    if (exprProjection.containsKey(pos)) {
                        pos = (Integer)exprProjection.get(pos);
                    } else {
                        throw Util.newInternal("Identifier '" + originalRelName + "." + originalFieldName + "' is not a group expr");
                    }
                }
                CorrelatorRel.Correlation newCorVar = new CorrelatorRel.Correlation(this.getCorrelOrdinal(correlName), pos);
                correlations.add(newCorVar);
                this.mapFieldAccessToCorVar.put(fieldAccess, newCorVar);
                RelNode refRel = this.mapCorrelToRefRel.get(correlName);
                SortedSet<CorrelatorRel.Correlation> corVarList = !this.mapRefRelToCorVar.containsKey(refRel) ? new TreeSet<CorrelatorRel.Correlation>() : this.mapRefRelToCorVar.get(refRel);
                corVarList.add(newCorVar);
                this.mapRefRelToCorVar.put(refRel, corVarList);
            }
            if (!correlations.isEmpty()) {
                CorrelatorRel rel = new CorrelatorRel(rightRel.getCluster(), leftRel, rightRel, joinCond, correlations, joinType);
                for (CorrelatorRel.Correlation correlation : correlations) {
                    this.mapCorVarToCorRel.put(correlation, rel);
                }
                return rel;
            }
        }
        return RelOptUtil.pushExpInEqualJoinCondIntoProj(this.cluster, joinCond, joinType, leftRel, rightRel);
    }

    private static boolean containsGet(RexNode node) {
        try {
            node.accept(new RexVisitorImpl<Void>(true){

                @Override
                public Void visitCall(RexCall call) {
                    if (call.getOperator() == RexBuilder.GET_OPERATOR) {
                        throw Util.FoundOne.NULL;
                    }
                    return (Void)super.visitCall(call);
                }
            });
            return false;
        }
        catch (Util.FoundOne e) {
            return true;
        }
    }

    private boolean isSubqNonCorrelated(RelNode subq, Blackboard bb) {
        Set<String> correlatedVariables = RelOptUtil.getVariablesUsed(subq);
        for (String correlName : correlatedVariables) {
            DeferredLookup lookup = this.mapCorrelToDeferred.get(correlName);
            String originalRelName = lookup.getOriginalRelName();
            int[] nsIndexes = new int[]{-1};
            SqlValidatorScope[] ancestorScopes = new SqlValidatorScope[]{null};
            SqlValidatorNamespace foundNs = lookup.bb.scope.resolve(originalRelName, ancestorScopes, nsIndexes);
            assert (foundNs != null);
            assert (nsIndexes.length == 1);
            SqlValidatorScope ancestorScope = ancestorScopes[0];
            SqlValidatorScope parentScope = bb.scope;
            do {
                if (ancestorScope != parentScope) continue;
                return false;
            } while (parentScope instanceof DelegatingScope && (parentScope = ((DelegatingScope)parentScope).getParent()) != null);
        }
        return true;
    }

    protected List<RelDataTypeField> getSystemFields() {
        return Collections.emptyList();
    }

    private RexNode convertJoinCondition(Blackboard bb, SqlNode condition, JoinConditionType conditionType, RelNode leftRel, RelNode rightRel) {
        if (condition == null) {
            return this.rexBuilder.makeLiteral(true);
        }
        bb.setRoot((List<RelNode>)ImmutableList.of((Object)leftRel, (Object)rightRel));
        this.replaceSubqueries(bb, condition);
        switch (conditionType) {
            case ON: {
                bb.setRoot((List<RelNode>)ImmutableList.of((Object)leftRel, (Object)rightRel));
                return bb.convertExpression(condition);
            }
            case USING: {
                SqlNodeList list = (SqlNodeList)condition;
                ArrayList<String> nameList = new ArrayList<String>();
                for (SqlNode columnName : list) {
                    SqlIdentifier id = (SqlIdentifier)columnName;
                    String name = id.getSimple();
                    nameList.add(name);
                }
                return this.convertUsing(leftRel, rightRel, nameList);
            }
        }
        throw Util.unexpected(conditionType);
    }

    private RexNode convertUsing(RelNode leftRel, RelNode rightRel, List<String> nameList) {
        RexNode conditionExp = null;
        for (String name : nameList) {
            RelDataType leftRowType = leftRel.getRowType();
            RelDataTypeField leftField = this.catalogReader.field(leftRowType, name);
            RexInputRef left = this.rexBuilder.makeInputRef(leftField.getType(), leftField.getIndex());
            RelDataType rightRowType = rightRel.getRowType();
            RelDataTypeField rightField = this.catalogReader.field(rightRowType, name);
            RexInputRef right = this.rexBuilder.makeInputRef(rightField.getType(), leftRowType.getFieldList().size() + rightField.getIndex());
            RexNode equalsCall = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, left, right);
            if (conditionExp == null) {
                conditionExp = equalsCall;
                continue;
            }
            conditionExp = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, conditionExp, equalsCall);
        }
        return conditionExp;
    }

    private static JoinRelType convertJoinType(JoinType joinType) {
        switch (joinType) {
            case COMMA: 
            case INNER: 
            case CROSS: {
                return JoinRelType.INNER;
            }
            case FULL: {
                return JoinRelType.FULL;
            }
            case LEFT: {
                return JoinRelType.LEFT;
            }
            case RIGHT: {
                return JoinRelType.RIGHT;
            }
        }
        throw Util.unexpected(joinType);
    }

    protected void convertAgg(Blackboard bb, SqlSelect select, List<SqlNode> orderExprList) {
        assert (bb.root != null) : "precondition: child != null";
        SqlNodeList groupList = select.getGroup();
        SqlNodeList selectList = select.getSelectList();
        SqlNode having = select.getHaving();
        AggConverter aggConverter = new AggConverter(bb, select);
        this.createAggImpl(bb, aggConverter, selectList, groupList, having, orderExprList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void createAggImpl(Blackboard bb, AggConverter aggConverter, SqlNodeList selectList, SqlNodeList groupList, SqlNode having, List<SqlNode> orderExprList) {
        SqlNodeList aggList = new SqlNodeList(SqlParserPos.ZERO);
        for (SqlNode selectNode : selectList) {
            if (!this.validator.isAggregate(selectNode)) continue;
            aggList.add(selectNode);
        }
        this.replaceSubqueries(bb, aggList);
        if (groupList == null) {
            groupList = SqlNodeList.EMPTY;
        }
        HashMap<Integer, Integer> groupExprProjection = new HashMap<Integer, Integer>();
        int i = -1;
        for (SqlNode groupExpr : groupList) {
            ++i;
            SqlNode expandedGroupExpr = this.validator.expand(groupExpr, bb.scope);
            aggConverter.addGroupExpr(expandedGroupExpr);
            if (!(expandedGroupExpr instanceof SqlIdentifier)) continue;
            SqlIdentifier expr = (SqlIdentifier)expandedGroupExpr;
            assert (expr.names.size() == 2);
            String originalRelName = (String)expr.names.get(0);
            String originalFieldName = (String)expr.names.get(1);
            int[] nsIndexes = new int[]{-1};
            SqlValidatorScope[] ancestorScopes = new SqlValidatorScope[]{null};
            SqlValidatorNamespace foundNs = bb.scope.resolve(originalRelName, ancestorScopes, nsIndexes);
            assert (foundNs != null);
            assert (nsIndexes.length == 1);
            int childNamespaceIndex = nsIndexes[0];
            int namespaceOffset = 0;
            if (childNamespaceIndex > 0) {
                assert (ancestorScopes[0] instanceof ListScope);
                List<SqlValidatorNamespace> children = ((ListScope)ancestorScopes[0]).getChildren();
                for (int j = 0; j < childNamespaceIndex; ++j) {
                    namespaceOffset += children.get(j).getRowType().getFieldCount();
                }
            }
            RelDataTypeField field = this.catalogReader.field(foundNs.getRowType(), originalFieldName);
            int origPos = namespaceOffset + field.getIndex();
            groupExprProjection.put(origPos, i);
        }
        RexNode havingExpr = null;
        ArrayList<RexNode> selectExprs = new ArrayList<RexNode>();
        ArrayList<String> selectNames = new ArrayList<String>();
        try {
            Util.permAssert(bb.agg == null, "already in agg mode");
            bb.agg = aggConverter;
            selectList.accept(aggConverter);
            for (SqlNode expr : orderExprList) {
                expr.accept(aggConverter);
            }
            if (having != null) {
                having.accept(aggConverter);
            }
            List<RexNode> preExprs = aggConverter.getPreExprs();
            List<String> preNames = aggConverter.getPreNames();
            if (preExprs.size() == 0) {
                preExprs = Collections.singletonList(this.rexBuilder.makeExactLiteral(BigDecimal.ZERO));
                preNames = Collections.singletonList(null);
            }
            RelNode inputRel = bb.root;
            Set<String> correlatedVariablesBefore = RelOptUtil.getVariablesUsed(inputRel);
            bb.setRoot(CalcRel.createProject(inputRel, preExprs, preNames, true), false);
            bb.mapRootRelToFieldProjection.put(bb.root, groupExprProjection);
            Set<String> correlatedVariables = RelOptUtil.getVariablesUsed(bb.root);
            correlatedVariables.removeAll(correlatedVariablesBefore);
            for (String correl : correlatedVariables) {
                this.mapCorrelToRefRel.put(correl, bb.root);
            }
            bb.columnMonotonicities.clear();
            for (SqlNode groupItem : groupList) {
                bb.columnMonotonicities.add(bb.scope.getMonotonicity(groupItem));
            }
            bb.setRoot(this.createAggregate(bb, BitSets.range(aggConverter.groupExprs.size()), aggConverter.getAggCalls()), false);
            bb.mapRootRelToFieldProjection.put(bb.root, groupExprProjection);
            if (having != null) {
                SqlNode newHaving = SqlToRelConverter.pushDownNotForIn(having);
                this.replaceSubqueries(bb, newHaving);
                havingExpr = bb.convertExpression(newHaving);
                if (havingExpr.isAlwaysTrue()) {
                    havingExpr = null;
                }
            }
            this.replaceSubqueries(bb, selectList);
            int k = 0;
            SelectScope selectScope = SqlValidatorUtil.getEnclosingSelectScope(bb.scope);
            SqlValidatorNamespace selectNamespace = this.validator.getNamespace(selectScope.getNode());
            List<String> names = selectNamespace.getRowType().getFieldNames();
            int sysFieldCount = selectList.size() - names.size();
            for (SqlNode expr : selectList) {
                selectExprs.add(bb.convertExpression(expr));
                selectNames.add(k < sysFieldCount ? this.validator.deriveAlias(expr, k++) : names.get(k++ - sysFieldCount));
            }
            for (SqlNode expr : orderExprList) {
                selectExprs.add(bb.convertExpression(expr));
                selectNames.add(this.validator.deriveAlias(expr, k++));
            }
        }
        finally {
            bb.agg = null;
        }
        if (havingExpr != null) {
            bb.setRoot(CalcRel.createFilter(bb.root, havingExpr), false);
        }
        bb.setRoot(CalcRel.createProject(bb.root, selectExprs, selectNames, true), false);
        bb.columnMonotonicities.clear();
        for (SqlNode selectItem : selectList) {
            bb.columnMonotonicities.add(bb.scope.getMonotonicity(selectItem));
        }
    }

    protected RelNode createAggregate(Blackboard bb, BitSet groupSet, List<AggregateCall> aggCalls) {
        return new AggregateRel(this.cluster, bb.root, groupSet, aggCalls);
    }

    public RexDynamicParam convertDynamicParam(SqlDynamicParam dynamicParam) {
        while (dynamicParam.getIndex() >= this.dynamicParamSqlNodes.size()) {
            this.dynamicParamSqlNodes.add(null);
        }
        this.dynamicParamSqlNodes.set(dynamicParam.getIndex(), dynamicParam);
        return this.rexBuilder.makeDynamicParam(this.getDynamicParamType(dynamicParam.getIndex()), dynamicParam.getIndex());
    }

    protected void gatherOrderExprs(Blackboard bb, SqlSelect select, SqlNodeList orderList, List<SqlNode> extraOrderExprs, List<RelFieldCollation> collationList) {
        assert (bb.root != null) : "precondition: child != null";
        assert (select != null);
        if (orderList == null) {
            return;
        }
        for (SqlNode orderItem : orderList) {
            collationList.add(this.convertOrderItem(select, orderItem, extraOrderExprs, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.UNSPECIFIED));
        }
    }

    protected RelFieldCollation convertOrderItem(SqlSelect select, SqlNode orderItem, List<SqlNode> extraExprs, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection) {
        assert (select != null);
        switch (orderItem.getKind()) {
            case DESCENDING: {
                return this.convertOrderItem(select, (SqlNode)((SqlCall)orderItem).operand(0), extraExprs, RelFieldCollation.Direction.DESCENDING, nullDirection);
            }
            case NULLS_FIRST: {
                return this.convertOrderItem(select, (SqlNode)((SqlCall)orderItem).operand(0), extraExprs, direction, RelFieldCollation.NullDirection.FIRST);
            }
            case NULLS_LAST: {
                return this.convertOrderItem(select, (SqlNode)((SqlCall)orderItem).operand(0), extraExprs, direction, RelFieldCollation.NullDirection.LAST);
            }
        }
        SqlNode converted = this.validator.expandOrderExpr(select, orderItem);
        SelectScope selectScope = this.validator.getRawSelectScope(select);
        int ordinal = -1;
        for (SqlNode selectItem : selectScope.getExpandedSelectList()) {
            ++ordinal;
            if (!converted.equalsDeep(SqlUtil.stripAs(selectItem), false)) continue;
            return new RelFieldCollation(ordinal, direction, nullDirection);
        }
        for (SqlNode extraExpr : extraExprs) {
            ++ordinal;
            if (!converted.equalsDeep(extraExpr, false)) continue;
            return new RelFieldCollation(ordinal, direction, nullDirection);
        }
        extraExprs.add(converted);
        return new RelFieldCollation(ordinal + 1, direction, nullDirection);
    }

    protected boolean enableDecorrelation() {
        return this.decorrelationEnabled;
    }

    public boolean hasCorrelation() {
        return !this.mapCorVarToCorRel.isEmpty();
    }

    protected RelNode decorrelateQuery(RelNode rootRel) {
        RelDecorrelator decorrelator = new RelDecorrelator(this.rexBuilder, this.mapRefRelToCorVar, this.mapCorVarToCorRel, this.mapFieldAccessToCorVar, this.cluster.getPlanner().getContext());
        boolean dumpPlan = SQL2REL_LOGGER.isLoggable(Level.FINE);
        RelNode newRootRel = decorrelator.removeCorrelationViaRule(rootRel);
        if (dumpPlan) {
            SQL2REL_LOGGER.fine(RelOptUtil.dumpPlan("Plan after removing CorrelatorRel", newRootRel, false, SqlExplainLevel.EXPPLAN_ATTRIBUTES));
        }
        if (!this.mapCorVarToCorRel.isEmpty()) {
            newRootRel = decorrelator.decorrelate(newRootRel);
        }
        return newRootRel;
    }

    public void setTrimUnusedFields(boolean trim) {
        this.trimUnusedFields = trim;
    }

    public boolean isTrimUnusedFields() {
        return this.trimUnusedFields;
    }

    protected RelNode convertQueryRecursive(SqlNode query, boolean top, RelDataType targetRowType) {
        switch (query.getKind()) {
            case SELECT: {
                return this.convertSelect((SqlSelect)query);
            }
            case INSERT: {
                return this.convertInsert((SqlInsert)query);
            }
            case DELETE: {
                return this.convertDelete((SqlDelete)query);
            }
            case UPDATE: {
                return this.convertUpdate((SqlUpdate)query);
            }
            case MERGE: {
                return this.convertMerge((SqlMerge)query);
            }
            case INTERSECT: 
            case EXCEPT: 
            case UNION: {
                return this.convertSetOp((SqlCall)query);
            }
            case WITH: {
                return this.convertWith((SqlWith)query);
            }
            case VALUES: {
                return this.convertValues((SqlCall)query, targetRowType);
            }
        }
        throw Util.newInternal("not a query: " + query);
    }

    protected RelNode convertSetOp(SqlCall call) {
        RelNode left = this.convertQueryRecursive((SqlNode)call.operand(0), false, null);
        RelNode right = this.convertQueryRecursive((SqlNode)call.operand(1), false, null);
        boolean all = false;
        if (call.getOperator() instanceof SqlSetOperator) {
            all = ((SqlSetOperator)call.getOperator()).isAll();
        }
        switch (call.getKind()) {
            case UNION: {
                return new UnionRel(this.cluster, (List<RelNode>)ImmutableList.of((Object)left, (Object)right), all);
            }
            case INTERSECT: {
                if (!all) {
                    return new IntersectRel(this.cluster, (List<RelNode>)ImmutableList.of((Object)left, (Object)right), all);
                }
                throw Util.newInternal("set operator INTERSECT ALL not suported");
            }
            case EXCEPT: {
                if (!all) {
                    return new MinusRel(this.cluster, (List<RelNode>)ImmutableList.of((Object)left, (Object)right), all);
                }
                throw Util.newInternal("set operator EXCEPT ALL not suported");
            }
        }
        throw Util.unexpected(call.getKind());
    }

    protected RelNode convertInsert(SqlInsert call) {
        RelOptTable targetTable = this.getTargetTable(call);
        RelDataType targetRowType = this.validator.getValidatedNodeType(call);
        assert (targetRowType != null);
        RelNode sourceRel = this.convertQueryRecursive(call.getSource(), false, targetRowType);
        RelNode massagedRel = this.convertColumnList(call, sourceRel);
        ModifiableTable modifiableTable = targetTable.unwrap(ModifiableTable.class);
        if (modifiableTable != null) {
            return modifiableTable.toModificationRel(this.cluster, targetTable, this.catalogReader, massagedRel, TableModificationRelBase.Operation.INSERT, null, false);
        }
        return new TableModificationRel(this.cluster, targetTable, this.catalogReader, massagedRel, TableModificationRelBase.Operation.INSERT, null, false);
    }

    private RelOptTable.ToRelContext createToRelContext() {
        return new RelOptTable.ToRelContext(){

            @Override
            public RelOptCluster getCluster() {
                return SqlToRelConverter.this.cluster;
            }

            @Override
            public RelNode expandView(RelDataType rowType, String queryString, List<String> schemaPath) {
                return SqlToRelConverter.this.viewExpander.expandView(rowType, queryString, schemaPath);
            }
        };
    }

    public RelNode toRel(RelOptTable table) {
        return table.toRel(this.createToRelContext());
    }

    protected RelOptTable getTargetTable(SqlNode call) {
        SqlValidatorNamespace targetNs = this.validator.getNamespace(call).resolve();
        return SqlValidatorUtil.getRelOptTable(targetNs, this.catalogReader, null, null);
    }

    protected RelNode convertColumnList(SqlInsert call, RelNode sourceRel) {
        RelDataType sourceRowType = sourceRel.getRowType();
        RexNode sourceRef = this.rexBuilder.makeRangeReference(sourceRowType, 0, false);
        ArrayList<String> targetColumnNames = new ArrayList<String>();
        ArrayList<RexNode> columnExprs = new ArrayList<RexNode>();
        this.collectInsertTargets(call, sourceRef, targetColumnNames, columnExprs);
        RelOptTable targetTable = this.getTargetTable(call);
        RelDataType targetRowType = targetTable.getRowType();
        List<RelDataTypeField> targetFields = targetRowType.getFieldList();
        ArrayList<Object> sourceExps = new ArrayList<Object>(Collections.nCopies(targetFields.size(), null));
        ArrayList<Object> fieldNames = new ArrayList<Object>(Collections.nCopies(targetFields.size(), null));
        for (Pair<String, RexNode> p : Pair.zip(targetColumnNames, columnExprs)) {
            RelDataTypeField field = this.catalogReader.field(targetRowType, (String)p.left);
            assert (field != null) : "column " + (String)p.left + " not found";
            sourceExps.set(field.getIndex(), p.right);
        }
        for (int i = 0; i < targetFields.size(); ++i) {
            RelDataTypeField field = targetFields.get(i);
            String fieldName = field.getName();
            fieldNames.set(i, fieldName);
            if (sourceExps.get(i) != null) {
                if (!this.defaultValueFactory.isGeneratedAlways(targetTable, i)) continue;
                throw Static.RESOURCE.insertIntoAlwaysGenerated(fieldName).ex();
            }
            sourceExps.set(i, this.defaultValueFactory.newColumnDefaultValue(targetTable, i));
            sourceExps.set(i, this.castNullLiteralIfNeeded((RexNode)sourceExps.get(i), field.getType()));
        }
        return CalcRel.createProject(sourceRel, sourceExps, fieldNames, true);
    }

    private RexNode castNullLiteralIfNeeded(RexNode node, RelDataType type) {
        if (!RexLiteral.isNullLiteral(node)) {
            return node;
        }
        return this.rexBuilder.makeCast(type, node);
    }

    protected void collectInsertTargets(SqlInsert call, RexNode sourceRef, List<String> targetColumnNames, List<RexNode> columnExprs) {
        int i;
        RelOptTable targetTable = this.getTargetTable(call);
        RelDataType targetRowType = targetTable.getRowType();
        SqlNodeList targetColumnList = call.getTargetColumnList();
        if (targetColumnList == null) {
            targetColumnNames.addAll(targetRowType.getFieldNames());
        } else {
            for (i = 0; i < targetColumnList.size(); ++i) {
                SqlIdentifier id = (SqlIdentifier)targetColumnList.get(i);
                targetColumnNames.add(id.getSimple());
            }
        }
        for (i = 0; i < targetColumnNames.size(); ++i) {
            RexNode expr = this.rexBuilder.makeFieldAccess(sourceRef, i);
            columnExprs.add(expr);
        }
    }

    private RelNode convertDelete(SqlDelete call) {
        RelOptTable targetTable = this.getTargetTable(call);
        RelNode sourceRel = this.convertSelect(call.getSourceSelect());
        return new TableModificationRel(this.cluster, targetTable, this.catalogReader, sourceRel, TableModificationRelBase.Operation.DELETE, null, false);
    }

    private RelNode convertUpdate(SqlUpdate call) {
        RelOptTable targetTable = this.getTargetTable(call);
        ArrayList<String> targetColumnNameList = new ArrayList<String>();
        for (SqlNode node : call.getTargetColumnList()) {
            SqlIdentifier id = (SqlIdentifier)node;
            String name = id.getSimple();
            targetColumnNameList.add(name);
        }
        RelNode sourceRel = this.convertSelect(call.getSourceSelect());
        return new TableModificationRel(this.cluster, targetTable, this.catalogReader, sourceRel, TableModificationRelBase.Operation.UPDATE, targetColumnNameList, false);
    }

    private RelNode convertMerge(SqlMerge call) {
        RelOptTable targetTable = this.getTargetTable(call);
        ArrayList<String> targetColumnNameList = new ArrayList<String>();
        SqlUpdate updateCall = call.getUpdateCall();
        if (updateCall != null) {
            for (SqlNode targetColumn : updateCall.getTargetColumnList()) {
                SqlIdentifier id = (SqlIdentifier)targetColumn;
                String name = id.getSimple();
                targetColumnNameList.add(name);
            }
        }
        RelNode mergeSourceRel = this.convertSelect(call.getSourceSelect());
        SqlInsert insertCall = call.getInsertCall();
        int nLevel1Exprs = 0;
        List<RexNode> level1InsertExprs = null;
        List<RexNode> level2InsertExprs = null;
        if (insertCall != null) {
            RelNode insertRel = this.convertInsert(insertCall);
            level1InsertExprs = ((ProjectRel)insertRel.getInput(0)).getProjects();
            if (insertRel.getInput(0).getInput(0) instanceof ProjectRel) {
                level2InsertExprs = ((ProjectRel)insertRel.getInput(0).getInput(0)).getProjects();
            }
            nLevel1Exprs = level1InsertExprs.size();
        }
        JoinRel joinRel = (JoinRel)mergeSourceRel.getInput(0);
        int nSourceFields = joinRel.getLeft().getRowType().getFieldCount();
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        for (int level1Idx = 0; level1Idx < nLevel1Exprs; ++level1Idx) {
            if (level2InsertExprs != null && level1InsertExprs.get(level1Idx) instanceof RexInputRef) {
                int level2Idx = ((RexInputRef)level1InsertExprs.get(level1Idx)).getIndex();
                projects.add(level2InsertExprs.get(level2Idx));
                continue;
            }
            projects.add(level1InsertExprs.get(level1Idx));
        }
        if (updateCall != null) {
            ProjectRel project = (ProjectRel)mergeSourceRel;
            projects.addAll(Util.skip(project.getProjects(), nSourceFields));
        }
        RelNode massagedRel = CalcRel.createProject(joinRel, projects, null, true);
        return new TableModificationRel(this.cluster, targetTable, this.catalogReader, massagedRel, TableModificationRelBase.Operation.MERGE, targetColumnNameList, false);
    }

    private RexNode convertIdentifier(Blackboard bb, SqlIdentifier identifier) {
        RexNode e;
        SqlCall call = SqlUtil.makeCall(this.opTab, identifier);
        if (call != null) {
            return bb.convertExpression(call);
        }
        if (bb.agg != null) {
            throw Util.newInternal("Identifier '" + identifier + "' is not a group expr");
        }
        SqlValidatorNamespace namespace = null;
        if (bb.scope != null) {
            identifier = bb.scope.fullyQualify(identifier);
            namespace = bb.scope.resolve((String)identifier.names.get(0), null, null);
        }
        String correlationName = (e = bb.lookupExp((String)identifier.names.get(0))) instanceof RexCorrelVariable ? ((RexCorrelVariable)e).getName() : null;
        for (String name : Util.skip(identifier.names)) {
            if (namespace != null) {
                name = namespace.translate(name);
                namespace = null;
            }
            boolean caseSensitive = true;
            e = this.rexBuilder.makeFieldAccess(e, name, true);
        }
        if (e instanceof RexInputRef) {
            e = this.adjustInputRef(bb, (RexInputRef)e);
        }
        if (null != correlationName) {
            assert (e instanceof RexFieldAccess);
            RexNode prev = bb.mapCorrelateVariableToRexNode.put(correlationName, e);
            assert (prev == null);
        }
        return e;
    }

    protected RexNode adjustInputRef(Blackboard bb, RexInputRef inputRef) {
        RelDataTypeField field = bb.getRootField(inputRef);
        if (field != null) {
            return this.rexBuilder.makeInputRef(field.getType(), inputRef.getIndex());
        }
        return inputRef;
    }

    private RelNode convertRowConstructor(Blackboard bb, SqlCall rowConstructor) {
        assert (this.isRowConstructor(rowConstructor)) : rowConstructor;
        List<SqlNode> operands = rowConstructor.getOperandList();
        return this.convertMultisets(operands, bb);
    }

    private RelNode convertCursor(Blackboard bb, SqlCall cursorCall) {
        assert (cursorCall.operandCount() == 1);
        Object query = cursorCall.operand(0);
        RelNode converted = this.convertQuery((SqlNode)query, false, false);
        int iCursor = bb.cursors.size();
        bb.cursors.add(converted);
        RexInputRef expr = new RexInputRef(iCursor, converted.getRowType());
        bb.mapSubqueryToExpr.put(cursorCall, expr);
        return converted;
    }

    private RelNode convertMultisets(List<SqlNode> operands, Blackboard bb) {
        int i;
        ArrayList<Cloneable> joinList = new ArrayList<Cloneable>();
        ArrayList<SqlNode> lastList = new ArrayList<SqlNode>();
        for (i = 0; i < operands.size(); ++i) {
            RelNode input;
            SqlNode operand = operands.get(i);
            if (!(operand instanceof SqlCall)) {
                lastList.add(operand);
                continue;
            }
            final SqlCall call = (SqlCall)operand;
            SqlOperator op = call.getOperator();
            if (op != SqlStdOperatorTable.MULTISET_VALUE && op != SqlStdOperatorTable.MULTISET_QUERY) {
                lastList.add(operand);
                continue;
            }
            if (op == SqlStdOperatorTable.MULTISET_VALUE) {
                SqlNodeList list = new SqlNodeList(call.getOperandList(), call.getParserPosition());
                CollectNamespace nss = (CollectNamespace)this.validator.getNamespace(call);
                Blackboard usedBb = null != nss ? this.createBlackboard(nss.getScope(), null) : this.createBlackboard(new ListScope(bb.scope){

                    public SqlNode getNode() {
                        return call;
                    }
                }, null);
                RelDataType multisetType = this.validator.getValidatedNodeType(call);
                this.validator.setValidatedNodeType(list, multisetType.getComponentType());
                input = this.convertQueryOrInList(usedBb, list);
            } else {
                input = this.convertQuery((SqlNode)call.operand(0), false, true);
            }
            if (lastList.size() > 0) {
                joinList.add(lastList);
            }
            lastList = new ArrayList();
            CollectRel collectRel = new CollectRel(this.cluster, this.cluster.traitSetOf(Convention.NONE), input, this.validator.deriveAlias(call, i));
            joinList.add(collectRel);
        }
        if (joinList.size() == 0) {
            joinList.add(lastList);
        }
        for (i = 0; i < joinList.size(); ++i) {
            Object o = joinList.get(i);
            if (!(o instanceof List)) continue;
            List projectList = (List)o;
            ArrayList<RexNode> selectList = new ArrayList<RexNode>();
            ArrayList<String> fieldNameList = new ArrayList<String>();
            for (int j = 0; j < projectList.size(); ++j) {
                SqlNode operand = (SqlNode)projectList.get(j);
                selectList.add(bb.convertExpression(operand));
                fieldNameList.add(SqlUtil.deriveAliasFromOrdinal(j));
            }
            RelNode projRel = CalcRel.createProject((RelNode)new OneRowRel(this.cluster), selectList, fieldNameList);
            Set<String> correlatedVariables = RelOptUtil.getVariablesUsed(projRel);
            for (String correl : correlatedVariables) {
                this.mapCorrelToRefRel.put(correl, projRel);
            }
            joinList.set(i, projRel);
        }
        RelNode ret = (RelNode)joinList.get(0);
        for (int i2 = 1; i2 < joinList.size(); ++i2) {
            RelNode relNode = (RelNode)joinList.get(i2);
            ret = this.createJoin(ret, relNode, this.rexBuilder.makeLiteral(true), JoinRelType.INNER, (Set<String>)ImmutableSet.of());
        }
        return ret;
    }

    protected RelNode createJoin(RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) {
        return new JoinRel(this.cluster, left, right, condition, joinType, variablesStopped);
    }

    private void convertSelectList(Blackboard bb, SqlSelect select, List<SqlNode> orderList) {
        SqlNodeList selectList = select.getSelectList();
        selectList = this.validator.expandStar(selectList, select, false);
        this.replaceSubqueries(bb, selectList);
        List<String> fieldNames = new ArrayList<String>();
        ArrayList<RexNode> exprs = new ArrayList<RexNode>();
        TreeSet<String> aliases = new TreeSet<String>();
        ArrayList<SqlMonotonicity> columnMonotonicityList = new ArrayList<SqlMonotonicity>();
        this.extraSelectItems(bb, select, exprs, fieldNames, aliases, columnMonotonicityList);
        int i = -1;
        for (SqlNode expr : selectList) {
            exprs.add(bb.convertExpression(expr));
            fieldNames.add(this.deriveAlias(expr, aliases, ++i));
        }
        for (SqlNode expr : orderList) {
            SqlNode expr2 = this.validator.expandOrderExpr(select, expr);
            exprs.add(bb.convertExpression(expr2));
            fieldNames.add(this.deriveAlias(expr, aliases, ++i));
        }
        fieldNames = SqlValidatorUtil.uniquify(fieldNames);
        RelNode inputRel = bb.root;
        Set<String> correlatedVariablesBefore = RelOptUtil.getVariablesUsed(inputRel);
        bb.setRoot(CalcRel.createProject(bb.root, exprs, fieldNames), false);
        assert (bb.columnMonotonicities.isEmpty());
        bb.columnMonotonicities.addAll(columnMonotonicityList);
        for (SqlNode selectItem : selectList) {
            bb.columnMonotonicities.add(selectItem.getMonotonicity(bb.scope));
        }
        Set<String> correlatedVariables = RelOptUtil.getVariablesUsed(bb.root);
        correlatedVariables.removeAll(correlatedVariablesBefore);
        for (String correl : correlatedVariables) {
            this.mapCorrelToRefRel.put(correl, bb.root);
        }
    }

    protected void extraSelectItems(Blackboard bb, SqlSelect select, List<RexNode> exprList, List<String> nameList, Collection<String> aliasList, List<SqlMonotonicity> columnMonotonicityList) {
    }

    private String deriveAlias(SqlNode node, Collection<String> aliases, int ordinal) {
        String alias = this.validator.deriveAlias(node, ordinal);
        if (alias == null || aliases.contains(alias)) {
            String aliasBase = alias == null ? "EXPR$" : alias;
            int j = 0;
            while (aliases.contains(alias = aliasBase + j)) {
                ++j;
            }
        }
        aliases.add(alias);
        return alias;
    }

    public RelNode convertWith(SqlWith with) {
        return this.convertQuery(with.body, false, false);
    }

    public RelNode convertValues(SqlCall values, RelDataType targetRowType) {
        SqlValidatorScope scope = this.validator.getOverScope(values);
        assert (scope != null);
        Blackboard bb = this.createBlackboard(scope, null);
        this.convertValuesImpl(bb, values, targetRowType);
        return bb.root;
    }

    private void convertValuesImpl(Blackboard bb, SqlCall values, RelDataType targetRowType) {
        RelNode valuesRel = this.convertRowValues(bb, values, values.getOperandList(), true, targetRowType);
        if (valuesRel != null) {
            bb.setRoot(valuesRel, true);
            return;
        }
        ArrayList<RelNode> unionRels = new ArrayList<RelNode>();
        for (SqlNode rowConstructor1 : values.getOperandList()) {
            SqlCall rowConstructor = (SqlCall)rowConstructor1;
            Blackboard tmpBb = this.createBlackboard(bb.scope, null);
            this.replaceSubqueries(tmpBb, rowConstructor);
            ArrayList<Pair<RexNode, String>> exps = new ArrayList<Pair<RexNode, String>>();
            for (Ord operand : Ord.zip(rowConstructor.getOperandList())) {
                exps.add(Pair.of(tmpBb.convertExpression((SqlNode)operand.e), this.validator.deriveAlias((SqlNode)operand.e, operand.i)));
            }
            RelNode in = null == tmpBb.root ? new OneRowRel(this.cluster) : tmpBb.root;
            unionRels.add(CalcRel.createProject(in, Pair.left(exps), Pair.right(exps), true));
        }
        if (unionRels.size() == 0) {
            throw Util.newInternal("empty values clause");
        }
        if (unionRels.size() == 1) {
            bb.setRoot((RelNode)unionRels.get(0), true);
        } else {
            bb.setRoot(new UnionRel(this.cluster, unionRels, true), true);
        }
    }

    private String createCorrel() {
        int n = this.nextCorrel++;
        return CORREL_PREFIX + n;
    }

    private int getCorrelOrdinal(String correlName) {
        assert (correlName.startsWith(CORREL_PREFIX));
        return Integer.parseInt(correlName.substring(CORREL_PREFIX.length()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HistogramShuttle
    extends RexShuttle {
        static final boolean ENABLE_HISTOGRAM_AGG = false;
        private final List<RexNode> partitionKeys;
        private final ImmutableList<RexFieldCollation> orderKeys;
        private final RexWindowBound lowerBound;
        private final RexWindowBound upperBound;
        private final SqlWindow window;

        HistogramShuttle(List<RexNode> partitionKeys, ImmutableList<RexFieldCollation> orderKeys, RexWindowBound lowerBound, RexWindowBound upperBound, SqlWindow window) {
            this.partitionKeys = partitionKeys;
            this.orderKeys = orderKeys;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.window = window;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            SqlOperator op = call.getOperator();
            if (!(op instanceof SqlAggFunction)) {
                return super.visitCall(call);
            }
            SqlAggFunction aggOp = (SqlAggFunction)op;
            RelDataType type = call.getType();
            List<RexNode> exprs = call.getOperands();
            SqlOperator histogramOp = null;
            if (histogramOp != null) {
                boolean reinterpretCast;
                RelDataType histogramType = this.computeHistogramType(type);
                boolean bl = reinterpretCast = type.getSqlTypeName() == SqlTypeName.DECIMAL;
                if (histogramType != type) {
                    exprs = new ArrayList<RexNode>(exprs);
                    exprs.set(0, reinterpretCast ? SqlToRelConverter.this.rexBuilder.makeReinterpretCast(histogramType, exprs.get(0), SqlToRelConverter.this.rexBuilder.makeLiteral(false)) : SqlToRelConverter.this.rexBuilder.makeCast(histogramType, exprs.get(0)));
                }
                RexCallBinding bind = new RexCallBinding(SqlToRelConverter.this.rexBuilder.getTypeFactory(), SqlStdOperatorTable.HISTOGRAM_AGG, exprs);
                RexNode over = SqlToRelConverter.this.rexBuilder.makeOver(SqlStdOperatorTable.HISTOGRAM_AGG.inferReturnType(bind), SqlStdOperatorTable.HISTOGRAM_AGG, exprs, this.partitionKeys, this.orderKeys, this.lowerBound, this.upperBound, this.window.isRows(), this.window.isAllowPartial(), false);
                RexNode histogramCall = SqlToRelConverter.this.rexBuilder.makeCall(histogramType, histogramOp, (List<RexNode>)ImmutableList.of((Object)over));
                if (histogramType != type) {
                    histogramCall = reinterpretCast ? SqlToRelConverter.this.rexBuilder.makeReinterpretCast(type, histogramCall, SqlToRelConverter.this.rexBuilder.makeLiteral(false)) : SqlToRelConverter.this.rexBuilder.makeCast(type, histogramCall);
                }
                return histogramCall;
            }
            boolean needSum0 = aggOp == SqlStdOperatorTable.SUM && type.isNullable();
            SqlAggFunction aggOpToUse = needSum0 ? SqlStdOperatorTable.SUM0 : aggOp;
            return SqlToRelConverter.this.rexBuilder.makeOver(type, aggOpToUse, exprs, this.partitionKeys, this.orderKeys, this.lowerBound, this.upperBound, this.window.isRows(), this.window.isAllowPartial(), needSum0);
        }

        SqlFunction getHistogramOp(SqlAggFunction aggFunction) {
            if (aggFunction == SqlStdOperatorTable.MIN) {
                return SqlStdOperatorTable.HISTOGRAM_MIN;
            }
            if (aggFunction == SqlStdOperatorTable.MAX) {
                return SqlStdOperatorTable.HISTOGRAM_MAX;
            }
            if (aggFunction == SqlStdOperatorTable.FIRST_VALUE) {
                return SqlStdOperatorTable.HISTOGRAM_FIRST_VALUE;
            }
            if (aggFunction == SqlStdOperatorTable.LAST_VALUE) {
                return SqlStdOperatorTable.HISTOGRAM_LAST_VALUE;
            }
            return null;
        }

        private RelDataType computeHistogramType(RelDataType type) {
            if (SqlTypeUtil.isExactNumeric(type) && type.getSqlTypeName() != SqlTypeName.BIGINT) {
                return new BasicSqlType(SqlTypeName.BIGINT);
            }
            if (SqlTypeUtil.isApproximateNumeric(type) && type.getSqlTypeName() != SqlTypeName.DOUBLE) {
                return new BasicSqlType(SqlTypeName.DOUBLE);
            }
            return type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LookupContext {
        private final List<Pair<RelNode, Integer>> relOffsetList = new ArrayList<Pair<RelNode, Integer>>();

        LookupContext(Blackboard bb, List<RelNode> rels, int systemFieldCount) {
            bb.flatten(rels, systemFieldCount, new int[]{0}, this.relOffsetList);
        }

        Pair<RelNode, Integer> findRel(int offset) {
            return this.relOffsetList.get(offset);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AggConverter
    implements SqlVisitor<Void> {
        private final Blackboard bb;
        private final Map<String, String> nameMap = new HashMap<String, String>();
        private final SqlNodeList groupExprs = new SqlNodeList(SqlParserPos.ZERO);
        private final List<RexNode> convertedInputExprs = new ArrayList<RexNode>();
        private final List<String> convertedInputExprNames = new ArrayList<String>();
        private final List<RexInputRef> inputRefs = new ArrayList<RexInputRef>();
        private final List<AggregateCall> aggCalls = new ArrayList<AggregateCall>();
        private final Map<SqlNode, RexNode> aggMapping = new HashMap<SqlNode, RexNode>();
        private final Map<AggregateCall, RexNode> aggCallMapping = new HashMap<AggregateCall, RexNode>();

        public AggConverter(Blackboard bb, SqlSelect select) {
            this.bb = bb;
            SqlNodeList selectList = select.getSelectList();
            for (int i = 0; i < selectList.size(); ++i) {
                SqlNode selectItem = selectList.get(i);
                String name = null;
                if (SqlUtil.isCallTo(selectItem, SqlStdOperatorTable.AS)) {
                    SqlCall call = (SqlCall)selectItem;
                    selectItem = call.operand(0);
                    name = ((SqlNode)call.operand(1)).toString();
                }
                if (name == null) {
                    name = SqlToRelConverter.this.validator.deriveAlias(selectItem, i);
                }
                this.nameMap.put(selectItem.toString(), name);
            }
        }

        public void addGroupExpr(SqlNode expr) {
            RexNode convExpr = this.bb.convertExpression(expr);
            RexNode rex = this.lookupGroupExpr(expr);
            if (rex != null) {
                return;
            }
            this.groupExprs.add(expr);
            String name = this.nameMap.get(expr.toString());
            this.addExpr(convExpr, name);
            RelDataType type = convExpr.getType();
            this.inputRefs.add(SqlToRelConverter.this.rexBuilder.makeInputRef(type, this.inputRefs.size()));
        }

        private void addExpr(RexNode expr, String name) {
            this.convertedInputExprs.add(expr);
            if (name == null && expr instanceof RexInputRef) {
                int i = ((RexInputRef)expr).getIndex();
                name = this.bb.root.getRowType().getFieldList().get(i).getName();
            }
            if (this.convertedInputExprNames.contains(name)) {
                name = null;
            }
            this.convertedInputExprNames.add(name);
        }

        @Override
        public Void visit(SqlIdentifier id) {
            return null;
        }

        @Override
        public Void visit(SqlNodeList nodeList) {
            for (int i = 0; i < nodeList.size(); ++i) {
                nodeList.get(i).accept(this);
            }
            return null;
        }

        @Override
        public Void visit(SqlLiteral lit) {
            return null;
        }

        @Override
        public Void visit(SqlDataTypeSpec type) {
            return null;
        }

        @Override
        public Void visit(SqlDynamicParam param) {
            return null;
        }

        @Override
        public Void visit(SqlIntervalQualifier intervalQualifier) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visit(SqlCall call) {
            if (call.getOperator().isAggregator()) {
                assert (this.bb.agg == this);
                ArrayList<Integer> args = new ArrayList<Integer>();
                ArrayList<RelDataType> argTypes = call.getOperator() instanceof SqlCountAggFunction ? new ArrayList<RelDataType>(call.getOperandList().size()) : null;
                try {
                    this.bb.agg = null;
                    for (SqlNode operand : call.getOperandList()) {
                        SqlIdentifier id;
                        if (operand instanceof SqlIdentifier && (id = (SqlIdentifier)operand).isStar()) {
                            assert (call.operandCount() == 1);
                            assert (args.isEmpty());
                            break;
                        }
                        RexNode convertedExpr = this.bb.convertExpression(operand);
                        assert (convertedExpr != null);
                        if (argTypes != null) {
                            argTypes.add(convertedExpr.getType());
                        }
                        args.add(this.lookupOrCreateGroupExpr(convertedExpr));
                    }
                }
                finally {
                    this.bb.agg = this;
                }
                Aggregation aggregation = (Aggregation)((Object)call.getOperator());
                RelDataType type = SqlToRelConverter.this.validator.deriveType(this.bb.scope, call);
                boolean distinct = false;
                SqlLiteral quantifier = call.getFunctionQuantifier();
                if (null != quantifier && quantifier.getValue() == SqlSelectKeyword.DISTINCT) {
                    distinct = true;
                }
                AggregateCall aggCall = new AggregateCall(aggregation, distinct, args, type, this.nameMap.get(call.toString()));
                RexNode rex = SqlToRelConverter.this.rexBuilder.addAggCall(aggCall, this.groupExprs.size(), this.aggCalls, this.aggCallMapping, argTypes);
                this.aggMapping.put(call, rex);
            } else {
                if (call instanceof SqlSelect) {
                    return null;
                }
                for (SqlNode operand : call.getOperandList()) {
                    if (operand == null) continue;
                    operand.accept(this);
                }
            }
            return null;
        }

        private int lookupOrCreateGroupExpr(RexNode expr) {
            for (int i = 0; i < this.convertedInputExprs.size(); ++i) {
                RexNode convertedInputExpr = this.convertedInputExprs.get(i);
                if (!expr.toString().equals(convertedInputExpr.toString())) continue;
                return i;
            }
            int index = this.convertedInputExprs.size();
            this.addExpr(expr, null);
            return index;
        }

        public RexNode lookupGroupExpr(SqlNode expr) {
            for (int i = 0; i < this.groupExprs.size(); ++i) {
                SqlNode groupExpr = this.groupExprs.get(i);
                if (!expr.equalsDeep(groupExpr, false)) continue;
                return this.inputRefs.get(i);
            }
            return null;
        }

        public RexNode lookupAggregates(SqlCall call) {
            assert (this.bb.agg == this);
            return this.aggMapping.get(call);
        }

        public List<RexNode> getPreExprs() {
            return this.convertedInputExprs;
        }

        public List<String> getPreNames() {
            return this.convertedInputExprNames;
        }

        public List<AggregateCall> getAggCalls() {
            return this.aggCalls;
        }

        public RelDataTypeFactory getTypeFactory() {
            return SqlToRelConverter.this.typeFactory;
        }
    }

    private class NoOpSubqueryConverter
    implements SubqueryConverter {
        private NoOpSubqueryConverter() {
        }

        public boolean canConvertSubquery() {
            return false;
        }

        public RexNode convertSubquery(SqlCall subquery, SqlToRelConverter parentConverter, boolean isExists, boolean isExplain) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NullDefaultValueFactory
    implements DefaultValueFactory {
        NullDefaultValueFactory() {
        }

        @Override
        public boolean isGeneratedAlways(RelOptTable table, int iColumn) {
            return false;
        }

        @Override
        public RexNode newColumnDefaultValue(RelOptTable table, int iColumn) {
            return SqlToRelConverter.this.rexBuilder.constantNull();
        }

        @Override
        public RexNode newAttributeInitializer(RelDataType type, SqlFunction constructor, int iAttribute, List<RexNode> constructorArgs) {
            return SqlToRelConverter.this.rexBuilder.constantNull();
        }
    }

    private static class DeferredLookup {
        Blackboard bb;
        String originalRelName;

        DeferredLookup(Blackboard bb, String originalRelName) {
            this.bb = bb;
            this.originalRelName = originalRelName;
        }

        public RexFieldAccess getFieldAccess(String name) {
            return (RexFieldAccess)this.bb.mapCorrelateVariableToRexNode.get(name);
        }

        public String getOriginalRelName() {
            return this.originalRelName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Blackboard
    implements SqlRexContext,
    SqlVisitor<RexNode> {
        public final SqlValidatorScope scope;
        private final Map<String, RexNode> nameToNodeMap;
        public RelNode root;
        private List<RelNode> inputs;
        private final Map<String, RexNode> mapCorrelateVariableToRexNode = new HashMap<String, RexNode>();
        List<RelNode> cursors;
        private final List<SqlNode> subqueryList = new ArrayList<SqlNode>();
        private final Map<SqlNode, RexNode> mapSubqueryToExpr = new HashMap<SqlNode, RexNode>();
        private boolean subqueryNeedsOuterJoin;
        AggConverter agg;
        SqlWindow window;
        private final Map<RelNode, Map<Integer, Integer>> mapRootRelToFieldProjection = new HashMap<RelNode, Map<Integer, Integer>>();
        private final List<SqlMonotonicity> columnMonotonicities = new ArrayList<SqlMonotonicity>();
        private final List<RelDataTypeField> systemFieldList = new ArrayList<RelDataTypeField>();

        protected Blackboard(SqlValidatorScope scope, Map<String, RexNode> nameToNodeMap) {
            this.scope = scope;
            this.nameToNodeMap = nameToNodeMap;
            this.cursors = new ArrayList<RelNode>();
            this.subqueryNeedsOuterJoin = false;
        }

        public RexNode register(RelNode rel, JoinRelType joinType) {
            return this.register(rel, joinType, null);
        }

        public RexNode register(RelNode rel, JoinRelType joinType, RexNode[] leftJoinKeysForIn) {
            assert (joinType != null);
            if (this.root == null) {
                assert (leftJoinKeysForIn == null);
                this.setRoot(rel, false);
                return SqlToRelConverter.this.rexBuilder.makeRangeReference(this.root.getRowType(), 0, false);
            }
            RexNode joinCond = null;
            final int origLeftInputCount = this.root.getRowType().getFieldCount();
            if (leftJoinKeysForIn != null) {
                ArrayList<RexNode> newLeftInputExpr = new ArrayList<RexNode>();
                for (int i = 0; i < origLeftInputCount; ++i) {
                    newLeftInputExpr.add(SqlToRelConverter.this.rexBuilder.makeInputRef(this.root, i));
                }
                Collections.addAll(newLeftInputExpr, leftJoinKeysForIn);
                ProjectRel newLeftInput = (ProjectRel)CalcRel.createProject(this.root, newLeftInputExpr, null, true);
                if (this.mapRootRelToFieldProjection.containsKey(this.root)) {
                    this.mapRootRelToFieldProjection.put(newLeftInput, this.mapRootRelToFieldProjection.get(this.root));
                }
                this.setRoot(newLeftInput, false);
                ArrayList<RexInputRef> newLeftJoinKeysForIn = new ArrayList<RexInputRef>();
                for (int i = 0; i < leftJoinKeysForIn.length; ++i) {
                    int x = origLeftInputCount + i;
                    newLeftJoinKeysForIn.add(SqlToRelConverter.this.rexBuilder.makeInputRef(newLeftInput.getProjects().get(x).getType(), x));
                }
                joinCond = SqlToRelConverter.this.createJoinConditionForIn(this, newLeftJoinKeysForIn, rel);
            }
            int leftFieldCount = this.root.getRowType().getFieldCount();
            final RelNode join = SqlToRelConverter.this.createJoin(this, this.root, rel, joinCond, joinType);
            this.setRoot(join, false);
            if (leftJoinKeysForIn != null && joinType == JoinRelType.LEFT) {
                int rightFieldLength = rel.getRowType().getFieldCount();
                assert (leftJoinKeysForIn.length == rightFieldLength - 1);
                final int rexRangeRefLength = leftJoinKeysForIn.length + rightFieldLength;
                RelDataType returnType = SqlToRelConverter.this.typeFactory.createStructType((List<? extends Map.Entry<String, RelDataType>>)new AbstractList<Map.Entry<String, RelDataType>>(){

                    @Override
                    public Map.Entry<String, RelDataType> get(int index) {
                        return join.getRowType().getFieldList().get(origLeftInputCount + index);
                    }

                    @Override
                    public int size() {
                        return rexRangeRefLength;
                    }
                });
                return SqlToRelConverter.this.rexBuilder.makeRangeReference(returnType, origLeftInputCount, false);
            }
            return SqlToRelConverter.this.rexBuilder.makeRangeReference(rel.getRowType(), leftFieldCount, joinType.generatesNullsOnRight());
        }

        public void setRoot(RelNode root, boolean leaf) {
            this.setRoot(Collections.singletonList(root), root, root instanceof JoinRel);
            if (leaf) {
                SqlToRelConverter.this.leaves.add(root);
            }
            this.columnMonotonicities.clear();
        }

        private void setRoot(List<RelNode> inputs, RelNode root, boolean hasSystemFields) {
            this.inputs = inputs;
            this.root = root;
            this.systemFieldList.clear();
            if (hasSystemFields) {
                this.systemFieldList.addAll(SqlToRelConverter.this.getSystemFields());
            }
        }

        public void setDataset(String datasetName) {
        }

        void setRoot(List<RelNode> inputs) {
            this.setRoot(inputs, null, false);
        }

        RexNode lookupExp(String name) {
            boolean isParent;
            if (this.nameToNodeMap != null) {
                RexNode node = this.nameToNodeMap.get(name);
                if (node == null) {
                    throw Util.newInternal("Unknown identifier '" + name + "' encountered while expanding expression" + node);
                }
                return node;
            }
            SqlValidatorScope[] ancestorScopes = new SqlValidatorScope[]{null};
            int[] offsets = new int[]{-1};
            SqlValidatorNamespace foundNs = this.scope.resolve(name, ancestorScopes, offsets);
            if (foundNs == null) {
                return null;
            }
            SqlValidatorScope ancestorScope = ancestorScopes[0];
            boolean bl = isParent = ancestorScope != this.scope;
            if (this.inputs != null && !isParent) {
                int offset = offsets[0];
                LookupContext rels = new LookupContext(this, this.inputs, this.systemFieldList.size());
                return this.lookup(offset, rels);
            }
            assert (isParent);
            DeferredLookup lookup = new DeferredLookup(this, name);
            String correlName = SqlToRelConverter.this.createCorrel();
            SqlToRelConverter.this.mapCorrelToDeferred.put(correlName, lookup);
            RelDataType rowType = foundNs.getRowType();
            return SqlToRelConverter.this.rexBuilder.makeCorrel(rowType, correlName);
        }

        RexNode lookup(int offset, LookupContext lookupContext) {
            Pair<RelNode, Integer> pair = lookupContext.findRel(offset);
            return SqlToRelConverter.this.rexBuilder.makeRangeReference(((RelNode)pair.left).getRowType(), (Integer)pair.right, false);
        }

        RelDataTypeField getRootField(RexInputRef inputRef) {
            int fieldOffset = inputRef.getIndex();
            for (RelNode input : this.inputs) {
                RelDataType rowType = input.getRowType();
                if (rowType == null) {
                    return null;
                }
                if (fieldOffset < rowType.getFieldCount()) {
                    return rowType.getFieldList().get(fieldOffset);
                }
                fieldOffset -= rowType.getFieldCount();
            }
            throw new AssertionError();
        }

        public void flatten(List<RelNode> rels, int systemFieldCount, int[] start, List<Pair<RelNode, Integer>> relOffsetList) {
            for (RelNode rel : rels) {
                if (SqlToRelConverter.this.leaves.contains(rel)) {
                    relOffsetList.add(Pair.of(rel, start[0]));
                    start[0] = start[0] + rel.getRowType().getFieldCount();
                    continue;
                }
                if (rel instanceof JoinRel || rel instanceof AggregateRel) {
                    start[0] = start[0] + systemFieldCount;
                }
                this.flatten(rel.getInputs(), systemFieldCount, start, relOffsetList);
            }
        }

        void registerSubquery(SqlNode node) {
            this.subqueryList.add(node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ImmutableList<RelNode> retrieveCursors() {
            try {
                ImmutableList immutableList = ImmutableList.copyOf(this.cursors);
                return immutableList;
            }
            finally {
                this.cursors.clear();
            }
        }

        @Override
        public RexNode convertExpression(SqlNode expr) {
            RexNode rex;
            if (this.agg != null) {
                SqlNode expandedGroupExpr = SqlToRelConverter.this.validator.expand(expr, this.scope);
                RexNode rex2 = this.agg.lookupGroupExpr(expandedGroupExpr);
                if (rex2 != null) {
                    return rex2;
                }
                if (expr instanceof SqlCall && (rex2 = this.agg.lookupAggregates((SqlCall)expr)) != null) {
                    return rex2;
                }
            }
            if ((rex = SqlToRelConverter.this.convertExtendedExpression(expr, this)) != null) {
                return rex;
            }
            SqlKind kind = expr.getKind();
            switch (kind) {
                case CURSOR: 
                case EXISTS: 
                case SCALAR_QUERY: 
                case SELECT: {
                    rex = this.mapSubqueryToExpr.get(expr);
                    assert (rex != null) : "rex != null";
                    if (kind == SqlKind.CURSOR) {
                        return rex;
                    }
                    if ((kind == SqlKind.SCALAR_QUERY || kind == SqlKind.EXISTS) && this.isConvertedSubq(rex)) {
                        return rex;
                    }
                    boolean needTruthTest = false;
                    RexNode fieldAccess = SqlToRelConverter.this.rexBuilder.makeFieldAccess(rex, rex.getType().getFieldCount() - 1);
                    if (fieldAccess.getType().isNullable() && kind == SqlKind.EXISTS) {
                        needTruthTest = true;
                    }
                    if (needTruthTest) {
                        fieldAccess = SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_TRUE, fieldAccess);
                    }
                    return fieldAccess;
                }
                case IN: {
                    RexNode rexNode;
                    rex = this.mapSubqueryToExpr.get(expr);
                    assert (rex != null) : "rex != null";
                    if (!(rex instanceof RexRangeRef)) {
                        return rex;
                    }
                    boolean isNotInFilter = ((SqlInOperator)((SqlCall)expr).getOperator()).isNotIn();
                    boolean needTruthTest = this.subqueryNeedsOuterJoin || isNotInFilter;
                    if (needTruthTest) {
                        assert (rex instanceof RexRangeRef);
                        rexNode = SqlToRelConverter.this.rexBuilder.makeFieldAccess(rex, rex.getType().getFieldCount() - 1);
                        if (!isNotInFilter) {
                            rexNode = SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_TRUE, rexNode);
                        } else {
                            rexNode = SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_TRUE, rexNode));
                            for (int i = 0; i < (rex.getType().getFieldCount() - 1) / 2; ++i) {
                                rexNode = SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, rexNode, SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, SqlToRelConverter.this.rexBuilder.makeFieldAccess(rex, i)));
                            }
                        }
                    } else {
                        rexNode = SqlToRelConverter.this.rexBuilder.makeLiteral(true);
                    }
                    return rexNode;
                }
                case OVER: {
                    return SqlToRelConverter.this.convertOver(this, expr);
                }
            }
            rex = expr.accept(this);
            Util.permAssert(rex != null, "conversion result not null");
            return rex;
        }

        public RexNode convertSortExpression(SqlNode expr, Set<SqlKind> flags) {
            switch (expr.getKind()) {
                case DESCENDING: 
                case NULLS_FIRST: 
                case NULLS_LAST: {
                    flags.add(expr.getKind());
                    Object operand = ((SqlCall)expr).operand(0);
                    return this.convertSortExpression((SqlNode)operand, flags);
                }
            }
            return this.convertExpression(expr);
        }

        private boolean isConvertedSubq(RexNode rex) {
            RexNode operand;
            RexCall call;
            if (rex instanceof RexLiteral || rex instanceof RexDynamicParam) {
                return true;
            }
            return rex instanceof RexCall && (call = (RexCall)rex).getOperator() == SqlStdOperatorTable.CAST && (operand = call.getOperands().get(0)) instanceof RexLiteral;
        }

        @Override
        public int getGroupCount() {
            if (this.agg != null) {
                return this.agg.groupExprs.size();
            }
            if (this.window != null) {
                return this.window.isAlwaysNonEmpty() ? 1 : 0;
            }
            return -1;
        }

        @Override
        public RexBuilder getRexBuilder() {
            return SqlToRelConverter.this.rexBuilder;
        }

        @Override
        public RexRangeRef getSubqueryExpr(SqlCall call) {
            return (RexRangeRef)this.mapSubqueryToExpr.get(call);
        }

        @Override
        public RelDataTypeFactory getTypeFactory() {
            return SqlToRelConverter.this.typeFactory;
        }

        @Override
        public DefaultValueFactory getDefaultValueFactory() {
            return SqlToRelConverter.this.defaultValueFactory;
        }

        @Override
        public SqlValidator getValidator() {
            return SqlToRelConverter.this.validator;
        }

        @Override
        public RexNode convertLiteral(SqlLiteral literal) {
            return SqlToRelConverter.this.exprConverter.convertLiteral(this, literal);
        }

        public RexNode convertInterval(SqlIntervalQualifier intervalQualifier) {
            return SqlToRelConverter.this.exprConverter.convertInterval(this, intervalQualifier);
        }

        @Override
        public RexNode visit(SqlLiteral literal) {
            return SqlToRelConverter.this.exprConverter.convertLiteral(this, literal);
        }

        @Override
        public RexNode visit(SqlCall call) {
            SqlOperator op;
            if (this.agg != null && (op = call.getOperator()).isAggregator()) {
                return this.agg.lookupAggregates(call);
            }
            return SqlToRelConverter.this.exprConverter.convertCall(this, call);
        }

        @Override
        public RexNode visit(SqlNodeList nodeList) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RexNode visit(SqlIdentifier id) {
            return SqlToRelConverter.this.convertIdentifier(this, id);
        }

        @Override
        public RexNode visit(SqlDataTypeSpec type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RexNode visit(SqlDynamicParam param) {
            return SqlToRelConverter.this.convertDynamicParam(param);
        }

        @Override
        public RexNode visit(SqlIntervalQualifier intervalQualifier) {
            return this.convertInterval(intervalQualifier);
        }

        public void adjustSubqueries(final int index, final int count) {
            for (Map.Entry<SqlNode, RexNode> entry : this.mapSubqueryToExpr.entrySet()) {
                RexNode expr = entry.getValue();
                RexShuttle shuttle = new RexShuttle(){

                    public RexNode visitRangeRef(RexRangeRef rangeRef) {
                        if (rangeRef.getOffset() >= index) {
                            return SqlToRelConverter.this.rexBuilder.makeRangeReference(rangeRef.getType(), rangeRef.getOffset() + count, false);
                        }
                        return rangeRef;
                    }

                    public RexNode visitInputRef(RexInputRef inputRef) {
                        if (inputRef.getIndex() >= index) {
                            return SqlToRelConverter.this.rexBuilder.makeInputRef(inputRef.getType(), inputRef.getIndex() + count);
                        }
                        return inputRef;
                    }
                };
                RexNode newExpr = expr.accept(shuttle);
                entry.setValue(newExpr);
            }
        }

        public List<SqlMonotonicity> getColumnMonotonicities() {
            return this.columnMonotonicities;
        }
    }
}

