/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql2rel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SetOpRel;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.rel.TableFunctionRel;
import org.eigenbase.rel.TableModificationRel;
import org.eigenbase.rel.ValuesRel;
import org.eigenbase.rel.rules.RemoveTrivialProjectRule;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelDataTypeImpl;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexPermuteInputsShuttle;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.util.Pair;
import org.eigenbase.util.ReflectUtil;
import org.eigenbase.util.ReflectiveVisitor;
import org.eigenbase.util.Util;
import org.eigenbase.util.mapping.IntPair;
import org.eigenbase.util.mapping.Mapping;
import org.eigenbase.util.mapping.MappingType;
import org.eigenbase.util.mapping.Mappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelFieldTrimmer
implements ReflectiveVisitor {
    private final ReflectUtil.MethodDispatcher<TrimResult> trimFieldsDispatcher;

    public RelFieldTrimmer(SqlValidator validator) {
        Util.discard(validator);
        this.trimFieldsDispatcher = ReflectUtil.createMethodDispatcher(TrimResult.class, this, "trimFields", RelNode.class, BitSet.class, Set.class);
    }

    public RelNode trim(RelNode root) {
        int fieldCount = root.getRowType().getFieldCount();
        BitSet fieldsUsed = BitSets.range(fieldCount);
        Set<RelDataTypeField> extraFields = Collections.emptySet();
        TrimResult trimResult = this.dispatchTrimFields(root, fieldsUsed, extraFields);
        if (!((Mapping)trimResult.right).isIdentity()) {
            throw new IllegalArgumentException();
        }
        return (RelNode)trimResult.left;
    }

    protected TrimResult trimChild(RelNode rel, RelNode input, BitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        Util.discard(rel);
        if (input.getClass().getName().endsWith("MedMdrClassExtentRel")) {
            fieldsUsed = BitSets.range(input.getRowType().getFieldCount());
        }
        return this.dispatchTrimFields(input, fieldsUsed, extraFields);
    }

    protected TrimResult trimChildRestore(RelNode rel, RelNode input, BitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        TrimResult trimResult = this.trimChild(rel, input, fieldsUsed, extraFields);
        if (((Mapping)trimResult.right).isIdentity()) {
            return trimResult;
        }
        RelDataType rowType = input.getRowType();
        List<RelDataTypeField> fieldList = rowType.getFieldList();
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        List<String> nameList = rowType.getFieldNames();
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        assert (((Mapping)trimResult.right).getSourceCount() == fieldList.size());
        for (int i = 0; i < fieldList.size(); ++i) {
            int source = ((Mapping)trimResult.right).getTargetOpt(i);
            RelDataTypeField field = fieldList.get(i);
            exprList.add(source < 0 ? rexBuilder.makeZeroLiteral(field.getType()) : rexBuilder.makeInputRef(field.getType(), source));
        }
        RelNode project = CalcRel.createProject((RelNode)trimResult.left, exprList, nameList);
        return new TrimResult(project, Mappings.createIdentity(fieldList.size()));
    }

    protected final TrimResult dispatchTrimFields(RelNode rel, BitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        TrimResult trimResult = this.trimFieldsDispatcher.invoke(rel, fieldsUsed, extraFields);
        RelNode newRel = (RelNode)trimResult.left;
        Mapping mapping = (Mapping)trimResult.right;
        int fieldCount = rel.getRowType().getFieldCount();
        assert (mapping.getSourceCount() == fieldCount) : "source: " + mapping.getSourceCount() + " != " + fieldCount;
        int newFieldCount = newRel.getRowType().getFieldCount();
        assert (mapping.getTargetCount() + extraFields.size() == newFieldCount) : "target: " + mapping.getTargetCount() + " + " + extraFields.size() + " != " + newFieldCount;
        if (newRel.equals(rel)) {
            return new TrimResult(rel, mapping);
        }
        return trimResult;
    }

    public TrimResult trimFields(RelNode rel, BitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        Util.discard(fieldsUsed);
        return new TrimResult(rel, Mappings.createIdentity(rel.getRowType().getFieldCount()));
    }

    public TrimResult trimFields(ProjectRel project, BitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelNode newProject;
        RelDataType rowType = project.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelNode input = project.getChild();
        RelDataType inputRowType = input.getRowType();
        BitSet inputFieldsUsed = new BitSet(inputRowType.getFieldCount());
        LinkedHashSet<RelDataTypeField> inputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(inputFieldsUsed, inputExtraFields);
        for (Ord ord : Ord.zip(project.getProjects())) {
            if (!fieldsUsed.get(ord.i)) continue;
            ((RexNode)ord.e).accept(inputFinder);
        }
        TrimResult trimResult = this.trimChild(project, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && fieldsUsed.cardinality() == fieldCount) {
            return new TrimResult(project, Mappings.createIdentity(fieldCount));
        }
        if (fieldsUsed.cardinality() == 0) {
            Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, 1);
            RexLiteral expr = project.getCluster().getRexBuilder().makeExactLiteral(BigDecimal.ZERO);
            RelDataType newRowType = project.getCluster().getTypeFactory().createStructType(Collections.singletonList(expr.getType()), Collections.singletonList("DUMMY"));
            ProjectRel newProject2 = new ProjectRel(project.getCluster(), project.getCluster().traitSetOf(RelCollationImpl.EMPTY), newInput, Collections.singletonList(expr), newRowType, project.getFlags());
            return new TrimResult(newProject2, mapping);
        }
        ArrayList<RexNode> newProjectExprList = new ArrayList<RexNode>();
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle(inputMapping, newInput);
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, fieldsUsed.cardinality());
        for (Ord ord : Ord.zip(project.getProjects())) {
            if (!fieldsUsed.get(ord.i)) continue;
            mapping.set(ord.i, newProjectExprList.size());
            RexNode newProjectExpr = ((RexNode)ord.e).accept(shuttle);
            newProjectExprList.add(newProjectExpr);
        }
        RelDataType newRowType = project.getCluster().getTypeFactory().createStructType(Mappings.apply3(mapping, rowType.getFieldList()));
        List<RelCollation> newCollations = RexUtil.apply((Mappings.TargetMapping)inputMapping, project.getCollationList());
        if (RemoveTrivialProjectRule.isIdentity(newProjectExprList, newRowType, newInput.getRowType())) {
            newProject = newInput;
        } else {
            newProject = new ProjectRel(project.getCluster(), project.getCluster().traitSetOf(newCollations.isEmpty() ? RelCollationImpl.EMPTY : newCollations.get(0)), newInput, newProjectExprList, newRowType, project.getFlags());
            assert (newProject.getClass() == project.getClass());
        }
        return new TrimResult(newProject, mapping);
    }

    public TrimResult trimFields(FilterRel filter, BitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = filter.getRowType();
        int fieldCount = rowType.getFieldCount();
        RexNode conditionExpr = filter.getCondition();
        RelNode input = filter.getChild();
        BitSet inputFieldsUsed = (BitSet)fieldsUsed.clone();
        LinkedHashSet<RelDataTypeField> inputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(inputFieldsUsed, inputExtraFields);
        conditionExpr.accept(inputFinder);
        TrimResult trimResult = this.trimChild(filter, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && fieldsUsed.cardinality() == fieldCount) {
            return new TrimResult(filter, Mappings.createIdentity(fieldCount));
        }
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle(inputMapping, newInput);
        RexNode newConditionExpr = conditionExpr.accept(shuttle);
        FilterRel newFilter = new FilterRel(filter.getCluster(), newInput, newConditionExpr);
        assert (newFilter.getClass() == filter.getClass());
        return new TrimResult(newFilter, inputMapping);
    }

    public TrimResult trimFields(SortRel sort, BitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = sort.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelCollation collation = sort.getCollation();
        RelNode input = sort.getChild();
        BitSet inputFieldsUsed = (BitSet)fieldsUsed.clone();
        for (RelFieldCollation field : collation.getFieldCollations()) {
            inputFieldsUsed.set(field.getFieldIndex());
        }
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild(sort, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && inputMapping.isIdentity() && fieldsUsed.cardinality() == fieldCount) {
            return new TrimResult(sort, Mappings.createIdentity(fieldCount));
        }
        SortRel newSort = sort.copy(sort.getTraitSet(), newInput, RexUtil.apply((Mappings.TargetMapping)inputMapping, collation));
        assert (newSort.getClass() == sort.getClass());
        return new TrimResult(newSort, inputMapping);
    }

    public TrimResult trimFields(JoinRel join, BitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = join.getRowType();
        int fieldCount = rowType.getFieldCount();
        RexNode conditionExpr = join.getCondition();
        int systemFieldCount = join.getSystemFieldList().size();
        BitSet fieldsUsedPlus = (BitSet)fieldsUsed.clone();
        LinkedHashSet<RelDataTypeField> combinedInputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(fieldsUsedPlus, combinedInputExtraFields);
        conditionExpr.accept(inputFinder);
        int systemFieldUsedCount = 0;
        for (int i = 0; i < systemFieldCount; ++i) {
            if (!fieldsUsed.get(i)) continue;
            ++systemFieldUsedCount;
        }
        int newSystemFieldCount = systemFieldUsedCount == 0 ? 0 : systemFieldCount;
        int offset = systemFieldCount;
        int changeCount = 0;
        int newFieldCount = newSystemFieldCount;
        ArrayList<Object> newInputs = new ArrayList<Object>(2);
        ArrayList<Mapping> inputMappings = new ArrayList<Mapping>();
        ArrayList<Integer> inputExtraFieldCounts = new ArrayList<Integer>();
        for (RelNode input : join.getInputs()) {
            RelDataType inputRowType = input.getRowType();
            int inputFieldCount = inputRowType.getFieldCount();
            BitSet inputFieldsUsed = new BitSet(inputFieldCount);
            for (int bit : BitSets.toIter(fieldsUsedPlus)) {
                if (bit < offset || bit >= offset + inputFieldCount) continue;
                inputFieldsUsed.set(bit - offset);
            }
            if (newSystemFieldCount > 0) {
                inputFieldsUsed.set(0, newSystemFieldCount);
            }
            Set<RelDataTypeField> inputExtraFields = RelDataTypeImpl.extra(inputRowType) == null ? Collections.emptySet() : combinedInputExtraFields;
            inputExtraFieldCounts.add(inputExtraFields.size());
            TrimResult trimResult = this.trimChild(join, input, inputFieldsUsed, inputExtraFields);
            newInputs.add(trimResult.left);
            if (trimResult.left != input) {
                ++changeCount;
            }
            Mapping inputMapping = (Mapping)trimResult.right;
            inputMappings.add(inputMapping);
            offset += inputFieldCount;
            newFieldCount += inputMapping.getTargetCount() + inputExtraFields.size();
        }
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, newFieldCount);
        for (int i = 0; i < newSystemFieldCount; ++i) {
            mapping.set(i, i);
        }
        offset = systemFieldCount;
        int newOffset = newSystemFieldCount;
        for (int i = 0; i < inputMappings.size(); ++i) {
            Mapping inputMapping = (Mapping)inputMappings.get(i);
            for (IntPair pair : inputMapping) {
                mapping.set(pair.source + offset, pair.target + newOffset);
            }
            offset += inputMapping.getSourceCount();
            newOffset += inputMapping.getTargetCount() + (Integer)inputExtraFieldCounts.get(i);
        }
        if (changeCount == 0 && mapping.isIdentity()) {
            return new TrimResult(join, Mappings.createIdentity(fieldCount));
        }
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle(mapping, (RelNode)newInputs.get(0), (RelNode)newInputs.get(1));
        RexNode newConditionExpr = conditionExpr.accept(shuttle);
        JoinRel newJoin = join.copy(join.getTraitSet(), newConditionExpr, (RelNode)newInputs.get(0), (RelNode)newInputs.get(1), join.getJoinType(), join.isSemiJoinDone());
        return new TrimResult(newJoin, mapping);
    }

    public TrimResult trimFields(SetOpRel setOp, BitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = setOp.getRowType();
        int fieldCount = rowType.getFieldCount();
        int changeCount = 0;
        if (fieldsUsed.isEmpty()) {
            fieldsUsed.set(rowType.getFieldCount() - 1);
        }
        Mapping mapping = this.createMapping(fieldsUsed, fieldCount);
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        for (RelNode input : setOp.getInputs()) {
            TrimResult trimResult = this.trimChild(setOp, input, fieldsUsed, extraFields);
            RelNode newInput = (RelNode)trimResult.left;
            Mapping inputMapping = (Mapping)trimResult.right;
            Mapping remaining = Mappings.divide(mapping, inputMapping);
            if (input != (newInput = CalcRel.projectMapping(newInput, remaining, null))) {
                ++changeCount;
            }
            newInputs.add(newInput);
        }
        if (changeCount == 0 && mapping.isIdentity()) {
            return new TrimResult(setOp, mapping);
        }
        RelNode newSetOp = setOp.copy(setOp.getTraitSet(), newInputs);
        return new TrimResult(newSetOp, mapping);
    }

    public TrimResult trimFields(AggregateRel aggregate, BitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        int groupCount;
        RelDataType rowType = aggregate.getRowType();
        BitSet inputFieldsUsed = new BitSet();
        Iterator<Object> i$ = BitSets.toIter(aggregate.getGroupSet()).iterator();
        while (i$.hasNext()) {
            int i = i$.next();
            inputFieldsUsed.set(i);
        }
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            for (int i : aggCall.getArgList()) {
                inputFieldsUsed.set(i);
            }
        }
        RelNode input = aggregate.getInput(0);
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild(aggregate, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (input == newInput && fieldsUsed.equals(BitSets.range(rowType.getFieldCount()))) {
            return new TrimResult(aggregate, Mappings.createIdentity(rowType.getFieldCount()));
        }
        int j = groupCount = aggregate.getGroupSet().cardinality();
        int usedAggCallCount = 0;
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            if (!fieldsUsed.get(j++)) continue;
            ++usedAggCallCount;
        }
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, rowType.getFieldCount(), groupCount + usedAggCallCount);
        BitSet newGroupSet = Mappings.apply(inputMapping, aggregate.getGroupSet());
        for (IntPair pair : inputMapping) {
            if (pair.source >= groupCount) continue;
            mapping.set(pair.source, pair.target);
        }
        ArrayList<AggregateCall> newAggCallList = new ArrayList<AggregateCall>();
        j = groupCount;
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            if (fieldsUsed.get(j)) {
                AggregateCall newAggCall = new AggregateCall(aggCall.getAggregation(), aggCall.isDistinct(), Mappings.apply2(inputMapping, aggCall.getArgList()), aggCall.getType(), aggCall.getName());
                if (newAggCall.equals(aggCall)) {
                    newAggCall = aggCall;
                }
                mapping.set(j, groupCount + newAggCallList.size());
                newAggCallList.add(newAggCall);
            }
            ++j;
        }
        AggregateRel newAggregate = new AggregateRel(aggregate.getCluster(), newInput, newGroupSet, newAggCallList);
        assert (newAggregate.getClass() == aggregate.getClass());
        return new TrimResult(newAggregate, mapping);
    }

    public TrimResult trimFields(TableModificationRel modifier, BitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        Util.discard(fieldsUsed);
        RelDataType rowType = modifier.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelNode input = modifier.getChild();
        int inputFieldCount = input.getRowType().getFieldCount();
        BitSet inputFieldsUsed = BitSets.range(inputFieldCount);
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild(modifier, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (!inputMapping.isIdentity()) {
            throw Util.newInternal("Expected identity mapping, got " + inputMapping);
        }
        RelNode newModifier = modifier;
        if (newInput != input) {
            newModifier = modifier.copy(modifier.getTraitSet(), (List)Collections.singletonList(newInput));
        }
        assert (newModifier.getClass() == modifier.getClass());
        Mappings.IdentityMapping mapping = Mappings.createIdentity(fieldCount);
        return new TrimResult(newModifier, mapping);
    }

    public TrimResult trimFields(TableFunctionRel tabFun, BitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = tabFun.getRowType();
        int fieldCount = rowType.getFieldCount();
        ArrayList<Object> newInputs = new ArrayList<Object>();
        for (RelNode input : tabFun.getInputs()) {
            int inputFieldCount = input.getRowType().getFieldCount();
            BitSet inputFieldsUsed = BitSets.range(inputFieldCount);
            Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
            TrimResult trimResult = this.trimChildRestore(tabFun, input, inputFieldsUsed, inputExtraFields);
            assert (((Mapping)trimResult.right).isIdentity());
            newInputs.add(trimResult.left);
        }
        RelNode newTabFun = tabFun;
        if (!tabFun.getInputs().equals(newInputs)) {
            newTabFun = tabFun.copy(tabFun.getTraitSet(), newInputs);
        }
        assert (newTabFun.getClass() == tabFun.getClass());
        Mappings.IdentityMapping mapping = Mappings.createIdentity(fieldCount);
        return new TrimResult(newTabFun, mapping);
    }

    public TrimResult trimFields(ValuesRel values, BitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = values.getRowType();
        int fieldCount = rowType.getFieldCount();
        if (fieldsUsed.isEmpty()) {
            fieldsUsed = BitSets.range(fieldCount - 1, fieldCount);
        }
        if (fieldsUsed.equals(BitSets.range(fieldCount))) {
            Mappings.IdentityMapping mapping = Mappings.createIdentity(fieldCount);
            return new TrimResult(values, mapping);
        }
        ArrayList<List<RexLiteral>> newTuples = new ArrayList<List<RexLiteral>>();
        for (List<RexLiteral> tuple : values.getTuples()) {
            ArrayList<RexLiteral> newTuple = new ArrayList<RexLiteral>();
            for (int field : BitSets.toIter(fieldsUsed)) {
                newTuple.add(tuple.get(field));
            }
            newTuples.add(newTuple);
        }
        Mapping mapping = this.createMapping(fieldsUsed, fieldCount);
        RelDataType newRowType = values.getCluster().getTypeFactory().createStructType(Mappings.apply3(mapping, rowType.getFieldList()));
        ValuesRel newValues = new ValuesRel(values.getCluster(), newRowType, newTuples);
        return new TrimResult(newValues, mapping);
    }

    private Mapping createMapping(BitSet fieldsUsed, int fieldCount) {
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, fieldsUsed.cardinality());
        int i = 0;
        for (int field : BitSets.toIter(fieldsUsed)) {
            mapping.set(field, i++);
        }
        return mapping;
    }

    public TrimResult trimFields(TableAccessRelBase tableAccessRel, BitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        int fieldCount = tableAccessRel.getRowType().getFieldCount();
        if (fieldsUsed.equals(BitSets.range(fieldCount)) && extraFields.isEmpty()) {
            return this.trimFields((RelNode)tableAccessRel, fieldsUsed, extraFields);
        }
        RelNode newTableAccessRel = tableAccessRel.project(fieldsUsed, extraFields);
        Mapping mapping = this.createMapping(fieldsUsed, fieldCount);
        return new TrimResult(newTableAccessRel, mapping);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TrimResult
    extends Pair<RelNode, Mapping> {
        public TrimResult(RelNode left, Mapping right) {
            super(left, right);
        }
    }
}

