/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.validate.AbstractNamespace;
import org.eigenbase.sql.validate.SqlUserDefinedTableFunction;
import org.eigenbase.sql.validate.SqlUserDefinedTableMacro;
import org.eigenbase.sql.validate.SqlValidatorImpl;
import org.eigenbase.sql.validate.SqlValidatorScope;

public class ProcedureNamespace
extends AbstractNamespace {
    private final SqlValidatorScope scope;
    private final SqlCall call;

    ProcedureNamespace(SqlValidatorImpl validator, SqlValidatorScope scope, SqlCall call, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.scope = scope;
        this.call = call;
    }

    public RelDataType validateImpl() {
        this.validator.inferUnknownTypes(this.validator.unknownType, this.scope, this.call);
        RelDataType type = this.validator.deriveTypeImpl(this.scope, this.call);
        SqlOperator operator = this.call.getOperator();
        if (operator instanceof SqlUserDefinedTableFunction) {
            assert (type.getSqlTypeName() == SqlTypeName.CURSOR) : "User-defined table function should have CURSOR type, not " + type;
            SqlUserDefinedTableFunction udf = (SqlUserDefinedTableFunction)operator;
            return udf.getRowType(this.validator.typeFactory, this.call.getOperandList());
        }
        if (operator instanceof SqlUserDefinedTableMacro) {
            assert (type.getSqlTypeName() == SqlTypeName.CURSOR) : "User-defined table macro should have CURSOR type, not " + type;
            SqlUserDefinedTableMacro udf = (SqlUserDefinedTableMacro)operator;
            return udf.getTable(this.validator.typeFactory, this.call.getOperandList()).getRowType(this.validator.typeFactory);
        }
        return type;
    }

    public SqlNode getNode() {
        return this.call;
    }
}

