/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.validate.DelegatingScope;
import org.eigenbase.sql.validate.SqlMoniker;
import org.eigenbase.sql.validate.SqlValidatorNamespace;
import org.eigenbase.sql.validate.SqlValidatorScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderByScope
extends DelegatingScope {
    private final SqlNodeList orderList;
    private final SqlSelect select;

    OrderByScope(SqlValidatorScope parent, SqlNodeList orderList, SqlSelect select) {
        super(parent);
        this.orderList = orderList;
        this.select = select;
    }

    @Override
    public SqlNode getNode() {
        return this.orderList;
    }

    @Override
    public void findAllColumnNames(List<SqlMoniker> result) {
        SqlValidatorNamespace ns = this.validator.getNamespace(this.select);
        this.addColumnNames(ns, result);
    }

    @Override
    public SqlIdentifier fullyQualify(SqlIdentifier identifier) {
        if (identifier.isSimple() && this.validator.getConformance().isSortByAlias()) {
            String name = (String)identifier.names.get(0);
            SqlValidatorNamespace selectNs = this.validator.getNamespace(this.select);
            RelDataType rowType = selectNs.getRowType();
            RelDataTypeField field = this.validator.catalogReader.field(rowType, name);
            if (field != null && !field.getName().startsWith("*")) {
                return identifier;
            }
        }
        return super.fullyQualify(identifier);
    }

    @Override
    public RelDataType resolveColumn(String name, SqlNode ctx) {
        SqlValidatorNamespace selectNs = this.validator.getNamespace(this.select);
        RelDataType rowType = selectNs.getRowType();
        RelDataTypeField field = this.validator.catalogReader.field(rowType, name);
        if (field != null) {
            return field.getType();
        }
        SqlValidatorScope selectScope = this.validator.getSelectScope(this.select);
        return selectScope.resolveColumn(name, ctx);
    }

    @Override
    public void validateExpr(SqlNode expr) {
        SqlNode expanded = this.validator.expandOrderExpr(this.select, expr);
        this.parent.validateExpr(expanded);
    }
}

