/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlJoin;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.validate.AbstractNamespace;
import org.eigenbase.sql.validate.SqlValidatorImpl;

class JoinNamespace
extends AbstractNamespace {
    private final SqlJoin join;

    JoinNamespace(SqlValidatorImpl validator, SqlJoin join) {
        super(validator, null);
        this.join = join;
    }

    protected RelDataType validateImpl() {
        RelDataType leftType = this.validator.getNamespace(this.join.getLeft()).getRowType();
        RelDataType rightType = this.validator.getNamespace(this.join.getRight()).getRowType();
        RelDataTypeFactory typeFactory = this.validator.getTypeFactory();
        switch (this.join.getJoinType()) {
            case LEFT: {
                rightType = typeFactory.createTypeWithNullability(rightType, true);
                break;
            }
            case RIGHT: {
                leftType = typeFactory.createTypeWithNullability(leftType, true);
                break;
            }
            case FULL: {
                leftType = typeFactory.createTypeWithNullability(leftType, true);
                rightType = typeFactory.createTypeWithNullability(rightType, true);
            }
        }
        return typeFactory.createJoinType(leftType, rightType);
    }

    public SqlNode getNode() {
        return this.join;
    }
}

